/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Events;
import arc.func.Boolf;
import arc.func.Floatc2;
import arc.func.Intc2;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.entities.Damage;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.Tile;

public class WaveSpawner {
    private static final float margin = 0.0f;
    private static final float coreMargin = 16.0f;
    private static final float maxSteps = 30.0f;
    private int tmpCount;
    private Seq<Tile> spawns = new Seq();
    private boolean spawning = false;
    private boolean any = false;
    private Tile firstSpawn = null;

    public WaveSpawner() {
        Events.on(EventType.WorldLoadEvent.class, e -> this.reset());
    }

    @Nullable
    public Tile getFirstSpawn() {
        this.firstSpawn = null;
        this.eachGroundSpawn((cx, cy) -> {
            this.firstSpawn = Vars.world.tile(cx, cy);
        });
        return this.firstSpawn;
    }

    public int countSpawns() {
        return this.spawns.size;
    }

    public Seq<Tile> getSpawns() {
        return this.spawns;
    }

    public boolean playerNear() {
        return Vars.state.hasSpawns() && !Vars.player.dead() && this.spawns.contains((Tile)((Object)((Boolf<Tile>)g -> Mathf.dst(g.x * 8, g.y * 8, Vars.player.x, Vars.player.y) < Vars.state.rules.dropZoneRadius && Vars.player.team() != Vars.state.rules.waveTeam)));
    }

    public void spawnEnemies() {
        this.spawning = true;
        this.eachGroundSpawn(-1, (spawnX, spawnY, doShockwave) -> {
            if (doShockwave) {
                this.doShockwave(spawnX, spawnY);
            }
        });
        for (SpawnGroup group : Vars.state.rules.spawns) {
            float spread;
            if (group.type == null) continue;
            int spawned = group.getSpawned(Vars.state.wave - 1);
            if (group.type.flying) {
                spread = 0.0f;
                this.eachFlyerSpawn(group.spawn, (spawnX, spawnY) -> {
                    for (int i = 0; i < spawned; ++i) {
                        Unit unit = group.createUnit(Vars.state.rules.waveTeam, Vars.state.wave - 1);
                        unit.set(spawnX + Mathf.range(spread), spawnY + Mathf.range(spread));
                        this.spawnEffect(unit);
                    }
                });
                continue;
            }
            spread = 16.0f;
            this.eachGroundSpawn(group.spawn, (spawnX, spawnY, doShockwave) -> {
                for (int i = 0; i < spawned; ++i) {
                    Tmp.v1.rnd(spread);
                    Unit unit = group.createUnit(Vars.state.rules.waveTeam, Vars.state.wave - 1);
                    unit.set(spawnX + Tmp.v1.x, spawnY + Tmp.v1.y);
                    this.spawnEffect(unit);
                }
            });
        }
        Time.run(121.0f, () -> {
            this.spawning = false;
        });
    }

    public void doShockwave(float x, float y) {
        Fx.spawnShockwave.at(x, y, Vars.state.rules.dropZoneRadius);
        Damage.damage(Vars.state.rules.waveTeam, x, y, Vars.state.rules.dropZoneRadius, 1.0E8f, true);
    }

    public void eachGroundSpawn(Intc2 cons) {
        this.eachGroundSpawn(-1, (x, y, shock) -> cons.get(World.toTile(x), World.toTile(y)));
    }

    private void eachGroundSpawn(int filterPos, SpawnConsumer cons) {
        if (Vars.state.hasSpawns()) {
            for (Tile spawn : this.spawns) {
                if (filterPos != -1 && filterPos != spawn.pos()) continue;
                cons.accept(spawn.worldx(), spawn.worldy(), true);
            }
        }
        if (Vars.state.rules.attackMode && Vars.state.teams.isActive(Vars.state.rules.waveTeam) && !Vars.state.teams.playerCores().isEmpty()) {
            Building firstCore = Vars.state.teams.playerCores().first();
            for (Building building : Vars.state.rules.waveTeam.cores()) {
                if (filterPos != -1 && filterPos != building.pos()) continue;
                Tmp.v1.set(firstCore).sub(building).limit(16.0f + (float)(building.block.size * 8) / 2.0f * Mathf.sqrt2);
                boolean valid = false;
                int steps = 0;
                while (true) {
                    int n = steps++;
                    if (!((float)n < 30.0f)) break;
                    int tx = World.toTile(building.x + Tmp.v1.x);
                    int ty = World.toTile(building.y + Tmp.v1.y);
                    this.any = false;
                    Geometry.circle(tx, ty, Vars.world.width(), Vars.world.height(), 3, (x, y) -> {
                        if (Vars.world.solid(x, y)) {
                            this.any = true;
                        }
                    });
                    if (!this.any) {
                        valid = true;
                        break;
                    }
                    Tmp.v1.setLength(Tmp.v1.len() + 8.8f);
                }
                if (!valid) continue;
                cons.accept(building.x + Tmp.v1.x, building.y + Tmp.v1.y, false);
            }
        }
    }

    private void eachFlyerSpawn(int filterPos, Floatc2 cons) {
        for (Tile tile : this.spawns) {
            if (filterPos != -1 && filterPos != tile.pos()) continue;
            float angle = Angles.angle((float)Vars.world.width() / 2.0f, (float)Vars.world.height() / 2.0f, tile.x, tile.y);
            float trns = (float)Math.max(Vars.world.width(), Vars.world.height()) * Mathf.sqrt2 * 8.0f;
            float spawnX = Mathf.clamp((float)(Vars.world.width() * 8) / 2.0f + Angles.trnsx(angle, trns), -0.0f, (float)(Vars.world.width() * 8) + 0.0f);
            float spawnY = Mathf.clamp((float)(Vars.world.height() * 8) / 2.0f + Angles.trnsy(angle, trns), -0.0f, (float)(Vars.world.height() * 8) + 0.0f);
            cons.get(spawnX, spawnY);
        }
        if (Vars.state.rules.attackMode && Vars.state.teams.isActive(Vars.state.rules.waveTeam)) {
            for (Building building : Vars.state.rules.waveTeam.data().cores) {
                if (filterPos != -1 && filterPos != building.pos()) continue;
                cons.get(building.x, building.y);
            }
        }
    }

    public int countGroundSpawns() {
        this.tmpCount = 0;
        this.eachGroundSpawn((x, y) -> ++this.tmpCount);
        return this.tmpCount;
    }

    public int countFlyerSpawns() {
        this.tmpCount = 0;
        this.eachFlyerSpawn(-1, (x, y) -> ++this.tmpCount);
        return this.tmpCount;
    }

    public boolean isSpawning() {
        return this.spawning && !Vars.net.client();
    }

    public void reset() {
        this.spawning = false;
        this.spawns.clear();
        for (Tile tile : Vars.world.tiles) {
            if (tile.overlay() != Blocks.spawn) continue;
            this.spawns.add(tile);
        }
    }

    public void spawnEffect(Unit unit) {
        this.spawnEffect(unit, unit.angleTo((float)Vars.world.width() / 2.0f * 8.0f, (float)Vars.world.height() / 2.0f * 8.0f));
    }

    public void spawnEffect(Unit unit, float rotation) {
        unit.rotation = rotation;
        unit.apply(StatusEffects.unmoving, 30.0f);
        unit.apply(StatusEffects.invincible, 60.0f);
        unit.add();
        unit.unloaded();
        Events.fire(new EventType.UnitSpawnEvent(unit));
        Call.spawnEffect(unit.x, unit.y, unit.rotation, unit.type);
    }

    public static void spawnEffect(float x, float y, float rotation, UnitType u) {
        Fx.unitSpawn.at(x, y, rotation, u);
        Time.run(30.0f, () -> Fx.spawn.at(x, y));
    }

    private static interface SpawnConsumer {
        public void accept(float var1, float var2, boolean var3);
    }
}

