/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.gen.Teamc;

public class FlyingFollowAI
extends FlyingAI {
    public Teamc following;

    @Override
    public void updateMovement() {
        this.unloadPayloads();
        if (this.following != null) {
            float f;
            Teamc teamc = this.following;
            if (teamc instanceof Sized) {
                Sized s = (Sized)((Object)teamc);
                f = s.hitSize() / 2.0f * 1.1f;
            } else {
                f = 0.0f;
            }
            this.moveTo(this.following, f + this.unit.hitSize / 2.0f + 15.0f, 50.0f);
        } else if (this.target != null && this.unit.hasWeapons()) {
            this.moveTo(this.target, 80.0f);
        }
        if (this.shouldFaceTarget()) {
            this.unit.lookAt(this.target);
        } else if (this.following != null) {
            this.unit.lookAt(this.following);
        }
        if (this.timer.get(2, 30.0f)) {
            this.following = Units.closest(this.unit.team, this.unit.x, this.unit.y, Math.max(this.unit.type.range, 400.0f), u -> !u.dead() && u.type != this.unit.type, (u, tx, ty) -> -u.maxHealth + Mathf.dst2(u.x, u.y, tx, ty) / 6400.0f);
        }
    }

    public boolean shouldFaceTarget() {
        return this.target != null && (this.following == null || this.unit.within(this.target, this.unit.range()));
    }

    @Override
    public void updateVisuals() {
        if (this.unit.isFlying()) {
            this.unit.wobble();
            if (!this.shouldFaceTarget()) {
                this.unit.lookAt(this.unit.prefRotation());
            }
        }
    }

    @Override
    public AIController fallback() {
        return new FlyingAI();
    }

    @Override
    public boolean useFallback() {
        return Vars.state.rules.pvp || Vars.state.rules.waveTeam != this.unit.team;
    }
}

