/*
 * Decompiled with CFR 0.152.
 */
package mindustry.desktop;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.Files;
import arc.backend.sdl.SdlApplication;
import arc.backend.sdl.SdlConfig;
import arc.backend.sdl.jni.SDL;
import arc.discord.DiscordRPC;
import arc.files.Fi;
import arc.func.Cons;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.serialization.Base64Coder;
import com.codedisaster.steamworks.SteamAPI;
import java.io.FileOutputStream;
import java.io.OutputStream;
import mindustry.ClientLauncher;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.desktop.steam.SNet;
import mindustry.desktop.steam.SStats;
import mindustry.desktop.steam.SUser;
import mindustry.desktop.steam.SVars;
import mindustry.desktop.steam.SWorkshop;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.net.ArcNetProvider;
import mindustry.net.CrashSender;
import mindustry.net.Net;
import mindustry.service.GameService;
import mindustry.type.Publishable;

public class DesktopLauncher
extends ClientLauncher {
    public static final long discordID = 610508934456934412L;
    boolean useDiscord = !OS.hasProp("nodiscord");
    boolean loadError = false;
    Throwable steamError;

    public static void main(final String[] arg) {
        try {
            Vars.loadLogger();
            new SdlApplication(new DesktopLauncher(arg), new SdlConfig(){
                {
                    this.title = "Mindustry";
                    this.maximized = true;
                    this.width = 900;
                    this.height = 700;
                    for (int i = 0; i < arg.length; ++i) {
                        if (arg[i].charAt(0) != '-') continue;
                        String name = arg[i].substring(1);
                        try {
                            switch (name) {
                                case "width": {
                                    this.width = Integer.parseInt(arg[i + 1]);
                                    break;
                                }
                                case "height": {
                                    this.height = Integer.parseInt(arg[i + 1]);
                                    break;
                                }
                                case "gl3": {
                                    this.gl30 = true;
                                    break;
                                }
                                case "antialias": {
                                    this.samples = 16;
                                    break;
                                }
                                case "debug": {
                                    Log.level = Log.LogLevel.debug;
                                    break;
                                }
                                case "maximized": {
                                    this.maximized = Boolean.parseBoolean(arg[i + 1]);
                                }
                            }
                            continue;
                        }
                        catch (NumberFormatException number) {
                            Log.warn("Invalid parameter number value.", new Object[0]);
                        }
                    }
                    this.setWindowIcon(Files.FileType.internal, "icons/icon_64.png");
                }
            });
        }
        catch (Throwable e) {
            DesktopLauncher.handleCrash(e);
        }
    }

    public DesktopLauncher(String[] args) {
        Version.init();
        boolean useSteam = Version.modifier.contains("steam");
        Vars.testMobile = Seq.with(args).contains("-testMobile");
        if (this.useDiscord) {
            try {
                DiscordRPC.connect(610508934456934412L);
                Log.info("Initialized Discord rich presence.");
                Runtime.getRuntime().addShutdownHook(new Thread(DiscordRPC::close));
            }
            catch (DiscordRPC.NoDiscordClientException none) {
                this.useDiscord = false;
            }
            catch (Throwable t) {
                this.useDiscord = false;
                Log.warn("Failed to initialize Discord RPC - you are likely using a JVM <16.", new Object[0]);
            }
        }
        if (useSteam) {
            Events.on(EventType.ClientLoadEvent.class, event -> {
                if (this.steamError != null) {
                    Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Vars.ui.showErrorMessage(Core.bundle.format("steam.error", this.steamError.getMessage() == null ? this.steamError.getClass().getSimpleName() : this.steamError.getClass().getSimpleName() + ": " + this.steamError.getMessage())))));
                }
            });
            try {
                SteamAPI.loadLibraries();
                if (!SteamAPI.init()) {
                    this.loadError = true;
                    Log.err("Steam client not running.", new Object[0]);
                } else {
                    this.initSteam(args);
                    Vars.steam = true;
                }
                if (SteamAPI.restartAppIfNecessary(1127400)) {
                    System.exit(0);
                }
            }
            catch (Throwable e) {
                Vars.steam = false;
                Log.err("Failed to load Steam native libraries.", new Object[0]);
                this.logSteamError(e);
            }
        }
    }

    void logSteamError(Throwable e) {
        this.steamError = e;
        this.loadError = true;
        Log.err(e);
        try (FileOutputStream s = new FileOutputStream("steam-error-log-" + System.nanoTime() + ".txt");){
            String log = Strings.neatError(e);
            ((OutputStream)s).write(log.getBytes());
        }
        catch (Exception e2) {
            Log.err(e2);
        }
    }

    void initSteam(String[] args) {
        SVars.net = new SNet(new ArcNetProvider());
        SVars.stats = new SStats();
        SVars.workshop = new SWorkshop();
        SVars.user = new SUser();
        boolean[] isShutdown = new boolean[]{false};
        Vars.service = new GameService(){

            @Override
            public boolean enabled() {
                return true;
            }

            @Override
            public void completeAchievement(String name) {
                SVars.stats.stats.setAchievement(name);
                SVars.stats.stats.storeStats();
            }

            @Override
            public void clearAchievement(String name) {
                SVars.stats.stats.clearAchievement(name);
                SVars.stats.stats.storeStats();
            }

            @Override
            public boolean isAchieved(String name) {
                return SVars.stats.stats.isAchieved(name, false);
            }

            @Override
            public int getStat(String name, int def) {
                return SVars.stats.stats.getStatI(name, def);
            }

            @Override
            public void setStat(String name, int amount) {
                SVars.stats.stats.setStatI(name, amount);
            }

            @Override
            public void storeStats() {
                SVars.stats.onUpdate();
            }
        };
        Events.on(EventType.ClientLoadEvent.class, event -> {
            Core.settings.defaults("name", SVars.net.friends.getPersonaName());
            if (Vars.player.name.isEmpty()) {
                Vars.player.name = SVars.net.friends.getPersonaName();
                Core.settings.put("name", Vars.player.name);
            }
            Vars.steamPlayerName = SVars.net.friends.getPersonaName();
            Core.app.addListener(new ApplicationListener(){

                @Override
                public void update() {
                    if (SteamAPI.isSteamRunning()) {
                        SteamAPI.runCallbacks();
                    }
                }
            });
            Core.app.post(() -> {
                if (args.length >= 2 && args[0].equals("+connect_lobby")) {
                    try {
                        long id = Long.parseLong(args[1]);
                        Vars.ui.join.connect("steam:" + id, 6567);
                    }
                    catch (Exception e) {
                        Log.err("Failed to parse steam lobby ID: @", e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        });
        Events.on(EventType.DisposeEvent.class, event -> {
            SteamAPI.shutdown();
            isShutdown[0] = true;
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!isShutdown[0]) {
                SteamAPI.shutdown();
            }
        }));
    }

    static void handleCrash(Throwable e) {
        Cons<Runnable> dialog = Runnable::run;
        boolean badGPU = false;
        String finalMessage = Strings.getFinalMessage(e);
        String total = Strings.getCauses(e).toString();
        if (total.contains("Couldn't create window") || total.contains("OpenGL 2.0 or higher") || total.toLowerCase().contains("pixel format") || total.contains("GLEW") || total.contains("unsupported combination of formats")) {
            dialog.get(() -> DesktopLauncher.message(total.contains("Couldn't create window") ? "A graphics initialization error has occured! Try to update your graphics drivers:\n" + finalMessage : "Your graphics card does not support the right OpenGL features.\nTry to update your graphics drivers. If this doesn't work, your computer may not support Mindustry.\n\nFull message: " + finalMessage));
            badGPU = true;
        }
        boolean fbgp = badGPU;
        CrashSender.send(e, file -> {
            Throwable fc = Strings.getFinalCause(e);
            if (!fbgp) {
                dialog.get(() -> DesktopLauncher.message("A crash has occured. It has been saved in:\n" + file.getAbsolutePath() + "\n" + fc.getClass().getSimpleName().replace("Exception", "") + (fc.getMessage() == null ? "" : ":\n" + fc.getMessage())));
            }
        });
    }

    @Override
    public Seq<Fi> getWorkshopContent(Class<? extends Publishable> type) {
        return !Vars.steam ? super.getWorkshopContent(type) : SVars.workshop.getWorkshopFiles(type);
    }

    @Override
    public void viewListing(Publishable pub) {
        SVars.workshop.viewListing(pub);
    }

    @Override
    public void viewListingID(String id) {
        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + id);
    }

    @Override
    public Net.NetProvider getNet() {
        return Vars.steam ? SVars.net : new ArcNetProvider();
    }

    @Override
    public void openWorkshop() {
        SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/app/1127400/workshop/");
    }

    @Override
    public void publish(Publishable pub) {
        SVars.workshop.publish(pub);
    }

    @Override
    public void inviteFriends() {
        SVars.net.showFriendInvites();
    }

    @Override
    public void updateLobby() {
        if (SVars.net != null) {
            SVars.net.updateLobby();
        }
    }

    @Override
    public void updateRPC() {
        if (!this.useDiscord && !Vars.steam) {
            return;
        }
        boolean inGame = Vars.state.isGame();
        String gameMapWithWave = "Unknown Map";
        String gameMode = "";
        String gamePlayersSuffix = "";
        String uiState = "";
        if (inGame) {
            gameMapWithWave = Strings.capitalize(Strings.stripColors(Vars.state.map.name()));
            if (Vars.state.rules.waves) {
                gameMapWithWave = gameMapWithWave + " | Wave " + Vars.state.wave;
            }
            String string = Vars.state.rules.pvp ? "PvP" : (Vars.state.rules.attackMode ? "Attack" : (gameMode = Vars.state.rules.infiniteResources ? "Sandbox" : "Survival"));
            if (Vars.net.active() && Groups.player.size() > 1) {
                gamePlayersSuffix = " | " + Groups.player.size() + " Players";
            }
        } else {
            uiState = Vars.ui.editor != null && Vars.ui.editor.isShown() ? "In Editor" : (Vars.ui.planet != null && Vars.ui.planet.isShown() ? "In Launch Selection" : "In Menu");
        }
        if (this.useDiscord) {
            DiscordRPC.RichPresence presence = new DiscordRPC.RichPresence();
            if (inGame) {
                presence.state = gameMode + gamePlayersSuffix;
                presence.details = gameMapWithWave;
                if (Vars.state.rules.waves) {
                    presence.largeImageText = "Wave " + Vars.state.wave;
                }
            } else {
                presence.state = uiState;
            }
            presence.largeImageKey = "logo";
            try {
                DiscordRPC.send(presence);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Vars.steam) {
            SVars.net.friends.setRichPresence("steam_display", "#steam_status_raw");
            if (inGame) {
                SVars.net.friends.setRichPresence("steam_status", gameMapWithWave);
            } else {
                SVars.net.friends.setRichPresence("steam_status", uiState);
            }
        }
    }

    @Override
    public String getUUID() {
        if (Vars.steam) {
            try {
                byte[] result = new byte[8];
                new Rand(SVars.user.user.getSteamID().getAccountID()).nextBytes(result);
                return new String(Base64Coder.encode(result));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getUUID();
    }

    private static void message(String message) {
        SDL.SDL_ShowSimpleMessageBox(16, "oh no", message);
    }
}

