/*
 * Decompiled with CFR 0.152.
 */
package mindustry.desktop.steam;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Structs;
import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamFriendsCallback;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamMatchmaking;
import com.codedisaster.steamworks.SteamMatchmakingCallback;
import com.codedisaster.steamworks.SteamNetworking;
import com.codedisaster.steamworks.SteamNetworkingCallback;
import com.codedisaster.steamworks.SteamResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CopyOnWriteArrayList;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.net.ArcNetProvider;
import mindustry.net.Host;
import mindustry.net.Net;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.net.Packets;

public class SNet
implements SteamNetworkingCallback,
SteamMatchmakingCallback,
SteamFriendsCallback,
Net.NetProvider {
    public final SteamNetworking snet = new SteamNetworking(this);
    public final SteamMatchmaking smat = new SteamMatchmaking(this);
    public final SteamFriends friends = new SteamFriends(this);
    final Net.NetProvider provider;
    final ArcNetProvider.PacketSerializer serializer = new ArcNetProvider.PacketSerializer();
    final ByteBuffer writeBuffer = ByteBuffer.allocateDirect(16384);
    final ByteBuffer readBuffer = ByteBuffer.allocateDirect(16384);
    final ByteBuffer readCopyBuffer = ByteBuffer.allocate(this.writeBuffer.capacity());
    final CopyOnWriteArrayList<SteamConnection> connections = new CopyOnWriteArrayList();
    final IntMap<SteamConnection> steamConnections = new IntMap();
    SteamID currentLobby;
    SteamID currentServer;
    Cons<Host> lobbyCallback;
    Runnable lobbyDoneCallback;
    Runnable joinCallback;

    public SNet(Net.NetProvider provider) {
        this.provider = provider;
        Events.on(EventType.ClientLoadEvent.class, e -> Core.app.addListener(new ApplicationListener(){
            int length;
            SteamID from = new SteamID();

            @Override
            public void update() {
                while ((this.length = SNet.this.snet.isP2PPacketAvailable(0)) != 0) {
                    try {
                        SNet.this.readBuffer.position(0).limit(SNet.this.readBuffer.capacity());
                        int len = SNet.this.snet.readP2PPacket(this.from, SNet.this.readBuffer, 0);
                        SNet.this.readBuffer.limit(len);
                        SNet.this.readCopyBuffer.position(0);
                        SNet.this.readCopyBuffer.put(SNet.this.readBuffer);
                        SNet.this.readCopyBuffer.position(0);
                        int fromID = this.from.getAccountID();
                        Object output = SNet.this.serializer.read(SNet.this.readCopyBuffer);
                        if (!(output instanceof Packet)) {
                            return;
                        }
                        Packet pack = (Packet)output;
                        if (Vars.net.server()) {
                            SteamConnection con = SNet.this.steamConnections.get(fromID);
                            try {
                                if (con == null) {
                                    con = new SteamConnection(SteamID.createFromNativeHandle(this.from.handle()));
                                    Packets.Connect c = new Packets.Connect();
                                    c.addressTCP = "steam:" + this.from.getAccountID();
                                    Log.info("&bReceived STEAM connection: @", c.addressTCP);
                                    SNet.this.steamConnections.put(this.from.getAccountID(), con);
                                    SNet.this.connections.add(con);
                                    Vars.net.handleServerReceived(con, c);
                                }
                                Vars.net.handleServerReceived(con, pack);
                            }
                            catch (Throwable e) {
                                Log.err(e);
                            }
                            continue;
                        }
                        if (SNet.this.currentServer == null || fromID != SNet.this.currentServer.getAccountID()) continue;
                        try {
                            Vars.net.handleClientReceived(pack);
                        }
                        catch (Throwable t) {
                            Vars.net.handleException(t);
                        }
                    }
                    catch (Exception e) {
                        if (Vars.net.server()) {
                            Log.err(e);
                            continue;
                        }
                        Vars.net.showError(e);
                    }
                }
            }
        }));
        Events.on(EventType.WaveEvent.class, e -> this.updateWave());
        Events.run((Object)EventType.Trigger.newGame, this::updateWave);
    }

    public boolean isSteamClient() {
        return this.currentServer != null;
    }

    @Override
    public void connectClient(String ip, int port, Runnable success) throws IOException {
        if (ip.startsWith("steam:")) {
            String lobbyname = ip.substring("steam:".length());
            try {
                SteamID lobby = SteamID.createFromNativeHandle(Long.parseLong(lobbyname));
                this.joinCallback = success;
                this.smat.joinLobby(lobby);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid Steam ID: " + lobbyname);
            }
        } else {
            this.provider.connectClient(ip, port, success);
        }
    }

    @Override
    public void sendClient(Object object, boolean reliable) {
        if (this.isSteamClient()) {
            if (this.currentServer == null) {
                Log.info("Not connected, quitting.");
                return;
            }
            try {
                this.writeBuffer.limit(this.writeBuffer.capacity());
                this.writeBuffer.position(0);
                this.serializer.write(this.writeBuffer, object);
                int length = this.writeBuffer.position();
                this.writeBuffer.flip();
                this.snet.sendP2PPacket(this.currentServer, this.writeBuffer, reliable || length >= 1000 ? SteamNetworking.P2PSend.Reliable : SteamNetworking.P2PSend.UnreliableNoDelay, 0);
            }
            catch (Exception e) {
                Vars.net.showError(e);
            }
        } else {
            this.provider.sendClient(object, reliable);
        }
    }

    @Override
    public void disconnectClient() {
        if (this.isSteamClient()) {
            if (this.currentLobby != null) {
                this.smat.leaveLobby(this.currentLobby);
                this.snet.closeP2PSessionWithUser(this.currentServer);
                this.currentServer = null;
                this.currentLobby = null;
                Vars.net.handleClientReceived(new Packets.Disconnect());
            }
        } else {
            this.provider.disconnectClient();
        }
    }

    @Override
    public void discoverServers(Cons<Host> callback, Runnable done) {
        this.smat.addRequestLobbyListResultCountFilter(32);
        this.smat.addRequestLobbyListDistanceFilter(SteamMatchmaking.LobbyDistanceFilter.Worldwide);
        this.smat.requestLobbyList();
        this.lobbyCallback = callback;
        this.lobbyDoneCallback = () -> this.provider.discoverServers(callback, done);
    }

    @Override
    public void pingHost(String address, int port, Cons<Host> valid, Cons<Exception> failed) {
        this.provider.pingHost(address, port, valid, failed);
    }

    @Override
    public void hostServer(int port) throws IOException {
        this.provider.hostServer(port);
        this.smat.createLobby(Core.settings.getBool("steampublichost") ? SteamMatchmaking.LobbyType.Public : SteamMatchmaking.LobbyType.FriendsOnly, Core.settings.getInt("playerlimit"));
        Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Log.info("Server: @\nClient: @\nActive: @", Vars.net.server(), Vars.net.client(), Vars.net.active()))));
    }

    public void updateLobby() {
        if (this.currentLobby != null && Vars.net.server()) {
            this.smat.setLobbyType(this.currentLobby, Core.settings.getBool("steampublichost") ? SteamMatchmaking.LobbyType.Public : SteamMatchmaking.LobbyType.FriendsOnly);
            this.smat.setLobbyMemberLimit(this.currentLobby, Core.settings.getInt("playerlimit"));
        }
    }

    void updateWave() {
        if (this.currentLobby != null && Vars.net.server()) {
            this.smat.setLobbyData(this.currentLobby, "mapname", Vars.state.map.name());
            this.smat.setLobbyData(this.currentLobby, "wave", Vars.state.wave + "");
            this.smat.setLobbyData(this.currentLobby, "gamemode", Vars.state.rules.mode().name() + "");
        }
    }

    @Override
    public void closeServer() {
        this.provider.closeServer();
        if (this.currentLobby != null) {
            this.smat.leaveLobby(this.currentLobby);
            for (SteamConnection con : this.steamConnections.values()) {
                con.close();
            }
            this.currentLobby = null;
        }
        this.steamConnections.clear();
    }

    @Override
    public Iterable<? extends NetConnection> getConnections() {
        CopyOnWriteArrayList<SteamConnection> connectionsOut = new CopyOnWriteArrayList<SteamConnection>(this.connections);
        for (NetConnection netConnection : this.provider.getConnections()) {
            connectionsOut.add((SteamConnection)netConnection);
        }
        return connectionsOut;
    }

    void disconnectSteamUser(SteamID steamid) {
        int sid = steamid.getAccountID();
        this.snet.closeP2PSessionWithUser(steamid);
        if (this.steamConnections.containsKey(sid)) {
            SteamConnection con = this.steamConnections.get(sid);
            Vars.net.handleServerReceived(con, new Packets.Disconnect());
            this.steamConnections.remove(sid);
            this.connections.remove(con);
        }
    }

    @Override
    public void onLobbyInvite(SteamID steamIDUser, SteamID steamIDLobby, long gameID) {
        Log.info("onLobbyInvite @ @ @", steamIDLobby.getAccountID(), steamIDUser.getAccountID(), gameID);
    }

    @Override
    public void onLobbyEnter(SteamID steamIDLobby, int chatPermissions, boolean blocked, SteamMatchmaking.ChatRoomEnterResponse response) {
        Log.info("onLobbyEnter @ @", new Object[]{steamIDLobby.getAccountID(), response});
        if (response != SteamMatchmaking.ChatRoomEnterResponse.Success) {
            Vars.ui.loadfrag.hide();
            Vars.ui.showErrorMessage(Core.bundle.format("cantconnect", response.toString()));
            return;
        }
        int version = Strings.parseInt(this.smat.getLobbyData(steamIDLobby, "version"), -1);
        if (version != Version.build) {
            Vars.ui.loadfrag.hide();
            Vars.ui.showInfo("[scarlet]" + (version > Version.build ? Packets.KickReason.clientOutdated : Packets.KickReason.serverOutdated).toString() + "\n[]" + Core.bundle.format("server.versions", Version.build, version));
            this.smat.leaveLobby(steamIDLobby);
            return;
        }
        Vars.logic.reset();
        Vars.net.reset();
        this.currentLobby = steamIDLobby;
        this.currentServer = this.smat.getLobbyOwner(steamIDLobby);
        Log.info("Connect to owner @: @", this.currentServer.getAccountID(), this.friends.getFriendPersonaName(this.currentServer));
        if (this.joinCallback != null) {
            this.joinCallback.run();
            this.joinCallback = null;
        }
        Packets.Connect con = new Packets.Connect();
        con.addressTCP = "steam:" + this.currentServer.getAccountID();
        Vars.net.setClientConnected();
        Vars.net.handleClientReceived(con);
        Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Log.info("Server: @\nClient: @\nActive: @", Vars.net.server(), Vars.net.client(), Vars.net.active()))));
    }

    @Override
    public void onLobbyChatUpdate(SteamID lobby, SteamID who, SteamID changer, SteamMatchmaking.ChatMemberStateChange change) {
        Log.info("lobby @: @ caused @'s change: @", new Object[]{lobby.getAccountID(), who.getAccountID(), changer.getAccountID(), change});
        if (change == SteamMatchmaking.ChatMemberStateChange.Disconnected || change == SteamMatchmaking.ChatMemberStateChange.Left) {
            if (Vars.net.client()) {
                if (who.equals(this.currentServer) || who.equals(this.currentLobby)) {
                    Vars.net.disconnect();
                    Log.info("Current host left.");
                }
            } else {
                this.disconnectSteamUser(who);
            }
        }
    }

    @Override
    public void onLobbyMatchList(int matches) {
        Log.info("found @ matches", matches);
        if (this.lobbyDoneCallback != null) {
            Seq<Host> hosts = new Seq<Host>();
            for (int i = 0; i < matches; ++i) {
                try {
                    String mode;
                    SteamID lobby = this.smat.getLobbyByIndex(i);
                    if (this.smat.getLobbyData(lobby, "hidden").equals("true") || (mode = this.smat.getLobbyData(lobby, "gamemode")) == null || mode.isEmpty() || Version.build != -1 && Strings.parseInt(this.smat.getLobbyData(lobby, "version"), -1) != Version.build) continue;
                    Host out = new Host(-1, this.smat.getLobbyData(lobby, "name"), "steam:" + lobby.handle(), this.smat.getLobbyData(lobby, "mapname"), Strings.parseInt(this.smat.getLobbyData(lobby, "wave"), -1), this.smat.getNumLobbyMembers(lobby), Strings.parseInt(this.smat.getLobbyData(lobby, "version"), -1), this.smat.getLobbyData(lobby, "versionType"), Gamemode.valueOf(mode), this.smat.getLobbyMemberLimit(lobby), "", null);
                    hosts.add(out);
                    continue;
                }
                catch (Exception e) {
                    Log.err(e);
                }
            }
            hosts.sort(Structs.comparingInt(h -> -h.players));
            hosts.each(this.lobbyCallback);
            this.lobbyDoneCallback.run();
        }
    }

    @Override
    public void onLobbyCreated(SteamResult result, SteamID steamID) {
        if (!Vars.net.server()) {
            Log.info("Lobby created on server: @, ignoring.", steamID);
            return;
        }
        Log.info("Lobby @ created? @", new Object[]{result, steamID.getAccountID()});
        if (result == SteamResult.OK) {
            this.currentLobby = steamID;
            this.smat.setLobbyData(steamID, "name", Vars.player.name);
            this.smat.setLobbyData(steamID, "mapname", Vars.state.map.name());
            this.smat.setLobbyData(steamID, "version", Version.build + "");
            this.smat.setLobbyData(steamID, "versionType", Version.type);
            this.smat.setLobbyData(steamID, "wave", Vars.state.wave + "");
            this.smat.setLobbyData(steamID, "gamemode", Vars.state.rules.mode().name() + "");
        }
    }

    public void showFriendInvites() {
        if (this.currentLobby != null) {
            this.friends.activateGameOverlayInviteDialog(this.currentLobby);
            Log.info("Activating overlay dialog");
        }
    }

    @Override
    public void onP2PSessionConnectFail(SteamID steamIDRemote, SteamNetworking.P2PSessionError sessionError) {
        if (Vars.net.server()) {
            Log.info("@ has disconnected: @", new Object[]{steamIDRemote.getAccountID(), sessionError});
            this.disconnectSteamUser(steamIDRemote);
        } else if (steamIDRemote.equals(this.currentServer)) {
            Log.info("Disconnected! @: @", new Object[]{steamIDRemote.getAccountID(), sessionError});
            Vars.net.handleClientReceived(new Packets.Disconnect());
        }
    }

    @Override
    public void onP2PSessionRequest(SteamID steamIDRemote) {
        Log.info("Connection request: @", steamIDRemote.getAccountID());
        if (Vars.net.server()) {
            Log.info("Am server, accepting request from " + steamIDRemote.getAccountID());
            this.snet.acceptP2PSessionWithUser(steamIDRemote);
        }
    }

    @Override
    public void onGameLobbyJoinRequested(SteamID lobby, SteamID steamIDFriend) {
        Log.info("onGameLobbyJoinRequested @ @", lobby, steamIDFriend);
        this.smat.joinLobby(lobby);
    }

    public class SteamConnection
    extends NetConnection {
        final SteamID sid;

        public SteamConnection(SteamID sid) {
            super(sid.getAccountID() + "");
            this.sid = sid;
            Log.info("Created STEAM connection: @", sid.getAccountID());
        }

        @Override
        public void send(Object object, boolean reliable) {
            block2: {
                try {
                    SNet.this.writeBuffer.limit(SNet.this.writeBuffer.capacity());
                    SNet.this.writeBuffer.position(0);
                    SNet.this.serializer.write(SNet.this.writeBuffer, object);
                    int length = SNet.this.writeBuffer.position();
                    SNet.this.writeBuffer.flip();
                    SNet.this.snet.sendP2PPacket(this.sid, SNet.this.writeBuffer, reliable || length >= 1000 ? (object instanceof Packets.StreamChunk ? SteamNetworking.P2PSend.ReliableWithBuffering : SteamNetworking.P2PSend.Reliable) : SteamNetworking.P2PSend.UnreliableNoDelay, 0);
                }
                catch (Exception e) {
                    Log.err(e);
                    Log.info("Error sending packet. Disconnecting invalid client!");
                    this.close();
                    SteamConnection k = SNet.this.steamConnections.get(this.sid.getAccountID());
                    if (k == null) break block2;
                    SNet.this.steamConnections.remove(this.sid.getAccountID());
                }
            }
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void close() {
            SNet.this.disconnectSteamUser(this.sid);
        }
    }
}

