/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.IntSet;
import arc.util.Disposable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.graphics.IndexedRenderer;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Cliff;
import mindustry.world.blocks.environment.Floor;

public class MapRenderer
implements Disposable {
    private static final int chunkSize = 64;
    private IndexedRenderer[][] chunks;
    private IntSet updates = new IntSet();
    private IntSet delayedUpdates = new IntSet();
    private TextureRegion clearEditor;
    private int width;
    private int height;

    public void resize(int width, int height) {
        int y;
        int x;
        this.updates.clear();
        this.delayedUpdates.clear();
        if (this.chunks != null) {
            for (x = 0; x < this.chunks.length; ++x) {
                for (y = 0; y < this.chunks[0].length; ++y) {
                    this.chunks[x][y].dispose();
                }
            }
        }
        this.chunks = new IndexedRenderer[(int)Math.ceil((float)width / 64.0f)][(int)Math.ceil((float)height / 64.0f)];
        for (x = 0; x < this.chunks.length; ++x) {
            for (y = 0; y < this.chunks[0].length; ++y) {
                this.chunks[x][y] = new IndexedRenderer(8192);
            }
        }
        this.width = width;
        this.height = height;
        this.updateAll();
    }

    public void draw(float tx, float ty, float tw, float th) {
        Draw.flush();
        this.clearEditor = Core.atlas.find("clear-editor");
        this.updates.each(i -> this.render(i % this.width, i / this.width));
        this.updates.clear();
        this.updates.addAll(this.delayedUpdates);
        this.delayedUpdates.clear();
        if (this.chunks == null) {
            return;
        }
        Texture texture = Core.atlas.find((String)"clear-editor").texture;
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                IndexedRenderer mesh = this.chunks[x][y];
                if (mesh == null) continue;
                mesh.getTransformMatrix().setToTranslation(tx, ty).scale(tw / (float)(this.width * 8), th / (float)(this.height * 8));
                mesh.setProjectionMatrix(Draw.proj());
                mesh.render(texture);
            }
        }
    }

    public void updatePoint(int x, int y) {
        this.updates.add(x + y * this.width);
    }

    public void updateAll() {
        this.clearEditor = Core.atlas.find("clear-editor");
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.render(x, y);
            }
        }
    }

    private TextureRegion getIcon(Block wall, int index) {
        return !wall.editorIcon().found() ? this.clearEditor : (wall.variants > 0 ? wall.editorVariantRegions()[Mathf.randomSeed((long)index, 0, wall.editorVariantRegions().length - 1)] : wall.editorIcon());
    }

    private void render(int wx, int wy) {
        TextureRegion region;
        boolean useSyntheticWall;
        int x = wx / 64;
        int y = wy / 64;
        if (x >= this.chunks.length || y >= this.chunks[0].length) {
            return;
        }
        IndexedRenderer mesh = this.chunks[x][y];
        Tile tile = Vars.editor.tiles().getn(wx, wy);
        Team team = tile.team();
        Floor floor = tile.floor();
        Floor overlay = tile.overlay();
        Block wall = tile.block();
        int idxWall = wx % 64 + wy % 64 * 64;
        int idxDecal = wx % 64 + wy % 64 * 64 + 4096;
        boolean center = tile.isCenter();
        boolean bl = useSyntheticWall = wall.synthetic() || overlay.wallOre;
        if (wall != Blocks.air && useSyntheticWall) {
            region = !center ? this.clearEditor : this.getIcon(wall, idxWall);
            float width = (float)region.width * region.scl();
            float height = (float)region.height * region.scl();
            float ox = wall.offset + (8.0f - width) / 2.0f;
            float oy = wall.offset + (8.0f - height) / 2.0f;
            if (overlay.wallOre && !wall.synthetic()) {
                height = 8.0f;
                width = 8.0f;
                oy = 0.0f;
                ox = 0.0f;
            }
            mesh.draw(idxWall, region, (float)(wx * 8) + ox, (float)(wy * 8) + oy, width, height, tile.build == null || !wall.rotate ? 0.0f : tile.build.rotdeg());
        } else {
            region = floor.editorVariantRegions()[Mathf.randomSeed((long)idxWall, 0, floor.editorVariantRegions().length - 1)];
            mesh.draw(idxWall, region, wx * 8, wy * 8, 8.0f, 8.0f);
        }
        float offsetX = -(wall.size / 3) * 8;
        float offsetY = -(wall.size / 3) * 8;
        if ((wall.update || wall.destructible) && center) {
            mesh.setColor(team.color);
            region = Core.atlas.find("block-border-editor");
        } else if (!useSyntheticWall && wall != Blocks.air && center) {
            region = this.getIcon(wall, idxWall);
            if (wall == Blocks.cliff) {
                mesh.setColor(Tmp.c1.set(floor.mapColor).mul(1.6f));
                region = ((Cliff)Blocks.cliff).editorCliffs[tile.data & 0xFF];
            }
            offsetX = 4.0f - (float)region.width * region.scl() / 2.0f;
            offsetY = 4.0f - (float)region.height * region.scl() / 2.0f;
        } else if ((wall == Blocks.air || overlay.wallOre) && !overlay.isAir()) {
            if (floor.isLiquid) {
                mesh.setColor(Tmp.c1.set(1.0f, 1.0f, 1.0f, floor.overlayAlpha));
            }
            region = overlay.editorVariantRegions()[Mathf.randomSeed((long)idxWall, 0, tile.overlay().editorVariantRegions().length - 1)];
        } else {
            region = this.clearEditor;
        }
        float width = (float)region.width * region.scl();
        float height = (float)region.height * region.scl();
        if (!wall.synthetic() && wall != Blocks.air && !wall.isMultiblock()) {
            offsetY = 0.0f;
            offsetX = 0.0f;
            height = 8.0f;
            width = 8.0f;
        }
        mesh.draw(idxDecal, region, (float)(wx * 8) + offsetX, (float)(wy * 8) + offsetY, width, height);
        mesh.setColor(Color.white);
    }

    @Override
    public void dispose() {
        if (this.chunks == null) {
            return;
        }
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                if (this.chunks[x][y] == null) continue;
                this.chunks[x][y].dispose();
            }
        }
    }
}

