/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.game.SpawnGroup;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class WaveGraph
extends Table {
    public Seq<SpawnGroup> groups = new Seq();
    public int from = 0;
    public int to = 20;
    private Mode mode = Mode.counts;
    private int[][] values;
    private OrderedSet<UnitType> used = new OrderedSet();
    private int max;
    private int maxTotal;
    private float maxHealth;
    private Table colors;
    private ObjectSet<UnitType> hidden = new ObjectSet();

    public WaveGraph() {
        this.background(Tex.pane);
        this.rect((x, y, width, height) -> {
            float cx;
            int n;
            Lines.stroke(Scl.scl(3.0f));
            GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
            Font font = Fonts.outline;
            lay.setText(font, "1");
            switch (this.mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case counts: {
                    n = this.nextStep(this.max);
                    break;
                }
                case health: {
                    n = this.nextStep((int)this.maxHealth);
                    break;
                }
                case totals: {
                    n = this.nextStep(this.maxTotal);
                }
            }
            int maxY = n;
            float fh = lay.height;
            float offsetX = Scl.scl(lay.width * (float)(maxY + "").length() * 2.0f);
            float offsetY = Scl.scl(22.0f) + fh + Scl.scl(5.0f);
            float graphX = x + offsetX;
            float graphY = y + offsetY;
            float graphW = width - offsetX;
            float graphH = height - offsetY;
            float spacing = graphW / (float)(this.values.length - 1);
            if (this.mode == Mode.counts) {
                for (UnitType type : this.used.orderedItems()) {
                    Draw.color(this.color(type));
                    Draw.alpha(this.parentAlpha);
                    Lines.beginLine();
                    for (int i = 0; i < this.values.length; ++i) {
                        int val = this.values[i][type.id];
                        cx = graphX + (float)i * spacing;
                        float cy = graphY + (float)val * graphH / (float)maxY;
                        Lines.linePoint(cx, cy);
                    }
                    Lines.endLine();
                }
            } else if (this.mode == Mode.totals) {
                Lines.beginLine();
                Draw.color(Pal.accent);
                for (int i = 0; i < this.values.length; ++i) {
                    int sum = 0;
                    for (UnitType type : this.used.orderedItems()) {
                        sum += this.values[i][type.id];
                    }
                    float cx2 = graphX + (float)i * spacing;
                    float cy = graphY + (float)sum * graphH / (float)maxY;
                    Lines.linePoint(cx2, cy);
                }
                Lines.endLine();
            } else if (this.mode == Mode.health) {
                Lines.beginLine();
                Draw.color(Pal.health);
                for (int i = 0; i < this.values.length; ++i) {
                    float sum = 0.0f;
                    for (UnitType type : this.used.orderedItems()) {
                        sum += type.health * (float)this.values[i][type.id];
                    }
                    float cx3 = graphX + (float)i * spacing;
                    float cy = graphY + sum * graphH / (float)maxY;
                    Lines.linePoint(cx3, cy);
                }
                Lines.endLine();
            }
            float totalMarks = Mathf.clamp(maxY, 1, 10);
            int markSpace = Math.max(1, Mathf.ceil((float)maxY / totalMarks));
            Draw.color(Color.lightGray);
            Draw.alpha(0.1f);
            for (int i = 0; i < maxY; i += markSpace) {
                float cy = graphY + (float)i * graphH / (float)maxY;
                cx = graphX;
                Lines.line(cx, cy, cx + graphW, cy);
                lay.setText(font, "" + i);
                font.draw("" + i, cx, cy + lay.height / 2.0f, 16);
            }
            Draw.alpha(1.0f);
            float len = Scl.scl(4.0f);
            font.setColor(Color.lightGray);
            for (int i = 0; i < this.values.length; ++i) {
                float cy = y + fh;
                float cx4 = graphX + graphW / (float)(this.values.length - 1) * (float)i;
                Lines.line(cx4, cy, cx4, cy + len);
                if (i != this.values.length / 2) continue;
                font.draw("" + (i + this.from + 1), cx4, cy - Scl.scl(2.0f), 1);
            }
            font.setColor(Color.white);
            Pools.free(lay);
            Draw.reset();
        }).pad(4.0f).padBottom(10.0f).grow();
        this.row();
        this.table((Table t) -> {
            this.colors = t;
        }).growX();
        this.row();
        this.table((Table t) -> {
            t.left();
            ButtonGroup group = new ButtonGroup();
            for (Mode m : Mode.all) {
                t.button("@wavemode." + m.name(), Styles.fullTogglet, () -> {
                    this.mode = m;
                }).group(group).height(35.0f).update((T b) -> b.setChecked(m == this.mode)).width(130.0f);
            }
        }).growX();
    }

    public void rebuild() {
        this.values = new int[this.to - this.from + 1][Vars.content.units().size];
        this.used.clear();
        this.maxTotal = 1;
        this.max = 1;
        this.maxHealth = 1.0f;
        for (int i = this.from; i <= this.to; ++i) {
            int index = i - this.from;
            float healthsum = 0.0f;
            int sum = 0;
            for (SpawnGroup spawn : this.groups) {
                int spawned = spawn.getSpawned(i);
                int[] nArray = this.values[index];
                short s = spawn.type.id;
                nArray[s] = nArray[s] + spawned;
                if (spawned > 0) {
                    this.used.add(spawn.type);
                }
                this.max = Math.max(this.max, this.values[index][spawn.type.id]);
                healthsum += (float)spawned * spawn.type.health;
                sum += spawned;
            }
            this.maxTotal = Math.max(this.maxTotal, sum);
            this.maxHealth = Math.max(this.maxHealth, healthsum);
        }
        ObjectSet usedCopy = new ObjectSet(this.used);
        this.colors.clear();
        this.colors.left();
        this.colors.button("@waves.units.hide", Styles.flatt, () -> {
            if (this.hidden.size == usedCopy.size) {
                this.hidden.clear();
            } else {
                this.hidden.addAll(usedCopy);
            }
            this.used.clear();
            this.used.addAll(usedCopy);
            for (UnitType o : this.hidden) {
                this.used.remove(o);
            }
        }).update((T b) -> b.setText(this.hidden.size == usedCopy.size ? "@waves.units.show" : "@waves.units.hide")).height(32.0f).width(130.0f);
        this.colors.pane((Table t) -> {
            t.left();
            for (UnitType type : this.used) {
                t.button((Button b) -> {
                    Color tcolor = this.color(type).cpy();
                    b.image().size(32.0f).update((T i) -> i.setColor(b.isChecked() ? Tmp.c1.set(tcolor).mul(0.5f) : tcolor)).get().act(1.0f);
                    b.image(type.uiIcon).size(32.0f).padRight(20.0f).update((T i) -> i.setColor(b.isChecked() ? Color.gray : Color.white)).get().act(1.0f);
                    b.margin(0.0f);
                }, (Button.ButtonStyle)Styles.fullTogglet, () -> {
                    if (!this.hidden.add(type)) {
                        this.hidden.remove(type);
                    }
                    this.used.clear();
                    this.used.addAll(usedCopy);
                    for (UnitType o : this.hidden) {
                        this.used.remove(o);
                    }
                }).update((T b) -> b.setChecked(this.hidden.contains(type)));
            }
        }).scrollY(false);
        for (UnitType type : this.hidden) {
            this.used.remove(type);
        }
    }

    Color color(UnitType type) {
        return Tmp.c1.fromHsv((float)type.id / (float)Vars.content.units().size * 360.0f, 0.7f, 1.0f);
    }

    int nextStep(float value) {
        int order = 1;
        while ((float)order < value) {
            if ((float)(order * 2) > value) {
                return order * 2;
            }
            if ((float)(order * 5) > value) {
                return order * 5;
            }
            if ((float)(order * 10) > value) {
                return order * 10;
            }
            order *= 10;
        }
        return order;
    }

    static enum Mode {
        counts,
        totals,
        health;

        static Mode[] all;

        static {
            all = Mode.values();
        }
    }
}

