/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Events;
import arc.math.Mathf;
import arc.struct.Bits;
import arc.struct.LongSeq;
import arc.util.Nullable;
import arc.util.Time;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.FogEvent;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.io.SaveFileReader;
import mindustry.io.SaveVersion;
import mindustry.world.meta.BlockFlag;

public final class FogControl
implements SaveFileReader.CustomChunk {
    private static volatile int ww;
    private static volatile int wh;
    private static final int dynamicUpdateInterval = 40;
    private static final Object notifyStatic;
    private static final Object notifyDynamic;
    @Nullable
    private volatile FogData[] fog;
    private final LongSeq staticEvents = new LongSeq();
    private final LongSeq dynamicEventQueue = new LongSeq();
    private final LongSeq unitEventQueue = new LongSeq();
    private final LongSeq dynamicEvents = new LongSeq(100);
    @Nullable
    private Thread staticFogThread;
    @Nullable
    private Thread dynamicFogThread;
    private boolean justLoaded = false;
    private boolean loadedStatic = false;

    public FogControl() {
        Events.on(EventType.ResetEvent.class, e -> this.stop());
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.stop();
            this.loadedStatic = false;
            this.justLoaded = true;
            ww = Vars.world.width();
            wh = Vars.world.height();
            if (Vars.state.rules.fog && Vars.state.rules.staticFog) {
                this.pushStaticBlocks(true);
                this.updateStatic();
                this.loadedStatic = true;
            }
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            if (Vars.state.rules.fog && event.tile.build != null && event.tile.isCenter() && !event.tile.build.team.isOnlyAI() && event.tile.block().flags.contains(BlockFlag.hasFogRadius)) {
                FogData data = this.data(event.tile.team());
                if (data != null) {
                    data.dynamicUpdated = true;
                }
                if (Vars.state.rules.staticFog) {
                    LongSeq longSeq = this.staticEvents;
                    synchronized (longSeq) {
                        this.pushEvent(FogEvent.get(event.tile.x, event.tile.y, Mathf.round(event.tile.build.fogRadius()), event.tile.build.team.id), false);
                    }
                }
            }
        });
        Events.on(EventType.TilePreChangeEvent.class, e -> {
            FogData data;
            if (Vars.state.rules.fog && e.tile.build != null && !e.tile.build.team.isOnlyAI() && e.tile.block().flags.contains(BlockFlag.hasFogRadius) && (data = this.data(e.tile.team())) != null) {
                data.dynamicUpdated = true;
            }
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (Vars.state.rules.fog && this.fog[e.unit.team.id] != null) {
                this.fog[e.unit.team.id].dynamicUpdated = true;
            }
        });
        SaveVersion.addCustomChunk("static-fog-data", this);
    }

    @Nullable
    public Bits getDiscovered(Team team) {
        return this.fog == null || this.fog[team.id] == null ? null : this.fog[team.id].staticData;
    }

    public boolean isDiscovered(Team team, int x, int y) {
        if (!Vars.state.rules.staticFog || !Vars.state.rules.fog || team == null || team.isAI()) {
            return true;
        }
        Bits data = this.getDiscovered(team);
        if (data == null) {
            return false;
        }
        if (x < 0 || y < 0 || x >= ww || y >= wh) {
            return false;
        }
        return data.get(x + y * ww);
    }

    public boolean isVisible(Team team, float x, float y) {
        return this.isVisibleTile(team, World.toTile(x), World.toTile(y));
    }

    public boolean isVisibleTile(Team team, int x, int y) {
        if (!Vars.state.rules.fog || team == null || team.isAI()) {
            return true;
        }
        FogData data = this.data(team);
        if (data == null) {
            return false;
        }
        if (x < 0 || y < 0 || x >= ww || y >= wh) {
            return false;
        }
        return data.read.get(x + y * ww);
    }

    public void resetFog() {
        this.fog = null;
    }

    @Nullable
    FogData data(Team team) {
        return this.fog == null || this.fog[team.id] == null ? null : this.fog[team.id];
    }

    void stop() {
        this.fog = null;
        this.staticEvents.clear();
        if (this.staticFogThread != null) {
            this.staticFogThread.interrupt();
            this.staticFogThread = null;
        }
        this.dynamicEvents.clear();
        if (this.dynamicFogThread != null) {
            this.dynamicFogThread.interrupt();
            this.dynamicFogThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushStaticBlocks(boolean initial) {
        if (this.fog == null) {
            this.fog = new FogData[256];
        }
        LongSeq longSeq = this.staticEvents;
        synchronized (longSeq) {
            for (Building build : Groups.build) {
                if (!build.block.flags.contains(BlockFlag.hasFogRadius)) continue;
                if (this.fog[build.team.id] == null) {
                    this.fog[build.team.id] = new FogData();
                }
                this.pushEvent(FogEvent.get(build.tile.x, build.tile.y, Mathf.round(build.fogRadius()), build.team.id), initial);
            }
        }
    }

    void pushEvent(long event, boolean skipRender) {
        if (!Vars.state.rules.staticFog) {
            return;
        }
        this.staticEvents.add(event);
        if (!skipRender && !Vars.headless && FogEvent.team(event) == Vars.player.team().id) {
            Vars.renderer.fog.handleEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate(Team team, Building build) {
        if (Vars.state.rules.fog && this.fog[team.id] != null) {
            this.fog[team.id].dynamicUpdated = true;
            if (Vars.state.rules.staticFog) {
                LongSeq longSeq = this.staticEvents;
                synchronized (longSeq) {
                    this.pushEvent(FogEvent.get(build.tile.x, build.tile.y, Mathf.round(build.fogRadius()), build.team.id), false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object;
        if (this.fog == null) {
            this.fog = new FogData[256];
        }
        if (Vars.state.rules.staticFog && !this.loadedStatic) {
            this.pushStaticBlocks(false);
            this.updateStatic();
            this.loadedStatic = true;
        }
        if (this.staticFogThread == null) {
            this.staticFogThread = new StaticFogThread();
            this.staticFogThread.setPriority(4);
            this.staticFogThread.setDaemon(true);
            this.staticFogThread.start();
        }
        if (this.dynamicFogThread == null) {
            this.dynamicFogThread = new DynamicFogThread();
            this.dynamicFogThread.setPriority(4);
            this.dynamicFogThread.setDaemon(true);
            this.dynamicFogThread.start();
        }
        this.dynamicEventQueue.clear();
        for (Teams.TeamData team : Vars.state.teams.present) {
            if (team.team.isOnlyAI()) continue;
            this.unitEventQueue.clear();
            FogData data = this.fog[team.team.id];
            if (data == null) {
                data = this.fog[team.team.id] = new FogData();
            }
            LongSeq longSeq = this.staticEvents;
            synchronized (longSeq) {
                for (Unit unit : team.units) {
                    int tx = unit.tileX();
                    int ty = unit.tileY();
                    int pos = tx + ty * ww;
                    if (unit.type.fogRadius <= 0.0f) continue;
                    long event = FogEvent.get(tx, ty, (int)unit.type.fogRadius, team.team.id);
                    this.unitEventQueue.add(event);
                    if (unit.lastFogPos == pos) continue;
                    this.pushEvent(event, false);
                    unit.lastFogPos = pos;
                    data.dynamicUpdated = true;
                }
            }
            if (!data.dynamicUpdated || Time.timeSinceMillis(data.lastDynamicMs) <= 40L) continue;
            data.dynamicUpdated = false;
            data.lastDynamicMs = Time.millis();
            for (Building build : Vars.indexer.getFlagged(team.team, BlockFlag.hasFogRadius)) {
                this.dynamicEventQueue.add(FogEvent.get(build.tile.x, build.tile.y, Mathf.round(build.fogRadius()), build.team.id));
            }
            this.dynamicEventQueue.addAll(this.unitEventQueue);
        }
        if (this.dynamicEventQueue.size > 0) {
            object = this.dynamicEvents;
            synchronized (object) {
                this.dynamicEvents.clear();
                this.dynamicEvents.addAll(this.dynamicEventQueue);
            }
            this.dynamicEventQueue.clear();
            if (this.justLoaded) {
                this.updateDynamic(new Bits(256));
                this.justLoaded = false;
            }
            object = notifyDynamic;
            synchronized (object) {
                notifyDynamic.notify();
            }
        }
        if (Vars.state.rules.staticFog && this.staticEvents.size > 0 && this.staticFogThread != null) {
            object = notifyStatic;
            synchronized (object) {
                notifyStatic.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatic() {
        LongSeq longSeq = this.staticEvents;
        synchronized (longSeq) {
            int size = this.staticEvents.size;
            for (int i = 0; i < size; ++i) {
                long event = this.staticEvents.items[i];
                int x = FogEvent.x(event);
                int y = FogEvent.y(event);
                int rad = FogEvent.radius(event);
                int team = FogEvent.team(event);
                FogData data = this.fog[team];
                if (data == null) continue;
                FogControl.circle(data.staticData, x, y, rad);
            }
            this.staticEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDynamic(Bits cleared) {
        cleared.clear();
        LongSeq longSeq = this.dynamicEvents;
        synchronized (longSeq) {
            int size = this.dynamicEvents.size;
            for (int i = 0; i < size; ++i) {
                FogData data;
                long event = this.dynamicEvents.items[i];
                int x = FogEvent.x(event);
                int y = FogEvent.y(event);
                int rad = FogEvent.radius(event);
                int team = FogEvent.team(event);
                if (rad <= 0 || (data = this.fog[team]) == null) continue;
                if (!cleared.get(team)) {
                    cleared.set(team);
                    data.write.clear();
                }
                FogControl.circle(data.write, x, y, rad + 1);
            }
            this.dynamicEvents.clear();
        }
        for (int i = 0; i < 256; ++i) {
            if (!cleared.get(i)) continue;
            FogData data = this.fog[i];
            Bits temp = data.read;
            data.read = data.write;
            data.write = temp;
        }
    }

    @Override
    public void write(DataOutput stream) throws IOException {
        int i;
        int used = 0;
        for (i = 0; i < 256; ++i) {
            if (this.fog[i] == null) continue;
            ++used;
        }
        stream.writeByte(used);
        stream.writeShort(Vars.world.width());
        stream.writeShort(Vars.world.height());
        for (i = 0; i < 256; ++i) {
            if (this.fog[i] == null) continue;
            stream.writeByte(i);
            Bits data = this.fog[i].staticData;
            int size = ww * wh;
            int pos = 0;
            while (pos < size) {
                int consecutives;
                boolean cur = data.get(pos);
                for (consecutives = 0; consecutives < 127 && pos < size && cur == data.get(pos); ++consecutives, ++pos) {
                }
                int mask = cur ? 128 : 0;
                stream.write(mask | consecutives);
            }
        }
    }

    @Override
    public void read(DataInput stream) throws IOException {
        if (this.fog == null) {
            this.fog = new FogData[256];
        }
        int teams = stream.readUnsignedByte();
        short w = stream.readShort();
        short h = stream.readShort();
        int len = w * h;
        ww = w;
        wh = h;
        for (int ti = 0; ti < teams; ++ti) {
            int team = stream.readUnsignedByte();
            this.fog[team] = new FogData();
            int pos = 0;
            Bits bools = this.fog[team].staticData;
            while (pos < len) {
                int data = stream.readByte() & 0xFF;
                boolean sign = (data & 0x80) != 0;
                int consec = data & 0x7F;
                if (sign) {
                    bools.set(pos, pos + consec);
                    pos += consec;
                    continue;
                }
                pos += consec;
            }
        }
    }

    @Override
    public boolean shouldWrite() {
        return Vars.state.rules.fog && Vars.state.rules.staticFog && this.fog != null;
    }

    static void circle(Bits arr, int x, int y, int radius) {
        int f = 1 - radius;
        int ddFx = 1;
        int ddFy = -2 * radius;
        int px = 0;
        int py = radius;
        FogControl.hline(arr, x, x, y + radius);
        FogControl.hline(arr, x, x, y - radius);
        FogControl.hline(arr, x - radius, x + radius, y);
        while (px < py) {
            if (f >= 0) {
                --py;
                f += (ddFy += 2);
            }
            f += (ddFx += 2);
            FogControl.hline(arr, x - ++px, x + px, y + py);
            FogControl.hline(arr, x - px, x + px, y - py);
            FogControl.hline(arr, x - py, x + py, y + px);
            FogControl.hline(arr, x - py, x + py, y - px);
        }
    }

    static void hline(Bits arr, int x1, int x2, int y) {
        if (y < 0 || y >= wh) {
            return;
        }
        if (x1 > x2) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (x1 >= ww) {
            return;
        }
        if (x2 < 0) {
            return;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 >= ww) {
            x2 = ww - 1;
        }
        int off = y * ww;
        arr.set(off + x1, off + ++x2);
    }

    static {
        notifyStatic = new Object();
        notifyDynamic = new Object();
    }

    static class FogData {
        volatile Bits read;
        volatile Bits write;
        final Bits staticData;
        long lastDynamicMs = 0L;
        boolean dynamicUpdated = true;

        FogData() {
            int len = ww * wh;
            this.read = new Bits(len);
            this.write = new Bits(len);
            this.staticData = new Bits(len);
        }
    }

    class StaticFogThread
    extends Thread {
        StaticFogThread() {
            super("StaticFogThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = notifyStatic;
                        synchronized (object) {
                            try {
                                notifyStatic.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        FogControl.this.updateStatic();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    class DynamicFogThread
    extends Thread {
        final Bits cleared;

        DynamicFogThread() {
            super("DynamicFogThread");
            this.cleared = new Bits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = notifyDynamic;
                        synchronized (object) {
                            try {
                                notifyDynamic.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        FogControl.this.updateDynamic(this.cleared);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class FogEventStruct {
        int x;
        int y;
        int radius;
        int team;

        FogEventStruct() {
        }
    }
}

