/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.gen.WorldLabel;
import mindustry.graphics.MinimapRenderer;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;

public class MapObjectives
implements Iterable<MapObjective>,
Eachable<MapObjective> {
    public static final Seq<Prov<? extends MapObjective>> allObjectiveTypes = new Seq();
    public static final Seq<Prov<? extends ObjectiveMarker>> allMarkerTypes = new Seq();
    public Seq<MapObjective> all = new Seq(4);
    protected transient boolean changed;

    @SafeVarargs
    public static void registerObjective(Prov<? extends MapObjective> ... providers) {
        for (Prov<? extends MapObjective> prov : providers) {
            allObjectiveTypes.add(prov);
            Class<?> type = prov.get().getClass();
            JsonIO.classTag(Strings.camelize(type.getSimpleName().replace("Objective", "")), type);
            JsonIO.classTag(type.getSimpleName().replace("Objective", ""), type);
        }
    }

    @SafeVarargs
    public static void registerMarker(Prov<? extends ObjectiveMarker> ... providers) {
        for (Prov<? extends ObjectiveMarker> prov : providers) {
            allMarkerTypes.add(prov);
            Class<?> type = prov.get().getClass();
            JsonIO.classTag(Strings.camelize(type.getSimpleName().replace("Marker", "")), type);
            JsonIO.classTag(type.getSimpleName().replace("Marker", ""), type);
        }
    }

    public void add(MapObjective ... objectives) {
        for (MapObjective objective : objectives) {
            this.flatten(objective);
        }
    }

    private void flatten(MapObjective objective) {
        for (MapObjective child : objective.children) {
            this.flatten(child);
        }
        objective.children.clear();
        this.all.add(objective);
    }

    public void update() {
        this.eachRunning(obj -> {
            for (ObjectiveMarker marker : obj.markers) {
                if (marker.wasAdded) continue;
                marker.wasAdded = true;
                marker.added();
            }
            if (obj.update() && !Vars.net.client()) {
                ((MapObjective)obj).completed = true;
                obj.done();
                for (ObjectiveMarker marker : obj.markers) {
                    if (!marker.wasAdded) continue;
                    marker.removed();
                    marker.wasAdded = false;
                }
            }
            this.changed |= ((MapObjective)obj).changed;
            ((MapObjective)obj).changed = false;
        });
    }

    public boolean checkChanged() {
        boolean has = this.changed;
        this.changed = false;
        return has;
    }

    public boolean any() {
        return this.all.count(MapObjective::qualified) > 0;
    }

    public void clear() {
        if (this.all.size > 0) {
            this.changed = true;
        }
        this.all.clear();
    }

    public void eachRunning(Cons<MapObjective> cons) {
        this.all.each(MapObjective::qualified, cons);
    }

    public <T extends MapObjective> void eachRunning(Boolf<? super MapObjective> pred, Cons<T> cons) {
        this.all.each(obj -> obj.qualified() && pred.get((MapObjective)obj), cons);
    }

    @Override
    public Iterator<MapObjective> iterator() {
        return this.all.iterator();
    }

    @Override
    public void each(Cons<? super MapObjective> cons) {
        this.all.each(cons);
    }

    static {
        MapObjectives.registerObjective(ResearchObjective::new, ProduceObjective::new, ItemObjective::new, CoreItemObjective::new, BuildCountObjective::new, UnitCountObjective::new, DestroyUnitsObjective::new, TimerObjective::new, DestroyBlockObjective::new, DestroyBlocksObjective::new, DestroyCoreObjective::new, CommandModeObjective::new, FlagObjective::new);
        MapObjectives.registerMarker(ShapeTextMarker::new, MinimapMarker::new, ShapeMarker::new, TextMarker::new);
    }

    public static abstract class MapObjective {
        @Nullable
        @Multiline
        public String details;
        @Unordered
        public String[] flagsAdded = new String[0];
        @Unordered
        public String[] flagsRemoved = new String[0];
        public ObjectiveMarker[] markers = new ObjectiveMarker[0];
        public transient Seq<MapObjective> parents = new Seq(2);
        private final transient Seq<MapObjective> children = new Seq(2);
        public transient int editorX = -1;
        public transient int editorY = -1;
        private boolean completed;
        private transient boolean depFinished;
        private transient boolean changed;

        public abstract boolean update();

        public void reset() {
        }

        public void done() {
            this.changed();
            Call.objectiveCompleted(this.flagsRemoved, this.flagsAdded);
        }

        protected void changed() {
            this.changed = true;
        }

        public final boolean dependencyFinished() {
            if (this.depFinished) {
                return true;
            }
            for (MapObjective parent : this.parents) {
                if (parent.isCompleted()) continue;
                return false;
            }
            this.depFinished = true;
            return true;
        }

        public final boolean isCompleted() {
            return this.completed;
        }

        public boolean qualified() {
            return !this.completed && this.dependencyFinished();
        }

        public MapObjective child(MapObjective child) {
            child.parents.add(this);
            this.children.add(child);
            return this;
        }

        public MapObjective parent(MapObjective parent) {
            this.parents.add(parent);
            return this;
        }

        public MapObjective details(String details) {
            this.details = details;
            return this;
        }

        public MapObjective flagsAdded(String ... flagsAdded) {
            this.flagsAdded = flagsAdded;
            return this;
        }

        public MapObjective flagsRemoved(String ... flagsRemoved) {
            this.flagsRemoved = flagsRemoved;
            return this;
        }

        public MapObjective markers(ObjectiveMarker ... markers) {
            this.markers = markers;
            return this;
        }

        @Nullable
        public String text() {
            return null;
        }

        @Nullable
        public String details() {
            return this.details;
        }

        public String typeName() {
            String className = this.getClass().getSimpleName().replace("Objective", "");
            return Core.bundle == null ? className : Core.bundle.get("objective." + className.toLowerCase() + ".name", className);
        }
    }

    public static abstract class ObjectiveMarker {
        public transient boolean wasAdded;

        public void draw() {
        }

        public void drawMinimap(MinimapRenderer minimap) {
        }

        public void added() {
        }

        public void removed() {
        }

        public String typeName() {
            String className = this.getClass().getSimpleName().replace("Marker", "");
            return Core.bundle == null ? className : Core.bundle.get("marker." + className.toLowerCase() + ".name", className);
        }

        public static String fetchText(String text) {
            return text.startsWith("@") ? (Vars.mobile ? Core.bundle.get(text.substring(1) + ".mobile", Core.bundle.get(text.substring(1))) : Core.bundle.get(text.substring(1))) : text;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TilePos {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Second {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Multiline {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Synthetic {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Researchable {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LabelFlag {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unordered {
    }

    public static class TextMarker
    extends ObjectiveMarker {
        @Multiline
        public String text = "uwu";
        @TilePos
        public Vec2 pos = new Vec2();
        public float fontSize = 1.0f;
        @LabelFlag
        public byte flags = (byte)3;
        private transient String fetchedText;

        public TextMarker(String text, float x, float y, float fontSize, byte flags) {
            this.text = text;
            this.fontSize = fontSize;
            this.flags = flags;
            this.pos.set(x, y);
        }

        public TextMarker(String text, float x, float y) {
            this.text = text;
            this.pos.set(x, y);
        }

        public TextMarker() {
        }

        @Override
        public void draw() {
            if (this.fetchedText == null) {
                this.fetchedText = TextMarker.fetchText(this.text);
            }
            WorldLabel.drawAt(this.fetchedText, this.pos.x, this.pos.y, Draw.z(), this.flags, this.fontSize);
        }
    }

    public static class ShapeMarker
    extends ObjectiveMarker {
        @TilePos
        public Vec2 pos = new Vec2();
        public float radius = 8.0f;
        public float rotation = 0.0f;
        public float stroke = 1.0f;
        public boolean fill = false;
        public boolean outline = true;
        public int sides = 4;
        public Color color = Color.valueOf("ffd37f");

        public ShapeMarker(float x, float y) {
            this.pos.set(x, y);
        }

        public ShapeMarker(float x, float y, float radius, float rotation) {
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
        }

        public ShapeMarker() {
        }

        @Override
        public void draw() {
            int sides = Math.min(this.sides, 200);
            if (!this.fill) {
                if (this.outline) {
                    Lines.stroke(this.stroke + 2.0f, Pal.gray);
                    Lines.poly(this.pos.x, this.pos.y, sides, this.radius + 1.0f, this.rotation);
                }
                Lines.stroke(this.stroke, this.color);
                Lines.poly(this.pos.x, this.pos.y, sides, this.radius + 1.0f, this.rotation);
            } else {
                Draw.color(this.color);
                Fill.poly(this.pos.x, this.pos.y, sides, this.radius, this.rotation);
            }
            Draw.reset();
        }
    }

    public static class MinimapMarker
    extends ObjectiveMarker {
        public Point2 pos = new Point2();
        public float radius = 5.0f;
        public float stroke = 11.0f;
        public Color color = Color.valueOf("f25555");

        public MinimapMarker(int x, int y) {
            this.pos.set(x, y);
        }

        public MinimapMarker(int x, int y, Color color) {
            this.pos.set(x, y);
            this.color = color;
        }

        public MinimapMarker(int x, int y, float radius, float stroke, Color color) {
            this.pos.set(x, y);
            this.stroke = stroke;
            this.radius = radius;
            this.color = color;
        }

        public MinimapMarker() {
        }

        @Override
        public void drawMinimap(MinimapRenderer minimap) {
            minimap.transform(Tmp.v1.set(this.pos.x * 8, this.pos.y * 8));
            float rad = minimap.scale(this.radius * 8.0f);
            float fin = Interp.pow2Out.apply(Time.globalTime / 100.0f % 1.0f);
            Lines.stroke(Scl.scl((1.0f - fin) * this.stroke + 0.1f), this.color);
            Lines.circle(Tmp.v1.x, Tmp.v1.y, rad * fin);
            Draw.reset();
        }
    }

    public static class ShapeTextMarker
    extends ObjectiveMarker {
        @Multiline
        public String text = "frog";
        @TilePos
        public Vec2 pos = new Vec2();
        public float fontSize = 1.0f;
        public float textHeight = 7.0f;
        @LabelFlag
        public byte flags = (byte)3;
        public float radius = 6.0f;
        public float rotation = 0.0f;
        public int sides = 4;
        public Color color = Color.valueOf("ffd37f");
        private transient String fetchedText;

        public ShapeTextMarker(String text, float x, float y) {
            this.text = text;
            this.pos.set(x, y);
        }

        public ShapeTextMarker(String text, float x, float y, float radius) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
        }

        public ShapeTextMarker(String text, float x, float y, float radius, float rotation) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
        }

        public ShapeTextMarker(String text, float x, float y, float radius, float rotation, float textHeight) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
            this.textHeight = textHeight;
        }

        public ShapeTextMarker() {
        }

        @Override
        public void draw() {
            Lines.stroke(3.0f, Pal.gray);
            Lines.poly(this.pos.x, this.pos.y, this.sides, this.radius + 1.0f, this.rotation);
            Lines.stroke(1.0f, this.color);
            Lines.poly(this.pos.x, this.pos.y, this.sides, this.radius + 1.0f, this.rotation);
            Draw.reset();
            if (this.fetchedText == null) {
                this.fetchedText = ShapeTextMarker.fetchText(this.text);
            }
            WorldLabel.drawAt(this.fetchedText, this.pos.x, this.pos.y + this.radius + this.textHeight, Draw.z(), this.flags, this.fontSize);
        }
    }

    public static class DestroyCoreObjective
    extends MapObjective {
        @Override
        public boolean update() {
            return Vars.state.rules.waveTeam.cores().size == 0;
        }

        @Override
        public String text() {
            return Core.bundle.get("objective.destroycore");
        }
    }

    public static class FlagObjective
    extends MapObjective {
        public String flag = "flag";
        @Multiline
        public String text;

        public FlagObjective(String flag, String text) {
            this.flag = flag;
            this.text = text;
        }

        public FlagObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.objectiveFlags.contains(this.flag);
        }

        @Override
        public String text() {
            return this.text != null && this.text.startsWith("@") ? Core.bundle.get(this.text.substring(1)) : this.text;
        }
    }

    public static class CommandModeObjective
    extends MapObjective {
        @Override
        public boolean update() {
            return Vars.headless || Vars.control.input.selectedUnits.contains((Unit)((Object)((Boolf<Unit>)u -> u.isCommandable() && u.command().hasCommand())));
        }

        @Override
        public String text() {
            return Core.bundle.get("objective.command");
        }
    }

    public static class DestroyBlocksObjective
    extends MapObjective {
        @Unordered
        public Point2[] positions = new Point2[0];
        public Team team = Team.crux;
        @Synthetic
        public Block block = Blocks.router;

        public DestroyBlocksObjective(Block block, Team team, Point2 ... positions) {
            this.block = block;
            this.team = team;
            this.positions = positions;
        }

        public DestroyBlocksObjective() {
        }

        public int progress() {
            int count = 0;
            for (Point2 pos : this.positions) {
                Building build = Vars.world.build(pos.x, pos.y);
                if (build != null && build.team == this.team && build.block == this.block) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean update() {
            return this.progress() >= this.positions.length;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyblocks", this.progress(), this.positions.length, this.block.emoji(), this.block.localizedName);
        }
    }

    public static class DestroyBlockObjective
    extends MapObjective {
        public Point2 pos = new Point2();
        public Team team = Team.crux;
        @Synthetic
        public Block block = Blocks.router;

        public DestroyBlockObjective(Block block, int x, int y, Team team) {
            this.block = block;
            this.team = team;
            this.pos.set(x, y);
        }

        public DestroyBlockObjective() {
        }

        @Override
        public boolean update() {
            Building build = Vars.world.build(this.pos.x, this.pos.y);
            return build == null || build.team != this.team || build.block != this.block;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyblock", this.block.emoji(), this.block.localizedName);
        }
    }

    public static class TimerObjective
    extends MapObjective {
        @Multiline
        public String text;
        @Second
        public float duration = 1800.0f;
        protected float countup;

        public TimerObjective(String text, float duration) {
            this.text = text;
            this.duration = duration;
        }

        public TimerObjective() {
        }

        @Override
        public boolean update() {
            float f;
            this.countup += Time.delta;
            return f >= this.duration;
        }

        @Override
        public void reset() {
            this.countup = 0.0f;
        }

        @Override
        @Nullable
        public String text() {
            if (this.text != null) {
                int i = (int)((this.duration - this.countup) / 60.0f);
                StringBuilder timeString = new StringBuilder();
                int m = i / 60;
                int s = i % 60;
                if (m > 0) {
                    timeString.append(m);
                    timeString.append(":");
                    if (s < 10) {
                        timeString.append("0");
                    }
                }
                timeString.append(s);
                if (this.text.startsWith("@")) {
                    return Core.bundle.format(this.text.substring(1), timeString.toString());
                }
                try {
                    return Core.bundle.formatString(this.text, timeString.toString());
                }
                catch (IllegalArgumentException e) {
                    this.text = "";
                }
            }
            return null;
        }
    }

    public static class DestroyUnitsObjective
    extends MapObjective {
        public int count = 1;

        public DestroyUnitsObjective(int count) {
            this.count = count;
        }

        public DestroyUnitsObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.enemyUnitsDestroyed >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyunits", this.count - Vars.state.stats.enemyUnitsDestroyed);
        }
    }

    public static class UnitCountObjective
    extends MapObjective {
        public UnitType unit = UnitTypes.dagger;
        public int count = 1;

        public UnitCountObjective(UnitType unit, int count) {
            this.unit = unit;
            this.count = count;
        }

        public UnitCountObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.defaultTeam.data().countType(this.unit) >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.buildunit", this.count - Vars.state.rules.defaultTeam.data().countType(this.unit), this.unit.emoji(), this.unit.localizedName);
        }
    }

    public static class BuildCountObjective
    extends MapObjective {
        @Synthetic
        public Block block = Blocks.conveyor;
        public int count = 1;

        public BuildCountObjective(Block block, int count) {
            this.block = block;
            this.count = count;
        }

        public BuildCountObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.placedBlockCount.get(this.block, 0) >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.build", this.count - Vars.state.stats.placedBlockCount.get(this.block, 0), this.block.emoji(), this.block.localizedName);
        }
    }

    public static class CoreItemObjective
    extends MapObjective {
        public Item item = Items.copper;
        public int amount = 2;

        public CoreItemObjective(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public CoreItemObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.coreItemCount.get(this.item) >= this.amount;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.coreitem", Vars.state.stats.coreItemCount.get(this.item), this.amount, this.item.emoji(), this.item.localizedName);
        }
    }

    public static class ItemObjective
    extends MapObjective {
        public Item item = Items.copper;
        public int amount = 1;

        public ItemObjective(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public ItemObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.defaultTeam.items().has(this.item, this.amount);
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.item", Vars.state.rules.defaultTeam.items().get(this.item), this.amount, this.item.emoji(), this.item.localizedName);
        }
    }

    public static class ProduceObjective
    extends MapObjective {
        @Researchable
        public UnlockableContent content = Items.copper;

        public ProduceObjective(UnlockableContent content) {
            this.content = content;
        }

        public ProduceObjective() {
        }

        @Override
        public boolean update() {
            return this.content.unlocked();
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.produce", this.content.emoji(), this.content.localizedName);
        }
    }

    public static class ResearchObjective
    extends MapObjective {
        @Researchable
        public UnlockableContent content = Items.copper;

        public ResearchObjective(UnlockableContent content) {
            this.content = content;
        }

        public ResearchObjective() {
        }

        @Override
        public boolean update() {
            return this.content.unlocked();
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.research", this.content.emoji(), this.content.localizedName);
        }
    }
}

