/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import mindustry.ctype.UnlockableContent;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;

public class Objectives {

    public static interface Objective {
        public boolean complete();

        public String display();

        default public void build(Table table) {
        }
    }

    public static class OnPlanet
    implements Objective {
        public Planet planet;

        public OnPlanet(Planet planet) {
            this.planet = planet;
        }

        protected OnPlanet() {
        }

        @Override
        public boolean complete() {
            return this.planet.sectors.contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase)));
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.onplanet", this.planet.localizedName);
        }
    }

    public static class OnSector
    implements Objective {
        public SectorPreset preset;

        public OnSector(SectorPreset zone) {
            this.preset = zone;
        }

        protected OnSector() {
        }

        @Override
        public boolean complete() {
            return this.preset.sector.hasBase();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.onsector", this.preset.localizedName);
        }
    }

    public static class SectorComplete
    implements Objective {
        public SectorPreset preset;

        public SectorComplete(SectorPreset zone) {
            this.preset = zone;
        }

        protected SectorComplete() {
        }

        @Override
        public boolean complete() {
            return this.preset.sector.save != null && this.preset.sector.isCaptured() && this.preset.sector.hasBase();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.capture", this.preset.localizedName);
        }
    }

    public static class Produce
    implements Objective {
        public UnlockableContent content;

        public Produce(UnlockableContent content) {
            this.content = content;
        }

        protected Produce() {
        }

        @Override
        public boolean complete() {
            return this.content.unlocked();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.produce", this.content.unlocked() ? this.content.emoji() + " " + this.content.localizedName : "???");
        }
    }

    public static class Research
    implements Objective {
        public UnlockableContent content;

        public Research(UnlockableContent content) {
            this.content = content;
        }

        protected Research() {
        }

        @Override
        public boolean complete() {
            return this.content.unlocked();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.research", this.content.techNode == null || this.content.techNode.parent == null || this.content.techNode.parent.content.unlocked() ? this.content.emoji() + " " + this.content.localizedName : "???");
        }
    }
}

