/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatf;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.WindowedMean;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.maps.SectorDamage;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.modules.ItemModule;

public class SectorInfo {
    private static final int valueWindow = 60;
    private static final float refreshPeriod = 60.0f;
    private static float returnf;
    public ObjectMap<Item, ExportStat> production = new ObjectMap();
    public ObjectMap<Item, ExportStat> rawProduction = new ObjectMap();
    public ObjectMap<Item, ExportStat> export = new ObjectMap();
    public ItemSeq items = new ItemSeq();
    public Block bestCoreType = Blocks.coreShard;
    public int storageCapacity = 0;
    public boolean hasCore = true;
    public boolean wasCaptured = false;
    @Nullable
    public Sector origin;
    @Nullable
    public Sector destination;
    public Seq<UnlockableContent> resources = new Seq();
    public boolean waves = true;
    public boolean attack = false;
    public boolean hasSpawns = true;
    public int wave = 1;
    public int winWave = -1;
    public int wavesSurvived = -1;
    public float waveSpacing = 7200.0f;
    public float damage;
    public int wavesPassed;
    public int spawnPosition;
    public float secondsPassed;
    public float minutesCaptured;
    @Nullable
    public String name;
    @Nullable
    public String icon;
    @Nullable
    public UnlockableContent contentIcon;
    public int waveVersion = -1;
    public boolean shown = false;
    public transient ItemSeq lastImported = new ItemSeq();
    public float sumHealth;
    public float sumRps;
    public float sumDps;
    public float waveHealthBase;
    public float waveHealthSlope;
    public float waveDpsBase;
    public float waveDpsSlope;
    public float bossHealth;
    public float bossDps;
    public float curEnemyHealth;
    public float curEnemyDps;
    public int bossWave = -1;
    private transient Interval time = new Interval();
    @Nullable
    private transient int[] coreDeltas;
    @Nullable
    private transient int[] productionDeltas;

    public void handleCoreItem(Item item, int amount) {
        if (this.coreDeltas == null) {
            this.coreDeltas = new int[Vars.content.items().size];
        }
        short s = item.id;
        this.coreDeltas[s] = this.coreDeltas[s] + amount;
    }

    public void handleProduction(Item item, int amount) {
        if (this.productionDeltas == null) {
            this.productionDeltas = new int[Vars.content.items().size];
        }
        short s = item.id;
        this.productionDeltas[s] = this.productionDeltas[s] + amount;
    }

    public Sector getRealDestination() {
        return !Vars.net.client() || this.destination != null ? this.destination : Vars.state.rules.sector.planet.sectors.find(Sector::hasBase);
    }

    public void handleItemExport(ItemStack stack) {
        this.handleItemExport(stack.item, stack.amount);
    }

    public void handleItemExport(Item item, int amount) {
        ((ExportStat)((Object)this.export.get((Item)item, (Prov<ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).counter += (float)amount;
    }

    public float getExport(Item item) {
        return ((ExportStat)((Object)this.export.get((Item)item, (Prov<ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).mean;
    }

    public void write() {
        if (Vars.state.rules.waveTeam.core() != null) {
            this.attack = true;
            if (!Vars.state.rules.sector.planet.allowWaves) {
                this.winWave = 0;
            }
        }
        if (this.winWave <= 0 && !this.attack && Vars.state.rules.sector.planet.allowWaves) {
            this.winWave = 30;
        }
        if (Vars.state.rules.sector != null && Vars.state.rules.sector.preset != null && Vars.state.rules.sector.preset.captureWave > 0 && !Vars.state.rules.sector.planet.allowWaves) {
            this.winWave = Vars.state.rules.sector.preset.captureWave;
        }
        Vars.state.wave = this.wave;
        Vars.state.rules.waves = this.waves;
        Vars.state.rules.waveSpacing = this.waveSpacing;
        Vars.state.rules.winWave = this.winWave;
        Vars.state.rules.attackMode = this.attack;
        CoreBlock.CoreBuild entity = Vars.state.rules.defaultTeam.core();
        if (entity != null) {
            entity.items.clear();
            entity.items.add(this.items);
            entity.items.each((i, a) -> entity.items.set(i, Mathf.clamp(a, 0, entity.storageCapacity)));
        }
    }

    public void prepare() {
        this.items.clear();
        CoreBlock.CoreBuild entity = Vars.state.rules.defaultTeam.core();
        if (entity != null) {
            ItemModule items = entity.items;
            for (int i = 0; i < items.length(); ++i) {
                this.items.set(Vars.content.item(i), items.get(i));
            }
            this.spawnPosition = entity.pos();
        }
        this.waveSpacing = Vars.state.rules.waveSpacing;
        this.wave = Vars.state.wave;
        this.winWave = Vars.state.rules.winWave;
        this.waves = Vars.state.rules.waves;
        this.attack = Vars.state.rules.attackMode;
        this.hasCore = entity != null;
        this.bestCoreType = !this.hasCore ? Blocks.air : Vars.state.rules.defaultTeam.cores().max((Floatf<CoreBlock.CoreBuild>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)F, lambda$prepare$1(mindustry.world.blocks.storage.CoreBlock$CoreBuild ), (Lmindustry/world/blocks/storage/CoreBlock$CoreBuild;)F)()).block;
        this.storageCapacity = entity != null ? entity.storageCapacity : 0;
        this.secondsPassed = 0.0f;
        this.wavesPassed = 0;
        this.damage = 0.0f;
        this.hasSpawns = Vars.spawner.countSpawns() > 0;
        this.production.each((item, stat) -> {
            stat.mean = Math.min(stat.mean, ((ExportStat)((Object)this.rawProduction.get((Item)item, (Prov<ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).mean);
        });
        Seq<Building> pads = Vars.indexer.getFlagged(Vars.state.rules.defaultTeam, BlockFlag.launchPad);
        if (pads.size == 0 || !pads.contains((Building)((Object)((Boolf<Building>)t -> t.efficiency > 0.0f)))) {
            this.export.clear();
        }
        if (Vars.state.rules.sector != null) {
            Vars.state.rules.sector.saveInfo();
        }
        if (Vars.state.rules.sector != null && Vars.state.rules.sector.planet.allowWaveSimulation) {
            SectorDamage.writeParameters(this);
        }
    }

    public void update() {
        if (Vars.net.client()) {
            return;
        }
        if (this.time.get(60.0f)) {
            this.export.each((item, stat) -> {
                if (!stat.loaded) {
                    stat.means.fill(stat.mean);
                    stat.loaded = true;
                }
                stat.means.add(Math.max(stat.counter, 0.0f));
                stat.counter = 0.0f;
                stat.mean = stat.means.rawMean();
            });
            if (this.coreDeltas == null) {
                this.coreDeltas = new int[Vars.content.items().size];
            }
            if (this.productionDeltas == null) {
                this.productionDeltas = new int[Vars.content.items().size];
            }
            for (Item item2 : Vars.content.items()) {
                this.updateDelta(item2, this.production, this.coreDeltas);
                this.updateDelta(item2, this.rawProduction, this.productionDeltas);
                this.production.get((Item)item2).mean = Math.min(this.production.get((Item)item2).mean, this.rawProduction.get((Item)item2).mean);
                if (!this.export.containsKey(item2)) continue;
                this.export.get((Item)item2).mean = Math.min(this.export.get((Item)item2).mean, this.rawProduction.get((Item)item2).mean + Math.max(-this.production.get((Item)item2).mean, 0.0f));
            }
            Arrays.fill(this.coreDeltas, 0);
            Arrays.fill(this.productionDeltas, 0);
        }
    }

    void updateDelta(Item item, ObjectMap<Item, ExportStat> map, int[] deltas) {
        ExportStat stat = (ExportStat)((Object)map.get(item, (ExportStat)((Object)((Prov<ExportStat>)ExportStat::new))));
        if (!stat.loaded) {
            stat.means.fill(stat.mean);
            stat.loaded = true;
        }
        stat.means.add(deltas[item.id]);
        stat.mean = stat.means.rawMean();
    }

    public ObjectFloatMap<Item> exportRates() {
        ObjectFloatMap<Item> map = new ObjectFloatMap<Item>();
        this.export.each((item, value) -> map.put((Item)item, value.mean));
        return map;
    }

    public boolean anyExports() {
        if (this.export.size == 0) {
            return false;
        }
        returnf = 0.0f;
        this.export.each((i, e) -> returnf += e.mean);
        return returnf >= 0.01f;
    }

    public ObjectMap<Item, ExportStat> importStats(Planet planet) {
        ObjectMap<Item, ExportStat> imports = new ObjectMap<Item, ExportStat>();
        this.eachImport(planet, sector -> sector.info.export.each((item, stat) -> ((ExportStat)((Object)imports.get(item, (Prov<ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).mean += stat.mean));
        return imports;
    }

    public void eachImport(Planet planet, Cons<Sector> cons) {
        for (Sector sector : planet.sectors) {
            Sector dest = sector.info.getRealDestination();
            if (!sector.hasBase() || sector.info == this || dest == null || dest.info != this || !sector.info.anyExports()) continue;
            cons.get(sector);
        }
    }

    private static /* synthetic */ float lambda$prepare$1(CoreBlock.CoreBuild e) {
        return e.block.size;
    }

    public static class ExportStat {
        public transient float counter;
        public transient WindowedMean means = new WindowedMean(60);
        public transient boolean loaded;
        public float mean;

        public String toString() {
            return this.mean + "";
        }
    }
}

