/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__label;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Syncc;
import mindustry.gen.Unitc;
import mindustry.gen.WorldLabelc;
import mindustry.graphics.Drawf;
import mindustry.io.TypeIO;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class WorldLabel
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__label,
IndexableEntity__sync,
Posc,
Syncc,
WorldLabelc {
    public static final byte flagBackground = 1;
    public static final byte flagOutline = 2;
    protected transient boolean added;
    public byte flags = (byte)3;
    public float fontSize = 1.0f;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__label = -1;
    protected transient int index__sync = -1;
    public transient long lastUpdated;
    public String text = "sample text";
    public transient long updateSpacing;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;
    public float z = 151.0f;

    protected WorldLabel() {
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public float fontSize() {
        return this.fontSize;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public int classId() {
        return 35;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String text() {
        return this.text;
    }

    public String toString() {
        return "WorldLabel#" + this.id;
    }

    @Override
    public long lastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public long updateSpacing() {
        return this.updateSpacing;
    }

    @Override
    public void flags(byte flags) {
        this.flags = flags;
    }

    @Override
    public void fontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    @Override
    public void setIndex__label(int index) {
        this.index__label = index;
    }

    @Override
    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    @Override
    public void text(String text) {
        this.text = text;
    }

    @Override
    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public void z(float z) {
        this.z = z;
    }

    @Override
    public void read(Reads read) {
        short REV = read.s();
        if (REV != 0) {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'WorldLabelComp'");
        }
        this.flags = read.b();
        this.fontSize = read.f();
        this.text = TypeIO.readString(read);
        this.x = read.f();
        this.y = read.f();
        this.z = read.f();
        this.afterRead();
    }

    @Override
    public void write(Writes write) {
        write.s(0);
        write.b(this.flags);
        write.f(this.fontSize);
        TypeIO.writeString(write, this.text);
        write.f(this.x);
        write.f(this.y);
        write.f(this.z);
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        WorldLabel worldLabel;
        return this == Vars.player || (worldLabel = this) instanceof Unitc && (u = (Unitc)((Object)worldLabel)).controller() == Vars.player;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        WorldLabel worldLabel = this;
        return worldLabel instanceof Unitc && (u = (Unitc)((Object)worldLabel)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean isSyncHidden(Player player) {
        return false;
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return false;
    }

    @Override
    public float clipSize() {
        return (float)this.text.length() * 10.0f * this.fontSize;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static WorldLabel create() {
        return new WorldLabel();
    }

    public static void drawAt(String text, float x, float y, float layer, int flags, float fontSize) {
        Draw.z(layer);
        float z = Drawf.text();
        Font font = (flags & 2) != 0 ? Fonts.outline : Fonts.def;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f) * fontSize);
        layout.setText(font, text);
        if ((flags & 1) != 0) {
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
            Fill.rect(x, y - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
            Draw.color();
        }
        font.setColor(Color.white);
        font.draw(text, x, y, 0.0f, 1, false);
        Draw.reset();
        Pools.free(layout);
        font.getData().setScale(1.0f);
        font.setColor(Color.white);
        font.setUseIntegerPositions(ints);
        Draw.z(z);
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.index__label = Groups.label.addIndex(this);
        this.added = true;
    }

    @Override
    public void afterRead() {
    }

    @Override
    public void afterSync() {
    }

    @Override
    public void draw() {
        WorldLabel.drawAt(this.text, this.x, this.y, this.z, this.flags, this.fontSize);
    }

    @Override
    public void handleSyncHidden() {
    }

    @Override
    public void hide() {
        this.remove();
        Call.removeWorldLabel(this.id);
    }

    @Override
    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis(this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp(this.x_LAST_, this.x_TARGET_, alpha);
            this.y = Mathf.lerp(this.y_LAST_, this.y_TARGET_, alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    @Override
    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.flags = read.b();
        this.fontSize = read.f();
        this.text = TypeIO.readString(read);
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.z = read.f();
        this.afterSync();
    }

    @Override
    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        Groups.label.removeIndex(this, this.index__label);
        this.index__label = -1;
        this.added = false;
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    @Override
    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void update() {
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
    }

    @Override
    public void writeSync(Writes write) {
        write.b(this.flags);
        write.f(this.fontSize);
        TypeIO.writeString(write, this.text);
        write.f(this.x);
        write.f(this.y);
        write.f(this.z);
    }

    @Override
    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

