/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureAtlas;
import arc.input.GestureDetector;
import arc.input.InputProcessor;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Arrays;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.CommandAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Itemsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.TileConfigCallPacket;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.Placement;
import mindustry.net.Administration;
import mindustry.net.ValidateException;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.fragments.BlockConfigFragment;
import mindustry.ui.fragments.BlockInventoryFragment;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;

public abstract class InputHandler
implements InputProcessor,
GestureDetector.GestureListener {
    static final float playerSelectRange = Vars.mobile ? 17.0f : 11.0f;
    static final IntSeq removed = new IntSeq();
    static final int maxLength = 100;
    static final Rect r1 = new Rect();
    static final Rect r2 = new Rect();
    static final Seq<Unit> tmpUnits = new Seq(false);
    public boolean logicCutscene;
    public Vec2 logicCamPan = new Vec2();
    public float logicCamSpeed = 0.1f;
    public float logicCutsceneZoom = -1.0f;
    public Seq<Boolp> inputLocks = Seq.with(() -> Vars.renderer.isCutscene(), () -> this.logicCutscene);
    public Interval controlInterval = new Interval();
    @Nullable
    public Block block;
    public boolean overrideLineRotation;
    public int rotation;
    public boolean droppingItem;
    public Group uiGroup;
    public boolean isBuilding = true;
    public boolean buildWasAutoPaused = false;
    public boolean wasShooting = false;
    @Nullable
    public UnitType controlledType;
    public float recentRespawnTimer;
    @Nullable
    public Schematic lastSchematic;
    public GestureDetector detector;
    public PlaceLine line = new PlaceLine();
    public BuildPlan resultplan;
    public BuildPlan bplan = new BuildPlan();
    public Seq<BuildPlan> linePlans = new Seq();
    public Seq<BuildPlan> selectPlans = new Seq(BuildPlan.class);
    public Seq<Unit> selectedUnits = new Seq();
    public Seq<Building> commandBuildings = new Seq(false);
    public boolean commandMode = false;
    public boolean commandRect = false;
    public boolean tappedOne = false;
    public float commandRectX;
    public float commandRectY;
    private Seq<BuildPlan> plansOut = new Seq(BuildPlan.class);
    private QuadTree<BuildPlan> playerPlanTree = new QuadTree(new Rect());
    public final BlockInventoryFragment inv;
    public final BlockConfigFragment config;
    private WidgetGroup group = new WidgetGroup();
    private final Eachable<BuildPlan> allPlans = cons -> {
        Vars.player.unit().plans().each(cons);
        this.selectPlans.each(cons);
        this.linePlans.each(cons);
    };
    private final Eachable<BuildPlan> allSelectLines = cons -> {
        this.selectPlans.each(cons);
        this.linePlans.each(cons);
    };

    public InputHandler() {
        this.group.touchable = Touchable.childrenOnly;
        this.inv = new BlockInventoryFragment();
        this.config = new BlockConfigFragment();
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit != null && e.unit.isPlayer() && e.unit.getPlayer().isLocal() && e.unit.type.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.killShooter)))) {
                Vars.player.shooting = false;
            }
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.playerPlanTree = new QuadTree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.logicCutscene = false;
        });
    }

    public static void transferItemEffect(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, to, null);
    }

    public static void takeItems(Building build, Item item, int amount, Unit to) {
        if (to == null || build == null) {
            return;
        }
        int removed = build.removeStack(item, Math.min(to.maxAccepted(item), amount));
        if (removed == 0) {
            return;
        }
        to.addItem(item, removed);
        for (int j = 0; j < Mathf.clamp(removed / 3, 1, 8); ++j) {
            Time.run((float)j * 3.0f, () -> InputHandler.transferItemEffect(item, build.x, build.y, to));
        }
    }

    public static void transferItemToUnit(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, to, () -> to.addItem(item));
    }

    public static void setItem(Building build, Item item, int amount) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.set(item, amount);
    }

    public static void clearItems(Building build) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.clear();
    }

    public static void transferItemTo(@Nullable Unit unit, Item item, int amount, float x, float y, Building build) {
        if (build == null || build.items == null || item == null) {
            return;
        }
        if (unit != null && unit.item() == item) {
            unit.stack.amount = Math.max(unit.stack.amount - amount, 0);
        }
        for (int i = 0; i < Mathf.clamp(amount / 3, 1, 8); ++i) {
            Time.run(i * 3, () -> InputHandler.createItemTransfer(item, amount, x, y, build, () -> {}));
        }
        if (amount > 0) {
            build.handleStack(item, amount, unit);
        }
    }

    public static void deletePlans(Player player, int[] positions) {
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.removePlanned, a -> {
            a.plans = positions;
        })) {
            throw new ValidateException(player, "Player cannot remove plans.");
        }
        if (player == null) {
            return;
        }
        Iterator<Teams.BlockPlan> it = player.team().data().plans.iterator();
        block0: while (it.hasNext()) {
            Teams.BlockPlan plan = it.next();
            for (int pos : positions) {
                if (plan.x != Point2.x(pos) || plan.y != Point2.y(pos)) continue;
                plan.removed = true;
                it.remove();
                continue block0;
            }
        }
    }

    public static void createItemTransfer(Item item, int amount, float x, float y, Position to, Runnable done) {
        Fx.itemTransfer.at(x, y, amount, item.color, to);
        if (done != null) {
            Time.run(Fx.itemTransfer.lifetime, done);
        }
    }

    public static void commandUnits(Player player, int[] unitIds, @Nullable Building buildTarget, @Nullable Unit unitTarget, @Nullable Vec2 posTarget) {
        if (player == null || unitIds == null) {
            return;
        }
        if (unitTarget != null && unitTarget.isNull()) {
            unitTarget = null;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandUnits, event -> {
            event.unitIDs = unitIds;
        })) {
            throw new ValidateException(player, "Player cannot command units.");
        }
        Teamc teamTarget = buildTarget == null ? unitTarget : buildTarget;
        for (int id : unitIds) {
            UnitController unitController;
            Unit unit = Groups.unit.getByID(id);
            if (unit == null || unit.team != player.team() || !((unitController = unit.controller()) instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            if (ai.command == null || ai.command.switchToMove) {
                ai.command(UnitCommand.moveCommand);
            }
            if (teamTarget != null && teamTarget.team() != player.team()) {
                ai.commandTarget(teamTarget);
            } else if (posTarget != null) {
                ai.commandPosition(posTarget);
            }
            unit.lastCommanded = player.coloredName();
            if (Vars.headless || player == Vars.player) continue;
            Vars.control.input.selectedUnits.remove(unit);
        }
        if (unitIds.length > 0 && player == Vars.player && !Vars.state.isPaused()) {
            if (teamTarget != null) {
                Fx.attackCommand.at(teamTarget);
            } else {
                Fx.moveCommand.at(posTarget);
            }
        }
    }

    public static void setUnitCommand(Player player, int[] unitIds, UnitCommand command) {
        if (player == null || unitIds == null || command == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandUnits, event -> {
            event.unitIDs = unitIds;
        })) {
            throw new ValidateException(player, "Player cannot command units.");
        }
        for (int id : unitIds) {
            UnitController unitController;
            Unit unit = Groups.unit.getByID(id);
            if (unit == null || unit.team != player.team() || !((unitController = unit.controller()) instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            boolean reset = command.resetTarget || ai.currentCommand().resetTarget;
            ai.command(command);
            if (reset) {
                ai.targetPos = null;
                ai.attackTarget = null;
            }
            unit.lastCommanded = player.coloredName();
        }
    }

    public static void commandBuilding(Player player, int[] buildings, Vec2 target) {
        if (player == null || target == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.commandBuilding, event -> {
            event.buildingPositions = buildings;
        })) {
            throw new ValidateException(player, "Player cannot command buildings.");
        }
        for (int pos : buildings) {
            Building build = Vars.world.build(pos);
            if (build == null || build.team() != player.team() || !build.block.commandable) continue;
            build.onCommand(target);
            build.lastAccessed = player.name;
            if (!Vars.state.isPaused() && player == Vars.player) {
                Fx.moveCommand.at(target);
            }
            Events.fire(new EventType.BuildingCommandEvent(player, build, target));
        }
    }

    public static void requestItem(Player player, Building build, Item item, int amount) {
        if (player == null || build == null || !build.interactable(player.team()) || !player.within(build, 220.0f) || player.dead()) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.withdrawItem, build.tile(), action -> {
            action.item = item;
            action.itemAmount = amount;
        }))) {
            throw new ValidateException(player, "Player cannot request items.");
        }
        Call.takeItems(build, item, Math.min(player.unit().maxAccepted(item), amount), player.unit());
        Events.fire(new EventType.WithdrawEvent(build, player, item, amount));
    }

    public static void transferInventory(Player player, Building build) {
        if (player == null || build == null || !player.within(build, 220.0f) || build.items == null || player.dead() || Vars.state.rules.onlyDepositCore && !(build instanceof CoreBlock.CoreBuild)) {
            return;
        }
        if (!(!Vars.net.server() || player.unit().stack.amount > 0 && Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.depositItem, build.tile, action -> {
            action.itemAmount = player.unit().stack.amount;
            action.item = player.unit().item();
        }))) {
            throw new ValidateException(player, "Player cannot transfer an item.");
        }
        Unit unit = player.unit();
        Item item = unit.item();
        int accepted = build.acceptStack(item, unit.stack.amount, unit);
        Call.transferItemTo(unit, item, accepted, unit.x, unit.y, build);
        Events.fire(new EventType.DepositEvent(build, player, item, accepted));
    }

    public static void removeQueueBlock(int x, int y, boolean breaking) {
        Vars.player.unit().removeBuild(x, y, breaking);
    }

    public static void requestUnitPayload(Player player, Unit target) {
        Unit unit;
        if (player == null || !((unit = player.unit()) instanceof Payloadc)) {
            return;
        }
        Payloadc pay = (Payloadc)((Object)unit);
        Unit unit2 = player.unit();
        if (target.isAI() && target.isGrounded() && pay.canPickup(target) && target.within(unit2, unit2.type.hitSize * 2.0f + target.type.hitSize * 2.0f)) {
            Call.pickedUnitPayload(unit2, target);
        }
    }

    public static void requestBuildPayload(Player player, Building build) {
        Payloadc pay;
        block10: {
            block9: {
                Unit unit;
                if (player == null || !((unit = player.unit()) instanceof Payloadc)) break block9;
                pay = (Payloadc)((Object)unit);
                if (build != null) break block10;
            }
            return;
        }
        Unit unit = player.unit();
        if (!unit.within(build, (float)(8 * build.block.size) * 1.2f + 40.0f)) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.pickupBlock, build.tile, action -> {
            action.unit = unit;
        })) {
            throw new ValidateException(player, "Player cannot pick up a block.");
        }
        if (Vars.state.teams.canInteract(unit.team, build.team)) {
            Payload current = build.getPayload();
            if (current != null && pay.canPickupPayload(current)) {
                Call.pickedBuildPayload(unit, build, false);
            } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                Call.pickedBuildPayload(unit, build, true);
            }
        }
    }

    public static void pickedUnitPayload(Unit unit, Unit target) {
        if (target != null && unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            pay.pickup(target);
        } else if (target != null) {
            target.remove();
        }
    }

    public static void pickedBuildPayload(Unit unit, Building build, boolean onGround) {
        if (build != null && unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            if (onGround) {
                if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                    pay.pickup(build);
                } else {
                    Fx.unitPickup.at(build);
                    build.tile.remove();
                }
            } else {
                Payload taken;
                Payload current = build.getPayload();
                if (current != null && pay.canPickupPayload(current) && (taken = build.takePayload()) != null) {
                    pay.addPayload(taken);
                    Fx.unitPickup.at(build);
                }
            }
        } else if (build != null && onGround) {
            Fx.unitPickup.at(build);
            build.tile.remove();
        }
    }

    public static void requestDropPayload(Player player, float x, float y) {
        if (player == null || Vars.net.client() || player.dead()) {
            return;
        }
        Payloadc pay = (Payloadc)((Object)player.unit());
        if (pay.payloads().isEmpty()) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.dropPayload, player.unit().tileOn(), action -> {
            action.payload = pay.payloads().peek();
        })) {
            throw new ValidateException(player, "Player cannot drop a payload.");
        }
        Tmp.v1.set(x, y).sub(pay).limit(32.0f).add(pay);
        float cx = Tmp.v1.x;
        float cy = Tmp.v1.y;
        Call.payloadDropped(player.unit(), cx, cy);
    }

    public static void payloadDropped(Unit unit, float x, float y) {
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            float prevx = pay.x();
            float prevy = pay.y();
            pay.set(x, y);
            pay.dropLastPayload();
            pay.set(prevx, prevy);
        }
    }

    public static void dropItem(Player player, float angle) {
        if (player == null) {
            return;
        }
        if (Vars.net.server() && player.unit().stack.amount <= 0) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        Unit unit = player.unit();
        Fx.dropItem.at(unit.x, unit.y, angle, Color.white, unit.item());
        unit.clearItem();
    }

    public static void rotateBlock(@Nullable Player player, Building build, boolean direction) {
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.rotate, build.tile(), action -> {
            action.rotation = Mathf.mod(build.rotation + Mathf.sign(direction), 4);
        }))) {
            throw new ValidateException(player, "Player cannot rotate a block.");
        }
        if (player != null) {
            build.lastAccessed = player.name;
        }
        int previous = build.rotation;
        build.rotation = Mathf.mod(build.rotation + Mathf.sign(direction), 4);
        build.updateProximity();
        build.noSleep();
        Fx.rotateBlock.at(build.x, build.y, build.block.size);
        Events.fire(new EventType.BuildRotateEvent(build, player == null ? null : player.unit(), previous));
    }

    public static void tileConfig(@Nullable Player player, Building build, @Nullable Object value) {
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.configure, build.tile, action -> {
            action.config = value;
        }))) {
            if (player.con != null) {
                TileConfigCallPacket packet = new TileConfigCallPacket();
                packet.player = player;
                packet.build = build;
                packet.value = build.config();
                player.con.send(packet, true);
            }
            throw new ValidateException(player, "Player cannot configure a tile.");
        }
        build.configured(player == null || player.dead() ? null : player.unit(), value);
        Events.fire(new EventType.ConfigEvent(build, player, value));
    }

    public static void tileTap(@Nullable Player player, Tile tile) {
        if (tile == null) {
            return;
        }
        Events.fire(new EventType.TapEvent(player, tile));
    }

    public static void buildingControlSelect(Player player, Building build) {
        if (player == null || build == null || player.dead()) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.buildSelect, action -> {
            action.tile = build.tile;
        })) {
            throw new ValidateException(player, "Player cannot control a building.");
        }
        if (player.team() == build.team && build.canControlSelect(player.unit())) {
            build.onControlSelect(player.unit());
        }
    }

    public static void unitBuildingControlSelect(Unit unit, Building build) {
        if (unit == null || unit.dead()) {
            return;
        }
        if (unit.team() == build.team && (Vars.net.client() || build.canControlSelect(unit))) {
            build.onControlSelect(unit);
        }
    }

    public static void unitControl(Player player, @Nullable Unit unit) {
        if (player == null) {
            return;
        }
        if (!(!Vars.net.server() || Vars.state.rules.possessionAllowed && Vars.netServer.admins.allowAction(player, Administration.ActionType.control, action -> {
            action.unit = unit;
        }))) {
            throw new ValidateException(player, "Player cannot control a unit.");
        }
        if (unit == null) {
            player.clearUnit();
        } else if (unit.isAI() && unit.team == player.team() && !unit.dead && unit.type.playerControllable) {
            if (Vars.net.client() && player.isLocal()) {
                player.justSwitchFrom = player.unit();
                player.justSwitchTo = unit;
            }
            Unit before = player.unit();
            player.unit(unit);
            if (before != null && !before.isNull()) {
                if (before.spawnedByCore) {
                    unit.dockedType = before.type;
                } else if (before.dockedType != null && before.dockedType.coreUnitDock) {
                    unit.dockedType = before.dockedType;
                }
            }
            Time.run(Fx.unitSpirit.lifetime, () -> Fx.unitControl.at(unit.x, unit.y, 0.0f, unit));
            if (!player.dead()) {
                Fx.unitSpirit.at(player.x, player.y, 0.0f, unit);
            }
        } else if (Vars.net.server()) {
            throw new ValidateException(player, "Player attempted to control invalid unit.");
        }
        Events.fire(new EventType.UnitControlEvent(player, unit));
    }

    public static void unitClear(Player player) {
        if (player == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.respawn, action -> {})) {
            throw new ValidateException(player, "Player cannot respawn.");
        }
        if (!player.dead() && !player.unit().spawnedByCore) {
            CoreBlock.CoreBuild closest;
            UnitType docked = player.unit().dockedType;
            if (docked == null && (closest = player.bestCore()) != null) {
                docked = ((CoreBlock)closest.block).unitType;
            }
            if (docked != null && docked.coreUnitDock) {
                Fx.spawn.at(player);
                if (!Vars.net.client()) {
                    Unit unit = docked.create(player.team());
                    unit.set(player.unit());
                    if (player.unit().isFlying() && unit.type.flying) {
                        Tmp.v1.trns(player.unit().rotation + 180.0f, player.unit().hitSize / 2.0f + unit.hitSize / 2.0f);
                        unit.x += Tmp.v1.x;
                        unit.y += Tmp.v1.y;
                    }
                    unit.rotation(player.unit().rotation);
                    unit.controller(player);
                    unit.spawnedByCore(true);
                    unit.add();
                }
                return;
            }
        }
        Fx.spawn.at(player);
        player.clearUnit();
        player.checkSpawn();
        player.deathTimer = 61.0f;
    }

    public void addLock(Boolp lock) {
        this.inputLocks.add(lock);
    }

    public boolean locked() {
        return this.inputLocks.contains((Boolp)((Object)((Boolf<Boolp>)Boolp::get)));
    }

    public Eachable<BuildPlan> allPlans() {
        return this.allPlans;
    }

    public boolean isUsingSchematic() {
        return !this.selectPlans.isEmpty();
    }

    public void update() {
        Unit unit;
        if (this.logicCutscene && !Vars.renderer.isCutscene()) {
            Core.camera.position.lerpDelta(this.logicCamPan, this.logicCamSpeed);
        } else {
            this.logicCutsceneZoom = -1.0f;
        }
        this.commandBuildings.removeAll(b -> !b.isValid());
        if (!this.commandMode) {
            this.commandRect = false;
        }
        this.playerPlanTree.clear();
        Vars.player.unit().plans.each(this.playerPlanTree::insert);
        Vars.player.typing = Vars.ui.chatfrag.shown();
        if (Vars.player.dead()) {
            this.droppingItem = false;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().updateBuilding(this.isBuilding);
        }
        if (Vars.player.shooting && !this.wasShooting && Vars.player.unit().hasWeapons() && Vars.state.rules.unitAmmo && !Vars.player.team().rules().infiniteAmmo && Vars.player.unit().ammo <= 0.0f) {
            Vars.player.unit().type.weapons.first().noAmmoSound.at(Vars.player.unit());
        }
        if (this.locked()) {
            this.block = null;
        }
        this.wasShooting = Vars.player.shooting;
        if (!Vars.player.dead()) {
            float f;
            this.recentRespawnTimer -= Time.delta / 70.0f;
            if (f <= 0.0f && Vars.player.justSwitchFrom != Vars.player.unit()) {
                this.controlledType = Vars.player.unit().type;
            }
        }
        if (this.controlledType != null && Vars.player.dead() && this.controlledType.playerControllable && (unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, u -> !u.isPlayer() && u.type == this.controlledType && !u.dead)) != null && (!Vars.net.client() || this.controlInterval.get(0, 70.0f))) {
            this.recentRespawnTimer = 1.0f;
            Call.unitControl(Vars.player, unit);
        }
    }

    public void checkUnit() {
        if (this.controlledType != null && this.controlledType.playerControllable) {
            Unit unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, u -> !u.isPlayer() && u.type == this.controlledType && !u.dead);
            if (unit == null && this.controlledType == UnitTypes.block) {
                ControlBlock cont;
                Building building = Vars.world.buildWorld(Vars.player.x, Vars.player.y);
                Unit unit2 = unit = building instanceof ControlBlock && (cont = (ControlBlock)((Object)building)).canControl() ? cont.unit() : null;
            }
            if (unit != null) {
                if (Vars.net.client()) {
                    Call.unitControl(Vars.player, unit);
                } else {
                    unit.controller(Vars.player);
                }
            }
        }
    }

    public void tryPickupPayload() {
        Unit unit = Vars.player.unit();
        if (!(unit instanceof Payloadc)) {
            return;
        }
        Payloadc pay = (Payloadc)((Object)unit);
        Unit target = Units.closest(Vars.player.team(), pay.x(), pay.y(), unit.type.hitSize * 2.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(unit, u.hitSize + unit.hitSize));
        if (target != null) {
            Call.requestUnitPayload(Vars.player, target);
        } else {
            Building build = Vars.world.buildWorld(pay.x(), pay.y());
            if (build != null && Vars.state.teams.canInteract(unit.team, build.team)) {
                Call.requestBuildPayload(Vars.player, build);
            }
        }
    }

    public void tryDropPayload() {
        Unit unit = Vars.player.unit();
        if (!(unit instanceof Payloadc)) {
            return;
        }
        Call.requestDropPayload(Vars.player, Vars.player.x, Vars.player.y);
    }

    public float getMouseX() {
        return Core.input.mouseX();
    }

    public float getMouseY() {
        return Core.input.mouseY();
    }

    public void buildPlacementUI(Table table) {
    }

    public void buildUI(Group group) {
    }

    public void updateState() {
        if (Vars.state.isMenu()) {
            this.controlledType = null;
            this.logicCutscene = false;
            this.config.forceHide();
            this.commandRect = false;
            this.commandMode = false;
        }
    }

    public boolean multiUnitSelect() {
        return false;
    }

    public void selectUnitsRect() {
        if (this.commandMode && this.commandRect) {
            if (!this.tappedOne) {
                Seq<Unit> units = this.selectedCommandUnits(this.commandRectX, this.commandRectY, Core.input.mouseWorldX() - this.commandRectX, Core.input.mouseWorldY() - this.commandRectY);
                if (this.multiUnitSelect()) {
                    this.selectedUnits.removeAll(units);
                } else {
                    this.selectedUnits.clear();
                }
                this.selectedUnits.addAll(units);
                Events.fire(EventType.Trigger.unitCommandChange);
                this.commandBuildings.clear();
            }
            this.commandRect = false;
        }
    }

    public void selectTypedUnits() {
        Unit unit;
        if (this.commandMode && (unit = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
            this.selectedUnits.clear();
            Core.camera.bounds(Tmp.r1);
            this.selectedUnits.addAll(this.selectedCommandUnits(Tmp.r1.x, Tmp.r1.y, Tmp.r1.width, Tmp.r1.height, u -> u.type == unit.type));
            Events.fire(EventType.Trigger.unitCommandChange);
        }
    }

    public void tapCommandUnit() {
        if (this.commandMode) {
            Unit unit = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            Building build = Vars.world.buildWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            if (unit != null) {
                if (!this.selectedUnits.contains(unit)) {
                    this.selectedUnits.add(unit);
                } else {
                    this.selectedUnits.remove(unit);
                }
                this.commandBuildings.clear();
            } else {
                this.selectedUnits.clear();
                if (build != null && build.team == Vars.player.team() && build.block.commandable) {
                    if (this.commandBuildings.contains(build)) {
                        this.commandBuildings.remove(build);
                    } else {
                        this.commandBuildings.add(build);
                    }
                } else {
                    this.commandBuildings.clear();
                }
            }
            Events.fire(EventType.Trigger.unitCommandChange);
        }
    }

    public void commandTap(float screenX, float screenY) {
        if (this.commandMode) {
            Vec2 target = Core.input.mouseWorld(screenX, screenY).cpy();
            if (this.selectedUnits.size > 0) {
                int maxChunkSize;
                Healthc attack = Vars.world.buildWorld(target.x, target.y);
                if (attack == null || attack.team() == Vars.player.team()) {
                    attack = this.selectedEnemyUnit(target.x, target.y);
                }
                int[] ids = new int[this.selectedUnits.size];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = this.selectedUnits.get((int)i).id;
                }
                if (attack != null) {
                    Events.fire(EventType.Trigger.unitCommandAttack);
                }
                if (ids.length > (maxChunkSize = 200)) {
                    for (int i = 0; i < ids.length; i += maxChunkSize) {
                        Unit u;
                        Healthc b2;
                        int[] data = Arrays.copyOfRange(ids, i, Math.min(i + maxChunkSize, ids.length));
                        Call.commandUnits(Vars.player, data, (Building)(attack instanceof Building ? (b2 = attack) : null), attack instanceof Unit ? (u = (Unit)attack) : null, target);
                    }
                } else {
                    Unit u;
                    Healthc b3;
                    Call.commandUnits(Vars.player, ids, (Building)(attack instanceof Building ? (b3 = attack) : null), attack instanceof Unit ? (u = (Unit)attack) : null, target);
                }
            }
            if (this.commandBuildings.size > 0) {
                Call.commandBuilding(Vars.player, this.commandBuildings.mapInt(b -> b.pos()).toArray(), target);
            }
        }
    }

    public void drawCommand(Unit sel) {
        Drawf.square(sel.x, sel.y, sel.hitSize / 1.4f + Mathf.absin(4.0f, 1.0f), this.selectedUnits.contains(sel) ? Pal.remove : Pal.accent);
    }

    public void drawCommanded() {
        if (this.commandMode) {
            Unit sel;
            this.selectedUnits.removeAll(u -> !u.isCommandable());
            for (Unit unit : this.selectedUnits) {
                CommandAI ai = unit.command();
                if (ai.targetPos != null && ai.currentCommand().drawTarget) {
                    Position lineDest = ai.attackTarget != null ? ai.attackTarget : ai.targetPos;
                    Drawf.limitLine(unit, lineDest, unit.hitSize / 2.0f, 3.5f);
                    if (ai.attackTarget == null) {
                        Drawf.square(lineDest.getX(), lineDest.getY(), 3.5f);
                    }
                }
                Drawf.square(unit.x, unit.y, unit.hitSize / 1.4f + 1.0f);
                if (ai.attackTarget == null || !ai.currentCommand().drawTarget) continue;
                Drawf.target(ai.attackTarget.getX(), ai.attackTarget.getY(), 6.0f, Pal.remove);
            }
            for (Building commandBuild : this.commandBuildings) {
                if (commandBuild == null) continue;
                Drawf.square(commandBuild.x, commandBuild.y, commandBuild.hitSize() / 1.4f + 1.0f);
                Vec2 cpos = commandBuild.getCommandPosition();
                if (cpos == null) continue;
                Drawf.limitLine(commandBuild, cpos, commandBuild.hitSize() / 2.0f, 3.5f);
                Drawf.square(cpos.x, cpos.y, 3.5f);
            }
            if (this.commandMode && !this.commandRect && (sel = this.selectedCommandUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null && (this.multiUnitSelect() || this.selectedUnits.size != 1 || !this.selectedUnits.contains(sel))) {
                this.drawCommand(sel);
            }
            if (this.commandRect) {
                float x2 = Core.input.mouseWorldX();
                float y2 = Core.input.mouseWorldY();
                Seq<Unit> units = this.selectedCommandUnits(this.commandRectX, this.commandRectY, x2 - this.commandRectX, y2 - this.commandRectY);
                for (Unit unit : units) {
                    this.drawCommand(unit);
                }
                Draw.color(Pal.accent, 0.3f);
                Fill.crect(this.commandRectX, this.commandRectY, x2 - this.commandRectX, y2 - this.commandRectY);
            }
        }
        Draw.reset();
    }

    public void drawBottom() {
    }

    public void drawTop() {
    }

    public void drawOverSelect() {
    }

    public void drawSelected(int x, int y, Block block, Color color) {
        Drawf.selected(x, y, block, color);
    }

    public void drawBreaking(BuildPlan plan) {
        if (plan.breaking) {
            this.drawBreaking(plan.x, plan.y);
        } else {
            this.drawSelected(plan.x, plan.y, plan.block, Pal.remove);
        }
    }

    public void drawOverlapCheck(Block block, int cursorX, int cursorY, boolean valid) {
        Building blocker;
        if (!valid && Vars.state.rules.placeRangeCheck && (blocker = Build.getEnemyOverlap(block, Vars.player.team(), cursorX, cursorY)) != null && blocker.wasVisible) {
            Drawf.selected(blocker, Pal.remove);
            Tmp.v1.set(cursorX, cursorY).scl(8.0f).add(block.offset, block.offset).sub(blocker).scl(-1.0f).nor();
            Drawf.dashLineDst(Pal.remove, (float)(cursorX * 8) + block.offset + Tmp.v1.x * (float)block.size * 8.0f / 2.0f, (float)(cursorY * 8) + block.offset + Tmp.v1.y * (float)block.size * 8.0f / 2.0f, blocker.x + Tmp.v1.x * (float)(-blocker.block.size) * 8.0f / 2.0f, blocker.y + Tmp.v1.y * (float)(-blocker.block.size) * 8.0f / 2.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean planMatches(BuildPlan plan) {
        Tile tile = Vars.world.tile(plan.x, plan.y);
        if (tile == null) return false;
        Building building = tile.build;
        if (!(building instanceof ConstructBlock.ConstructBuild)) return false;
        ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)building;
        if (cons.current != plan.block) return false;
        return true;
    }

    public void drawBreaking(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Block block = tile.block();
        this.drawSelected(x, y, block, Pal.remove);
    }

    public void useSchematic(Schematic schem) {
        this.selectPlans.addAll(Vars.schematics.toPlans(schem, Vars.player.tileX(), Vars.player.tileY()));
    }

    protected void showSchematicSave() {
        if (this.lastSchematic == null) {
            return;
        }
        Schematic last = this.lastSchematic;
        Vars.ui.showTextInput("@schematic.add", "@name", "", text -> {
            Schematic replacement = Vars.schematics.all().find(s -> s.name().equals(text));
            if (replacement != null) {
                Vars.ui.showConfirm("@confirm", "@schematic.replace", () -> {
                    Vars.schematics.overwrite(replacement, last);
                    Vars.ui.showInfoFade("@schematic.saved");
                    Vars.ui.schematics.showInfo(replacement);
                });
            } else {
                last.tags.put("name", text);
                last.tags.put("description", "");
                Vars.schematics.add(last);
                Vars.ui.showInfoFade("@schematic.saved");
                Vars.ui.schematics.showInfo(last);
                Events.fire(new EventType.SchematicCreateEvent(last));
            }
        });
    }

    public void rotatePlans(Seq<BuildPlan> plans, int direction) {
        int ox = this.schemOriginX();
        int oy = this.schemOriginY();
        plans.each(plan -> {
            if (plan.breaking) {
                return;
            }
            plan.pointConfig(p -> {
                int cx = p.x;
                int cy = p.y;
                int lx = cx;
                if (direction >= 0) {
                    cx = -cy;
                    cy = lx;
                } else {
                    cx = cy;
                    cy = -lx;
                }
                p.set(cx, cy);
            });
            float wx = (float)((plan.x - ox) * 8) + plan.block.offset;
            float wy = (float)((plan.y - oy) * 8) + plan.block.offset;
            float x = wx;
            if (direction >= 0) {
                wx = -wy;
                wy = x;
            } else {
                wx = wy;
                wy = -x;
            }
            plan.x = World.toTile(wx - plan.block.offset) + ox;
            plan.y = World.toTile(wy - plan.block.offset) + oy;
            plan.rotation = plan.block.planRotation(Mathf.mod(plan.rotation + direction, 4));
        });
    }

    public void flipPlans(Seq<BuildPlan> plans, boolean x) {
        int origin = (x ? this.schemOriginX() : this.schemOriginY()) * 8;
        plans.each(plan -> {
            if (plan.breaking) {
                return;
            }
            float value = -((float)((x ? plan.x : plan.y) * 8 - origin) + plan.block.offset) + (float)origin;
            if (x) {
                plan.x = (int)((value - plan.block.offset) / 8.0f);
            } else {
                plan.y = (int)((value - plan.block.offset) / 8.0f);
            }
            plan.pointConfig(p -> {
                int corigin = x ? plan.originalWidth / 2 : plan.originalHeight / 2;
                int nvalue = -(x ? p.x : p.y);
                if (x) {
                    plan.originalX = -(plan.originalX - corigin) + corigin;
                    p.x = nvalue;
                } else {
                    plan.originalY = -(plan.originalY - corigin) + corigin;
                    p.y = nvalue;
                }
            });
            plan.block.flipRotation((BuildPlan)plan, x);
        });
    }

    protected int schemOriginX() {
        return this.rawTileX();
    }

    protected int schemOriginY() {
        return this.rawTileY();
    }

    @Nullable
    protected BuildPlan getPlan(int x, int y) {
        return this.getPlan(x, y, 1, null);
    }

    @Nullable
    protected BuildPlan getPlan(int x, int y, int size, BuildPlan skip) {
        float offset = (float)((size + 1) % 2 * 8) / 2.0f;
        r2.setSize(8 * size);
        r2.setCenter((float)(x * 8) + offset, (float)(y * 8) + offset);
        this.resultplan = null;
        Boolf<BuildPlan> test = plan -> {
            if (plan == skip) {
                return false;
            }
            Tile other = plan.tile();
            if (other == null) {
                return false;
            }
            if (!plan.breaking) {
                r1.setSize(plan.block.size * 8);
                r1.setCenter(other.worldx() + plan.block.offset, other.worldy() + plan.block.offset);
            } else {
                r1.setSize(other.block().size * 8);
                r1.setCenter(other.worldx() + other.block().offset, other.worldy() + other.block().offset);
            }
            return r2.overlaps(r1);
        };
        for (BuildPlan plan2 : Vars.player.unit().plans()) {
            if (!test.get(plan2)) continue;
            return plan2;
        }
        return this.selectPlans.find(test);
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2, int maxLength) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, maxLength, 1.0f);
        Placement.NormalizeResult dresult = Placement.normalizeArea(x1, y1, x2, y2, this.rotation, false, maxLength);
        for (int x = dresult.x; x <= dresult.x2; ++x) {
            for (int y = dresult.y; y <= dresult.y2; ++y) {
                Tile tile = Vars.world.tileBuilding(x, y);
                if (tile == null || !this.validBreak(tile.x, tile.y)) continue;
                this.drawBreaking(tile.x, tile.y);
            }
        }
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.stroke(1.0f);
        for (BuildPlan plan : Vars.player.unit().plans()) {
            if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawBreaking(plan);
        }
        for (BuildPlan plan : this.selectPlans) {
            if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawBreaking(plan);
        }
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = Vars.content.block(plan.block);
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(plan.x, plan.y, Vars.content.block(plan.block), Pal.remove);
        }
        Lines.stroke(2.0f);
        Draw.color(Pal.removeBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void drawRebuildSelection(int x, int y, int x2, int y2) {
        this.drawSelection(x, y, x2, y2, 0, Pal.sapBulletBack, Pal.sapBullet);
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea(Blocks.air, x, y, x2, y2, false, 0, 1.0f);
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = Vars.content.block(plan.block);
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(plan.x, plan.y, Vars.content.block(plan.block), Pal.sapBullet);
        }
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2) {
        this.drawBreakSelection(x1, y1, x2, y2, 100);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.drawSelection(x1, y1, x2, y2, maxLength, Pal.accentBack, Pal.accent);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength, Color col1, Color col2) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, maxLength, 1.0f);
        Lines.stroke(2.0f);
        Draw.color(col1);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(col2);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void flushSelectPlans(Seq<BuildPlan> plans) {
        for (BuildPlan plan : plans) {
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation)) continue;
            BuildPlan other = this.getPlan(plan.x, plan.y, plan.block.size, null);
            if (other == null) {
                this.selectPlans.add(plan.copy());
                continue;
            }
            if (other.breaking || other.x != plan.x || other.y != plan.y || other.block.size != plan.block.size) continue;
            this.selectPlans.remove(other);
            this.selectPlans.add(plan.copy());
        }
    }

    protected void flushPlansReverse(Seq<BuildPlan> plans) {
        for (int i = plans.size - 1; i >= 0; --i) {
            BuildPlan plan = plans.get(i);
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation)) continue;
            BuildPlan copy = plan.copy();
            plan.block.onNewPlan(copy);
            Vars.player.unit().addBuild(copy, false);
        }
    }

    protected void flushPlans(Seq<BuildPlan> plans) {
        for (BuildPlan plan : plans) {
            if (plan.block == null || !this.validPlace(plan.x, plan.y, plan.block, plan.rotation)) continue;
            BuildPlan copy = plan.copy();
            plan.block.onNewPlan(copy);
            Vars.player.unit().addBuild(copy);
        }
    }

    protected void drawOverPlan(BuildPlan plan) {
        this.drawOverPlan(plan, this.validPlace(plan.x, plan.y, plan.block, plan.rotation));
    }

    protected void drawOverPlan(BuildPlan plan, boolean valid) {
        Draw.reset();
        Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
        Draw.alpha(1.0f);
        plan.block.drawPlanConfigTop(plan, this.allSelectLines);
        Draw.reset();
    }

    protected void drawPlan(BuildPlan plan) {
        plan.cachedValid = this.validPlace(plan.x, plan.y, plan.block, plan.rotation);
        this.drawPlan(plan, plan.cachedValid);
    }

    protected void drawPlan(BuildPlan plan, boolean valid) {
        plan.block.drawPlan(plan, this.allPlans(), valid);
    }

    protected void drawPlan(int x, int y, Block block, int rotation) {
        this.bplan.set(x, y, rotation, block);
        this.bplan.animScale = 1.0f;
        block.drawPlan(this.bplan, this.allPlans(), this.validPlace(x, y, block, rotation));
    }

    protected void removeSelection(int x1, int y1, int x2, int y2) {
        this.removeSelection(x1, y1, x2, y2, false);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.removeSelection(x1, y1, x2, y2, false, maxLength);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush) {
        this.removeSelection(x1, y1, x2, y2, flush, 100);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush, int maxLength) {
        Placement.NormalizeResult result = Placement.normalizeArea(x1, y1, x2, y2, this.rotation, false, maxLength);
        for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
            for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                int wy;
                int wx = x1 + x * Mathf.sign(x2 - x1);
                Tile tile = Vars.world.tileBuilding(wx, wy = y1 + y * Mathf.sign(y2 - y1));
                if (tile == null) continue;
                if (!flush) {
                    this.tryBreakBlock(wx, wy);
                    continue;
                }
                if (!this.validBreak(tile.x, tile.y) || this.selectPlans.contains((BuildPlan)((Object)((Boolf<BuildPlan>)r -> r.tile() != null && r.tile() == tile)))) continue;
                this.selectPlans.add(new BuildPlan(tile.x, tile.y));
            }
        }
        Tmp.r1.set(result.x * 8, result.y * 8, (result.x2 - result.x) * 8, (result.y2 - result.y) * 8);
        Iterator<BuildPlan> it = Vars.player.unit().plans().iterator();
        while (it.hasNext()) {
            BuildPlan plan = it.next();
            if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            it.remove();
        }
        it = this.selectPlans.iterator();
        while (it.hasNext()) {
            BuildPlan plan = it.next();
            if (plan.breaking || !plan.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            it.remove();
        }
        removed.clear();
        Iterator<Teams.BlockPlan> broken = Vars.player.team().data().plans.iterator();
        while (broken.hasNext()) {
            Teams.BlockPlan plan = broken.next();
            Block block = Vars.content.block(plan.block);
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            removed.add(Point2.pack(plan.x, plan.y));
            plan.removed = true;
            broken.remove();
        }
        if (InputHandler.removed.size > 0 && Vars.net.active()) {
            Call.deletePlans(Vars.player, removed.toArray());
        }
    }

    protected void updateLine(int x1, int y1, int x2, int y2) {
        this.linePlans.clear();
        this.iterateLine(x1, y1, x2, y2, l -> {
            this.rotation = l.rotation;
            BuildPlan plan = new BuildPlan(l.x, l.y, l.rotation, this.block, this.block.nextConfig());
            plan.animScale = 1.0f;
            this.linePlans.add(plan);
        });
        if (Core.settings.getBool("blockreplace")) {
            this.linePlans.each(plan -> {
                Block replace = plan.block.getReplacement((BuildPlan)plan, this.linePlans);
                if (replace.unlockedNow()) {
                    plan.block = replace;
                }
            });
            this.block.handlePlacementLine(this.linePlans);
        }
    }

    protected void updateLine(int x1, int y1) {
        this.updateLine(x1, y1, this.tileX(this.getMouseX()), this.tileY(this.getMouseY()));
    }

    boolean checkConfigTap() {
        return this.config.isShown() && this.config.getSelected().onConfigureTapped(Core.input.mouseWorldX(), Core.input.mouseWorldY());
    }

    boolean tileTapped(@Nullable Building build) {
        if (build == null) {
            this.inv.hide();
            this.config.hideConfig();
            this.commandBuildings.clear();
            return false;
        }
        boolean consumed = false;
        boolean showedInventory = false;
        if (build.block.commandable && this.commandMode) {
            consumed = true;
        } else if (build.block.configurable && build.interactable(Vars.player.team())) {
            consumed = true;
            if (!this.config.isShown() && build.shouldShowConfigure(Vars.player) || this.config.isShown() && this.config.getSelected().onConfigureBuildTapped(build)) {
                Sounds.click.at(build);
                this.config.showConfig(build);
            }
        } else if (!this.config.hasConfigMouse()) {
            if (this.config.isShown() && this.config.getSelected().onConfigureBuildTapped(build)) {
                consumed = true;
                this.config.hideConfig();
            }
            if (this.config.isShown()) {
                consumed = true;
            }
        }
        if (!consumed && build.interactable(Vars.player.team())) {
            build.tapped();
        }
        if (build.interactable(Vars.player.team()) && build.block.consumesTap) {
            consumed = true;
        } else if (build.interactable(Vars.player.team()) && build.block.synthetic() && (!consumed || build.block.allowConfigInventory) && build.block.hasItems && build.items.total() > 0) {
            this.inv.showFor(build);
            consumed = true;
            showedInventory = true;
        }
        if (!showedInventory) {
            this.inv.hide();
        }
        return consumed;
    }

    boolean tryTapPlayer(float x, float y) {
        if (this.canTapPlayer(x, y)) {
            this.droppingItem = true;
            return true;
        }
        return false;
    }

    boolean canTapPlayer(float x, float y) {
        return Vars.player.within(x, y, playerSelectRange) && Vars.player.unit().stack.amount > 0;
    }

    boolean tryBeginMine(Tile tile) {
        if (this.canMine(tile)) {
            Vars.player.unit().mineTile = tile;
            return true;
        }
        return false;
    }

    boolean tryStopMine() {
        if (Vars.player.unit().mining()) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean tryStopMine(Tile tile) {
        if (Vars.player.unit().mineTile == tile) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean canMine(Tile tile) {
        return !Core.scene.hasMouse() && Vars.player.unit().validMine(tile) && Vars.player.unit().acceptsItem(Vars.player.unit().getMineResult(tile)) && (Core.settings.getBool("doubletapmine") || !tile.floor().playerUnmineable || tile.overlay().itemDrop != null);
    }

    Tile tileAt(float x, float y) {
        return Vars.world.tile(this.tileX(x), this.tileY(y));
    }

    int rawTileX() {
        return World.toTile(Core.input.mouseWorld().x);
    }

    int rawTileY() {
        return World.toTile(Core.input.mouseWorld().y);
    }

    int tileX(float cursorX) {
        Vec2 vec = Core.input.mouseWorld(cursorX, 0.0f);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.x);
    }

    int tileY(float cursorY) {
        Vec2 vec = Core.input.mouseWorld(0.0f, cursorY);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.y);
    }

    public void panCamera(Vec2 position) {
        if (!this.locked()) {
            Core.camera.position.set(position);
        }
    }

    public boolean selectedBlock() {
        return this.isPlacing();
    }

    public boolean isPlacing() {
        return this.block != null;
    }

    public boolean isBreaking() {
        return false;
    }

    public boolean isRebuildSelecting() {
        return Core.input.keyDown(Binding.rebuild_select);
    }

    public float mouseAngle(float x, float y) {
        return Core.input.mouseWorld(this.getMouseX(), this.getMouseY()).sub(x, y).angle();
    }

    @Nullable
    public Unit selectedUnit() {
        ControlBlock cont;
        Building build;
        Unit unit = Units.closest(Vars.player.team(), Core.input.mouseWorld().x, Core.input.mouseWorld().y, 40.0f, u -> u.isAI() && u.type.playerControllable);
        if (unit != null) {
            unit.hitbox(Tmp.r1);
            Tmp.r1.grow(6.0f);
            if (Tmp.r1.contains(Core.input.mouseWorld())) {
                return unit;
            }
        }
        if ((build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) instanceof ControlBlock && (cont = (ControlBlock)((Object)build)).canControl() && build.team == Vars.player.team() && cont.unit() != Vars.player.unit() && cont.unit().isAI()) {
            return cont.unit();
        }
        return null;
    }

    @Nullable
    public Building selectedControlBuild() {
        Building build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (build != null && !Vars.player.dead() && build.canControlSelect(Vars.player.unit()) && build.team == Vars.player.team()) {
            return build;
        }
        return null;
    }

    @Nullable
    public Unit selectedCommandUnit(float x, float y) {
        QuadTree<Unit> tree = Vars.player.team().data().tree();
        tmpUnits.clear();
        float rad = 4.0f;
        tree.intersect(x - rad / 2.0f, y - rad / 2.0f, rad, rad, tmpUnits);
        return tmpUnits.min(u -> u.isCommandable(), u -> u.dst(x, y) - u.hitSize / 2.0f);
    }

    @Nullable
    public Unit selectedEnemyUnit(float x, float y) {
        tmpUnits.clear();
        float rad = 4.0f;
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == Vars.player.team()) continue;
            ((Teams.TeamData[])data.items)[i].tree().intersect(x - rad / 2.0f, y - rad / 2.0f, rad, rad, tmpUnits);
        }
        return tmpUnits.min(u -> !u.inFogTo(Vars.player.team()), u -> u.dst(x, y) - u.hitSize / 2.0f);
    }

    public Seq<Unit> selectedCommandUnits(float x, float y, float w, float h, Boolf<Unit> predicate) {
        QuadTree<Unit> tree = Vars.player.team().data().tree();
        tmpUnits.clear();
        float rad = 4.0f;
        tree.intersect(Tmp.r1.set(x - rad / 2.0f, y - rad / 2.0f, rad * 2.0f + w, rad * 2.0f + h).normalize(), tmpUnits);
        tmpUnits.removeAll(u -> !u.isCommandable() || !predicate.get((Unit)u));
        return tmpUnits;
    }

    public Seq<Unit> selectedCommandUnits(float x, float y, float w, float h) {
        return this.selectedCommandUnits(x, y, w, h, u -> true);
    }

    public void remove() {
        Table table;
        Core.input.removeProcessor(this);
        this.group.remove();
        if (Core.scene != null && (table = (Table)Core.scene.find("inputTable")) != null) {
            table.clear();
        }
        if (this.detector != null) {
            Core.input.removeProcessor(this.detector);
        }
        if (this.uiGroup != null) {
            this.uiGroup.remove();
            this.uiGroup = null;
        }
    }

    public void add() {
        Core.input.getInputProcessors().remove(i -> i instanceof InputHandler || i instanceof GestureDetector && ((GestureDetector)i).getListener() instanceof InputHandler);
        this.detector = new GestureDetector(20.0f, 0.5f, 0.3f, 0.15f, this);
        Core.input.addProcessor(this.detector);
        Core.input.addProcessor(this);
        if (Core.scene != null) {
            Table table = (Table)Core.scene.find("inputTable");
            if (table != null) {
                table.clear();
                this.buildPlacementUI(table);
            }
            this.uiGroup = new WidgetGroup();
            this.uiGroup.touchable = Touchable.childrenOnly;
            this.uiGroup.setFillParent(true);
            Vars.ui.hudGroup.addChild(this.uiGroup);
            this.uiGroup.toBack();
            this.buildUI(this.uiGroup);
            this.group.setFillParent(true);
            Vars.ui.hudGroup.addChildBefore(Core.scene.find("overlaymarker"), this.group);
            this.inv.build(this.group);
            this.config.build(this.group);
        }
    }

    public boolean canShoot() {
        return this.block == null && !this.onConfigurable() && !this.isDroppingItem() && !Vars.player.unit().activelyBuilding() && (!(Vars.player.unit() instanceof Mechc) || !Vars.player.unit().isFlying()) && !Vars.player.unit().mining() && !this.commandMode;
    }

    public boolean onConfigurable() {
        return false;
    }

    public boolean isDroppingItem() {
        return this.droppingItem;
    }

    public boolean canDropItem() {
        return this.droppingItem && !this.canTapPlayer(Core.input.mouseWorldX(), Core.input.mouseWorldY());
    }

    public void tryDropItems(@Nullable Building build, float x, float y) {
        if (!this.droppingItem || Vars.player.unit().stack.amount <= 0 || this.canTapPlayer(x, y) || Vars.state.isPaused()) {
            this.droppingItem = false;
            return;
        }
        this.droppingItem = false;
        ItemStack stack = Vars.player.unit().stack;
        if (build != null && build.acceptStack(stack.item, stack.amount, Vars.player.unit()) > 0 && build.interactable(Vars.player.team()) && build.block.hasItems && Vars.player.unit().stack().amount > 0 && build.interactable(Vars.player.team())) {
            if (!Vars.state.rules.onlyDepositCore || build instanceof CoreBlock.CoreBuild) {
                Call.transferInventory(Vars.player, build);
            }
        } else {
            Call.dropItem(Vars.player.angleTo(x, y));
        }
    }

    public void rebuildArea(int x, int y, int x2, int y2) {
        Placement.NormalizeResult result = Placement.normalizeArea(x, y, x2, y2, this.rotation, false, 999999999);
        Tmp.r1.set(result.x * 8, result.y * 8, (result.x2 - result.x) * 8, (result.y2 - result.y) * 8);
        for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
            Block block = Vars.content.block(plan.block);
            if (!block.bounds(plan.x, plan.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            Vars.player.unit().addBuild(new BuildPlan(plan.x, plan.y, plan.rotation, Vars.content.block(plan.block), plan.config));
        }
    }

    public void tryBreakBlock(int x, int y) {
        if (this.validBreak(x, y)) {
            this.breakBlock(x, y);
        }
    }

    public boolean validPlace(int x, int y, Block type, int rotation) {
        return this.validPlace(x, y, type, rotation, null);
    }

    public boolean validPlace(int x, int y, Block type, int rotation, BuildPlan ignore) {
        if (Vars.player.unit().plans.size > 0) {
            Tmp.r1.setCentered((float)(x * 8) + type.offset, (float)(y * 8) + type.offset, type.size * 8);
            this.plansOut.clear();
            this.playerPlanTree.intersect(Tmp.r1, this.plansOut);
            for (int i = 0; i < this.plansOut.size; ++i) {
                BuildPlan plan = ((BuildPlan[])this.plansOut.items)[i];
                if (plan == ignore || plan.breaking || !plan.block.bounds(plan.x, plan.y, Tmp.r1).overlaps(type.bounds(x, y, Tmp.r2)) || type.canReplace(plan.block) && Tmp.r1.equals(Tmp.r2)) continue;
                return false;
            }
        }
        return Build.validPlace(type, Vars.player.team(), x, y, rotation);
    }

    public boolean validBreak(int x, int y) {
        return Build.validBreak(Vars.player.team(), x, y);
    }

    public void breakBlock(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && tile.build != null) {
            tile = tile.build.tile;
        }
        Vars.player.unit().addBuild(new BuildPlan(tile.x, tile.y));
    }

    public void drawArrow(Block block, int x, int y, int rotation) {
        this.drawArrow(block, x, y, rotation, this.validPlace(x, y, block, rotation));
    }

    public void drawArrow(Block block, int x, int y, int rotation, boolean valid) {
        float trns = block.size / 2 * 8;
        int dx = Geometry.d4((int)rotation).x;
        int dy = Geometry.d4((int)rotation).y;
        float offsetx = (float)(x * 8) + block.offset + (float)dx * trns;
        float offsety = (float)(y * 8) + block.offset + (float)dy * trns;
        Draw.color(!valid ? Pal.removeBack : Pal.accentBack);
        TextureAtlas.AtlasRegion regionArrow = Core.atlas.find("place-arrow");
        Draw.rect(regionArrow, offsetx, offsety - 1.0f, (float)regionArrow.width * regionArrow.scl(), (float)regionArrow.height * regionArrow.scl(), (float)(rotation * 90 - 90));
        Draw.color(!valid ? Pal.remove : Pal.accent);
        Draw.rect(regionArrow, offsetx, offsety, (float)regionArrow.width * regionArrow.scl(), (float)regionArrow.height * regionArrow.scl(), (float)(rotation * 90 - 90));
    }

    void iterateLine(int startX, int startY, int endX, int endY, Cons<PlaceLine> cons) {
        boolean diagonal = Core.input.keyDown(Binding.diagonal_placement);
        if (Core.settings.getBool("swapdiagonal") && Vars.mobile) {
            boolean bl = diagonal = !diagonal;
        }
        if (this.block != null && this.block.swapDiagonalPlacement) {
            diagonal = !diagonal;
        }
        int endRotation = -1;
        Building start = Vars.world.build(startX, startY);
        Building end = Vars.world.build(endX, endY);
        Seq<Point2> points = diagonal && (this.block == null || this.block.allowDiagonal) ? (this.block != null && start instanceof ChainedBuilding && end instanceof ChainedBuilding && this.block.canReplace(end.block) && this.block.canReplace(start.block) ? Placement.upgradeLine(startX, startY, endX, endY) : Placement.pathfindLine(this.block != null && this.block.conveyorPlacement, startX, startY, endX, endY)) : Placement.normalizeLine(startX, startY, endX, endY);
        if (points.size > 1 && end instanceof ChainedBuilding) {
            Point2 secondToLast = points.get(points.size - 2);
            if (!(Vars.world.build(secondToLast.x, secondToLast.y) instanceof ChainedBuilding)) {
                endRotation = end.rotation;
            }
        }
        if (this.block != null) {
            this.block.changePlacementPath(points, this.rotation, diagonal);
        }
        float angle = Angles.angle(startX, startY, endX, endY);
        int baseRotation = this.rotation;
        if (!this.overrideLineRotation || diagonal) {
            baseRotation = startX == endX && startY == endY ? this.rotation : (int)((angle + 45.0f) / 90.0f) % 4;
        }
        Tmp.r3.set(-1.0f, -1.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.size; ++i) {
            Point2 point = points.get(i);
            if (this.block != null && Tmp.r2.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset).overlaps(Tmp.r3)) continue;
            Point2 next = i == points.size - 1 ? null : points.get(i + 1);
            this.line.x = point.x;
            this.line.y = point.y;
            if (!this.overrideLineRotation || diagonal) {
                int result = baseRotation;
                if (next != null) {
                    result = Tile.relativeTo(point.x, point.y, next.x, next.y);
                } else if (endRotation != -1) {
                    result = endRotation;
                } else if (this.block.conveyorPlacement && i > 0) {
                    Point2 prev = points.get(i - 1);
                    result = Tile.relativeTo(prev.x, prev.y, point.x, point.y);
                }
                if (result != -1) {
                    this.line.rotation = result;
                }
            } else {
                this.line.rotation = this.rotation;
            }
            this.line.last = next == null;
            cons.get(this.line);
            Tmp.r3.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset);
        }
    }

    static class PlaceLine {
        public int x;
        public int y;
        public int rotation;
        public boolean last;

        PlaceLine() {
        }
    }
}

