/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.io.PropertiesUtils;
import arc.util.serialization.Json;
import arc.util.serialization.Jval;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.mod.ContentParser;
import mindustry.mod.Mod;
import mindustry.mod.ModClassLoader;
import mindustry.mod.Plugin;
import mindustry.mod.Scripts;
import mindustry.type.ErrorContent;
import mindustry.type.Publishable;
import mindustry.ui.Styles;

public class Mods
implements Loadable {
    private static final String[] metaFiles = new String[]{"mod.json", "mod.hjson", "plugin.json", "plugin.hjson"};
    private static final ObjectSet<String> blacklistedMods = ObjectSet.with("ui-lib", "braindustry");
    private Json json = new Json();
    @Nullable
    private Scripts scripts;
    private ContentParser parser = new ContentParser();
    private ObjectMap<String, Seq<Fi>> bundles = new ObjectMap();
    private ObjectSet<String> specialFolders = ObjectSet.with("bundles", "sprites", "sprites-override");
    private int totalSprites;
    private ObjectFloatMap<String> textureResize = new ObjectFloatMap();
    private MultiPacker packer;
    @Nullable
    private Seq<LoadedMod> lastOrderedMods = new Seq();
    private ModClassLoader mainLoader = new ModClassLoader(this.getClass().getClassLoader());
    Seq<LoadedMod> mods = new Seq();
    private ObjectMap<Class<?>, ModMeta> metas = new ObjectMap();
    private boolean requiresReload;

    public Mods() {
        Events.on(EventType.ClientLoadEvent.class, e -> Core.app.post(this::checkWarnings));
    }

    public ClassLoader mainLoader() {
        return this.mainLoader;
    }

    public Fi getConfig(Mod mod) {
        ModMeta load = this.metas.get(mod.getClass());
        if (load == null) {
            throw new IllegalArgumentException("Mod is not loaded yet (or missing)!");
        }
        return Vars.modDirectory.child(load.name).child("config.json");
    }

    public void listFiles(String directory, Cons2<LoadedMod, Fi> cons) {
        this.eachEnabled(mod -> {
            Fi file = mod.root.child(directory);
            if (file.exists()) {
                for (Fi child : file.list()) {
                    cons.get((LoadedMod)mod, child);
                }
            }
        });
    }

    @Nullable
    public LoadedMod getMod(String name) {
        return this.mods.find(m -> m.name.equals(name));
    }

    @Nullable
    public LoadedMod getMod(Class<? extends Mod> type) {
        return this.mods.find(m -> m.main != null && m.main.getClass() == type);
    }

    public LoadedMod importMod(Fi file) throws IOException {
        String baseName;
        String finalName = baseName = file.nameWithoutExtension().replace(':', '_').replace(' ', '_');
        int count = 1;
        while (Vars.modDirectory.child(finalName + ".zip").exists()) {
            finalName = baseName + "" + count++;
        }
        Fi dest = Vars.modDirectory.child(finalName + ".zip");
        try {
            file.copyTo(dest);
            LoadedMod loaded = this.loadMod(dest, true, true);
            this.mods.add(loaded);
            this.lastOrderedMods = null;
            this.requiresReload = true;
            Core.settings.put("mod-" + loaded.name + "-enabled", true);
            this.sortMods();
            Core.app.post(() -> this.loadIcon(loaded));
            Events.fire(EventType.Trigger.importMod);
            return loaded;
        }
        catch (IOException e) {
            dest.delete();
            throw e;
        }
        catch (Throwable t) {
            dest.delete();
            throw new IOException(t);
        }
    }

    @Override
    public void loadAsync() {
        if (!this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::enabled)))) {
            return;
        }
        Time.mark();
        this.packer = new MultiPacker();
        Seq tasks = new Seq();
        this.eachEnabled(mod -> {
            Seq<Fi> sprites = mod.root.child("sprites").findAll(f -> f.extension().equals("png"));
            Seq<Fi> overrides = mod.root.child("sprites-override").findAll(f -> f.extension().equals("png"));
            this.packSprites(sprites, (LoadedMod)mod, true, tasks);
            this.packSprites(overrides, (LoadedMod)mod, false, tasks);
            Log.debug("Packed @ images for mod '@'.", sprites.size + overrides.size, mod.meta.name);
            this.totalSprites += sprites.size + overrides.size;
        });
        for (Future result : tasks) {
            try {
                Runnable packRun = (Runnable)result.get();
                if (packRun == null) continue;
                try {
                    packRun.run();
                }
                catch (Exception e) {
                    Log.err("Failed to fit image into the spritesheet, skipping.", new Object[0]);
                    Log.err(e);
                }
            }
            catch (Exception e) {
                Log.err(e);
            }
        }
        Log.debug("Time to pack textures: @", Float.valueOf(Time.elapsed()));
    }

    private void loadIcons() {
        for (LoadedMod mod : this.mods) {
            this.loadIcon(mod);
        }
    }

    private void loadIcon(LoadedMod mod) {
        if (mod.root.child("icon.png").exists() && !Vars.headless) {
            try {
                mod.iconTexture = new Texture(mod.root.child("icon.png"));
                mod.iconTexture.setFilter(Texture.TextureFilter.linear);
            }
            catch (Throwable t) {
                Log.err("Failed to load icon for mod '" + mod.name + "'.", t);
            }
        }
    }

    private void packSprites(Seq<Fi> sprites, LoadedMod mod, boolean prefix, Seq<Future<Runnable>> tasks) {
        boolean bleed = Core.settings.getBool("linear", true) && !mod.meta.pregenerated;
        float textureScale = mod.meta.texturescale;
        for (Fi file : sprites) {
            String regionName;
            String baseName = file.nameWithoutExtension();
            String string = regionName = baseName.contains(".") ? baseName.substring(0, baseName.indexOf(".")) : baseName;
            if (!prefix && !Core.atlas.has(regionName)) {
                Log.warn("Sprite '@' in mod '@' attempts to override a non-existent sprite. Ignoring.", regionName, mod.name);
                continue;
            }
            tasks.add(Vars.mainExecutor.submit(() -> {
                try {
                    Pixmap pix = new Pixmap(file.readBytes());
                    if (bleed) {
                        Pixmaps.bleed(pix, 2);
                    }
                    return () -> {
                        String fullName = (prefix ? mod.name + "-" : "") + baseName;
                        this.packer.add(this.getPage(file), fullName, new PixmapRegion(pix));
                        if (textureScale != 1.0f) {
                            this.textureResize.put(fullName, textureScale);
                        }
                        pix.dispose();
                    };
                }
                catch (Exception e) {
                    throw new Exception("Failed to load image " + file + " for mod " + mod.name, e);
                }
            }));
        }
    }

    @Override
    public void loadSync() {
        this.loadIcons();
        if (this.packer == null) {
            return;
        }
        Time.mark();
        if (this.totalSprites > 0) {
            class RegionEntry {
                String name;
                PixmapRegion region;
                int[] splits;
                int[] pads;

                RegionEntry(String name, PixmapRegion region, int[] splits, int[] pads) {
                    this.name = name;
                    this.region = region;
                    this.splits = splits;
                    this.pads = pads;
                }
            }
            MultiPacker.PageType type;
            Seq[] entries = new Seq[MultiPacker.PageType.all.length];
            for (int i = 0; i < MultiPacker.PageType.all.length; ++i) {
                entries[i] = new Seq();
            }
            ObjectMap<Texture, MultiPacker.PageType> pageTypes = ObjectMap.of(new Object[]{Core.atlas.find((String)"white").texture, MultiPacker.PageType.main, Core.atlas.find((String)"stone1").texture, MultiPacker.PageType.environment, Core.atlas.find((String)"clear-editor").texture, MultiPacker.PageType.editor, Core.atlas.find((String)"whiteui").texture, MultiPacker.PageType.ui, Core.atlas.find((String)"rubble-1-0").texture, MultiPacker.PageType.rubble});
            for (TextureAtlas.AtlasRegion region : Core.atlas.getRegions()) {
                type = pageTypes.get(region.texture, MultiPacker.PageType.main);
                if (this.packer.has(type, region.name)) continue;
                entries[type.ordinal()].add(new RegionEntry(region.name, Core.atlas.getPixmap(region), region.splits, region.pads));
            }
            for (int i = 0; i < MultiPacker.PageType.all.length; ++i) {
                Seq rects = entries[i];
                type = MultiPacker.PageType.all[i];
                rects.sort(Structs.comparingInt(o -> -Math.max(o.region.width, o.region.height)));
                for (RegionEntry entry : rects) {
                    this.packer.add(type, entry.name, entry.region, entry.splits, entry.pads);
                }
            }
            Core.atlas.dispose();
            final TextureAtlas shadow = Core.atlas;
            Core.atlas = new TextureAtlas(){
                {
                    this.error = shadow.find("error");
                }

                @Override
                public TextureAtlas.AtlasRegion find(String name) {
                    PixmapRegion base = Mods.this.packer.get(name);
                    if (base != null) {
                        TextureAtlas.AtlasRegion reg = new TextureAtlas.AtlasRegion(shadow.find((String)name).texture, base.x, base.y, base.width, base.height);
                        reg.name = name;
                        reg.pixmapRegion = base;
                        return reg;
                    }
                    return shadow.find(name);
                }

                @Override
                public boolean isFound(TextureRegion region) {
                    return region != shadow.find("error");
                }

                @Override
                public TextureRegion find(String name, TextureRegion def) {
                    return !this.has(name) ? def : this.find(name);
                }

                @Override
                public boolean has(String s) {
                    return shadow.has(s) || Mods.this.packer.get(s) != null;
                }

                @Override
                public PixmapRegion getPixmap(TextureAtlas.AtlasRegion region) {
                    PixmapRegion out = Mods.this.packer.get(region.name);
                    if (out == null) {
                        return Mods.this.packer.get("error");
                    }
                    return out;
                }
            };
            Texture.TextureFilter filter = Core.settings.getBool("linear", true) ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
            Time.mark();
            for (Seq<Content> arr : Vars.content.getContentMap()) {
                arr.each(c -> {
                    if (c instanceof UnlockableContent) {
                        UnlockableContent u = (UnlockableContent)c;
                        if (c.minfo.mod != null) {
                            u.load();
                            u.loadIcon();
                            if (u.generateIcons && !c.minfo.mod.meta.pregenerated) {
                                u.createIcons(this.packer);
                            }
                        }
                    }
                });
            }
            Log.debug("Time to generate icons: @", Float.valueOf(Time.elapsed()));
            Core.atlas = this.packer.flush(filter, new TextureAtlas());
            this.textureResize.each(e -> {
                Core.atlas.find((String)((String)e.key)).scale = e.value;
            });
            Core.atlas.setErrorRegion("error");
            Log.debug("Total pages: @", Core.atlas.getTextures().size);
            this.packer.printStats();
        }
        this.packer.dispose();
        this.packer = null;
        Log.debug("Total time to generate & flush textures synchronously: @", Float.valueOf(Time.elapsed()));
    }

    private MultiPacker.PageType getPage(Fi file) {
        String path = file.path();
        return path.contains("sprites/blocks/environment") || path.contains("sprites-override/blocks/environment") ? MultiPacker.PageType.environment : (path.contains("sprites/editor") || path.contains("sprites-override/editor") ? MultiPacker.PageType.editor : (path.contains("sprites/rubble") || path.contains("sprites-override/rubble") ? MultiPacker.PageType.rubble : (path.contains("sprites/ui") || path.contains("sprites-override/ui") ? MultiPacker.PageType.ui : MultiPacker.PageType.main)));
    }

    public void removeMod(LoadedMod mod) {
        boolean deleted;
        if (mod.root instanceof ZipFi) {
            mod.root.delete();
        }
        boolean bl = deleted = mod.file.isDirectory() ? mod.file.deleteDirectory() : mod.file.delete();
        if (!deleted) {
            Vars.ui.showErrorMessage("@mod.delete.error");
            return;
        }
        this.mods.remove(mod);
        mod.dispose();
        this.requiresReload = true;
    }

    public Scripts getScripts() {
        if (this.scripts == null) {
            this.scripts = Vars.platform.createScripts();
        }
        return this.scripts;
    }

    public boolean hasScripts() {
        return this.scripts != null;
    }

    public boolean requiresReload() {
        return this.requiresReload;
    }

    public boolean skipModLoading() {
        return Vars.failedToLaunch && Core.settings.getBool("modcrashdisable", true);
    }

    /*
     * WARNING - void declaration
     */
    public void load() {
        Seq candidates = new Seq();
        Seq.with(Vars.modDirectory.list()).retainAll(f -> f.extEquals("jar") || f.extEquals("zip") || f.isDirectory() && Structs.contains(metaFiles, meta -> f.child((String)meta).exists())).each(candidates::add);
        Vars.platform.getWorkshopContent(LoadedMod.class).each(candidates::add);
        ObjectMap<String, Fi> mapping = new ObjectMap<String, Fi>();
        Seq<ModMeta> metas = new Seq<ModMeta>();
        for (Fi file : candidates) {
            void var6_6;
            Object var6_7 = null;
            try {
                Fi zip;
                Fi fi = zip = file.isDirectory() ? file : new ZipFi(file);
                if (zip.list().length == 1 && zip.list()[0].isDirectory()) {
                    zip = zip.list()[0];
                }
                ModMeta modMeta = this.findMeta(zip);
            }
            catch (Throwable zip) {
                // empty catch block
            }
            if (var6_6 == null || var6_6.name == null) continue;
            metas.add((ModMeta)var6_6);
            mapping.put(var6_6.internalName, file);
        }
        OrderedMap<String, ModState> resolved = this.resolveDependencies(metas);
        for (ObjectMap.Entry entry : resolved) {
            Fi file = (Fi)mapping.get((String)entry.key);
            boolean steam = Vars.platform.getWorkshopContent(LoadedMod.class).contains(file);
            Log.debug("[Mods] Loading mod @", file);
            try {
                LoadedMod mod = this.loadMod(file, false, entry.value == ModState.enabled);
                mod.state = (ModState)((Object)entry.value);
                this.mods.add(mod);
                this.lastOrderedMods = null;
                if (!steam) continue;
                mod.addSteamID(file.name());
            }
            catch (Throwable e) {
                if (e instanceof ClassNotFoundException && e.getMessage().contains("mindustry.plugin.Plugin")) {
                    Log.info("Plugin '@' is outdated and needs to be ported to 6.0! Update its main class to inherit from 'mindustry.mod.Plugin'. See https://mindustrygame.github.io/wiki/modding/6-migrationv6/", file.name());
                    continue;
                }
                if (steam) {
                    Log.err("Failed to load mod workshop file @. Skipping.", file);
                    Log.err(e);
                    continue;
                }
                Log.err("Failed to load mod file @. Skipping.", file);
                Log.err(e);
            }
        }
        this.mods.each(this::updateDependencies);
        for (LoadedMod loadedMod : this.mods) {
            if (loadedMod.state != ModState.enabled) continue;
            if (!loadedMod.isSupported()) {
                loadedMod.state = ModState.unsupported;
                continue;
            }
            if (loadedMod.shouldBeEnabled()) continue;
            loadedMod.state = ModState.disabled;
        }
        this.sortMods();
        this.buildFiles();
    }

    private void sortMods() {
        this.mods.sort(Structs.comps(Structs.comparingInt(m -> m.state.ordinal()), Structs.comparing(m -> m.name)));
    }

    private void updateDependencies(LoadedMod mod) {
        mod.dependencies.clear();
        mod.missingDependencies.clear();
        mod.dependencies = mod.meta.dependencies.map(this::locateMod);
        for (int i = 0; i < mod.dependencies.size; ++i) {
            if (mod.dependencies.get(i) != null) continue;
            mod.missingDependencies.add(mod.meta.dependencies.get(i));
        }
    }

    public Seq<LoadedMod> orderedMods() {
        if (this.lastOrderedMods == null) {
            Seq<LoadedMod> enabled = this.mods.select(LoadedMod::enabled);
            ObjectMap<String, LoadedMod> mapping = enabled.asMap(m -> m.meta.internalName);
            this.lastOrderedMods = this.resolveDependencies(enabled.map(m -> m.meta)).orderedKeys().map(mapping::get);
        }
        return this.lastOrderedMods;
    }

    public LoadedMod locateMod(String name) {
        return this.mods.find(mod -> mod.enabled() && mod.name.equals(name));
    }

    private void buildFiles() {
        for (LoadedMod mod : this.orderedMods()) {
            boolean zipFolder = !mod.file.isDirectory() && mod.root.parent() != null;
            String parentName = zipFolder ? mod.root.name() : null;
            for (Fi file : mod.root.list()) {
                if (!file.isDirectory() || this.specialFolders.contains(file.name())) continue;
                file.walk(f -> Vars.tree.addFile(mod.file.isDirectory() ? f.path().substring(1 + mod.file.path().length()) : (zipFolder ? f.path().substring(parentName.length() + 1) : f.path()), (Fi)f));
            }
            Fi folder = mod.root.child("bundles");
            if (!folder.exists()) continue;
            for (Fi file : folder.list()) {
                if (!file.name().startsWith("bundle") || !file.extension().equals("properties")) continue;
                String name = file.nameWithoutExtension();
                ((Seq)((Object)this.bundles.get(name, (Seq<Fi>)((Object)((Prov<Seq>)Seq::new))))).add(file);
            }
        }
        Events.fire(new EventType.FileTreeInitEvent());
        for (I18NBundle bundle = Core.bundle; bundle != null; bundle = bundle.getParent()) {
            String str = bundle.getLocale().toString();
            String locale = "bundle" + (str.isEmpty() ? "" : "_" + str);
            for (Fi file : (Seq)((Object)this.bundles.get(locale, (Seq<Fi>)((Object)((Prov<Seq>)Seq::new))))) {
                try {
                    PropertiesUtils.load(bundle.getProperties(), file.reader());
                }
                catch (Throwable e) {
                    Log.err("Error loading bundle: " + file + "/" + locale, e);
                }
            }
        }
    }

    private void checkWarnings() {
        if (this.scripts != null && this.scripts.hasErrored()) {
            Vars.ui.showErrorMessage("@mod.scripts.disable");
        }
        if (this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::hasContentErrors)))) {
            Vars.ui.loadfrag.hide();
            new Dialog(""){
                {
                    this.setFillParent(true);
                    this.cont.margin(15.0f);
                    this.cont.add("@error.title");
                    this.cont.row();
                    this.cont.image().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                    this.cont.row();
                    this.cont.add("@mod.errors").wrap().growX().center().get().setAlignment(1);
                    this.cont.row();
                    this.cont.pane((Table p) -> Mods.this.mods.each(m -> m.enabled() && m.hasContentErrors(), m -> {
                        p.add(m.name).color(Pal.accent).left();
                        p.row();
                        p.image().fillX().pad(4.0f).color(Pal.accent);
                        p.row();
                        p.table((Table d) -> {
                            d.left().marginLeft(15.0f);
                            for (final Content c : m.erroredContent) {
                                d.add(c.minfo.sourceFile.nameWithoutExtension()).left().padRight(10.0f);
                                d.button("@details", (Drawable)Icon.downOpen, Styles.cleart, () -> new Dialog(""){
                                    {
                                        super(arg0);
                                        this.setFillParent(true);
                                        this.cont.pane((Table e) -> e.add(c2.minfo.error).wrap().grow().labelAlign(1, 8)).grow();
                                        this.cont.row();
                                        this.cont.button("@ok", Icon.left, this::hide).size(240.0f, 60.0f);
                                    }
                                }.show()).size(190.0f, 50.0f).left().marginLeft(6.0f);
                                d.row();
                            }
                        }).left();
                        p.row();
                    }));
                    this.cont.row();
                    this.cont.button("@ok", this::hide).size(300.0f, 50.0f);
                }
            }.show();
        }
    }

    public boolean hasContentErrors() {
        return this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::hasContentErrors))) || this.scripts != null && this.scripts.hasErrored();
    }

    public void loadScripts() {
        Time.mark();
        boolean[] any = new boolean[]{false};
        try {
            this.eachEnabled(mod -> {
                if (mod.root.child("scripts").exists()) {
                    Fi main;
                    Vars.content.setCurrentMod((LoadedMod)mod);
                    Seq<Fi> allScripts = mod.root.child("scripts").findAll(f -> f.extEquals("js"));
                    Fi fi = main = allScripts.size == 1 ? allScripts.first() : mod.root.child("scripts").child("main.js");
                    if (main.exists() && !main.isDirectory()) {
                        try {
                            if (this.scripts == null) {
                                this.scripts = Vars.platform.createScripts();
                            }
                            any[0] = true;
                            this.scripts.run((LoadedMod)mod, main);
                        }
                        catch (Throwable e) {
                            Core.app.post(() -> {
                                Log.err("Error loading main script @ for mod @.", main.name(), mod.meta.name);
                                Log.err(e);
                            });
                        }
                    } else {
                        Core.app.post(() -> Log.err("No main.js found for mod @.", mod.meta.name));
                    }
                }
            });
        }
        finally {
            Vars.content.setCurrentMod(null);
        }
        if (any[0]) {
            Log.info("Time to initialize modded scripts: @", Float.valueOf(Time.elapsed()));
        }
    }

    public void loadContent() {
        for (LoadedMod mod : this.orderedMods()) {
            if (mod.main == null || mod.meta.hidden) continue;
            Vars.content.setCurrentMod(mod);
            mod.main.loadContent();
        }
        Vars.content.setCurrentMod(null);
        class LoadRun
        implements Comparable<LoadRun> {
            final ContentType type;
            final Fi file;
            final LoadedMod mod;

            public LoadRun(ContentType type, Fi file, LoadedMod mod) {
                this.type = type;
                this.file = file;
                this.mod = mod;
            }

            @Override
            public int compareTo(LoadRun l) {
                int mod = this.mod.name.compareTo(l.mod.name);
                if (mod != 0) {
                    return mod;
                }
                return this.file.name().compareTo(l.file.name());
            }
        }
        Seq<LoadRun> runs = new Seq<LoadRun>();
        for (LoadedMod mod : this.orderedMods()) {
            if (!mod.root.child("content").exists()) continue;
            Fi contentRoot = mod.root.child("content");
            for (ContentType type : ContentType.all) {
                String lower = type.name().toLowerCase(Locale.ROOT);
                Fi folder = contentRoot.child(lower + (lower.endsWith("s") ? "" : "s"));
                if (!folder.exists()) continue;
                for (Fi file : folder.findAll(f -> f.extension().equals("json") || f.extension().equals("hjson"))) {
                    runs.add(new LoadRun(type, file, mod));
                }
            }
        }
        runs.sort();
        for (LoadRun l : runs) {
            Content current = Vars.content.getLastAdded();
            try {
                Object object;
                Content loaded = this.parser.parse(l.mod, l.file.nameWithoutExtension(), l.file.readString("UTF-8"), l.file, l.type);
                Object[] objectArray = new Object[2];
                objectArray[0] = l.mod.meta.name;
                if (loaded instanceof UnlockableContent) {
                    UnlockableContent u = (UnlockableContent)loaded;
                    object = u.localizedName;
                } else {
                    object = loaded;
                }
                objectArray[1] = object;
                Log.debug("[@] Loaded '@'.", objectArray);
            }
            catch (Throwable e) {
                if (current != Vars.content.getLastAdded() && Vars.content.getLastAdded() != null) {
                    this.parser.markError(Vars.content.getLastAdded(), l.mod, l.file, e);
                    continue;
                }
                ErrorContent error = new ErrorContent();
                this.parser.markError(error, l.mod, l.file, e);
            }
        }
        this.parser.finishParsing();
    }

    public void handleContentError(Content content, Throwable error) {
        this.parser.markError(content, error);
    }

    public void addParseListener(ContentParser.ParseListener hook) {
        this.parser.listeners.add(hook);
    }

    public Seq<String> getModStrings() {
        return this.mods.select(l -> !l.meta.hidden && l.enabled()).map(l -> l.name + ":" + l.meta.version);
    }

    public void setEnabled(LoadedMod mod, boolean enabled) {
        if (mod.enabled() != enabled) {
            Core.settings.put("mod-" + mod.name + "-enabled", enabled);
            this.requiresReload = true;
            mod.state = enabled ? ModState.enabled : ModState.disabled;
            this.mods.each(this::updateDependencies);
            this.sortMods();
        }
    }

    public Seq<String> getIncompatibility(Seq<String> out) {
        Seq<String> mods = this.getModStrings();
        Seq<String> result = mods.copy();
        for (String mod : mods) {
            if (!out.remove(mod)) continue;
            result.remove(mod);
        }
        return result;
    }

    public Seq<LoadedMod> list() {
        return this.mods;
    }

    public void eachClass(Cons<Mod> cons) {
        this.orderedMods().each(p -> p.main != null, p -> this.contextRun((LoadedMod)p, () -> cons.get(p.main)));
    }

    public void eachEnabled(Cons<LoadedMod> cons) {
        this.orderedMods().each(LoadedMod::enabled, cons);
    }

    public void contextRun(LoadedMod mod, Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error loading mod " + mod.meta.name, t);
        }
    }

    @Nullable
    public ModMeta findMeta(Fi file) {
        String name;
        Fi metaFile = null;
        String[] stringArray = metaFiles;
        int n = stringArray.length;
        for (int i = 0; i < n && !(metaFile = file.child(name = stringArray[i])).exists(); ++i) {
        }
        if (!metaFile.exists()) {
            return null;
        }
        ModMeta meta = this.json.fromJson(ModMeta.class, Jval.read(metaFile.readString()).toString(Jval.Jformat.plain));
        meta.cleanup();
        return meta;
    }

    public OrderedMap<String, ModState> resolveDependencies(Seq<ModMeta> metas) {
        ModResolutionContext context = new ModResolutionContext();
        for (ModMeta meta : metas) {
            Seq<ModDependency> dependencies = new Seq<ModDependency>();
            for (String dependency : meta.dependencies) {
                dependencies.add(new ModDependency(dependency, true));
            }
            for (String dependency : meta.softDependencies) {
                dependencies.add(new ModDependency(dependency, false));
            }
            context.dependencies.put(meta.internalName, dependencies);
        }
        for (String key : context.dependencies.keys()) {
            if (context.ordered.contains(key)) continue;
            this.resolve(key, context);
            context.visited.clear();
        }
        OrderedMap<String, ModState> result = new OrderedMap<String, ModState>();
        for (String name : context.ordered) {
            result.put(name, ModState.enabled);
        }
        result.putAll(context.invalid);
        return result;
    }

    private boolean resolve(String element, ModResolutionContext context) {
        context.visited.add(element);
        for (ModDependency dependency : context.dependencies.get(element)) {
            if (context.visited.contains(dependency.name) && !context.ordered.contains(dependency.name)) {
                context.invalid.put(dependency.name, ModState.circularDependencies);
                return false;
            }
            if (context.dependencies.containsKey(dependency.name)) {
                if (context.ordered.contains(dependency.name) || this.resolve(dependency.name, context) || !dependency.required) continue;
                context.invalid.put(element, ModState.incompleteDependencies);
                return false;
            }
            if (!dependency.required) continue;
            context.invalid.put(element, ModState.missingDependencies);
            return false;
        }
        if (!context.ordered.contains(element)) {
            context.ordered.add(element);
        }
        return true;
    }

    private LoadedMod loadMod(Fi sourceFile) throws Exception {
        return this.loadMod(sourceFile, false, true);
    }

    private LoadedMod loadMod(Fi sourceFile, boolean overwrite, boolean initialize) throws Exception {
        Time.mark();
        ZipFi rootZip = null;
        try {
            int line;
            Mod mainMod;
            ModMeta meta;
            Fi zip;
            Fi fi;
            if (sourceFile.isDirectory()) {
                fi = sourceFile;
            } else {
                rootZip = new ZipFi(sourceFile);
                fi = zip = rootZip;
            }
            if (zip.list().length == 1 && zip.list()[0].isDirectory()) {
                zip = zip.list()[0];
            }
            if ((meta = this.findMeta(zip)) == null) {
                Log.warn("Mod @ doesn't have a '[mod/plugin].[h]json' file, skipping.", zip);
                throw new ModLoadException("Invalid file: No mod.json found.");
            }
            String camelized = meta.name.replace(" ", "");
            String mainClass = meta.main == null ? camelized.toLowerCase(Locale.ROOT) + "." + camelized + "Mod" : meta.main;
            String baseName = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
            LoadedMod other = this.mods.find(m -> m.name.equals(baseName));
            if (other != null) {
                if (overwrite && !other.hasSteamID()) {
                    if (other.root instanceof ZipFi) {
                        other.root.delete();
                    }
                    if (other.file.isDirectory()) {
                        other.file.deleteDirectory();
                    } else {
                        other.file.delete();
                    }
                    this.mods.remove(other);
                } else {
                    throw new ModLoadException("A mod with the name '" + baseName + "' is already imported.");
                }
            }
            ClassLoader loader = null;
            Fi mainFile = zip;
            if (Vars.android) {
                mainFile = mainFile.child("classes.dex");
            } else {
                String[] path;
                for (String str : path = (mainClass.replace('.', '/') + ".class").split("/")) {
                    if (str.isEmpty()) continue;
                    mainFile = mainFile.child(str);
                }
            }
            if ((mainFile.exists() || meta.java) && !this.skipModLoading() && Core.settings.getBool("mod-" + baseName + "-enabled", true) && Version.isAtLeast(meta.minGameVersion) && (meta.getMinMajor() >= 136 || Vars.headless) && initialize) {
                if (Vars.ios) {
                    throw new ModLoadException("Java class mods are not supported on iOS.");
                }
                loader = Vars.platform.loadJar(sourceFile, this.mainLoader);
                this.mainLoader.addChild(loader);
                Class<?> main = Class.forName(mainClass, true, loader);
                if ((main.getSuperclass().getName().equals("mindustry.mod.Plugin") || main.getSuperclass().getName().equals("mindustry.mod.Mod")) && main.getSuperclass().getClassLoader() != Mod.class.getClassLoader()) {
                    throw new ModLoadException("This mod/plugin has loaded Mindustry dependencies from its own class loader. You are incorrectly including Mindustry dependencies in the mod JAR - make sure Mindustry is declared as `compileOnly` in Gradle, and that the JAR is created with `runtimeClasspath`!");
                }
                this.metas.put(main, meta);
                mainMod = (Mod)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                mainMod = null;
            }
            if (mainMod instanceof Plugin) {
                meta.hidden = true;
            }
            if (meta.version != null && (line = meta.version.indexOf(10)) != -1) {
                meta.version = meta.version.substring(0, line);
            }
            if (this.skipModLoading()) {
                Core.settings.put("mod-" + baseName + "-enabled", false);
            }
            if (!Vars.headless && Core.settings.getBool("mod-" + baseName + "-enabled", true)) {
                Log.info("Loaded mod '@' in @ms", meta.name, Float.valueOf(Time.elapsed()));
            }
            return new LoadedMod(sourceFile, zip, mainMod, loader, meta);
        }
        catch (Exception e) {
            if (rootZip != null) {
                rootZip.delete();
            }
            throw e;
        }
    }

    public static class ModMeta {
        public String name;
        public String internalName;
        public String minGameVersion = "0";
        @Nullable
        public String displayName;
        @Nullable
        public String author;
        @Nullable
        public String description;
        @Nullable
        public String subtitle;
        @Nullable
        public String version;
        @Nullable
        public String main;
        @Nullable
        public String repo;
        public Seq<String> dependencies = Seq.with(new String[0]);
        public Seq<String> softDependencies = Seq.with(new String[0]);
        public boolean hidden;
        public boolean java;
        public boolean keepOutlines;
        public float texturescale = 1.0f;
        public boolean pregenerated;

        public String displayName() {
            return this.displayName;
        }

        public String shortDescription() {
            return Strings.truncate(this.subtitle == null ? (this.description == null || this.description.length() > 40 ? "" : this.description) : this.subtitle, 40, "...");
        }

        public void cleanup() {
            if (this.name != null) {
                this.name = Strings.stripColors(this.name);
            }
            if (this.displayName != null) {
                this.displayName = Strings.stripColors(this.displayName);
            }
            if (this.displayName == null) {
                this.displayName = this.name;
            }
            if (this.author != null) {
                this.author = Strings.stripColors(this.author);
            }
            if (this.description != null) {
                this.description = Strings.stripColors(this.description);
            }
            if (this.subtitle != null) {
                this.subtitle = Strings.stripColors(this.subtitle).replace("\n", "");
            }
            if (this.name != null) {
                this.internalName = this.name.toLowerCase(Locale.ROOT).replace(" ", "-");
            }
        }

        public int getMinMajor() {
            String ver = this.minGameVersion == null ? "0" : this.minGameVersion;
            int dot = ver.indexOf(".");
            return dot != -1 ? Strings.parseInt(ver.substring(0, dot), 0) : Strings.parseInt(ver, 0);
        }

        public String toString() {
            return "ModMeta{name='" + this.name + '\'' + ", minGameVersion='" + this.minGameVersion + '\'' + ", displayName='" + this.displayName + '\'' + ", author='" + this.author + '\'' + ", description='" + this.description + '\'' + ", subtitle='" + this.subtitle + '\'' + ", version='" + this.version + '\'' + ", main='" + this.main + '\'' + ", repo='" + this.repo + '\'' + ", dependencies=" + this.dependencies + ", softDependencies=" + this.softDependencies + ", hidden=" + this.hidden + ", java=" + this.java + ", keepOutlines=" + this.keepOutlines + ", texturescale=" + this.texturescale + ", pregenerated=" + this.pregenerated + '}';
        }
    }

    public static class LoadedMod
    implements Publishable,
    Disposable {
        public final Fi file;
        public final Fi root;
        @Nullable
        public final Mod main;
        public final String name;
        public final ModMeta meta;
        public Seq<LoadedMod> dependencies = new Seq();
        public Seq<String> missingDependencies = new Seq();
        public ObjectSet<Content> erroredContent = new ObjectSet();
        public ModState state = ModState.enabled;
        @Nullable
        public Texture iconTexture;
        @Nullable
        public ClassLoader loader;

        public LoadedMod(Fi file, Fi root, Mod main, ClassLoader loader, ModMeta meta) {
            this.root = root;
            this.file = file;
            this.loader = loader;
            this.main = main;
            this.meta = meta;
            this.name = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
        }

        public boolean isJava() {
            return this.meta.java || this.main != null;
        }

        @Nullable
        public String getRepo() {
            return Core.settings.getString("mod-" + this.name + "-repo", this.meta.repo);
        }

        public void setRepo(String repo) {
            Core.settings.put("mod-" + this.name + "-repo", repo);
        }

        public boolean enabled() {
            return this.state == ModState.enabled || this.state == ModState.contentErrors;
        }

        public boolean shouldBeEnabled() {
            return Core.settings.getBool("mod-" + this.name + "-enabled", true);
        }

        public boolean hasUnmetDependencies() {
            return !this.missingDependencies.isEmpty();
        }

        public boolean hasContentErrors() {
            return !this.erroredContent.isEmpty();
        }

        public boolean isSupported() {
            if (Vars.headless) {
                return true;
            }
            if (this.isOutdated() || this.isBlacklisted()) {
                return false;
            }
            return Version.isAtLeast(this.meta.minGameVersion);
        }

        public boolean isBlacklisted() {
            return blacklistedMods.contains(this.name);
        }

        public boolean isOutdated() {
            return this.getMinMajor() < 136;
        }

        public int getMinMajor() {
            return this.meta.getMinMajor();
        }

        @Override
        public void dispose() {
            if (this.iconTexture != null) {
                this.iconTexture.dispose();
                this.iconTexture = null;
            }
        }

        @Override
        public String getSteamID() {
            return Core.settings.getString(this.name + "-steamid", null);
        }

        @Override
        public void addSteamID(String id) {
            Core.settings.put(this.name + "-steamid", id);
        }

        @Override
        public void removeSteamID() {
            Core.settings.remove(this.name + "-steamid");
        }

        @Override
        public String steamTitle() {
            return this.meta.name;
        }

        @Override
        public String steamDescription() {
            return this.meta.description;
        }

        @Override
        public String steamTag() {
            return "mod";
        }

        @Override
        public Fi createSteamFolder(String id) {
            return this.file;
        }

        @Override
        public Fi createSteamPreview(String id) {
            return this.file.child("preview.png");
        }

        @Override
        public boolean prePublish() {
            if (!this.file.isDirectory()) {
                Vars.ui.showErrorMessage("@mod.folder.missing");
                return false;
            }
            if (!this.file.child("preview.png").exists()) {
                Vars.ui.showErrorMessage("@mod.preview.missing");
                return false;
            }
            return true;
        }

        public String toString() {
            return "LoadedMod{file=" + this.file + ", root=" + this.root + ", name='" + this.name + '\'' + '}';
        }
    }

    public static enum ModState {
        enabled,
        contentErrors,
        missingDependencies,
        incompleteDependencies,
        circularDependencies,
        unsupported,
        disabled;

    }

    public static class ModResolutionContext {
        public final ObjectMap<String, Seq<ModDependency>> dependencies = new ObjectMap();
        public final ObjectSet<String> visited = new ObjectSet();
        public final OrderedSet<String> ordered = new OrderedSet();
        public final ObjectMap<String, ModState> invalid = new OrderedMap<String, ModState>();
    }

    public static final class ModDependency {
        public final String name;
        public final boolean required;

        public ModDependency(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }

    public static class ModLoadException
    extends RuntimeException {
        public ModLoadException(String message) {
            super(message);
        }
    }
}

