/*
 * Decompiled with CFR 0.152.
 */
package mindustry.service;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.struct.IntSet;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Structs;
import arc.util.Timer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.Planets;
import mindustry.content.SectorPresets;
import mindustry.content.TechTree;
import mindustry.content.UnitTypes;
import mindustry.game.EventType;
import mindustry.game.SectorInfo;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.PowerGraphUpdaterc;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.service.Achievement;
import mindustry.service.SStat;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.OverdriveProjector;
import mindustry.world.blocks.defense.RegenProjector;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.production.AttributeCrafter;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;

public class GameService {
    private Seq<Tile> tmpTiles = new Seq();
    private ObjectSet<String> blocksBuilt = new ObjectSet();
    private ObjectSet<String> unitsBuilt = new ObjectSet();
    private ObjectSet<UnitType> t5s = new ObjectSet();
    private IntSet checked = new IntSet();
    private Block[] allTransportSerpulo;
    private Block[] allTransportErekir;
    private Block[] allErekirBlocks;
    private Block[] allSerpuloBlocks;

    public void init() {
        if (Vars.clientLoaded) {
            this.registerEvents();
        } else {
            Events.on(EventType.ClientLoadEvent.class, e -> this.registerEvents());
        }
    }

    public boolean enabled() {
        return false;
    }

    public void completeAchievement(String name) {
    }

    public void clearAchievement(String name) {
    }

    public boolean isAchieved(String name) {
        return false;
    }

    public int getStat(String name, int def) {
        return def;
    }

    public void setStat(String name, int amount) {
    }

    public void storeStats() {
    }

    private void checkAllBlocks(Achievement ach, Block[] blocks) {
        if (!Structs.contains(blocks, t -> !this.blocksBuilt.contains(t.name))) {
            ach.complete();
        }
    }

    private void registerEvents() {
        this.allTransportSerpulo = (Block[])Vars.content.blocks().select(b -> b.category == Category.distribution && b.isVisibleOn(Planets.serpulo) && b.isVanilla() && b.buildVisibility == BuildVisibility.shown).toArray(Block.class);
        this.allTransportErekir = (Block[])Vars.content.blocks().select(b -> b.category == Category.distribution && b.isVisibleOn(Planets.erekir) && b.isVanilla() && b.buildVisibility == BuildVisibility.shown).toArray(Block.class);
        this.allSerpuloBlocks = (Block[])Vars.content.blocks().select(b -> b.synthetic() && b.isVisibleOn(Planets.serpulo) && b.isVanilla() && !(b instanceof CoreBlock) && b.buildVisibility == BuildVisibility.shown).toArray(Block.class);
        this.allErekirBlocks = (Block[])Vars.content.blocks().select(b -> b.synthetic() && b.isVisibleOn(Planets.erekir) && b.isVanilla() && !(b instanceof CoreBlock) && b.buildVisibility == BuildVisibility.shown).toArray(Block.class);
        this.unitsBuilt = Core.settings.getJson("units-built", ObjectSet.class, String.class, ObjectSet::new);
        this.blocksBuilt = Core.settings.getJson("blocks-built", ObjectSet.class, String.class, ObjectSet::new);
        this.t5s = ObjectSet.with(UnitTypes.omura, UnitTypes.reign, UnitTypes.toxopid, UnitTypes.eclipse, UnitTypes.oct, UnitTypes.corvus);
        this.checkAllBlocks(Achievement.allBlocksErekir, this.allErekirBlocks);
        this.checkAllBlocks(Achievement.allBlocksSerpulo, this.allSerpuloBlocks);
        float updateInterval = 2.0f;
        Timer.schedule(this::checkUpdate, updateInterval, updateInterval);
        if (Items.thorium.unlocked()) {
            Achievement.obtainThorium.complete();
        }
        if (Items.titanium.unlocked()) {
            Achievement.obtainTitanium.complete();
        }
        if (SectorPresets.origin.sector.isCaptured()) {
            Achievement.completeErekir.complete();
        }
        if (SectorPresets.planetaryTerminal.sector.isCaptured()) {
            Achievement.completeSerpulo.complete();
        }
        if (Vars.mods.list().size > 0) {
            Achievement.installMod.complete();
        }
        Events.on(EventType.ClientLoadEvent.class, e -> {
            if (Vars.mods.list().size > 0) {
                Achievement.installMod.complete();
            }
        });
        if (Core.bundle.get("yes").equals("router")) {
            Achievement.routerLanguage.complete();
        }
        if (!Planets.serpulo.sectors.contains((Sector)((Object)((Boolf<Sector>)s -> !s.isCaptured())))) {
            Achievement.captureAllSectors.complete();
        }
        Events.run((Object)EventType.Trigger.openConsole, () -> Achievement.openConsole.complete());
        Events.run((Object)EventType.Trigger.unitCommandAttack, () -> {
            if (this.campaign()) {
                Achievement.issueAttackCommand.complete();
            }
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (this.campaign() && e.unit.team != Vars.player.team()) {
                SStat.unitsDestroyed.add();
                if (e.unit.isBoss()) {
                    SStat.bossesDefeated.add();
                }
            }
        });
        Events.on(EventType.TurnEvent.class, e -> {
            float total = 0.0f;
            for (Planet planet : Vars.content.planets()) {
                for (Sector sec : planet.sectors) {
                    if (!sec.hasBase()) continue;
                    for (SectorInfo.ExportStat v : sec.info.production.values()) {
                        if (!(v.mean > 0.0f)) continue;
                        total += v.mean * 60.0f;
                    }
                }
            }
            SStat.maxProduction.max(Math.round(total));
        });
        Events.run((Object)EventType.Trigger.update, () -> {
            Seq<Unit> units;
            if (this.campaign() && !Achievement.hoverUnitLiquid.isAchieved() && Core.graphics.getFrameId() % 20L == 0L && (units = Vars.state.rules.defaultTeam.data().getUnits(UnitTypes.elude)) != null) {
                for (Unit unit : units) {
                    if (!unit.floorOn().isLiquid) continue;
                    Achievement.hoverUnitLiquid.complete();
                    break;
                }
            }
            if (this.campaign() && Vars.player.unit().type.canBoost && Vars.player.unit().elevation >= 0.25f) {
                Achievement.boostUnit.complete();
            }
        });
        Events.run((Object)EventType.Trigger.newGame, () -> Core.app.post(() -> {
            if (this.campaign() && Vars.player.core() != null && Vars.player.core().items.total() >= 10000) {
                Achievement.drop10kitems.complete();
            }
        }));
        Events.on(EventType.BuildingBulletDestroyEvent.class, e -> {
            Entityc patt6818$temp;
            if (this.campaign() && e.build.block == Blocks.scatter && e.build.team == Vars.state.rules.waveTeam && (patt6818$temp = e.bullet.owner) instanceof Unit) {
                Unit u = (Unit)patt6818$temp;
                if (u.type == UnitTypes.flare && u.team == Vars.player.team()) {
                    Achievement.destroyScatterFlare.complete();
                }
            }
        });
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            if (this.campaign() && Vars.state.rules.sector == SectorPresets.groundZero.sector && e.tile.block() == Blocks.coreNucleus) {
                Achievement.nucleusGroundZero.complete();
            }
        });
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            block21: {
                block24: {
                    block23: {
                        Block[] patt7810$temp;
                        block22: {
                            Building patt7740$temp;
                            if (!this.campaign() || e.unit == null || !e.unit.isLocal() || e.breaking) break block21;
                            SStat.blocksBuilt.add();
                            if (e.tile.block() == Blocks.router && e.tile.build.proximity().contains((Building)((Object)((Boolf<Building>)t -> t.block == Blocks.router)))) {
                                Achievement.chainRouters.complete();
                            }
                            if (e.tile.block() == Blocks.groundFactory) {
                                Achievement.buildGroundFactory.complete();
                            }
                            if (!((patt7740$temp = e.tile.build) instanceof AttributeCrafter.AttributeCrafterBuild)) break block22;
                            AttributeCrafter.AttributeCrafterBuild a = (AttributeCrafter.AttributeCrafterBuild)patt7740$temp;
                            if (a.attrsum > 0.0f) break block23;
                        }
                        if (!((patt7810$temp = e.tile.build) instanceof SolidPump.SolidPumpBuild)) break block24;
                        SolidPump.SolidPumpBuild sp = (SolidPump.SolidPumpBuild)patt7810$temp;
                        if (!(sp.boost > 0.0f)) break block24;
                    }
                    Achievement.boostBuildingFloor.complete();
                }
                if (!Achievement.allTransportOneMap.isAchieved()) {
                    Block[] allTransports = Vars.state.rules.sector.planet == Planets.erekir ? this.allTransportErekir : this.allTransportSerpulo;
                    boolean all = true;
                    for (Block block : allTransports) {
                        if (Vars.state.rules.defaultTeam.data().getCount(block) != 0) continue;
                        all = false;
                        break;
                    }
                    if (all) {
                        Achievement.allTransportOneMap.complete();
                    }
                }
                if (e.tile.block() instanceof MendProjector || e.tile.block() instanceof RegenProjector) {
                    Achievement.buildMendProjector.complete();
                }
                if (e.tile.block() instanceof OverdriveProjector) {
                    Achievement.buildOverdriveProjector.complete();
                }
                if (e.tile.block() == Blocks.waterExtractor && e.tile.getLinkedTiles(this.tmpTiles).contains((Tile)((Object)((Boolf<Tile>)t -> t.floor().liquidDrop == Liquids.water)))) {
                    Achievement.buildWexWater.complete();
                }
                if (this.blocksBuilt.add(e.tile.block().name)) {
                    if (Vars.state.rules.sector.planet == Planets.erekir) {
                        this.checkAllBlocks(Achievement.allBlocksErekir, this.allErekirBlocks);
                    } else {
                        this.checkAllBlocks(Achievement.allBlocksSerpulo, this.allSerpuloBlocks);
                    }
                    if (this.blocksBuilt.contains("meltdown") && this.blocksBuilt.contains("spectre") && this.blocksBuilt.contains("foreshadow")) {
                        Achievement.buildMeltdownSpectre.complete();
                    }
                    this.save();
                }
                if (!Achievement.circleConveyor.isAchieved() && e.tile.block() instanceof Conveyor) {
                    this.checked.clear();
                    Tile current = e.tile;
                    for (int i = 0; i < 4; ++i) {
                        Tile next;
                        this.checked.add(current.pos());
                        if (current.build != null && (next = current.nearby(current.build.rotation)) != null && next.block() instanceof Conveyor) {
                            current = next;
                            continue;
                        }
                        break block21;
                    }
                    if (current == e.tile && this.checked.size == 4) {
                        Achievement.circleConveyor.complete();
                    }
                }
            }
            if (this.campaign() && e.unit != null && e.unit.isLocal() && e.breaking && e.tile.block().breakSound == Sounds.rockBreak) {
                SStat.bouldersDeconstructed.add();
            }
        });
        Events.on(EventType.TurnEvent.class, e -> {
            int total = 0;
            for (Planet planet : Vars.content.planets()) {
                for (Sector sector : planet.sectors) {
                    if (!sector.hasBase()) continue;
                    total += sector.items().total;
                }
            }
            SStat.totalCampaignItems.max(total);
        });
        Events.on(EventType.SectorLaunchLoadoutEvent.class, e -> {
            if (!Vars.schematics.isDefaultLoadout(e.loadout)) {
                Achievement.launchCoreSchematic.complete();
            }
        });
        Events.on(EventType.UnitCreateEvent.class, e -> {
            if (this.campaign()) {
                if (this.unitsBuilt.add(e.unit.type.name)) {
                    SStat.unitTypesBuilt.max(Vars.content.units().count(u -> this.unitsBuilt.contains(u.name) && !u.isHidden()));
                    this.save();
                }
                if (this.t5s.contains(e.unit.type)) {
                    Achievement.buildT5.complete();
                }
            }
        });
        Events.on(EventType.UnitControlEvent.class, e -> {
            Unit patt12095$temp;
            BlockUnitc unit;
            Unit patt11950$temp = e.unit;
            if (patt11950$temp instanceof BlockUnitc) {
                unit = (BlockUnitc)((Object)patt11950$temp);
                if (unit.tile().block == Blocks.router) {
                    Achievement.becomeRouter.complete();
                }
            }
            if ((patt12095$temp = e.unit) instanceof BlockUnitc && (unit = (BlockUnitc)((Object)patt12095$temp)).tile() instanceof Turret.TurretBuild) {
                Achievement.controlTurret.complete();
            }
        });
        Events.on(EventType.SchematicCreateEvent.class, e -> SStat.schematicsCreated.add());
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (this.campaign() && e.tile.team() != Vars.player.team()) {
                SStat.blocksDestroyed.add();
            }
        });
        Events.on(EventType.MapMakeEvent.class, e -> SStat.mapsMade.add());
        Events.on(EventType.MapPublishEvent.class, e -> SStat.mapsPublished.add());
        Events.on(EventType.UnlockEvent.class, e -> {
            if (e.content == Items.thorium) {
                Achievement.obtainThorium.complete();
            }
            if (e.content == Items.titanium) {
                Achievement.obtainTitanium.complete();
            }
        });
        Events.run((Object)EventType.Trigger.openWiki, Achievement.openWiki::complete);
        Events.run((Object)EventType.Trigger.importMod, Achievement.installMod::complete);
        Events.run((Object)EventType.Trigger.exclusionDeath, Achievement.dieExclusion::complete);
        Events.on(EventType.UnitDrownEvent.class, e -> {
            if (this.campaign() && e.unit.isPlayer()) {
                Achievement.drown.complete();
            }
        });
        this.trigger(EventType.Trigger.impactPower, Achievement.powerupImpactReactor);
        this.trigger(EventType.Trigger.flameAmmo, Achievement.useFlameAmmo);
        this.trigger(EventType.Trigger.turretCool, Achievement.coolTurret);
        this.trigger(EventType.Trigger.suicideBomb, Achievement.suicideBomb);
        this.trigger(EventType.Trigger.blastGenerator, Achievement.blastGenerator);
        this.trigger(EventType.Trigger.forceProjectorBreak, Achievement.breakForceProjector);
        this.trigger(EventType.Trigger.neoplasmReact, Achievement.neoplasmWater);
        this.trigger(EventType.Trigger.shockwaveTowerUse, Achievement.shockwaveTowerUse);
        Events.run((Object)EventType.Trigger.enablePixelation, Achievement.enablePixelation::complete);
        Events.run((Object)EventType.Trigger.thoriumReactorOverheat, () -> {
            if (this.campaign()) {
                SStat.reactorsOverheated.add();
            }
        });
        Events.on(EventType.GeneratorPressureExplodeEvent.class, e -> {
            if (this.campaign() && e.build.block == Blocks.neoplasiaReactor) {
                Achievement.neoplasiaExplosion.complete();
            }
        });
        this.trigger(EventType.Trigger.shock, Achievement.shockWetEnemy);
        this.trigger(EventType.Trigger.blastFreeze, Achievement.blastFrozenUnit);
        Events.on(EventType.UnitBulletDestroyEvent.class, e -> {
            if (Vars.state.isCampaign() && Vars.player != null && Vars.player.team() == e.bullet.team) {
                Entityc patt14560$temp;
                if (e.bullet.owner instanceof Wall.WallBuild) {
                    Achievement.killEnemyPhaseWall.complete();
                }
                if (e.unit.type == UnitTypes.eclipse && (patt14560$temp = e.bullet.owner) instanceof Turret.TurretBuild) {
                    Turret.TurretBuild turret = (Turret.TurretBuild)patt14560$temp;
                    if (turret.block == Blocks.duo) {
                        Achievement.killEclipseDuo.complete();
                    }
                }
            }
        });
        Events.on(EventType.LaunchItemEvent.class, e -> {
            if (this.campaign()) {
                Achievement.launchItemPad.complete();
            }
        });
        Events.on(EventType.PickupEvent.class, e -> {
            if (e.carrier.isPlayer() && this.campaign() && e.unit != null && this.t5s.contains(e.unit.type)) {
                Achievement.pickupT5.complete();
            }
        });
        Events.on(EventType.UnitCreateEvent.class, e -> {
            if (this.campaign() && e.unit.team() == Vars.player.team()) {
                SStat.unitsBuilt.add();
            }
        });
        Events.on(EventType.SectorLaunchEvent.class, e -> SStat.timesLaunched.add());
        Events.on(EventType.LaunchItemEvent.class, e -> SStat.itemsLaunched.add(e.stack.amount));
        Events.on(EventType.WaveEvent.class, e -> {
            if (this.campaign()) {
                SStat.maxWavesSurvived.max(Vars.state.wave);
                if (Vars.state.stats.buildingsBuilt == 0 && Vars.state.wave >= 10) {
                    Achievement.survive10WavesNoBlocks.complete();
                }
            }
        });
        Events.on(EventType.PlayerJoin.class, e -> {
            if (Vars.net.server()) {
                SStat.maxPlayersServer.max(Groups.player.size());
            }
        });
        Runnable checkUnlocks = () -> {
            if (Blocks.router.unlocked()) {
                Achievement.researchRouter.complete();
            }
            if (!TechTree.all.contains((TechTree.TechNode)((Object)((Boolf<TechTree.TechNode>)t -> t.content.locked())))) {
                Achievement.researchAll.complete();
            }
            if (Blocks.microProcessor.unlocked()) {
                Achievement.researchLogic.complete();
            }
        };
        Events.on(EventType.ResearchEvent.class, e -> checkUnlocks.run());
        Events.on(EventType.UnlockEvent.class, e -> checkUnlocks.run());
        Events.on(EventType.ClientLoadEvent.class, e -> checkUnlocks.run());
        Events.on(EventType.WinEvent.class, e -> {
            if (Vars.state.rules.pvp) {
                SStat.pvpsWon.add();
            }
        });
        Events.on(EventType.ClientPreConnectEvent.class, e -> {
            if (e.host != null && !e.host.address.startsWith("steam:") && !e.host.address.startsWith("192.")) {
                Achievement.joinCommunityServer.complete();
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (e.sector.isBeingPlayed() || Vars.net.client()) {
                if (Vars.state.wave <= 5 && Vars.state.rules.attackMode) {
                    Achievement.defeatAttack5Waves.complete();
                }
                if (Vars.state.stats.buildingsDestroyed == 0) {
                    Achievement.captureNoBlocksBroken.complete();
                }
            }
            if (Vars.state.rules.attackMode) {
                SStat.attacksWon.add();
            }
            if (!e.sector.isBeingPlayed() && !Vars.net.client()) {
                Achievement.captureBackground.complete();
            }
            if (e.sector.planet == Planets.serpulo && !e.sector.planet.sectors.contains((Sector)((Object)((Boolf<Sector>)s -> !s.hasBase())))) {
                Achievement.captureAllSectors.complete();
            }
            if (e.sector.planet == Planets.erekir && e.sector.preset != null && e.sector.preset.isLastSector) {
                Achievement.completeErekir.complete();
            }
            if (e.sector.planet == Planets.serpulo && e.sector.preset != null && e.sector.preset.isLastSector) {
                Achievement.completeSerpulo.complete();
            }
            if (e.sector.planet == Planets.serpulo) {
                SStat.sectorsControlled.set(e.sector.planet.sectors.count(Sector::hasBase));
            }
        });
        Events.on(EventType.PayloadDropEvent.class, e -> {
            if (this.campaign() && e.unit != null && e.carrier.team == Vars.state.rules.defaultTeam && Vars.state.rules.waveTeam.cores().contains((CoreBlock.CoreBuild)((Object)((Boolf<CoreBlock.CoreBuild>)c -> c.within(e.unit, Vars.state.rules.enemyCoreBuildRadius))))) {
                Achievement.dropUnitsCoreZone.complete();
            }
        });
        Events.on(EventType.ClientChatEvent.class, e -> {
            if (e.message.contains("\uf6aa")) {
                Achievement.useAnimdustryEmoji.complete();
            }
        });
    }

    private void checkUpdate() {
        if (this.campaign()) {
            SStat.maxUnitActive.max(Groups.unit.count(t -> t.team == Vars.player.team()));
            if (Groups.unit.count(u -> u.type == UnitTypes.poly && u.team == Vars.player.team()) >= 10) {
                Achievement.active10Polys.complete();
            }
            for (Building building : Vars.player.team().cores()) {
                if (Vars.content.items().contains((Item)((Object)((Boolf<Item>)i -> !Vars.state.rules.hiddenBuildItems.contains((Item)i) && entity.items.get((Item)i) < entity.block.itemCapacity)))) continue;
                Achievement.fillCoreAllCampaign.complete();
                break;
            }
            for (PowerGraphUpdaterc powerGraphUpdaterc : Groups.powerGraph) {
                PowerGraph graph = powerGraphUpdaterc.graph();
                if (graph.all.size <= 1 || graph.all.first().team != Vars.player.team() || !graph.hasPowerBalanceSamples()) continue;
                float balance = graph.getPowerBalance() * 60.0f;
                if (balance < -10000.0f) {
                    Achievement.negative10kPower.complete();
                }
                if (balance > 100000.0f) {
                    Achievement.positive100kPower.complete();
                }
                if (!(graph.getBatteryStored() > 1000000.0f)) continue;
                Achievement.store1milPower.complete();
            }
        }
    }

    private void save() {
        Core.settings.putJson("units-built", String.class, this.unitsBuilt);
        Core.settings.putJson("blocks-built", String.class, this.blocksBuilt);
    }

    private void trigger(EventType.Trigger trigger, Achievement ach) {
        Events.run((Object)trigger, () -> {
            if (this.campaign()) {
                ach.complete();
            }
        });
    }

    private boolean campaign() {
        return Vars.state.isCampaign();
    }
}

