/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weapons;

import arc.graphics.g2d.Draw;
import arc.math.Angles;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Unit;
import mindustry.type.Weapon;

public class BuildWeapon
extends Weapon {
    public BuildWeapon() {
        this.rotate = true;
        this.noAttack = true;
        this.predictTarget = false;
        this.display = false;
        this.bullet = new BulletType();
        this.useAttackRange = false;
    }

    public BuildWeapon(String name) {
        super(name);
        this.rotate = true;
        this.noAttack = true;
        this.predictTarget = false;
        this.display = false;
        this.bullet = new BulletType();
        this.useAttackRange = false;
    }

    @Override
    public void update(Unit unit, WeaponMount mount) {
        mount.shoot = false;
        mount.rotate = true;
        if (unit.activelyBuilding()) {
            mount.aimX = unit.buildPlan().drawx();
            mount.aimY = unit.buildPlan().drawy();
        } else {
            float weaponRotation = unit.rotation - 90.0f;
            mount.aimX = unit.x + Angles.trnsx(unit.rotation - 90.0f, this.x, this.y) + Angles.trnsx(weaponRotation, this.shootX, this.shootY);
            mount.aimY = unit.y + Angles.trnsy(unit.rotation - 90.0f, this.x, this.y) + Angles.trnsy(weaponRotation, this.shootX, this.shootY);
        }
        super.update(unit, mount);
    }

    @Override
    public void draw(Unit unit, WeaponMount mount) {
        super.draw(unit, mount);
        if (unit.activelyBuilding()) {
            float z = Draw.z();
            float rotation = unit.rotation - 90.0f;
            float weaponRotation = rotation + (this.rotate ? mount.rotation : 0.0f);
            float wx = unit.x + Angles.trnsx(rotation, this.x, this.y) + Angles.trnsx(weaponRotation, 0.0f, -mount.recoil);
            float wy = unit.y + Angles.trnsy(rotation, this.x, this.y) + Angles.trnsy(weaponRotation, 0.0f, -mount.recoil);
            float px = wx + Angles.trnsx(weaponRotation, this.shootX, this.shootY);
            float py = wy + Angles.trnsy(weaponRotation, this.shootX, this.shootY);
            unit.drawBuildingBeam(px, py);
            Draw.z(z);
        }
    }
}

