/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.scene.Element;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.net.Administration;
import mindustry.ui.dialogs.BaseDialog;

public class AdminsDialog
extends BaseDialog {
    public AdminsDialog() {
        super("@server.admins");
        this.addCloseButton();
        this.setup();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        float w = 400.0f;
        float h = 80.0f;
        Table table = new Table();
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        if (Vars.netServer.admins.getAdmins().size == 0) {
            table.add("@server.admins.none");
        }
        for (Administration.PlayerInfo info : Vars.netServer.admins.getAdmins()) {
            Table res = new Table(Tex.button);
            res.margin(14.0f);
            res.labelWrap("[lightgray]" + info.lastName).width(w - h - 24.0f);
            res.add().growX();
            res.button(Icon.cancel, () -> Vars.ui.showConfirm("@confirm", "@confirmunadmin", () -> {
                Vars.netServer.admins.unAdminPlayer(info.id);
                Groups.player.each(player -> {
                    if (player != null && !player.isLocal() && player.uuid().equals(info.id)) {
                        player.admin(false);
                    }
                });
                this.setup();
            })).size(h).pad(-14.0f);
            table.add(res).width(w).height(h);
            table.row();
        }
        this.cont.add(pane);
    }
}

