/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.KeyBinds;
import arc.assets.loaders.TextureLoader;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.scene.Element;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.core.UI;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Objectives;
import mindustry.game.Schematic;
import mindustry.game.SectorInfo;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.input.Binding;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LaunchLoadoutDialog;
import mindustry.world.Block;
import mindustry.world.blocks.storage.CoreBlock;

public class PlanetDialog
extends BaseDialog
implements PlanetRenderer.PlanetInterfaceRenderer {
    static final String[] defaultIcons = new String[]{"effect", "power", "logic", "units", "liquid", "production", "defense", "turret", "distribution", "crafting", "settings", "cancel", "zoom", "ok", "star", "home", "pencil", "up", "down", "left", "right", "hammer", "warning", "tree", "admin", "map", "modePvp", "terrain", "modeSurvival", "commandRally", "commandAttack"};
    public static boolean debugSelect = false;
    public static float sectorShowDuration = 144.0f;
    public final FrameBuffer buffer = new FrameBuffer(2, 2, true);
    public final LaunchLoadoutDialog loadouts = new LaunchLoadoutDialog();
    public final PlanetRenderer planets;
    public PlanetParams state;
    public float zoom;
    @Nullable
    public Sector selected;
    @Nullable
    public Sector hovered;
    @Nullable
    public Sector launchSector;
    public Mode mode;
    public boolean launching;
    public Cons<Sector> listener;
    public Seq<Sector> newPresets;
    public float presetShow;
    public boolean showed;
    public boolean sectorsShown;
    public String searchText;
    public Table sectorTop;
    public Table notifs;
    public Table expandTable;
    public Label hoverLabel;
    private Texture[] planetTextures;

    public PlanetDialog() {
        super("", Styles.fullDialog);
        this.planets = Vars.renderer.planets;
        this.state = new PlanetParams();
        this.zoom = 1.0f;
        this.mode = Mode.look;
        this.listener = s -> {};
        this.newPresets = new Seq();
        this.presetShow = 0.0f;
        this.showed = false;
        this.searchText = "";
        this.sectorTop = new Table();
        this.notifs = new Table();
        this.expandTable = new Table();
        this.hoverLabel = new Label("");
        this.state.renderer = this;
        this.state.drawUi = true;
        this.shouldPause = true;
        this.state.planet = (Planet)Vars.content.getByName(ContentType.planet, Core.settings.getString("lastplanet", "serpulo"));
        if (this.state.planet == null) {
            this.state.planet = Planets.serpulo;
        }
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, KeyCode key) {
                if (event.targetActor == PlanetDialog.this && (key == KeyCode.escape || key == KeyCode.back || key == Core.keybinds.get((KeyBinds.KeyBind)Binding.planet_map).key)) {
                    if (PlanetDialog.this.showing() && PlanetDialog.this.newPresets.size > 1) {
                        PlanetDialog.this.newPresets.truncate(1);
                    } else if (PlanetDialog.this.selected != null) {
                        PlanetDialog.this.selectSector(null);
                    } else {
                        Core.app.post(() -> PlanetDialog.this.hide());
                    }
                    return true;
                }
                return false;
            }
        });
        this.hoverLabel.setStyle(Styles.outlineLabel);
        this.hoverLabel.setAlignment(1);
        this.rebuildButtons();
        this.onResize(this::rebuildButtons);
        this.dragged((cx, cy) -> {
            if (Core.input.getTouches() > 1) {
                return;
            }
            if (this.showing()) {
                this.newPresets.clear();
            }
            Vec3 pos = this.state.camPos;
            float upV = pos.angle(Vec3.Y);
            float xscale = 9.0f;
            float yscale = 10.0f;
            float margin = 1.0f;
            float speed = 1.0f - Math.abs(upV - 90.0f) / 90.0f;
            pos.rotate(this.state.camUp, cx / xscale * speed);
            float amount = cy / yscale;
            amount = Mathf.clamp(upV + amount, margin, 180.0f - margin) - upV;
            pos.rotate(Tmp.v31.set(this.state.camUp).rotate(this.state.camDir, 90.0f), amount);
        });
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                if (event.targetActor == PlanetDialog.this) {
                    PlanetDialog.this.zoom = Mathf.clamp(PlanetDialog.this.zoom + amountY / 10.0f, PlanetDialog.this.state.planet.minZoom, 2.0f);
                }
                return true;
            }
        });
        this.addCaptureListener(new ElementGestureListener(){
            float lastZoom = -1.0f;

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (this.lastZoom < 0.0f) {
                    this.lastZoom = PlanetDialog.this.zoom;
                }
                PlanetDialog.this.zoom = Mathf.clamp(initialDistance / distance * this.lastZoom, PlanetDialog.this.state.planet.minZoom, 2.0f);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                this.lastZoom = PlanetDialog.this.zoom;
            }
        });
        this.shown(this::setup);
        this.shown(() -> {
            if (!Core.settings.getBool("campaignselect") && !Vars.content.planets().contains((Planet)((Object)((Boolf<Planet>)p -> p.sectors.contains((Sector)((Object)((Boolf<Sector>)s -> s.hasBase()))))))) {
                BaseDialog diag = new BaseDialog("@campaign.select");
                Planet[] selected = new Planet[]{null};
                ButtonGroup group = new ButtonGroup();
                group.setMinCheckCount(0);
                this.state.planet = Planets.sun;
                Planet[] choices = new Planet[]{Planets.serpulo, Planets.erekir};
                int i = 0;
                for (Planet planet : choices) {
                    TextureRegion tex = new TextureRegion(this.planetTextures[i]);
                    diag.cont.button((Button b) -> {
                        b.top();
                        b.add(planet.localizedName).color(Pal.accent).style(Styles.outlineLabel);
                        b.row();
                        b.image(new TextureRegionDrawable(tex)).grow().scaling(Scaling.fit);
                    }, (Button.ButtonStyle)Styles.togglet, () -> {
                        selected[0] = planet;
                    }).size(Vars.mobile ? 220.0f : 320.0f).group(group);
                    ++i;
                }
                diag.cont.row();
                diag.cont.label(() -> selected[0] == null ? "@campaign.none" : "@campaign." + selected[0].name).labelAlign(1).style(Styles.outlineLabel).width(440.0f).wrap().colspan(2);
                diag.buttons.button("@ok", Icon.ok, () -> {
                    this.state.planet = selected[0];
                    this.lookAt(this.state.planet.getStartSector());
                    this.selectSector(this.state.planet.getStartSector());
                    Core.settings.put("campaignselect", true);
                    diag.hide();
                }).size(300.0f, 64.0f).disabled(b -> selected[0] == null);
                Core.app.post(diag::show);
            }
        });
        this.planetTextures = new Texture[2];
        String[] names = new String[]{"sprites/planets/serpulo.png", "sprites/planets/erekir.png"};
        for (int i = 0; i < names.length; ++i) {
            int fi = i;
            Core.assets.load((String)names[i], Texture.class, new TextureLoader.TextureParameter(){
                {
                    this.minFilter = this.magFilter = Texture.TextureFilter.linear;
                }
            }).loaded = t -> {
                this.planetTextures[fi] = t;
            };
            Core.assets.finishLoadingAsset(names[i]);
        }
        if (Vars.content.planets().contains((Planet)((Object)((Boolf<Planet>)p -> p.sectors.contains((Sector)((Object)((Boolf<Sector>)s -> s.hasBase())))))) || Blocks.scatter.unlocked() || Blocks.router.unlocked()) {
            Seq.with(Blocks.junction, Blocks.mechanicalDrill, Blocks.conveyor, Blocks.duo, Items.copper, Items.lead).each(rec$ -> ((UnlockableContent)rec$).quietUnlock());
        }
    }

    @Override
    public Dialog show() {
        if (Vars.net.client()) {
            Vars.ui.showInfo("@map.multiplayer");
            return this;
        }
        if (Vars.state.rules.sector != null) {
            this.state.planet = Vars.state.rules.sector.planet;
            Core.settings.put("lastplanet", this.state.planet.name);
        }
        if (!this.selectable(this.state.planet)) {
            this.state.planet = Planets.serpulo;
        }
        this.rebuildButtons();
        this.mode = Mode.look;
        this.state.otherCamPos = null;
        this.launchSector = null;
        this.hovered = null;
        this.selected = null;
        this.launching = false;
        this.zoom = 1.0f;
        this.state.zoom = 1.0f;
        this.state.uiAlpha = 0.0f;
        this.launchSector = Vars.state.getSector();
        this.presetShow = 0.0f;
        this.showed = false;
        this.listener = s -> {};
        this.newPresets.clear();
        for (SectorPreset preset : Vars.content.sectors()) {
            if (!preset.unlocked() || preset.alwaysUnlocked || preset.sector.info.shown || preset.sector.hasBase() || preset.planet != this.state.planet) continue;
            this.newPresets.add(preset.sector);
            preset.sector.info.shown = true;
            preset.sector.saveInfo();
        }
        if (this.newPresets.any()) {
            this.newPresets.add(this.state.planet.getLastSector());
        }
        this.newPresets.reverse();
        this.updateSelected();
        if (this.state.planet.getLastSector() != null) {
            this.lookAt(this.state.planet.getLastSector());
        }
        return super.show();
    }

    void rebuildButtons() {
        this.buttons.clearChildren();
        this.buttons.bottom();
        if (Core.graphics.isPortrait()) {
            this.buttons.add(this.sectorTop).colspan(2).fillX().row();
            this.addBack();
            this.addTech();
        } else {
            this.addBack();
            this.buttons.add().growX();
            this.buttons.add(this.sectorTop).minWidth(230.0f);
            this.buttons.add().growX();
            this.addTech();
        }
    }

    void addBack() {
        this.buttons.button("@back", Icon.left, this::hide).size(200.0f, 54.0f).pad(2.0f).bottom();
    }

    void addTech() {
        this.buttons.button("@techtree", Icon.tree, () -> Vars.ui.research.show()).size(200.0f, 54.0f).pad(2.0f).bottom();
    }

    public void showOverview() {
        BaseDialog dialog = new BaseDialog("@overview");
        dialog.addCloseButton();
        dialog.add("@sectors.captured");
    }

    public void showPlanetLaunch(Sector sector, Cons<Sector> listener) {
        this.selected = null;
        this.hovered = null;
        this.launching = false;
        this.listener = listener;
        this.launchSector = sector;
        if (sector.planet.launchCandidates.size == 1) {
            this.state.planet = sector.planet.launchCandidates.first();
            this.state.otherCamPos = sector.planet.position;
            this.state.otherCamAlpha = 0.0f;
            Sector destSec = this.state.planet.sectors.get(this.state.planet.startSector);
            SectorPreset preset = destSec.preset;
            if (preset != null) {
                preset.unlock();
            }
            this.selected = destSec;
            this.updateSelected();
            this.rebuildExpand();
        }
        this.zoom = 1.0f;
        this.state.zoom = 1.0f;
        this.state.uiAlpha = 0.0f;
        this.mode = Mode.planetLaunch;
        super.show();
    }

    public void showSelect(Sector sector, Cons<Sector> listener) {
        this.selected = null;
        this.hovered = null;
        this.launching = false;
        this.listener = listener;
        this.lookAt(sector);
        this.zoom = 1.0f;
        this.state.zoom = 1.0f;
        this.state.uiAlpha = 0.0f;
        this.state.otherCamPos = null;
        this.launchSector = sector;
        this.mode = Mode.select;
        super.show();
    }

    void lookAt(Sector sector) {
        if (sector.tile == PlanetGrid.Ptile.empty) {
            return;
        }
        this.state.planet = sector.planet;
        this.state.camPos.set(Tmp.v33.set(sector.tile.v).rotate(Vec3.Y, -sector.planet.getRotation()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canSelect(Sector sector) {
        if (this.mode == Mode.select) {
            if (!sector.hasBase()) return false;
            if (this.launchSector == null) return false;
            if (sector.planet != this.launchSector.planet) return false;
            return true;
        }
        if (this.mode == Mode.planetLaunch) {
            if (sector.id != sector.planet.startSector) return false;
            return true;
        }
        if (sector.hasBase()) return true;
        if (sector.id == sector.planet.startSector) {
            return true;
        }
        if (sector.preset != null) {
            TechTree.TechNode node = sector.preset.techNode;
            if (node == null) return true;
            if (node.parent == null) return true;
            if (!node.parent.content.unlocked()) return false;
            UnlockableContent unlockableContent = node.parent.content;
            if (!(unlockableContent instanceof SectorPreset)) return true;
            SectorPreset preset = (SectorPreset)unlockableContent;
            if (!preset.sector.hasBase()) return false;
            return true;
        }
        if (sector.planet.generator == null) {
            if (sector.hasBase()) return true;
            if (!sector.near().contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase)))) return false;
            return true;
        }
        boolean bl = sector.planet.generator.allowLanding(sector);
        return bl;
    }

    Sector findLauncher(Sector to) {
        Sector launchSector;
        Sector sector = launchSector = this.launchSector != null && this.launchSector.planet == to.planet && this.launchSector.hasBase() ? this.launchSector : null;
        if (to.near().contains(launchSector)) {
            return launchSector;
        }
        Sector launchFrom = launchSector;
        if ((launchFrom == null || to.preset == null && !to.near().contains(launchSector)) && (launchFrom = to.near().find(Sector::hasBase)) == null && to.preset != null) {
            if (launchSector != null) {
                return launchSector;
            }
            launchFrom = this.state.planet.sectors.min(s -> !s.hasBase() ? Float.MAX_VALUE : s.tile.v.dst2(to.tile.v));
            if (!launchFrom.hasBase()) {
                launchFrom = null;
            }
        }
        return launchFrom;
    }

    boolean showing() {
        return this.newPresets.any();
    }

    @Override
    public void renderSectors(Planet planet) {
        Sector launchFrom;
        Sector current;
        if (this.state.uiAlpha > 0.01f) {
            for (Sector sec : planet.sectors) {
                if (this.canSelect(sec) || sec.unlocked() || debugSelect) {
                    Color color = sec.hasBase() ? Tmp.c2.set(Team.sharded.color).lerp(Team.crux.color, sec.hasEnemyBase() ? 0.5f : 0.0f) : (sec.preset != null ? (sec.preset.unlocked() ? Tmp.c2.set(Team.derelict.color).lerp(Color.white, Mathf.absin(Time.time, 10.0f, 1.0f)) : Color.gray) : (sec.hasEnemyBase() ? Team.crux.color : null));
                    if (color == null) continue;
                    this.planets.drawSelection(sec, Tmp.c1.set(color).mul(0.8f).a(this.state.uiAlpha), 0.026f, -0.001f);
                    continue;
                }
                this.planets.fill(sec, Tmp.c1.set(PlanetRenderer.shadowColor).mul(1.0f, 1.0f, 1.0f, this.state.uiAlpha), -0.001f);
            }
        }
        Sector sector = current = Vars.state.getSector() != null && Vars.state.getSector().isBeingPlayed() && Vars.state.getSector().planet == this.state.planet ? Vars.state.getSector() : null;
        if (current != null) {
            this.planets.fill(current, PlanetRenderer.hoverColor.write(Tmp.c1).mulA(this.state.uiAlpha), -0.001f);
        }
        if (this.hovered != null) {
            this.planets.fill(this.hovered, PlanetRenderer.hoverColor.write(Tmp.c1).mulA(this.state.uiAlpha), -0.001f);
            this.planets.drawBorders(this.hovered, PlanetRenderer.borderColor, this.state.uiAlpha);
        }
        if (this.selected != null) {
            this.planets.drawSelection(this.selected, this.state.uiAlpha);
            this.planets.drawBorders(this.selected, PlanetRenderer.borderColor, this.state.uiAlpha);
        }
        this.planets.batch.flush(4);
        if (this.hovered != null && !this.hovered.hasBase() && (launchFrom = this.findLauncher(this.hovered)) != null && this.hovered != launchFrom && this.canSelect(this.hovered)) {
            this.planets.drawArc(planet, launchFrom.tile.v, this.hovered.tile.v);
        }
        if (this.state.uiAlpha > 0.001f) {
            for (Sector sec : planet.sectors) {
                if (!sec.hasBase()) continue;
                if (planet.allowSectorInvasion) {
                    for (Sector enemy : sec.near()) {
                        if (!enemy.hasEnemyBase()) continue;
                        this.planets.drawArc(planet, enemy.tile.v, sec.tile.v, Team.crux.color.write(Tmp.c2).a(this.state.uiAlpha), Color.clear, 0.24f, 110.0f, 25);
                    }
                }
                if (this.selected == null || this.selected == sec || !this.selected.hasBase()) continue;
                if (sec.info.getRealDestination() == this.selected && sec.info.anyExports()) {
                    this.planets.drawArc(planet, sec.tile.v, this.selected.tile.v, Color.gray.write(Tmp.c2).a(this.state.uiAlpha), Pal.accent.write(Tmp.c3).a(this.state.uiAlpha), 0.4f, 90.0f, 25);
                }
                if (this.selected.info.getRealDestination() != sec || !this.selected.info.anyExports()) continue;
                this.planets.drawArc(planet, this.selected.tile.v, sec.tile.v, Pal.place.write(Tmp.c2).a(this.state.uiAlpha), Pal.accent.write(Tmp.c3).a(this.state.uiAlpha), 0.4f, 90.0f, 25);
            }
        }
    }

    @Override
    public void renderProjections(Planet planet) {
        float iw = 12.0f;
        for (Sector sec : planet.sectors) {
            Color color;
            if (sec == this.hovered) continue;
            TextureRegion preficon = sec.icon();
            TextureRegion icon = sec.isAttacked() ? Fonts.getLargeIcon("warning") : (!sec.hasBase() && sec.preset != null && sec.preset.unlocked() && preficon == null ? Fonts.getLargeIcon("terrain") : (sec.preset != null && sec.preset.locked() && sec.preset.techNode != null && !sec.preset.techNode.parent.content.locked() ? Fonts.getLargeIcon("lock") : preficon));
            Color color2 = color = sec.preset != null && !sec.hasBase() ? Team.derelict.color : Team.sharded.color;
            if (icon == null) continue;
            this.planets.drawPlane(sec, () -> {
                Draw.color(preficon == icon && sec.info.contentIcon != null ? Color.white : color, this.state.uiAlpha);
                Draw.rect(icon, 0.0f, 0.0f, iw, iw * (float)icon.height / (float)icon.width);
            });
        }
        Draw.reset();
        if (this.hovered != null && this.state.uiAlpha > 0.01f) {
            this.planets.drawPlane(this.hovered, () -> {
                TextureRegion icon;
                Draw.color(this.hovered.isAttacked() ? Pal.remove : Color.white, Pal.accent, Mathf.absin(5.0f, 1.0f));
                Draw.alpha(this.state.uiAlpha);
                TextureRegion textureRegion = this.hovered.locked() && !this.canSelect(this.hovered) ? Fonts.getLargeIcon("lock") : (icon = this.hovered.isAttacked() ? Fonts.getLargeIcon("warning") : this.hovered.icon());
                if (icon != null) {
                    Draw.rect(icon, 0.0f, 0.0f, iw, iw * (float)icon.height / (float)icon.width);
                }
                Draw.reset();
            });
        }
        Draw.reset();
    }

    boolean selectable(Planet planet) {
        if (this.mode == Mode.select) {
            return planet == this.state.planet;
        }
        if (this.mode == Mode.planetLaunch) {
            return this.launchSector != null && planet != this.launchSector.planet && this.launchSector.planet.launchCandidates.contains(planet);
        }
        return planet.alwaysUnlocked && planet.isLandable() || planet.sectors.contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase))) || debugSelect;
    }

    void setup() {
        this.searchText = "";
        this.state.zoom = 1.0f;
        this.zoom = 1.0f;
        this.state.uiAlpha = 1.0f;
        Vars.ui.minimapfrag.hide();
        this.clearChildren();
        this.margin(0.0f);
        this.stack(new Element(){
            {
                this.addListener(new ElementGestureListener(){

                    @Override
                    public void tap(InputEvent event, float x, float y, int count, KeyCode button) {
                        if (PlanetDialog.this.showing()) {
                            return;
                        }
                        if (PlanetDialog.this.hovered != null && PlanetDialog.this.selected == PlanetDialog.this.hovered && count == 2) {
                            PlanetDialog.this.playSelected();
                        }
                        if (PlanetDialog.this.hovered != null && (PlanetDialog.this.canSelect(PlanetDialog.this.hovered) || debugSelect)) {
                            PlanetDialog.this.selected = PlanetDialog.this.hovered;
                        }
                        if (PlanetDialog.this.selected != null) {
                            PlanetDialog.this.updateSelected();
                        }
                    }
                });
            }

            @Override
            public void act(float delta) {
                if (Core.scene.getDialog() == PlanetDialog.this && !Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true).isDescendantOf((Element e) -> e instanceof ScrollPane)) {
                    Core.scene.setScrollFocus(PlanetDialog.this);
                }
                super.act(delta);
            }

            @Override
            public void draw() {
                PlanetDialog.this.planets.render(PlanetDialog.this.state);
            }
        }, new Table(t -> {
            t.touchable = Touchable.disabled;
            t.top();
            t.label(() -> this.mode == Mode.select ? "@sectors.select" : "").style(Styles.outlineLabel).color(Pal.accent);
        }), this.buttons, new Table(t -> {
            t.top().left();
            ScrollPane pane = new ScrollPane(null, Styles.smallPane);
            t.add(pane).colspan(2).row();
            Table starsTable = new Table(Styles.black);
            pane.setWidget(starsTable);
            pane.setScrollingDisabled(true, false);
            int starCount = 0;
            for (Planet star : Vars.content.planets()) {
                if (star.solarSystem != star || !Vars.content.planets().contains((Planet)((Object)((Boolf<Planet>)p -> p.solarSystem == star && this.selectable((Planet)p))))) continue;
                if (++starCount > 1) {
                    starsTable.add(star.localizedName).padLeft(10.0f).padBottom(10.0f).padTop(10.0f).left().width(190.0f).row();
                }
                Table planetTable = new Table();
                planetTable.margin(4.0f);
                starsTable.add(planetTable).left().row();
                for (Planet planet : Vars.content.planets()) {
                    if (planet.solarSystem != star || !this.selectable(planet)) continue;
                    Button planetButton = planetTable.button(planet.localizedName, (Drawable)Icon.icons.get(planet.icon + "Small", Icon.icons.get(planet.icon, Icon.commandRallySmall)), Styles.flatTogglet, () -> {
                        this.selected = null;
                        this.launchSector = null;
                        if (this.state.planet != planet) {
                            this.newPresets.clear();
                            this.state.planet = planet;
                            this.rebuildExpand();
                        }
                        Core.settings.put("lastplanet", planet.name);
                    }).width(200.0f).height(40.0f).update((T bb) -> bb.setChecked(this.state.planet == planet)).with(w -> w.marginLeft(10.0f)).get();
                    ((Element)planetButton.getChildren().get(1)).setColor(planet.iconColor);
                    planetButton.setColor(planet.iconColor);
                    planetTable.background(Tex.pane).row();
                }
            }
        }).visible(() -> this.mode != Mode.select), new Table(c -> {
            this.expandTable = c;
        })).grow();
        this.rebuildExpand();
    }

    void rebuildExpand() {
        Table c = this.expandTable;
        c.clear();
        c.visible(() -> !Core.graphics.isPortrait() || !Vars.mobile);
        if (this.state.planet.sectors.contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase)))) {
            int attacked = this.state.planet.sectors.count(Sector::isAttacked);
            c.top().right();
            c.defaults().width(290.0f);
            c.button(Core.bundle.get("sectorlist") + (attacked == 0 ? "" : "\n[red]\u26a0[lightgray] " + Core.bundle.format("sectorlist.attacked", "[red]" + attacked + "[]")), (Drawable)Icon.downOpen, Styles.squareTogglet, () -> {
                this.sectorsShown = !this.sectorsShown;
            }).height(60.0f).checked(b -> {
                Image image = (Image)b.getCells().first().get();
                image.setDrawable(this.sectorsShown ? Icon.upOpen : Icon.downOpen);
                return this.sectorsShown;
            }).with(t -> t.left().margin(7.0f)).with(t -> t.getLabelCell().grow().left()).row();
            c.collapser((Table t) -> {
                t.background(Styles.black8);
                this.notifs = t;
                this.rebuildList();
            }, false, () -> this.sectorsShown).padBottom(64.0f).row();
        }
    }

    void rebuildList() {
        if (this.notifs == null) {
            return;
        }
        this.notifs.clear();
        Seq<Sector> all = this.state.planet.sectors.select(Sector::hasBase);
        all.sort(Structs.comps(Structs.comparingBool(s -> !s.isAttacked()), Structs.comparingInt(s -> s.save == null ? 0 : -((int)s.save.meta.timePlayed))));
        this.notifs.pane((Table p) -> {
            Runnable[] readd = new Runnable[]{null};
            p.table((Table s) -> {
                s.image(Icon.zoom).padRight(4.0f);
                s.field(this.searchText, t -> {
                    this.searchText = t;
                    readd[0].run();
                }).growX().height(50.0f);
            }).growX().row();
            Table con = p.table().growX().get();
            con.touchable = Touchable.enabled;
            readd[0] = () -> {
                con.clearChildren();
                for (Sector sec : all) {
                    if (!sec.hasBase() || !this.searchText.isEmpty() && !sec.name().toLowerCase().contains(this.searchText.toLowerCase())) continue;
                    con.button((Button t) -> {
                        t.marginRight(10.0f);
                        t.left();
                        t.defaults().growX();
                        t.table((Table head) -> {
                            head.left().defaults();
                            if (sec.isAttacked()) {
                                head.image(Icon.warningSmall).update((T i) -> i.color.set(Pal.accent).lerp(Pal.remove, Mathf.absin(Time.globalTime, 9.0f, 1.0f))).padRight(4.0f);
                            }
                            String ic = sec.iconChar() == null ? "" : sec.iconChar() + " ";
                            head.add(ic + sec.name()).growX().wrap();
                        }).growX().row();
                        if (sec.isAttacked()) {
                            this.addSurvivedInfo(sec, (Table)t, true);
                        }
                    }, Styles.underlineb, () -> {
                        this.lookAt(sec);
                        this.selected = sec;
                        this.updateSelected();
                    }).margin(8.0f).marginLeft(13.0f).marginBottom(6.0f).marginTop(6.0f).padBottom(3.0f).padTop(3.0f).growX().checked(b -> this.selected == sec).row();
                }
                if (con.getChildren().isEmpty()) {
                    con.add("@none.found").pad(10.0f);
                }
            };
            readd[0].run();
        }).grow().scrollX(false);
    }

    @Override
    public void draw() {
        boolean doBuffer;
        boolean bl = doBuffer = this.color.a < 0.99f;
        if (doBuffer) {
            this.buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            this.buffer.begin(Color.clear);
        }
        super.draw();
        if (doBuffer) {
            this.buffer.end();
            Draw.color(this.color);
            Draw.rect(Draw.wrap((Texture)this.buffer.getTexture()), this.width / 2.0f, this.height / 2.0f, this.width, -this.height);
            Draw.color();
        }
    }

    public void lookAt(Sector sector, float alpha) {
        float len = this.state.camPos.len();
        this.state.camPos.slerp(Tmp.v31.set(sector.tile.v).rotate(Vec3.Y, -sector.planet.getRotation()).setLength(len), alpha);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.state.otherCamPos != null) {
            this.state.otherCamAlpha = Mathf.lerpDelta(this.state.otherCamAlpha, 1.0f, 0.05f);
            this.state.camPos.set(0.0f, 4.0f, 0.1f);
            if (Mathf.equal(this.state.otherCamAlpha, 1.0f, 0.01f)) {
                this.state.camPos.set(Tmp.v31.set(this.state.otherCamPos).lerp(this.state.planet.position, this.state.otherCamAlpha).add(this.state.camPos).sub(this.state.planet.position));
                this.state.otherCamPos = null;
                this.newPresets.add(this.state.planet.sectors.get(this.state.planet.startSector));
            }
        }
        if (this.hovered != null && !Vars.mobile && this.state.planet.hasGrid()) {
            this.addChild(this.hoverLabel);
            this.hoverLabel.toFront();
            this.hoverLabel.touchable = Touchable.disabled;
            this.hoverLabel.color.a = this.state.uiAlpha;
            Vec3 pos = this.planets.cam.project(Tmp.v31.set(this.hovered.tile.v).setLength(1.17f * this.state.planet.radius).rotate(Vec3.Y, -this.state.planet.getRotation()).add(this.state.planet.position));
            this.hoverLabel.setPosition(pos.x - Core.scene.marginLeft, pos.y - Core.scene.marginBottom, 1);
            this.hoverLabel.getText().setLength(0);
            if (this.hovered != null) {
                StringBuilder tx = this.hoverLabel.getText();
                if (!this.canSelect(this.hovered)) {
                    if (this.mode == Mode.planetLaunch) {
                        tx.append("[gray]").append('\ue815');
                    } else {
                        tx.append("[gray]").append('\ue88d').append(" ").append(Core.bundle.get("locked"));
                    }
                } else {
                    tx.append("[accent][[ [white]").append(this.hovered.name()).append("[accent] ]");
                }
            }
            this.hoverLabel.invalidateHierarchy();
        } else {
            this.hoverLabel.remove();
        }
        if (this.launching && this.selected != null) {
            this.lookAt(this.selected, 0.1f);
        }
        if (this.showing()) {
            Sector to = this.newPresets.peek();
            this.presetShow += Time.delta;
            this.lookAt(to, 0.11f);
            this.zoom = 0.75f;
            if (this.presetShow >= 20.0f && !this.showed && this.newPresets.size > 1) {
                this.showed = true;
                Vars.ui.announce("\ue876 [accent]" + to.name(), 2.0f);
            }
            if (this.presetShow > sectorShowDuration) {
                this.newPresets.pop();
                this.showed = false;
                this.presetShow = 0.0f;
            }
        }
        if (this.state.planet.hasGrid()) {
            this.hovered = Core.scene.getDialog() == this ? this.state.planet.getSector(this.planets.cam.getMouseRay(), 1.17f * this.state.planet.radius) : null;
        } else if (this.state.planet.isLandable()) {
            boolean wasNull = this.selected == null;
            this.hovered = this.selected = this.state.planet.sectors.first();
            if (wasNull) {
                this.updateSelected();
            }
        } else {
            this.selected = null;
            this.hovered = null;
        }
        this.state.zoom = Mathf.lerpDelta(this.state.zoom, this.zoom, 0.4f);
        this.state.uiAlpha = Mathf.lerpDelta(this.state.uiAlpha, Mathf.num(this.state.zoom < 1.9f), 0.1f);
    }

    void displayItems(Table c, float scl, ObjectMap<Item, SectorInfo.ExportStat> stats, String name) {
        this.displayItems(c, scl, stats, name, t -> {});
    }

    void displayItems(Table c, float scl, ObjectMap<Item, SectorInfo.ExportStat> stats, String name, Cons<Table> builder) {
        Table t = new Table().left();
        int i = 0;
        for (Item item : Vars.content.items()) {
            int total;
            SectorInfo.ExportStat stat = stats.get(item);
            if (stat == null || (total = (int)(stat.mean * 60.0f * scl)) <= 1) continue;
            t.image(item.uiIcon).padRight(3.0f);
            t.add(UI.formatAmount(total) + " " + Core.bundle.get("unit.perminute")).color(Color.lightGray).padRight(3.0f);
            if (++i % 3 != 0) continue;
            t.row();
        }
        if (t.getChildren().any()) {
            c.defaults().left();
            c.add(name).row();
            builder.get(c);
            c.add(t).padLeft(10.0f).row();
        }
    }

    void showStats(Sector sector) {
        BaseDialog dialog = new BaseDialog(sector.name());
        dialog.cont.pane((Table c) -> {
            c.defaults().padBottom(5.0f);
            if (sector.preset != null && sector.preset.description != null) {
                c.add(sector.preset.displayDescription()).width(420.0f).wrap().left().row();
            }
            c.add(Core.bundle.get("sectors.time") + " [accent]" + sector.save.getPlayTime()).left().row();
            if (sector.info.waves && sector.hasBase()) {
                c.add(Core.bundle.get("sectors.wave") + " [accent]" + (sector.info.wave + sector.info.wavesPassed)).left().row();
            }
            if (sector.isAttacked() || !sector.hasBase()) {
                c.add(Core.bundle.get("sectors.threat") + " [accent]" + sector.displayThreat()).left().row();
            }
            if (sector.save != null && sector.info.resources.any()) {
                c.add("@sectors.resources").left().row();
                c.table((Table t) -> {
                    for (UnlockableContent uc : sector.info.resources) {
                        if (uc == null) continue;
                        t.image(uc.uiIcon).scaling(Scaling.fit).padRight(3.0f).size(24.0f);
                    }
                }).padLeft(10.0f).left().row();
            }
            this.displayItems((Table)c, sector.getProductionScale(), sector.info.production, "@sectors.production");
            this.displayItems((Table)c, sector.getProductionScale(), sector.info.export, "@sectors.export", t -> {
                if (sector.info.destination != null && sector.info.destination.hasBase()) {
                    String ic = sector.info.destination.iconChar();
                    t.add("\ue83a " + (ic == null || ic.isEmpty() ? "" : ic + " ") + sector.info.destination.name()).padLeft(10.0f).row();
                }
            });
            if (sector.hasBase()) {
                this.displayItems((Table)c, 1.0f, sector.info.importStats(sector.planet), "@sectors.import", t -> sector.info.eachImport(sector.planet, other -> {
                    String ic = other.iconChar();
                    t.add("\ue83a " + (ic == null || ic.isEmpty() ? "" : ic + " ") + other.name()).padLeft(10.0f).row();
                }));
            }
            ItemSeq items = sector.items();
            if (sector.hasBase() && items.total > 0) {
                c.add("@sectors.stored").left().row();
                c.table((Table t) -> {
                    t.left();
                    t.table((Table res) -> {
                        int i = 0;
                        for (ItemStack stack : items) {
                            res.image(stack.item.uiIcon).padRight(3.0f);
                            res.add(UI.formatAmount(Math.max(stack.amount, 0))).color(Color.lightGray);
                            if (++i % 4 != 0) continue;
                            res.row();
                        }
                    }).padLeft(10.0f);
                }).left().row();
            }
        });
        dialog.addCloseButton();
        if (sector.hasBase()) {
            dialog.buttons.button("@sector.abandon", Icon.cancel, () -> this.abandonSectorConfirm(sector, dialog::hide));
        }
        dialog.show();
    }

    public void abandonSectorConfirm(Sector sector, Runnable listener) {
        Vars.ui.showConfirm("@sector.abandon.confirm", () -> {
            if (listener != null) {
                listener.run();
            }
            if (sector.isBeingPlayed()) {
                this.hide();
                Time.runTask(7.0f, () -> {
                    for (CoreBlock.CoreBuild core : Vars.player.team().cores().copy()) {
                        core.kill();
                    }
                });
            } else {
                if (sector.save != null) {
                    sector.save.delete();
                }
                sector.save = null;
            }
            this.updateSelected();
        });
    }

    void addSurvivedInfo(Sector sector, Table table, boolean wrap) {
        if (!wrap) {
            table.add(sector.planet.allowWaveSimulation ? Core.bundle.format("sectors.underattack", (int)(sector.info.damage * 100.0f)) : "@sectors.underattack.nodamage").wrapLabel(wrap).row();
        }
        if (sector.planet.allowWaveSimulation && sector.info.wavesSurvived >= 0 && sector.info.wavesSurvived - sector.info.wavesPassed >= 0 && !sector.isBeingPlayed()) {
            int toCapture = sector.info.attack || sector.info.winWave <= 1 ? -1 : sector.info.winWave - (sector.info.wave + sector.info.wavesPassed);
            boolean plus = sector.info.wavesSurvived - sector.info.wavesPassed >= 39;
            table.add(Core.bundle.format("sectors.survives", Math.min(sector.info.wavesSurvived - sector.info.wavesPassed, toCapture <= 0 ? 200 : toCapture) + (plus ? "+" : "") + (toCapture < 0 ? "" : "/" + toCapture))).wrapLabel(wrap).row();
        }
    }

    void selectSector(Sector sector) {
        this.selected = sector;
        this.updateSelected();
    }

    void updateSelected() {
        boolean locked;
        final Sector sector = this.selected;
        Table stable = this.sectorTop;
        if (sector == null) {
            stable.clear();
            stable.visible = false;
            return;
        }
        stable.visible = true;
        float x = stable.getX(1);
        float y = stable.getY(1);
        stable.clear();
        stable.background(Styles.black6);
        stable.table((Table title) -> {
            title.add("[accent]" + sector.name()).padLeft(3.0f);
            if (sector.preset == null) {
                title.add().growX();
                title.button((Drawable)Icon.pencilSmall, Styles.clearNonei, () -> Vars.ui.showTextInput("@sectors.rename", "@name", 20, sector.name(), v -> {
                    sector.setName((String)v);
                    this.updateSelected();
                    this.rebuildList();
                })).size(40.0f).padLeft(4.0f);
            }
            TextureRegionDrawable icon = sector.info.contentIcon != null ? new TextureRegionDrawable(sector.info.contentIcon.uiIcon) : Icon.icons.get(sector.info.icon + "Small");
            title.button(icon == null ? Icon.noneSmall : icon, Styles.clearNonei, 24.0f, () -> new Dialog(""){
                {
                    super(arg0);
                    this.closeOnBack();
                    this.setFillParent(true);
                    Runnable refresh = () -> {
                        sector.saveInfo();
                        this.hide();
                        PlanetDialog.this.updateSelected();
                        PlanetDialog.this.rebuildList();
                    };
                    this.cont.pane((Table t) -> this.resized(true, () -> {
                        t.clearChildren();
                        t.marginRight(19.0f);
                        t.defaults().size(48.0f);
                        t.button((Drawable)Icon.none, Styles.squareTogglei, () -> {
                            sector2.info.icon = null;
                            sector2.info.contentIcon = null;
                            refresh.run();
                        }).checked(sector2.info.icon == null && sector2.info.contentIcon == null);
                        int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl(52.0f));
                        int i = 1;
                        for (String string : defaultIcons) {
                            TextureRegionDrawable value = Icon.icons.get(string);
                            t.button((Drawable)value, Styles.squareTogglei, () -> {
                                sector2.info.icon = key;
                                sector2.info.contentIcon = null;
                                refresh.run();
                            }).checked(string.equals(sector2.info.icon));
                            if (++i % cols != 0) continue;
                            t.row();
                        }
                        for (ContentType contentType : Vars.defaultContentIcons) {
                            t.row();
                            t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                            t.row();
                            i = 0;
                            for (UnlockableContent u : Vars.content.getBy(contentType).as()) {
                                if (u.isHidden() || !u.unlocked()) continue;
                                t.button(new TextureRegionDrawable(u.uiIcon), Styles.squareTogglei, 32.0f, () -> {
                                    sector2.info.icon = null;
                                    sector2.info.contentIcon = u;
                                    refresh.run();
                                }).checked(sector2.info.contentIcon == u);
                                if (++i % cols != 0) continue;
                                t.row();
                            }
                        }
                    }));
                    this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
                }
            }.show()).size(40.0f).tooltip("@sector.changeicon");
        }).row();
        stable.image().color(Pal.accent).fillX().height(3.0f).pad(3.0f).row();
        boolean bl = locked = sector.preset != null && sector.preset.locked() && !sector.hasBase() && sector.preset.techNode != null;
        if (locked) {
            stable.table((Table r) -> {
                r.add("@complete").colspan(2).left();
                r.row();
                for (Objectives.Objective o : sector.preset.techNode.objectives) {
                    if (o.complete()) continue;
                    r.add("> " + o.display()).color(Color.lightGray).left();
                    r.image(o.complete() ? Icon.ok : Icon.cancel, o.complete() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                    r.row();
                }
            }).row();
        } else if (!sector.hasBase()) {
            stable.add(Core.bundle.get("sectors.threat") + " [accent]" + sector.displayThreat()).row();
        }
        if (sector.isAttacked()) {
            this.addSurvivedInfo(sector, stable, false);
        } else if (sector.hasBase() && sector.planet.allowSectorInvasion && sector.near().contains((Sector)((Object)((Boolf<Sector>)Sector::hasEnemyBase)))) {
            stable.add("@sectors.vulnerable");
            stable.row();
        } else if (!sector.hasBase() && sector.hasEnemyBase()) {
            stable.add("@sectors.enemybase");
            stable.row();
        }
        if (sector.save != null && sector.info.resources.any()) {
            stable.table((Table t) -> {
                t.add("@sectors.resources").padRight(4.0f);
                for (UnlockableContent c : sector.info.resources) {
                    if (c == null) continue;
                    t.image(c.uiIcon).padRight(3.0f).scaling(Scaling.fit).size(24.0f);
                }
            }).padLeft(10.0f).fillX().row();
        }
        stable.row();
        if (sector.hasBase()) {
            stable.button("@stats", (Drawable)Icon.info, Styles.cleart, () -> this.showStats(sector)).height(40.0f).fillX().row();
        }
        if (sector.hasBase() && this.mode == Mode.look || this.canSelect(sector) || sector.preset != null && sector.preset.alwaysUnlocked || debugSelect) {
            stable.button(this.mode == Mode.select ? "@sectors.select" : (sector.isBeingPlayed() ? "@sectors.resume" : (sector.hasBase() ? "@sectors.go" : (locked ? "@locked" : "@sectors.launch"))), locked ? Icon.lock : Icon.play, this::playSelected).growX().height(54.0f).minWidth(170.0f).padTop(4.0f).disabled(locked);
        }
        stable.pack();
        stable.setPosition(x, y, 1);
        stable.act(0.0f);
    }

    void playSelected() {
        if (this.selected == null) {
            return;
        }
        Sector sector = this.selected;
        if (sector.isBeingPlayed()) {
            this.hide();
            return;
        }
        if (sector.preset != null && sector.preset.locked() && sector.preset.techNode != null && !sector.hasBase()) {
            return;
        }
        for (Planet planet : Vars.content.planets()) {
            Sector attacked;
            if (planet.allowWaveSimulation || debugSelect || planet.allowWaveSimulation != sector.planet.allowWaveSimulation || (attacked = planet.sectors.find((T s) -> s.isAttacked() && s != sector)) == null || planet.sectors.count(s -> s.isAttacked()) >= 2) continue;
            BaseDialog dialog = new BaseDialog("@sector.noswitch.title");
            dialog.cont.add(Core.bundle.format("sector.noswitch", attacked.name(), attacked.planet.localizedName)).width(400.0f).labelAlign(1).center().wrap();
            dialog.addCloseButton();
            dialog.buttons.button("@sector.view", Icon.eyeSmall, () -> {
                dialog.hide();
                this.lookAt(attacked);
                this.selectSector(attacked);
            });
            dialog.show();
            return;
        }
        boolean shouldHide = true;
        if (Vars.control.saves.getCurrent() != null && Vars.state.isGame() && this.mode != Mode.select) {
            try {
                Vars.control.saves.getCurrent().save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
        }
        if (this.mode == Mode.look && !sector.hasBase()) {
            shouldHide = false;
            Sector from = this.findLauncher(sector);
            if (from == null) {
                Vars.universe.clearLoadoutInfo();
                Vars.control.playSector(sector);
            } else {
                CoreBlock b;
                Block block;
                CoreBlock coreBlock = sector.allowLaunchSchematics() ? ((block = from.info.bestCoreType) instanceof CoreBlock ? (b = (CoreBlock)block) : (CoreBlock)from.planet.defaultCore) : (CoreBlock)from.planet.defaultCore;
                CoreBlock block2 = coreBlock;
                this.loadouts.show(block2, from, sector, () -> {
                    Schematic loadout = Vars.universe.getLastLoadout();
                    CoreBlock schemCore = loadout.findCore();
                    from.removeItems(loadout.requirements());
                    from.removeItems(Vars.universe.getLaunchResources());
                    Events.fire(new EventType.SectorLaunchLoadoutEvent(sector, from, loadout));
                    if (Core.settings.getBool("skipcoreanimation")) {
                        Vars.control.playSector(from, sector);
                        Time.runTask(8.0f, this::hide);
                    } else {
                        this.hide();
                        Time.runTask(5.0f, () -> {
                            Runnable doLaunch = () -> {
                                Vars.renderer.showLaunch(schemCore);
                                Time.runTask(152.0f, () -> Vars.control.playSector(from, sector));
                            };
                            if (!from.isBeingPlayed()) {
                                Time.runTask(9.0f, doLaunch);
                                Vars.control.playSector(from);
                            } else {
                                doLaunch.run();
                            }
                        });
                    }
                });
            }
        } else if (this.mode == Mode.select) {
            this.listener.get(sector);
        } else if (this.mode == Mode.planetLaunch) {
            this.listener.get(sector);
            sector.planet.unlockedOnLand.each(UnlockableContent::unlock);
            Vars.control.playSector(sector);
        } else {
            Vars.control.playSector(sector);
        }
        if (shouldHide) {
            this.hide();
        }
    }

    public static enum Mode {
        look,
        select,
        planetLaunch;

    }
}

