/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.scene.Group;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class PlayerListFragment {
    public Table content = new Table().marginRight(13.0f).marginLeft(13.0f);
    private boolean visible = false;
    private Interval timer = new Interval();
    private TextField search;
    private Seq<Player> players = new Seq();

    public void build(Group parent) {
        this.content.name = "players";
        parent.fill(cont -> {
            cont.name = "playerlist";
            cont.visible(() -> this.visible);
            cont.update(() -> {
                if (!Vars.net.active() || !Vars.state.isGame()) {
                    this.visible = false;
                    return;
                }
                if (this.visible && this.timer.get(20.0f)) {
                    this.rebuild();
                    this.content.pack();
                    this.content.act(Core.graphics.getDeltaTime());
                    Core.scene.act(0.0f);
                }
            });
            cont.table(Tex.buttonTrans, pane -> {
                pane.label(() -> Core.bundle.format(Groups.player.size() == 1 ? "players.single" : "players", Groups.player.size()));
                pane.row();
                this.search = pane.field(null, text -> this.rebuild()).grow().pad(8.0f).name("search").maxTextLength(40).get();
                this.search.setMessageText(Core.bundle.get("players.search"));
                pane.row();
                pane.pane(this.content).grow().scrollX(false);
                pane.row();
                pane.table(menu -> {
                    menu.defaults().growX().height(50.0f).fillY();
                    menu.name = "menu";
                    menu.button("@server.bans", Vars.ui.bans::show).disabled(b -> Vars.net.client());
                    menu.button("@server.admins", Vars.ui.admins::show).disabled(b -> Vars.net.client());
                    menu.button("@close", this::toggle);
                }).margin(0.0f).pad(10.0f).growX();
            }).touchable(Touchable.enabled).margin(14.0f).minWidth(360.0f);
        });
        this.rebuild();
    }

    public void rebuild() {
        boolean allowTeamSwitch = !Vars.state.isCampaign() && (Vars.state.rules.pvp || Vars.state.rules.infiniteResources);
        this.content.clear();
        float h = 50.0f;
        boolean found = false;
        this.players.clear();
        Groups.player.copy(this.players);
        this.players.sort(Structs.comps(Structs.comparing(Player::team), Structs.comparingBool(p -> !p.admin)));
        if (this.search.getText().length() > 0) {
            this.players.retainAll(p -> Strings.stripColors(p.name().toLowerCase()).contains(this.search.getText().toLowerCase()));
        }
        for (final Player user : this.players) {
            boolean clickable;
            found = true;
            NetConnection connection = user.con;
            if (connection == null && Vars.net.server() && !user.isLocal()) {
                return;
            }
            Table button = new Table();
            button.left();
            button.margin(5.0f).marginBottom(10.0f);
            final ClickListener listener = new ClickListener();
            Table iconTable = new Table(){

                @Override
                public void draw() {
                    super.draw();
                    Draw.colorMul(user.team().color, listener.isOver() ? 1.3f : 1.0f);
                    Draw.alpha(this.parentAlpha);
                    Lines.stroke(Scl.scl(4.0f));
                    Lines.rect(this.x, this.y, this.width, this.height);
                    Draw.reset();
                }
            };
            boolean bl = clickable = !Vars.state.rules.fog || !Vars.state.rules.pvp || user.team() == Vars.player.team();
            if (clickable) {
                iconTable.addListener(listener);
                iconTable.addListener(new HandCursorListener());
            }
            iconTable.margin(8.0f);
            iconTable.add(new Image(user.icon()).setScaling(Scaling.bounded)).grow();
            iconTable.name = user.name();
            iconTable.touchable = Touchable.enabled;
            iconTable.tapped(() -> {
                if (!user.dead() && clickable) {
                    Core.camera.position.set(user.unit());
                    Vars.ui.showInfoFade(Core.bundle.format("viewplayer", user.name), 1.0f);
                    InputHandler patt4596$temp = Vars.control.input;
                    if (patt4596$temp instanceof DesktopInput) {
                        DesktopInput input = (DesktopInput)patt4596$temp;
                        input.panning = true;
                    }
                }
            });
            button.add(iconTable).size(h);
            button.labelWrap("[#" + user.color().toString().toUpperCase() + "]" + user.name()).style(Styles.outlineLabel).width(170.0f).pad(10.0f);
            button.add().grow();
            button.background(Tex.underline);
            button.image(Icon.admin).visible(() -> user.admin && (user.isLocal() || !Vars.net.server())).padRight(5.0f).get().updateVisibility();
            ImageButton.ImageButtonStyle ustyle = new ImageButton.ImageButtonStyle(){
                {
                    this.down = Styles.none;
                    this.up = Styles.none;
                    this.imageDownColor = Pal.accent;
                    this.imageUpColor = Color.white;
                    this.imageOverColor = Color.lightGray;
                }
            };
            if (Vars.net.server() || Vars.player.admin && (!user.admin || user == Vars.player)) {
                button.add().growY();
                if (allowTeamSwitch || user != Vars.player) {
                    button.button((Drawable)Icon.menu, ustyle, () -> {
                        BaseDialog dialog = new BaseDialog(user.coloredName());
                        dialog.title.setColor(Color.white);
                        dialog.titleTable.remove();
                        dialog.closeOnBack();
                        TextButton.TextButtonStyle bstyle = Styles.defaultt;
                        dialog.cont.add(user.coloredName()).row();
                        dialog.cont.image(Tex.whiteui, Pal.accent).fillX().height(3.0f).pad(4.0f).row();
                        dialog.cont.pane(t -> {
                            t.defaults().size(220.0f, 55.0f).pad(3.0f);
                            if (user != Vars.player) {
                                t.button("@player.ban", (Drawable)Icon.hammer, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmban", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.ban, null));
                                    dialog.hide();
                                }).row();
                                t.button("@player.kick", (Drawable)Icon.cancel, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmkick", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.kick, null));
                                    dialog.hide();
                                }).row();
                                t.button("@player.trace", (Drawable)Icon.zoom, bstyle, () -> {
                                    Call.adminRequest(user, Packets.AdminAction.trace, null);
                                    dialog.hide();
                                }).row();
                            }
                            if (allowTeamSwitch) {
                                t.button("@player.team", (Drawable)Icon.redo, bstyle, () -> {
                                    BaseDialog teamSelect = new BaseDialog(Core.bundle.get("player.team") + ": " + user.name);
                                    teamSelect.setFillParent(false);
                                    ButtonGroup group = new ButtonGroup();
                                    int i = 0;
                                    for (Team team : Team.baseTeams) {
                                        ImageButton b = new ImageButton(Tex.whiteui, Styles.clearNoneTogglei);
                                        b.margin(4.0f);
                                        b.getImageCell().grow();
                                        b.getStyle().imageUpColor = team.color;
                                        b.clicked(() -> {
                                            Call.adminRequest(user, Packets.AdminAction.switchTeam, team);
                                            teamSelect.hide();
                                        });
                                        teamSelect.cont.add(b).size(50.0f).checked(a -> user.team() == team).group(group);
                                        if (i++ % 3 != 2) continue;
                                        teamSelect.cont.row();
                                    }
                                    teamSelect.addCloseButton();
                                    teamSelect.show();
                                    dialog.hide();
                                }).row();
                            }
                            if (!Vars.net.client() && !user.isLocal()) {
                                t.button("@player.admin", (Drawable)Icon.admin, Styles.togglet, () -> {
                                    dialog.hide();
                                    String id = user.uuid();
                                    if (user.admin) {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmunadmin", user.name()), () -> {
                                            Vars.netServer.admins.unAdminPlayer(id);
                                            user.admin = false;
                                        });
                                    } else {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmadmin", user.name()), () -> {
                                            Vars.netServer.admins.adminPlayer(id, user.usid());
                                            user.admin = true;
                                        });
                                    }
                                }).checked(b -> user.admin).row();
                            }
                        }).row();
                        dialog.cont.button("@back", Icon.left, dialog::hide).padTop(-1.0f).size(220.0f, 55.0f);
                        dialog.show();
                    }).size(h);
                }
            } else if (!user.isLocal() && !user.admin && Vars.net.client() && Groups.player.size() >= 3 && Vars.player.team() == user.team()) {
                button.add().growY();
                button.button((Drawable)Icon.hammer, ustyle, () -> Vars.ui.showTextInput("@votekick.reason", Core.bundle.format("votekick.reason.message", user.name()), "", reason -> Call.sendChatMessage("/votekick #" + user.id + " " + reason))).size(h);
            }
            this.content.add(button).width(350.0f).height(h + 14.0f);
            this.content.row();
        }
        if (!found) {
            this.content.add(Core.bundle.format("players.notfound", new Object[0])).padBottom(6.0f).width(350.0f).maxHeight(h + 14.0f);
        }
        this.content.marginBottom(5.0f);
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (this.visible) {
            this.rebuild();
        } else {
            Core.scene.setKeyboardFocus(null);
            this.search.clearText();
        }
    }
}

