/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.BufferItem;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.meta.BlockGroup;

public class Junction
extends Block {
    public float speed = 26.0f;
    public int capacity = 6;

    public Junction(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.underBullets = true;
        this.group = BlockGroup.transportation;
        this.unloadable = false;
        this.floating = true;
        this.noUpdateDisabled = true;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public class JunctionBuild
    extends Building {
        public DirectionalItemBuffer buffer;

        public JunctionBuild() {
            this.buffer = new DirectionalItemBuffer(Junction.this.capacity);
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return 0;
        }

        @Override
        public void updateTile() {
            for (int i = 0; i < 4; ++i) {
                long l;
                float time;
                if (this.buffer.indexes[i] <= 0) continue;
                if (this.buffer.indexes[i] > Junction.this.capacity) {
                    this.buffer.indexes[i] = Junction.this.capacity;
                }
                if (!(Time.time >= (time = BufferItem.time(l = this.buffer.buffers[i][0])) + Junction.this.speed / this.timeScale) && !(Time.time < time)) continue;
                Item item = Vars.content.item(BufferItem.item(l));
                Building dest = this.nearby(i);
                if (item == null || dest == null || !dest.acceptItem(this, item) || dest.team != this.team) continue;
                dest.handleItem(this, item);
                System.arraycopy(this.buffer.buffers[i], 1, this.buffer.buffers[i], 0, this.buffer.indexes[i] - 1);
                int n = i;
                this.buffer.indexes[n] = this.buffer.indexes[n] - 1;
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            this.buffer.accept(relative, item);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            if (relative == -1 || !this.buffer.accepts(relative)) {
                return false;
            }
            Building to = this.nearby(relative);
            return to != null && to.team == this.team;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read);
        }
    }
}

