/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class OverflowDuct
extends Block {
    public float speed = 5.0f;
    public boolean invert = false;
    public TextureRegion topRegion;

    public OverflowDuct(String name) {
        super(name);
        this.group = BlockGroup.transportation;
        this.update = true;
        this.solid = false;
        this.hasItems = true;
        this.conveyorPlacement = true;
        this.unloadable = false;
        this.itemCapacity = 1;
        this.noUpdateDisabled = true;
        this.rotate = true;
        this.underBullets = true;
        this.priority = -1.0f;
        this.envEnabled = 7;
        this.regionRotated1 = 1;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    public class OverflowDuctBuild
    extends Building {
        public float progress;
        @Nullable
        public Item current;

        @Override
        public void draw() {
            Draw.rect(OverflowDuct.this.region, this.x, this.y);
            Draw.rect(OverflowDuct.this.topRegion, this.x, this.y, this.rotdeg());
        }

        @Override
        public void updateTile() {
            this.progress += this.edelta() / OverflowDuct.this.speed * 2.0f;
            if (this.current != null) {
                Building target;
                if (this.progress >= 1.0f - 1.0f / OverflowDuct.this.speed && (target = this.target()) != null) {
                    target.handleItem(this, this.current);
                    this.cdump = (byte)(this.cdump == 0 ? 2 : 0);
                    this.items.remove(this.current, 1);
                    this.current = null;
                    this.progress %= 1.0f - 1.0f / OverflowDuct.this.speed;
                }
            } else {
                this.progress = 0.0f;
            }
            if (this.current == null && this.items.total() > 0) {
                this.current = this.items.first();
            }
        }

        @Nullable
        public Building target() {
            Building front;
            if (this.current == null) {
                return null;
            }
            if (OverflowDuct.this.invert) {
                boolean rc;
                Building l = this.left();
                Building r = this.right();
                boolean lc = l != null && l.team == this.team && l.acceptItem(this, this.current);
                boolean bl = rc = r != null && r.team == this.team && r.acceptItem(this, this.current);
                if (lc && !rc) {
                    return l;
                }
                if (rc && !lc) {
                    return r;
                }
                if (lc && rc) {
                    return this.cdump == 0 ? l : r;
                }
            }
            if ((front = this.front()) != null && front.team == this.team && front.acceptItem(this, this.current)) {
                return front;
            }
            if (OverflowDuct.this.invert) {
                return null;
            }
            for (int i = -1; i <= 1; ++i) {
                Building other;
                int dir = Mathf.mod(this.rotation + ((i + this.cdump + 1) % 3 - 1), 4);
                if (dir == this.rotation || (other = this.nearby(dir)) == null || other.team != this.team || !other.acceptItem(this, this.current)) continue;
                return other;
            }
            return null;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.current == null && this.items.total() == 0 && Edges.getFacingEdge(source.tile(), this.tile).relativeTo(this.tile) == this.rotation;
        }

        @Override
        public int removeStack(Item item, int amount) {
            int removed = super.removeStack(item, amount);
            if (item == this.current) {
                this.current = null;
            }
            return removed;
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            super.handleStack(item, amount, source);
            this.current = item;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.current = item;
            this.progress = -1.0f;
            this.items.add(item, 1);
            this.noSleep();
        }
    }
}

