/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.gen.Sounds;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Prop
extends Block {
    public float layer = 32.0f;

    public Prop(String name) {
        super(name);
        this.breakable = true;
        this.alwaysReplace = true;
        this.instantDeconstruct = true;
        this.breakEffect = Fx.breakProp;
        this.breakSound = Sounds.rockBreak;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.z(this.layer);
        Draw.rect(this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))] : this.region, tile.worldx(), tile.worldy());
    }

    @Override
    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.variants == 0) {
            textureRegionArray = super.icons();
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = Core.atlas.find(this.name + "1");
        }
        return textureRegionArray;
    }
}

