/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.heat;

import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawHeatOutput;
import mindustry.world.draw.DrawMulti;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class HeatProducer
extends GenericCrafter {
    public float heatOutput = 10.0f;
    public float warmupRate = 0.15f;

    public HeatProducer(String name) {
        super(name);
        this.drawer = new DrawMulti(new DrawDefault(), new DrawHeatOutput());
        this.rotateDraw = false;
        this.rotate = true;
        this.canOverdrive = false;
        this.drawArrow = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, this.heatOutput, StatUnit.heatUnits);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar("bar.heat", Pal.lightOrange, () -> entity.heat / this.heatOutput));
    }

    public class HeatProducerBuild
    extends GenericCrafter.GenericCrafterBuild
    implements HeatBlock {
        public float heat;

        public HeatProducerBuild() {
            super(HeatProducer.this);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.heat = Mathf.approachDelta(this.heat, HeatProducer.this.heatOutput * this.efficiency, HeatProducer.this.warmupRate * this.delta());
        }

        @Override
        public float heatFrac() {
            return this.heat / HeatProducer.this.heatOutput;
        }

        @Override
        public float heat() {
            return this.heat;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
        }
    }
}

