/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;

public class BuildPayload
implements Payload {
    public Building build;

    public BuildPayload(Block block, Team team) {
        this.build = block.newBuilding().create(block, team);
        this.build.tile = Vars.emptyTile;
    }

    public BuildPayload(Building build) {
        this.build = build;
    }

    public Block block() {
        return this.build.block;
    }

    public void place(Tile tile) {
        this.place(tile, 0);
    }

    public void place(Tile tile, int rotation) {
        tile.setBlock(this.build.block, this.build.team, rotation, () -> this.build);
        this.build.dropped();
    }

    @Override
    public UnlockableContent content() {
        return this.build.block;
    }

    @Override
    public void update(@Nullable Unit unitHolder, @Nullable Building buildingHolder) {
        if (!(unitHolder == null || this.build.block.updateInUnits && (Vars.state.rules.unitPayloadUpdate || this.build.block.alwaysUpdateInUnits))) {
            return;
        }
        this.build.tile = Vars.emptyTile;
        this.build.updatePayload(unitHolder, buildingHolder);
    }

    @Override
    public ItemStack[] requirements() {
        return this.build.block.requirements;
    }

    @Override
    public float buildTime() {
        return this.build.block.buildCost;
    }

    @Override
    public float x() {
        return this.build.x;
    }

    @Override
    public float y() {
        return this.build.y;
    }

    @Override
    public float size() {
        return this.build.block.size * 8;
    }

    @Override
    public void write(Writes write) {
        write.b(1);
        write.s(this.build.block.id);
        write.b(this.build.version());
        this.build.writeAll(write);
    }

    @Override
    public void set(float x, float y, float rotation) {
        this.build.set(x, y);
        this.build.payloadRotation = rotation;
    }

    @Override
    public void drawShadow(float alpha) {
        Drawf.squareShadow(this.build.x, this.build.y, (float)(this.build.block.size * 8) * 1.85f, alpha);
    }

    @Override
    public void draw() {
        float prevZ = Draw.z();
        Draw.z(prevZ - 1.0E-4f);
        this.drawShadow(1.0f);
        Draw.z(prevZ);
        Draw.zTransform(z -> z >= 91.0f ? z : 0.0011f + Math.min(Mathf.clamp(z, prevZ - 0.001f, prevZ + 0.9f), 89.0f));
        this.build.tile = Vars.emptyTile;
        this.build.payloadDraw();
        Draw.zTransform();
        Draw.z(prevZ);
    }

    @Override
    public TextureRegion icon() {
        return this.block().fullIcon;
    }
}

