/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.logic.LAccess;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;

public class PayloadRouter
extends PayloadConveyor {
    public boolean invert = false;
    public TextureRegion overRegion;

    public PayloadRouter(String name) {
        super(name);
        this.outputsPayload = true;
        this.outputFacing = false;
        this.configurable = true;
        this.clearOnDoubleTap = true;
        this.config(Block.class, (tile, item) -> {
            tile.sorted = item;
        });
        this.config(UnitType.class, (tile, item) -> {
            tile.sorted = item;
        });
        this.configClear(tile -> {
            tile.sorted = null;
        });
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.rect(this.overRegion, plan.drawx(), plan.drawy());
    }

    public boolean canSort(Block b) {
        return b.isVisible() && b.size <= this.size && !(b instanceof CoreBlock) && !Vars.state.rules.isBanned(b) && b.environmentBuildable();
    }

    public boolean canSort(UnitType t) {
        return !t.isHidden() && !t.isBanned() && t.supportsEnv(Vars.state.rules.env);
    }

    public class PayloadRouterBuild
    extends PayloadConveyor.PayloadConveyorBuild {
        @Nullable
        public UnlockableContent sorted;
        public int recDir;
        public boolean matches;
        public float smoothRot;
        public float controlTime = -1.0f;

        @Override
        public void add() {
            super.add();
            this.smoothRot = this.rotdeg();
        }

        public void pickNext() {
            if (this.item != null && this.controlTime <= 0.0f) {
                if (this.matches) {
                    this.rotation = this.recDir;
                    this.onProximityUpdate();
                } else {
                    int rotations = 0;
                    do {
                        this.rotation = (this.rotation + 1) % 4;
                        if (!this.matches && this.sorted != null && this.rotation == this.recDir) {
                            ++this.rotation;
                        }
                        this.onProximityUpdate();
                        if (!(this.next instanceof PayloadConveyor.PayloadConveyorBuild) || this.next instanceof PayloadRouterBuild) continue;
                        this.next.updateTile();
                    } while ((this.blocked || this.next == null || !this.next.acceptPayload(this.next, this.item)) && ++rotations < 4);
                }
            } else {
                this.onProximityUpdate();
            }
        }

        @Override
        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            super.control(type, p1, p2, p3, p4);
            if (type == LAccess.config) {
                int prev = this.rotation;
                this.rotation = Mathf.mod((int)p1, 4);
                this.controlTime = 360.0f;
                if (prev != this.rotation) {
                    this.onProximityUpdate();
                }
            }
        }

        @Override
        public void onControlSelect(Unit player) {
            super.onControlSelect(player);
            this.recDir = this.rotation;
            this.checkMatch();
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            super.handlePayload(source, payload);
            if (this.controlTime < 0.0f) {
                this.recDir = source == null ? this.rotation : (int)source.relativeTo(this);
            }
            this.checkMatch();
            this.pickNext();
        }

        /*
         * Unable to fully structure code
         */
        public void checkMatch() {
            if (this.sorted != null && (var3_1 = this.item) instanceof BuildPayload && (build = (BuildPayload)var3_1).block() == this.sorted) ** GOTO lbl-1000
            var3_1 = this.item;
            if (var3_1 instanceof UnitPayload) {
                unit = (UnitPayload)var3_1;
                ** if (unit.unit.type != this.sorted) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v0 = true;
                ** GOTO lbl10
            }
lbl-1000:
            // 2 sources

            {
                v0 = this.matches = false;
            }
lbl10:
            // 2 sources

            if (PayloadRouter.this.invert) {
                this.matches = this.matches == false;
            }
        }

        @Override
        public void moveFailed() {
            this.pickNext();
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.controlTime -= Time.delta;
            this.smoothRot = Mathf.slerpDelta(this.smoothRot, this.rotdeg(), 0.2f);
        }

        @Override
        public void drawSelect() {
            if (this.sorted != null) {
                float dx = this.x - (float)(PayloadRouter.this.size * 8) / 2.0f;
                float dy = this.y + (float)(PayloadRouter.this.size * 8) / 2.0f;
                float s = 6.0f;
                Draw.mixcol(Color.darkGray, 1.0f);
                Draw.rect(this.sorted.fullIcon, dx, dy - 1.0f, s, s);
                Draw.reset();
                Draw.rect(this.sorted.fullIcon, dx, dy, s, s);
            }
        }

        @Override
        public void draw() {
            Draw.rect(PayloadRouter.this.region, this.x, this.y);
            float dst = 0.8f;
            Draw.mixcol(this.team.color, Math.max((dst - Math.abs(this.fract() - 0.5f) * 2.0f) / dst, 0.0f));
            Draw.rect(PayloadRouter.this.topRegion, this.x, this.y, this.smoothRot);
            Draw.reset();
            Draw.rect(PayloadRouter.this.overRegion, this.x, this.y);
            Draw.z(35.0f);
            if (this.item != null) {
                this.item.draw();
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(PayloadRouter.this, table, Vars.content.blocks().select(PayloadRouter.this::canSort).as().add(Vars.content.units().select(PayloadRouter.this::canSort).as()), () -> (UnlockableContent)this.config(), this::configure);
        }

        @Override
        public Object config() {
            return this.sorted;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.b(this.sorted == null ? -1 : this.sorted.getContentType().ordinal());
            write.s(this.sorted == null ? -1 : (int)this.sorted.id);
            write.b(this.recDir);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                byte ctype = read.b();
                short sort = read.s();
                this.sorted = ctype == -1 ? null : (UnlockableContent)Vars.content.getByID(ContentType.all[ctype], sort);
                this.recDir = read.b();
                this.checkMatch();
            }
        }
    }
}

