/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Events;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;

public class PayloadSource
extends PayloadBlock {
    public PayloadSource(String name) {
        super(name);
        this.size = 3;
        this.update = true;
        this.outputsPayload = true;
        this.hasPower = false;
        this.rotate = true;
        this.configurable = true;
        this.selectionColumns = 8;
        this.selectionRows = 8;
        this.clipSize = 120.0f;
        this.noUpdateDisabled = true;
        this.clearOnDoubleTap = true;
        this.regionRotated1 = 1;
        this.commandable = true;
        this.config(Block.class, (build, block) -> {
            if (this.canProduce((Block)block) && build.configBlock != block) {
                build.configBlock = block;
                build.unit = null;
                build.payload = null;
                build.scl = 0.0f;
            }
        });
        this.config(UnitType.class, (build, unit) -> {
            if (this.canProduce((UnitType)unit) && build.unit != unit) {
                build.unit = unit;
                build.configBlock = null;
                build.payload = null;
                build.scl = 0.0f;
            }
        });
        this.configClear(build -> {
            build.configBlock = null;
            build.unit = null;
            build.payload = null;
            build.scl = 0.0f;
        });
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    public boolean canProduce(Block b) {
        return b.isVisible() && b.size < this.size && !(b instanceof CoreBlock) && !Vars.state.rules.isBanned(b) && b.environmentBuildable();
    }

    public boolean canProduce(UnitType t) {
        return !t.isHidden() && !t.isBanned() && t.supportsEnv(Vars.state.rules.env);
    }

    public class PayloadSourceBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        public UnitType unit;
        public Block configBlock;
        @Nullable
        public Vec2 commandPos;
        public float scl;

        @Override
        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        @Override
        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(PayloadSource.this, table, Vars.content.blocks().select(PayloadSource.this::canProduce).as().add(Vars.content.units().select(PayloadSource.this::canProduce).as()), () -> (UnlockableContent)this.config(), this::configure, PayloadSource.this.selectionRows, PayloadSource.this.selectionColumns);
        }

        @Override
        public Object config() {
            return this.unit == null ? this.configBlock : this.unit;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.payload == null) {
                this.scl = 0.0f;
                if (this.unit != null) {
                    this.payload = new UnitPayload(this.unit.create(this.team));
                    Unit p = ((UnitPayload)this.payload).unit;
                    if (this.commandPos != null && p.isCommandable()) {
                        p.command().commandPosition(this.commandPos);
                    }
                    Events.fire(new EventType.UnitCreateEvent(p, this));
                } else if (this.configBlock != null) {
                    this.payload = new BuildPayload(this.configBlock, this.team);
                }
                this.payVector.setZero();
                this.payRotation = this.rotdeg();
            }
            this.scl = Mathf.lerpDelta(this.scl, 1.0f, 0.1f);
            this.moveOutPayload();
        }

        @Override
        public void draw() {
            Draw.rect(PayloadSource.this.region, this.x, this.y);
            Draw.rect(PayloadSource.this.outRegion, this.x, this.y, this.rotdeg());
            Draw.rect(PayloadSource.this.topRegion, this.x, this.y);
            Draw.scl(this.scl);
            this.drawPayload();
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.unit == null ? -1 : (int)this.unit.id);
            write.s(this.configBlock == null ? -1 : (int)this.configBlock.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.unit = Vars.content.unit(read.s());
            this.configBlock = Vars.content.block(read.s());
        }
    }
}

