/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.blocks.power.PowerDistributor;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPower;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockStatus;

public class Battery
extends PowerDistributor {
    @Nullable
    public DrawBlock drawer;
    public Color emptyLightColor = Color.valueOf("f8c266");
    public Color fullLightColor = Color.valueOf("fb9567");
    @Deprecated
    public TextureRegion topRegion;

    public Battery(String name) {
        super(name);
        this.outputsPower = true;
        this.consumesPower = true;
        this.canOverdrive = false;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.battery});
        this.envEnabled |= 2;
        this.destructible = true;
        this.update = false;
    }

    @Override
    public void init() {
        super.init();
        this.checkDrawDefault();
    }

    void checkDrawDefault() {
        if (this.drawer == null) {
            this.drawer = new DrawMulti(new DrawDefault(), new DrawPower(){
                {
                    this.emptyLightColor = Battery.this.emptyLightColor;
                    this.fullLightColor = Battery.this.fullLightColor;
                }
            }, new DrawRegion("-top"));
        }
    }

    @Override
    public void load() {
        this.checkDrawDefault();
        super.load();
        this.drawer.load(this);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan(this, plan, list);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons(this);
    }

    @Override
    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline(this, out);
    }

    public class BatteryBuild
    extends Building {
        @Override
        public void draw() {
            Battery.this.drawer.draw(this);
        }

        @Override
        public void drawLight() {
            super.drawLight();
            Battery.this.drawer.drawLight(this);
        }

        @Override
        public float warmup() {
            return this.power.status;
        }

        @Override
        public void overwrote(Seq<Building> previous) {
            for (Building other : previous) {
                if (other.power == null || other.block.consPower == null || !other.block.consPower.buffered) continue;
                float amount = other.block.consPower.capacity * other.power.status;
                this.power.status = Mathf.clamp(this.power.status + amount / Battery.this.consPower.capacity);
            }
        }

        @Override
        public BlockStatus status() {
            if (Mathf.equal(this.power.status, 0.0f, 0.001f)) {
                return BlockStatus.noInput;
            }
            if (Mathf.equal(this.power.status, 1.0f, 0.001f)) {
                return BlockStatus.active;
            }
            return BlockStatus.noOutput;
        }
    }
}

