/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.audio.Sound;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.world.blocks.production.Drill;

public class BurstDrill
extends Drill {
    public float shake = 2.0f;
    public Interp speedCurve = Interp.pow2In;
    public TextureRegion topInvertRegion;
    public TextureRegion glowRegion;
    public TextureRegion arrowRegion;
    public TextureRegion arrowBlurRegion;
    public float invertedTime = 200.0f;
    public float arrowSpacing = 4.0f;
    public float arrowOffset = 0.0f;
    public int arrows = 3;
    public Color arrowColor = Color.valueOf("feb380");
    public Color baseArrowColor = Color.valueOf("6e7080");
    public Color glowColor = this.arrowColor.cpy();
    public Sound drillSound = Sounds.drillImpact;
    public float drillSoundVolume = 0.6f;
    public float drillSoundPitchRand = 0.1f;

    public BurstDrill(String name) {
        super(name);
        this.hardnessDrillMultiplier = 0.0f;
        this.liquidBoostIntensity = 1.0f;
        this.drillEffectRnd = 0.0f;
        this.drillEffect = Fx.shockwave;
        this.ambientSoundVolume = 0.18f;
        this.ambientSound = Sounds.drillCharge;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public float getDrillTime(Item item) {
        return this.drillTime / this.drillMultipliers.get(item, 1.0f);
    }

    public class BurstDrillBuild
    extends Drill.DrillBuild {
        public float smoothProgress;
        public float invertTime;

        public BurstDrillBuild() {
            super(BurstDrill.this);
            this.smoothProgress = 0.0f;
            this.invertTime = 0.0f;
        }

        @Override
        public void updateTile() {
            if (this.dominantItem == null) {
                return;
            }
            if (this.invertTime > 0.0f) {
                this.invertTime -= this.delta() / BurstDrill.this.invertedTime;
            }
            if (this.timer(BurstDrill.this.timerDump, 5.0f)) {
                this.dump(this.items.has(this.dominantItem) ? this.dominantItem : null);
            }
            float drillTime = BurstDrill.this.getDrillTime(this.dominantItem);
            this.smoothProgress = Mathf.lerpDelta(this.smoothProgress, this.progress / (drillTime - 20.0f), 0.1f);
            if (this.items.total() <= BurstDrill.this.itemCapacity - this.dominantItems && this.dominantItems > 0 && this.efficiency > 0.0f) {
                this.warmup = Mathf.approachDelta(this.warmup, this.progress / drillTime, 0.01f);
                float speed = this.efficiency;
                this.timeDrilled += BurstDrill.this.speedCurve.apply(this.progress / drillTime) * speed;
                this.lastDrillSpeed = 1.0f / drillTime * speed * (float)this.dominantItems;
                this.progress += this.delta() * speed;
            } else {
                this.warmup = Mathf.approachDelta(this.warmup, 0.0f, 0.01f);
                this.lastDrillSpeed = 0.0f;
                return;
            }
            if (this.dominantItems > 0 && this.progress >= drillTime && this.items.total() < BurstDrill.this.itemCapacity) {
                for (int i = 0; i < this.dominantItems; ++i) {
                    this.offload(this.dominantItem);
                }
                this.invertTime = 1.0f;
                this.progress %= drillTime;
                if (this.wasVisible) {
                    Effect.shake(BurstDrill.this.shake, BurstDrill.this.shake, this);
                    BurstDrill.this.drillSound.at(this.x, this.y, 1.0f + Mathf.range(BurstDrill.this.drillSoundPitchRand), BurstDrill.this.drillSoundVolume);
                    BurstDrill.this.drillEffect.at(this.x + Mathf.range(BurstDrill.this.drillEffectRnd), this.y + Mathf.range(BurstDrill.this.drillEffectRnd), this.dominantItem.color);
                }
            }
        }

        @Override
        public float ambientVolume() {
            return super.ambientVolume() * Mathf.pow(this.progress(), 4.0f);
        }

        @Override
        public boolean shouldConsume() {
            return this.items.total() <= BurstDrill.this.itemCapacity - this.dominantItems && this.enabled;
        }

        @Override
        public void draw() {
            Draw.rect(BurstDrill.this.region, this.x, this.y);
            this.drawDefaultCracks();
            Draw.rect(BurstDrill.this.topRegion, this.x, this.y);
            if (this.invertTime > 0.0f && BurstDrill.this.topInvertRegion.found()) {
                Draw.alpha(Interp.pow3Out.apply(this.invertTime));
                Draw.rect(BurstDrill.this.topInvertRegion, this.x, this.y);
                Draw.color();
            }
            if (this.dominantItem != null && BurstDrill.this.drawMineItem) {
                Draw.color(this.dominantItem.color);
                Draw.rect(BurstDrill.this.itemRegion, this.x, this.y);
                Draw.color();
            }
            float fract = this.smoothProgress;
            Draw.color(BurstDrill.this.arrowColor);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < BurstDrill.this.arrows; ++j) {
                    float arrowFract = BurstDrill.this.arrows - 1 - j;
                    float a = Mathf.clamp(fract * (float)BurstDrill.this.arrows - arrowFract);
                    Tmp.v1.trns(i * 90 + 45, (float)j * BurstDrill.this.arrowSpacing + BurstDrill.this.arrowOffset);
                    Draw.z(30.0f);
                    Draw.color(BurstDrill.this.baseArrowColor, BurstDrill.this.arrowColor, a);
                    Draw.rect(BurstDrill.this.arrowRegion, this.x + Tmp.v1.x, this.y + Tmp.v1.y, (float)(i * 90));
                    Draw.color(BurstDrill.this.arrowColor);
                    if (!BurstDrill.this.arrowBlurRegion.found()) continue;
                    Draw.z(31.0f);
                    Draw.blend(Blending.additive);
                    Draw.alpha(Mathf.pow(a, 10.0f));
                    Draw.rect(BurstDrill.this.arrowBlurRegion, this.x + Tmp.v1.x, this.y + Tmp.v1.y, (float)(i * 90));
                    Draw.blend();
                }
            }
            Draw.color();
            if (BurstDrill.this.glowRegion.found()) {
                Drawf.additive(BurstDrill.this.glowRegion, Tmp.c2.set(BurstDrill.this.glowColor).a(Mathf.pow(fract, 3.0f) * BurstDrill.this.glowColor.a), this.x, this.y);
            }
        }
    }
}

