/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.meta.BlockStatus;

public class Incinerator
extends Block {
    public Effect effect = Fx.fuelburn;
    public Color flameColor = Color.valueOf("ffad9d");

    public Incinerator(String name) {
        super(name);
        this.hasPower = true;
        this.hasLiquids = true;
        this.update = true;
        this.solid = true;
    }

    public class IncineratorBuild
    extends Building {
        public float heat;

        @Override
        public void updateTile() {
            this.heat = Mathf.approachDelta(this.heat, this.efficiency, 0.04f);
        }

        @Override
        public BlockStatus status() {
            return this.heat > 0.5f ? BlockStatus.active : BlockStatus.noInput;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.heat > 0.0f) {
                float g = 0.3f;
                float r = 0.06f;
                Draw.alpha((1.0f - g + Mathf.absin(Time.time, 8.0f, g) + Mathf.random(r) - r) * this.heat);
                Draw.tint(Incinerator.this.flameColor);
                Fill.circle(this.x, this.y, 2.0f);
                Draw.color(1.0f, 1.0f, 1.0f, this.heat);
                Fill.circle(this.x, this.y, 1.0f);
                Draw.color();
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (Mathf.chance(0.3)) {
                Incinerator.this.effect.at(this.x, this.y);
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.heat > 0.5f;
        }

        @Override
        public void handleLiquid(Building source, Liquid liquid, float amount) {
            if (Mathf.chance(0.02)) {
                Incinerator.this.effect.at(this.x, this.y);
            }
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.heat > 0.5f && liquid.incinerable;
        }
    }
}

