/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.Core;
import arc.KeyBinds;
import arc.func.Cons;
import arc.input.InputDevice;
import arc.input.InputMultiplexer;
import arc.input.InputProcessor;
import arc.input.KeyCode;
import arc.input.KeyboardDevice;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.OS;

public abstract class Input {
    protected KeyboardDevice keyboard = new KeyboardDevice();
    protected Seq<InputDevice> devices = Seq.with(this.keyboard);
    protected InputMultiplexer inputMultiplexer = new InputMultiplexer(this.keyboard);
    protected IntSet caughtKeys = new IntSet();
    protected Vec2 mouseReturn = new Vec2();
    protected boolean useKeyboard;

    public Vec2 mouseWorld(float x, float y) {
        return Core.camera.unproject(this.mouseReturn.set(x, y));
    }

    public Vec2 mouseScreen(float x, float y) {
        return Core.camera.project(this.mouseReturn.set(x, y));
    }

    public float mouseWorldX() {
        return Core.camera.unproject((Vec2)this.mouse()).x;
    }

    public float mouseWorldY() {
        return Core.camera.unproject((Vec2)this.mouse()).y;
    }

    public Vec2 mouseWorld() {
        return Core.camera.unproject(this.mouse());
    }

    public Vec2 mouse() {
        return this.mouseReturn.set(this.mouseX(), this.mouseY());
    }

    public void setUseKeyboard(boolean useKeyboard) {
        this.useKeyboard = useKeyboard;
    }

    public boolean useKeyboard() {
        return this.useKeyboard;
    }

    public abstract int mouseX();

    public abstract int mouseX(int var1);

    public abstract int deltaX();

    public abstract int deltaX(int var1);

    public abstract int mouseY();

    public abstract int mouseY(int var1);

    public abstract int deltaY();

    public abstract int deltaY(int var1);

    public abstract boolean isTouched();

    public abstract boolean justTouched();

    public int getTouches() {
        int sum = 0;
        for (int i = 0; i < 10; ++i) {
            if (!this.isTouched(i)) continue;
            ++sum;
        }
        return sum;
    }

    public abstract boolean isTouched(int var1);

    public float getPressure() {
        return this.getPressure(0);
    }

    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1.0f : 0.0f;
    }

    public boolean shift() {
        return this.keyDown(KeyCode.shiftLeft) || this.keyDown(KeyCode.shiftRight);
    }

    public boolean ctrl() {
        return OS.isMac ? this.keyDown(KeyCode.sym) : this.keyDown(KeyCode.controlLeft) || this.keyDown(KeyCode.controlRight);
    }

    public boolean alt() {
        return this.keyDown(KeyCode.altLeft) || this.keyDown(KeyCode.altRight);
    }

    public boolean keyDown(KeyCode key) {
        return this.keyboard.isPressed(key);
    }

    public boolean keyTap(KeyCode key) {
        return this.keyboard.isTapped(key);
    }

    public boolean keyRelease(KeyCode key) {
        return this.keyboard.isReleased(key);
    }

    public float axis(KeyCode key) {
        return this.keyboard.getAxis(key);
    }

    public boolean keyDown(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isPressed(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public boolean keyTap(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isTapped(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public boolean keyRelease(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isReleased(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public float axis(KeyBinds.KeyBind key) {
        KeyBinds.Axis axis = Core.keybinds.get(key);
        if (axis.key != null) {
            return this.keyboard.getAxis(axis.key);
        }
        return this.keyboard.isPressed(axis.min) && this.keyboard.isPressed(axis.max) ? 0.0f : (this.keyboard.isPressed(axis.min) ? -1.0f : (this.keyboard.isPressed(axis.max) ? 1.0f : 0.0f));
    }

    public float axisTap(KeyBinds.KeyBind key) {
        KeyBinds.Axis axis = Core.keybinds.get(key);
        if (axis.key != null) {
            return this.keyboard.getAxis(axis.key);
        }
        return this.keyboard.isTapped(axis.min) ? -1.0f : (this.keyboard.isTapped(axis.max) ? 1.0f : 0.0f);
    }

    public void getTextInput(TextInput input) {
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public Vec3 getAccelerometer() {
        return Vec3.Zero;
    }

    public Vec3 getGyroscope() {
        return Vec3.Zero;
    }

    public Vec3 getOrientation() {
        return Vec3.Zero;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public abstract long getCurrentEventTime();

    public void setCatch(KeyCode code, boolean c) {
        if (c) {
            this.caughtKeys.add(code.ordinal());
        } else {
            this.caughtKeys.remove(code.ordinal());
        }
    }

    public boolean isCatch(KeyCode code) {
        return this.caughtKeys.contains(code.ordinal());
    }

    public void addProcessor(InputProcessor processor) {
        this.inputMultiplexer.addProcessor(processor);
    }

    public void removeProcessor(InputProcessor processor) {
        this.inputMultiplexer.removeProcessor(processor);
    }

    public Seq<InputProcessor> getInputProcessors() {
        return this.inputMultiplexer.getProcessors();
    }

    public InputMultiplexer getInputMultiplexer() {
        return this.inputMultiplexer;
    }

    public Seq<InputDevice> getDevices() {
        return this.devices;
    }

    public KeyboardDevice getKeyboard() {
        return this.keyboard;
    }

    public boolean isPeripheralAvailable(Peripheral peripheral) {
        return peripheral == Peripheral.hardwareKeyboard;
    }

    public int getRotation() {
        return 0;
    }

    public Orientation getNativeOrientation() {
        return Orientation.landscape;
    }

    public static class TextInput {
        public boolean multiline = false;
        public boolean allowEmpty = true;
        public String title = "";
        public String text = "";
        public boolean numeric;
        public Cons<String> accepted = s -> {};
        public Runnable canceled = () -> {};
        public int maxLength = -1;
    }

    public static enum Peripheral {
        hardwareKeyboard,
        onscreenKeyboard,
        multitouchScreen,
        accelerometer,
        compass,
        vibrator,
        gyroscope,
        rotationVector,
        pressure;

    }

    public static enum Orientation {
        landscape,
        portrait;

    }
}

