/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.headless;

import arc.Application;
import arc.ApplicationListener;
import arc.Core;
import arc.Settings;
import arc.func.Cons;
import arc.mock.MockAudio;
import arc.mock.MockFiles;
import arc.mock.MockGraphics;
import arc.mock.MockInput;
import arc.struct.Seq;
import arc.util.TaskQueue;
import arc.util.Threads;
import arc.util.Time;

public class HeadlessApplication
implements Application {
    protected final MockGraphics graphics;
    protected final Seq<ApplicationListener> listeners = new Seq();
    protected final TaskQueue runnables = new TaskQueue();
    protected final Cons<Throwable> exceptionHandler;
    protected long renderInterval;
    protected Thread mainLoopThread;
    protected boolean running = true;

    public HeadlessApplication(ApplicationListener listener) {
        this(listener, 0.016666668f, t -> {
            throw new RuntimeException((Throwable)t);
        });
    }

    public HeadlessApplication(ApplicationListener listener, Cons<Throwable> exceptionHandler) {
        this(listener, 0.016666668f, exceptionHandler);
    }

    public HeadlessApplication(ApplicationListener listener, float renderIntervalSec, Cons<Throwable> exceptionHandler) {
        this.addListener(listener);
        this.exceptionHandler = exceptionHandler;
        Core.settings = new Settings();
        Core.app = this;
        Core.files = new MockFiles();
        Core.audio = new MockAudio();
        this.graphics = new MockGraphics();
        Core.graphics = this.graphics;
        Core.input = new MockInput();
        this.renderInterval = renderIntervalSec > 0.0f ? (long)(renderIntervalSec * 1.0E9f) : (long)(renderIntervalSec < 0.0f ? -1 : 0);
        this.initialize();
    }

    protected void initialize() {
        this.mainLoopThread = new Thread("HeadlessApplication"){

            @Override
            public void run() {
                try {
                    HeadlessApplication.this.mainLoop();
                }
                catch (Throwable t) {
                    HeadlessApplication.this.exceptionHandler.get(t);
                }
            }
        };
        this.mainLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainLoop() {
        Seq<ApplicationListener> seq = this.listeners;
        synchronized (seq) {
            for (ApplicationListener listener : this.listeners) {
                listener.init();
            }
        }
        long t = Time.nanos() + this.renderInterval;
        if ((float)this.renderInterval >= 0.0f) {
            while (this.running) {
                long n = Time.nanos();
                if (t > n) {
                    long sleep = t - n;
                    Threads.sleep(sleep / 1000000L, (int)(sleep % 1000000L));
                    t += this.renderInterval;
                } else {
                    t = n + this.renderInterval;
                }
                this.runnables.run();
                this.graphics.incrementFrameId();
                this.defaultUpdate();
                Seq<ApplicationListener> sleep = this.listeners;
                synchronized (sleep) {
                    for (ApplicationListener listener : this.listeners) {
                        listener.update();
                    }
                }
                this.graphics.updateTime();
                if (this.running) continue;
                break;
            }
        }
        Seq<ApplicationListener> seq2 = this.listeners;
        synchronized (seq2) {
            for (ApplicationListener listener : this.listeners) {
                listener.pause();
                listener.dispose();
            }
            this.dispose();
        }
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.headless;
    }

    @Override
    public String getClipboardText() {
        return null;
    }

    @Override
    public void setClipboardText(String text) {
    }

    @Override
    public Seq<ApplicationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void post(Runnable runnable) {
        this.runnables.post(runnable);
    }

    @Override
    public void exit() {
        this.post(() -> {
            this.running = false;
        });
    }
}

