/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel;

import arc.flabel.FConfig;
import arc.flabel.FEffect;
import arc.flabel.FLabel;
import arc.func.Intc2;
import arc.struct.Seq;

class FParser {
    private static String resetReplacement;

    FParser() {
    }

    static void parseTokens(FLabel label) {
        if (resetReplacement == null || FConfig.dirtyEffectMaps) {
            resetReplacement = FParser.getResetReplacement();
        }
        if (label.forceMarkupColor) {
            label.getFontCache().getFont().getData().markupEnabled = true;
        }
        label.tokenEntries.clear();
        FParser.parseReplacements(label);
        FParser.parseRegularTokens(label);
        FParser.stripTokens(label);
        label.tokenEntries.sort();
        label.tokenEntries.reverse();
    }

    private static void baseParse(FLabel label, TokenHandler replacer) {
        StringBuilder text = label.getText();
        StringBuilder result = new StringBuilder();
        result.ensureCapacity(text.length());
        int[] lastIndex = new int[]{0};
        int[] afterIndex = new int[]{0};
        FParser.parseAllTokens(label, false, (from, to) -> {
            String replacement = text.charAt(from - 1) == '{' ? replacer.handle(text.substring(from, to), from + afterIndex[0]) : "[" + text.substring(from, to) + "]";
            afterIndex[0] = afterIndex[0] - (to - from + 2);
            result.append(text.subSequence(lastIndex[0], from - 1));
            if (replacement == null) {
                result.append("{").append(text.subSequence(from, to)).append("}");
            } else {
                result.append(replacement);
            }
            lastIndex[0] = to + 1;
        });
        result.append(text.subSequence(lastIndex[0], text.length()));
        label.setText(result);
    }

    private static void parseReplacements(FLabel label) {
        FParser.baseParse(label, (text, index) -> {
            String replacement = null;
            if (text.length() > 1 && text.charAt(1) == '$') {
                String varname = text.substring(1);
                if (label.getTypingListener() != null) {
                    replacement = label.getTypingListener().replaceVariable(varname);
                }
                if (replacement == null) {
                    replacement = label.getVariables().get(varname);
                }
                if (replacement == null) {
                    replacement = FConfig.globalVars.get(varname);
                }
            } else if (text.equals("/color")) {
                replacement = "[#" + label.getClearColor().toString() + "]";
            } else if (text.equals("reset")) {
                replacement = resetReplacement + label.getDefaultToken();
            }
            return replacement;
        });
    }

    private static void parseRegularTokens(FLabel label) {
        FParser.baseParse(label, (text, index) -> {
            float floatValue = 0.0f;
            String stringValue = null;
            FEffect effect = null;
            int indexOffset = 0;
            TokenCategory tokenCategory = TokenCategory.event;
            InternalToken tmpToken = InternalToken.fromName(text);
            if (tmpToken == null) {
                if (FConfig.effects.containsKey(text)) {
                    tokenCategory = TokenCategory.effectStart;
                } else if (!text.isEmpty() && FConfig.effects.containsKey(text.substring(1))) {
                    tokenCategory = TokenCategory.effectEnd;
                }
            } else {
                tokenCategory = tmpToken.category;
            }
            switch (tokenCategory) {
                case wait: {
                    floatValue = FConfig.defaultWaitValue;
                    break;
                }
                case event: {
                    stringValue = text;
                    indexOffset = -1;
                    break;
                }
                case speed: {
                    switch (text) {
                        case "slower": {
                            floatValue = FConfig.defaultSpeedPerChar / 0.5f;
                            break;
                        }
                        case "slow": {
                            floatValue = FConfig.defaultSpeedPerChar / 0.667f;
                            break;
                        }
                        case "normal": {
                            floatValue = FConfig.defaultSpeedPerChar;
                            break;
                        }
                        case "fast": {
                            floatValue = FConfig.defaultSpeedPerChar / 2.0f;
                            break;
                        }
                        case "faster": {
                            floatValue = FConfig.defaultSpeedPerChar / 4.0f;
                        }
                    }
                    break;
                }
                case effectStart: {
                    effect = FConfig.effects.get(text).get();
                    effect.endToken = "/" + text;
                    break;
                }
            }
            TokenEntry entry = new TokenEntry(text, tokenCategory, index + indexOffset - 1, floatValue, stringValue);
            entry.effect = effect;
            label.tokenEntries.add(entry);
            return "{" + text + "}";
        });
    }

    private static void parseAllTokens(FLabel label, boolean square, Intc2 handler) {
        StringBuilder text = label.getText();
        block0: for (int i = 0; i < text.length(); ++i) {
            char end;
            char c = text.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            char c2 = c == '[' ? (char)']' : (end = c == '{' ? (char)'}' : '_');
            if (end == 95) continue;
            for (int j = i + 1; j < text.length() && text.charAt(j) != c; ++j) {
                if (text.charAt(j) != end) continue;
                handler.get(i + 1, j);
                i = j;
                continue block0;
            }
        }
    }

    private static void stripTokens(FLabel label) {
        FParser.baseParse(label, (text, index) -> "");
        FParser.parseAllTokens(label, true, (from, to) -> {});
    }

    private static String getResetReplacement() {
        Seq<String> tokens = new Seq<String>();
        FConfig.effects.keys().toSeq(tokens);
        tokens.replace(m -> "/" + m);
        tokens.add("clear");
        tokens.add("normal");
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append("{").append(token).append('}');
        }
        return sb.toString();
    }

    static class TokenEntry
    implements Comparable<TokenEntry> {
        String token;
        TokenCategory category;
        int index;
        float floatValue;
        String stringValue;
        FEffect effect;

        TokenEntry(String token, TokenCategory category, int index, float floatValue, String stringValue) {
            this.token = token;
            this.category = category;
            this.index = index;
            this.floatValue = floatValue;
            this.stringValue = stringValue;
        }

        @Override
        public int compareTo(TokenEntry o) {
            return Integer.compare(this.index, o.index);
        }
    }

    public static enum TokenCategory {
        wait,
        speed,
        color,
        variable,
        event,
        reset,
        skip,
        effectStart,
        effectEnd;

    }

    static enum InternalToken {
        wait(TokenCategory.wait),
        speed(TokenCategory.speed),
        slower(TokenCategory.speed),
        slow(TokenCategory.speed),
        normal(TokenCategory.speed),
        fast(TokenCategory.speed),
        faster(TokenCategory.speed),
        color(TokenCategory.color),
        clearcolor(TokenCategory.color),
        endcolor(TokenCategory.color),
        var(TokenCategory.variable),
        event(TokenCategory.event),
        reset(TokenCategory.reset),
        skip(TokenCategory.skip);

        final String name = this.name();
        final TokenCategory category;
        static final InternalToken[] all;

        private InternalToken(TokenCategory category) {
            this.category = category;
        }

        public String toString() {
            return this.name;
        }

        static InternalToken fromName(String name) {
            if (name != null) {
                for (InternalToken token : all) {
                    if (!name.equalsIgnoreCase(token.name)) continue;
                    return token;
                }
            }
            return null;
        }

        static {
            all = InternalToken.values();
        }
    }

    private static interface TokenHandler {
        public String handle(String var1, int var2);
    }
}

