/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.files.Fi;
import arc.graphics.GLTexture;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.graphics.gl.FileTextureData;
import arc.graphics.gl.PixmapTextureData;

public class Texture
extends GLTexture {
    TextureData data;

    public Texture(String internalPath) {
        this(Core.files.internal(internalPath));
    }

    public Texture(Fi file) {
        this(file, false);
    }

    public Texture(Fi file, boolean useMipMaps) {
        this(TextureData.load(file, useMipMaps));
    }

    public Texture(Pixmap pixmap) {
        this(new PixmapTextureData(pixmap, false, false));
    }

    public Texture(Pixmap pixmap, boolean useMipMaps) {
        this(new PixmapTextureData(pixmap, useMipMaps, false));
    }

    public Texture(int width, int height) {
        this(new PixmapTextureData(new Pixmap(width, height), false, true));
    }

    public Texture(TextureData data) {
        this(3553, Gl.genTexture(), data);
    }

    protected Texture() {
        super(0, 0);
    }

    protected Texture(int glTarget, int glHandle, TextureData data) {
        super(glTarget, glHandle);
        this.load(data);
    }

    public static Texture createEmpty(TextureData data) {
        Texture tex = new Texture();
        tex.data = data;
        return tex;
    }

    public void load(TextureData data) {
        this.data = data;
        this.width = data.getWidth();
        this.height = data.getHeight();
        if (!data.isPrepared()) {
            data.prepare();
        }
        this.bind();
        Texture.uploadImageData(3553, data);
        this.unsafeSetFilter(this.minFilter, this.magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        Gl.bindTexture(this.glTarget, 0);
    }

    public void draw(Pixmap pixmap) {
        this.draw(pixmap, 0, 0);
    }

    public void draw(Pixmap pixmap, int x, int y) {
        this.bind();
        Gl.texSubImage2D(this.glTarget, 0, x, y, pixmap.width, pixmap.height, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
    }

    @Override
    public int getDepth() {
        return 0;
    }

    public TextureData getTextureData() {
        return this.data;
    }

    @Override
    public boolean isDisposed() {
        return this.glHandle == 0;
    }

    public String toString() {
        if (this.data instanceof FileTextureData) {
            return this.data.toString();
        }
        return super.toString();
    }

    public static enum TextureWrap {
        mirroredRepeat(33648),
        clampToEdge(33071),
        repeat(10497);

        public static final TextureWrap[] all;
        final int glEnum;

        private TextureWrap(int glEnum) {
            this.glEnum = glEnum;
        }

        public int getGLEnum() {
            return this.glEnum;
        }

        static {
            all = TextureWrap.values();
        }
    }

    public static enum TextureFilter {
        nearest(9728),
        linear(9729),
        mipMap(9987),
        mipMapNearestNearest(9984),
        mipMapLinearNearest(9985),
        mipMapNearestLinear(9986),
        mipMapLinearLinear(9987);

        public static final TextureFilter[] all;
        public final int glEnum;

        private TextureFilter(int glEnum) {
            this.glEnum = glEnum;
        }

        public boolean isMipMap() {
            return this.glEnum != 9728 && this.glEnum != 9729;
        }

        static {
            all = TextureFilter.values();
        }
    }
}

