/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.gl.IndexData;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IndexBufferObject
implements IndexData {
    final ShortBuffer buffer;
    final ByteBuffer byteBuffer;
    final boolean isDirect;
    final int usage;
    final boolean empty;
    int bufferHandle;
    boolean dirty = true;
    boolean bound = false;

    public IndexBufferObject(int maxIndices) {
        this(true, maxIndices);
    }

    public IndexBufferObject(boolean isStatic, int maxIndices) {
        boolean bl = this.empty = maxIndices == 0;
        if (this.empty) {
            maxIndices = 1;
        }
        this.byteBuffer = Buffers.newUnsafeByteBuffer(maxIndices * 2);
        this.isDirect = true;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = Gl.genBuffer();
        this.usage = isStatic ? 35044 : 35048;
    }

    @Override
    public int size() {
        return this.empty ? 0 : this.buffer.limit();
    }

    @Override
    public int max() {
        return this.empty ? 0 : this.buffer.capacity();
    }

    @Override
    public void set(short[] indices, int offset, int count) {
        this.dirty = true;
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(count << 1);
        if (this.bound) {
            Gl.bufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.dirty = false;
        }
    }

    @Override
    public void set(ShortBuffer indices) {
        this.dirty = true;
        int pos = indices.position();
        this.buffer.clear();
        this.buffer.put(indices);
        this.buffer.flip();
        indices.position(pos);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 1);
        if (this.bound) {
            Gl.bufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.dirty = false;
        }
    }

    @Override
    public void update(int targetOffset, short[] indices, int offset, int count) {
        this.dirty = true;
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 2);
        Buffers.copy(indices, offset, (Buffer)this.byteBuffer, count);
        this.byteBuffer.position(pos);
        this.buffer.position(0);
        if (this.bound) {
            Gl.bufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.dirty = false;
        }
    }

    @Override
    public ShortBuffer buffer() {
        this.dirty = true;
        return this.buffer;
    }

    @Override
    public void bind() {
        if (this.bufferHandle == 0) {
            throw new ArcRuntimeException("No buffer allocated!");
        }
        Gl.bindBuffer(34963, this.bufferHandle);
        if (this.dirty) {
            this.byteBuffer.limit(this.buffer.limit() * 2);
            Gl.bufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.dirty = false;
        }
        this.bound = true;
    }

    @Override
    public void unbind() {
        Gl.bindBuffer(34963, 0);
        this.bound = false;
    }

    @Override
    public void dispose() {
        Gl.bindBuffer(34963, 0);
        Gl.deleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        Buffers.disposeUnsafeByteBuffer(this.byteBuffer);
    }
}

