/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.util.ArcRuntimeException;

public class MipMapGenerator {
    private static boolean useHWMipMap = true;

    private MipMapGenerator() {
    }

    public static void setUseHardwareMipMap(boolean useHWMipMap) {
        MipMapGenerator.useHWMipMap = useHWMipMap;
    }

    public static void generateMipMap(Pixmap pixmap, int textureWidth, int textureHeight) {
        MipMapGenerator.generateMipMap(3553, pixmap, textureWidth, textureHeight);
    }

    public static void generateMipMap(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        if (!useHWMipMap) {
            MipMapGenerator.generateMipMapCPU(target, pixmap, textureWidth, textureHeight);
            return;
        }
        if (Core.app.isAndroid() || Core.app.isWeb() || Core.app.isIOS()) {
            MipMapGenerator.generateMipMapGLES20(target, pixmap);
        } else {
            MipMapGenerator.generateMipMapDesktop(target, pixmap, textureWidth, textureHeight);
        }
    }

    private static void generateMipMapGLES20(int target, Pixmap pixmap) {
        Gl.texImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
        Gl.generateMipmap(target);
    }

    private static void generateMipMapDesktop(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        if (Core.graphics.supportsExtension("GL_ARB_framebuffer_object") || Core.graphics.supportsExtension("GL_EXT_framebuffer_object") || Core.gl30 != null) {
            Gl.texImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
            Gl.generateMipmap(target);
        } else {
            MipMapGenerator.generateMipMapCPU(target, pixmap, textureWidth, textureHeight);
        }
    }

    private static void generateMipMapCPU(int target, Pixmap pixmap, int textureWidth, int textureHeight) {
        Gl.texImage2D(target, 0, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
        if (Core.gl20 == null && textureWidth != textureHeight) {
            throw new ArcRuntimeException("texture width and height must be square when using mipmapping.");
        }
        int width = pixmap.width / 2;
        int height = pixmap.height / 2;
        int level = 1;
        while (width > 0 && height > 0) {
            Pixmap tmp = new Pixmap(width, height);
            tmp.draw(pixmap, 0, 0, pixmap.width, pixmap.height, 0, 0, width, height);
            if (level > 1) {
                pixmap.dispose();
            }
            pixmap = tmp;
            Gl.texImage2D(target, level, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
            width = pixmap.width / 2;
            height = pixmap.height / 2;
            ++level;
        }
    }
}

