/*
 * Decompiled with CFR 0.152.
 */
package arc.net;

import arc.math.Rand;
import arc.net.ArcNet;
import arc.net.ArcNetException;
import arc.net.Connection;
import arc.net.DcReason;
import arc.net.EndPoint;
import arc.net.FrameworkMessage;
import arc.net.NetListener;
import arc.net.NetSerializer;
import arc.net.ServerDiscoveryHandler;
import arc.net.UdpConnection;
import arc.struct.IntMap;
import arc.util.Structs;
import arc.util.Threads;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class Server
implements EndPoint {
    private final NetSerializer serializer;
    private final int writeBufferSize;
    private final int objectBufferSize;
    private final Selector selector;
    private int emptySelects;
    private ServerSocketChannel serverChannel;
    private UdpConnection udp;
    private Connection[] connections = new Connection[0];
    private IntMap<Connection> pendingConnections = new IntMap();
    NetListener[] listeners = new NetListener[0];
    private Object listenerLock = new Object();
    private volatile boolean shutdown;
    private final Object updateLock = new Object();
    private Thread updateThread;
    private int multicastPort = 21010;
    protected InetAddress multicastGroup;
    protected DiscoveryReceiver discoveryReceiver;
    protected ServerDiscoveryHandler discoveryHandler;
    private ServerConnectFilter connectFilter;
    private NetListener dispatchListener = new NetListener(){

        @Override
        public void connected(Connection connection) {
            NetListener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].connected(connection);
            }
        }

        @Override
        public void disconnected(Connection connection, DcReason reason) {
            Server.this.removeConnection(connection);
            NetListener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].disconnected(connection, reason);
            }
        }

        @Override
        public void received(Connection connection, Object object) {
            NetListener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].received(connection, object);
            }
        }

        @Override
        public void idle(Connection connection) {
            NetListener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].idle(connection);
            }
        }
    };

    public Server(int writeBufferSize, int objectBufferSize, NetSerializer serializer) {
        this.writeBufferSize = writeBufferSize;
        this.objectBufferSize = objectBufferSize;
        this.serializer = serializer;
        this.discoveryHandler = (address, handler) -> handler.respond(ByteBuffer.allocate(0));
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error opening the selector.", ex);
        }
    }

    public void setMulticast(String group, int multicastPort) {
        this.multicastPort = multicastPort;
        try {
            this.multicastGroup = InetAddress.getByName(group);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDiscoveryHandler(ServerDiscoveryHandler newDiscoveryHandler) {
        this.discoveryHandler = newDiscoveryHandler;
    }

    public void setConnectFilter(ServerConnectFilter connectFilter) {
        this.connectFilter = connectFilter;
    }

    public void bind(int tcpPort) throws IOException {
        this.bind(new InetSocketAddress(tcpPort), null);
    }

    public void bind(int tcpPort, int udpPort) throws IOException {
        this.bind(new InetSocketAddress(tcpPort), new InetSocketAddress(udpPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(InetSocketAddress tcpPort, InetSocketAddress udpPort) throws IOException {
        this.close();
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.serverChannel = this.selector.provider().openServerSocketChannel();
                this.serverChannel.socket().bind(tcpPort);
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                if (udpPort != null) {
                    this.udp = new UdpConnection(this.serializer, this.objectBufferSize);
                    this.udp.bind(this.selector, udpPort);
                }
                if (this.multicastGroup != null && (udpPort == null || this.multicastPort != udpPort.getPort())) {
                    this.discoveryReceiver = new DiscoveryReceiver(this.multicastPort);
                    this.discoveryReceiver.start();
                }
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int timeout) throws IOException {
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long startTime = System.currentTimeMillis();
        int select = timeout > 0 ? this.selector.select(timeout) : this.selector.selectNow();
        if (select == 0) {
            ++this.emptySelects;
            if (this.emptySelects == 100) {
                this.emptySelects = 0;
                long elapsedTime = System.currentTimeMillis() - startTime;
                try {
                    if (elapsedTime < 25L) {
                        Thread.sleep(25L - elapsedTime);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            Set<SelectionKey> keys;
            this.emptySelects = 0;
            Set<SelectionKey> set = keys = this.selector.selectedKeys();
            synchronized (set) {
                UdpConnection udp = this.udp;
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    this.keepAlive();
                    SelectionKey selectionKey = iter.next();
                    iter.remove();
                    Connection fromConnection = (Connection)selectionKey.attachment();
                    try {
                        Object object2;
                        Connection[] connections;
                        InetSocketAddress fromAddress;
                        int ops = selectionKey.readyOps();
                        if (fromConnection != null) {
                            if (udp != null && fromConnection.udpRemoteAddress == null) {
                                fromConnection.close(DcReason.error);
                                continue;
                            }
                            if ((ops & 1) == 1) {
                                try {
                                    Object object3;
                                    while ((object3 = fromConnection.tcp.readObject()) != null) {
                                        fromConnection.notifyReceived(object3);
                                    }
                                }
                                catch (ArcNetException | IOException ex) {
                                    ArcNet.handleError(new ArcNetException("Error reading TCP from connection: " + fromConnection, ex));
                                    fromConnection.close(ex.getMessage() != null && ex.getMessage().contains("closed") ? DcReason.closed : DcReason.error);
                                }
                            }
                            if ((ops & 4) != 4) continue;
                            try {
                                fromConnection.tcp.writeOperation();
                            }
                            catch (IOException ex) {
                                fromConnection.close(ex.getMessage() != null && ex.getMessage().contains("closed") ? DcReason.closed : DcReason.error);
                            }
                            continue;
                        }
                        if ((ops & 0x10) == 16) {
                            ServerSocketChannel serverChannel = this.serverChannel;
                            if (serverChannel == null) continue;
                            try {
                                SocketChannel socketChannel = serverChannel.accept();
                                if (socketChannel == null) continue;
                                this.acceptOperation(socketChannel);
                            }
                            catch (IOException ex) {
                                ArcNet.handleError(ex);
                            }
                            continue;
                        }
                        if (udp == null) {
                            selectionKey.channel().close();
                            continue;
                        }
                        try {
                            fromAddress = udp.readFromAddress();
                        }
                        catch (IOException ex) {
                            ArcNet.handleError(ex);
                            continue;
                        }
                        if (fromAddress == null) continue;
                        for (Connection connection : connections = this.connections) {
                            if (!fromAddress.equals(connection.udpRemoteAddress)) continue;
                            fromConnection = connection;
                            break;
                        }
                        try {
                            object2 = udp.readObject();
                        }
                        catch (ArcNetException ex) {
                            ArcNet.handleError(new ArcNetException("Error reading UDP from connection: " + (fromConnection == null ? fromAddress : fromAddress), ex));
                            continue;
                        }
                        if (object2 instanceof FrameworkMessage) {
                            if (object2 instanceof FrameworkMessage.RegisterUDP) {
                                int fromConnectionID = ((FrameworkMessage.RegisterUDP)object2).connectionID;
                                Connection connection = this.pendingConnections.remove(fromConnectionID);
                                if (connection == null || connection.udpRemoteAddress != null) continue;
                                connection.udpRemoteAddress = fromAddress;
                                this.addConnection(connection);
                                connection.sendTCP(new FrameworkMessage.RegisterUDP());
                                connection.notifyConnected();
                                continue;
                            }
                            if (object2 instanceof FrameworkMessage.DiscoverHost) {
                                try {
                                    this.discoveryHandler.onDiscoverReceived(fromAddress.getAddress(), buff -> udp.datagramChannel.send(buff, fromAddress));
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                        }
                        if (fromConnection == null) continue;
                        fromConnection.notifyReceived(object2);
                    }
                    catch (CancelledKeyException ex) {
                        if (fromConnection != null) {
                            fromConnection.close(DcReason.error);
                            continue;
                        }
                        selectionKey.channel().close();
                    }
                }
            }
        }
        long time = System.currentTimeMillis();
        for (Connection connection : this.connections) {
            if (connection.tcp.isTimedOut(time)) {
                connection.close(DcReason.timeout);
            } else if (connection.tcp.needsKeepAlive(time)) {
                connection.sendTCP(FrameworkMessage.keepAlive);
            }
            if (!connection.isIdle()) continue;
            connection.notifyIdle();
        }
    }

    private void keepAlive() {
        long time = System.currentTimeMillis();
        for (Connection connection : this.connections) {
            if (!connection.tcp.needsKeepAlive(time)) continue;
            connection.sendTCP(FrameworkMessage.keepAlive);
        }
    }

    @Override
    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException ex) {
                this.close();
            }
        }
    }

    @Override
    public void start() {
        new Thread((Runnable)this, "Server").start();
    }

    @Override
    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.close();
    }

    private void acceptOperation(SocketChannel socketChannel) {
        if (this.connectFilter != null) {
            try {
                if (!this.connectFilter.accept(((InetSocketAddress)socketChannel.getRemoteAddress()).getAddress().getHostAddress())) {
                    socketChannel.close();
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Connection connection = this.newConnection();
        connection.initialize(this.serializer, this.writeBufferSize, this.objectBufferSize);
        connection.endPoint = this;
        UdpConnection udp = this.udp;
        if (udp != null) {
            connection.udp = udp;
        }
        try {
            int id;
            SelectionKey selectionKey = connection.tcp.accept(this.selector, socketChannel);
            selectionKey.attach(connection);
            connection.id = id = this.generateId();
            connection.setConnected(true);
            connection.addListener(this.dispatchListener);
            if (udp == null) {
                this.addConnection(connection);
            } else {
                this.pendingConnections.put(id, connection);
            }
            FrameworkMessage.RegisterTCP registerConnection = new FrameworkMessage.RegisterTCP();
            registerConnection.connectionID = id;
            connection.sendTCP(registerConnection);
            if (udp == null) {
                connection.notifyConnected();
            }
        }
        catch (IOException ex) {
            connection.close(DcReason.error);
        }
    }

    private int generateId() {
        int[] id = new int[]{0};
        Rand rand = new Rand();
        do {
            id[0] = rand.nextInt();
        } while (this.pendingConnections.containsKey(id[0]) || Structs.contains(this.connections, c -> c.id == id[0]));
        return id[0];
    }

    protected Connection newConnection() {
        return new Connection();
    }

    private void addConnection(Connection connection) {
        Connection[] newConnections = new Connection[this.connections.length + 1];
        newConnections[0] = connection;
        System.arraycopy(this.connections, 0, newConnections, 1, this.connections.length);
        this.connections = newConnections;
    }

    void removeConnection(Connection connection) {
        ArrayList<Connection> temp = new ArrayList<Connection>(Arrays.asList(this.connections));
        temp.remove(connection);
        this.connections = temp.toArray(new Connection[0]);
        this.pendingConnections.remove(connection.id);
    }

    public void sendToAllTCP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendTCP(object);
        }
    }

    public void sendToAllExceptTCP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == connectionID) continue;
            connection.sendTCP(object);
        }
    }

    public void sendToTCP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != connectionID) continue;
            connection.sendTCP(object);
            break;
        }
    }

    public void sendToAllUDP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendUDP(object);
        }
    }

    public void sendToAllExceptUDP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == connectionID) continue;
            connection.sendUDP(object);
        }
    }

    public void sendToUDP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != connectionID) continue;
            connection.sendUDP(object);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(NetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            NetListener[] listeners = this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listeners[i]) continue;
                return;
            }
            NetListener[] newListeners = new NetListener[n + 1];
            newListeners[0] = listener;
            System.arraycopy(listeners, 0, newListeners, 1, n);
            this.listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(NetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            NetListener[] listeners = this.listeners;
            int n = listeners.length;
            NetListener[] newListeners = new NetListener[n - 1];
            int ii = 0;
            for (int i = 0; i < n; ++i) {
                NetListener copyListener = listeners[i];
                if (listener == copyListener) continue;
                if (ii == n - 1) {
                    return;
                }
                newListeners[ii++] = copyListener;
            }
            this.listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        UdpConnection udp;
        Connection[] connections = this.connections;
        int n2 = connections.length;
        for (int i = 0; i < n2; ++i) {
            connections[i].close(DcReason.closed);
        }
        this.connections = new Connection[0];
        ServerSocketChannel serverChannel = this.serverChannel;
        if (serverChannel != null) {
            try {
                serverChannel.close();
            }
            catch (IOException n2) {
                // empty catch block
            }
            this.serverChannel = null;
        }
        if (this.discoveryReceiver != null) {
            this.discoveryReceiver.close();
            this.discoveryReceiver = null;
        }
        if ((udp = this.udp) != null) {
            udp.close();
            this.udp = null;
        }
        Object object = this.updateLock;
        synchronized (object) {
        }
        this.selector.wakeup();
        try {
            this.selector.selectNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() throws IOException {
        this.close();
        this.selector.close();
    }

    @Override
    public Thread getUpdateThread() {
        return this.updateThread;
    }

    public Connection[] getConnections() {
        return this.connections;
    }

    public static interface ServerConnectFilter {
        public boolean accept(String var1);
    }

    class DiscoveryReceiver {
        MulticastSocket socket = null;
        Thread multicastThread;
        int multicastPort;

        DiscoveryReceiver(int multicastPort) {
            this.multicastPort = multicastPort;
        }

        void close() {
            try {
                if (this.multicastThread != null) {
                    this.multicastThread.interrupt();
                }
                if (this.socket != null) {
                    this.socket.leaveGroup(Server.this.multicastGroup);
                    this.socket.close();
                }
            }
            catch (IOException e) {
                ArcNet.handleError(e);
            }
        }

        void start() {
            this.multicastThread = Threads.daemon("Server Multicast Discovery", () -> {
                try {
                    this.socket = new MulticastSocket(this.multicastPort);
                    this.socket.joinGroup(Server.this.multicastGroup);
                    DatagramPacket packet = new DatagramPacket(new byte[512], 512);
                    while (true) {
                        this.socket.receive(packet);
                        Server.this.discoveryHandler.onDiscoverReceived(packet.getAddress(), buffer -> {
                            byte[] data = buffer.array();
                            DatagramPacket out = new DatagramPacket(data, data.length);
                            out.setSocketAddress(packet.getSocketAddress());
                            this.socket.send(out);
                        });
                    }
                }
                catch (IOException e) {
                    ArcNet.handleError(e);
                    return;
                }
            });
        }
    }
}

