/*
 * Decompiled with CFR 0.152.
 */
package arc.net.dns;

import arc.files.Fi;
import arc.net.dns.AbstractNameserverProvider;
import arc.util.OS;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;

public final class ResolvConfNameserverProvider
extends AbstractNameserverProvider {
    @Override
    public void initialize() {
        this.reset();
        if (!this.tryParseResolveConf("/etc/resolv.conf")) {
            this.tryParseResolveConf("sys:/etc/resolv.cfg");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryParseResolveConf(String path) {
        Fi conf = new Fi(path);
        if (!conf.exists()) return false;
        try (BufferedReader reader = conf.reader(1024);){
            String line;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equals("nameserver")) continue;
                this.addNameServer(new InetSocketAddress(tokenizer.nextToken(), 53));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return !OS.isWindows && !OS.isAndroid;
    }
}

