/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.Input;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.event.ChangeListener;
import arc.scene.event.ClickListener;
import arc.scene.event.IbeamCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.TextArea;
import arc.scene.utils.Disableable;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.OS;
import arc.util.Time;
import arc.util.Timer;
import arc.util.Tmp;
import arc.util.pooling.Pools;

public class TextField
extends Element
implements Disableable {
    protected static final char BACKSPACE = '\b';
    protected static final char TAB = '\t';
    protected static final char DELETE = '\u007f';
    protected static final char BULLET = '\u0095';
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    private static final Vec2 tmp3 = new Vec2();
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.1f;
    public Object imeData;
    protected final GlyphLayout layout = new GlyphLayout(true);
    protected final FloatSeq glyphPositions = new FloatSeq();
    protected String text;
    protected int cursor;
    protected int selectionStart;
    protected boolean hasSelection;
    protected boolean writeEnters;
    protected CharSequence displayText;
    protected float fontOffset;
    protected float textHeight;
    protected float textOffset;
    protected InputListener inputDialogListener;
    protected TextFieldStyle style;
    protected InputListener inputListener;
    protected TextFieldListener listener;
    protected TextFieldValidator validator;
    protected TextFieldFilter filter;
    protected boolean focusTraversal = true;
    protected boolean onlyFontChars = true;
    protected boolean disabled;
    protected String undoText = "";
    protected long lastChangeTime;
    protected boolean passwordMode;
    protected float renderOffset;
    protected boolean cursorOn = true;
    protected boolean hasInputDialog = false;
    protected long lastBlink;
    protected KeyRepeatTask keyRepeatTask = new KeyRepeatTask();
    protected boolean programmaticChangeEvents;
    protected String messageText;
    protected int textHAlign = 8;
    protected float selectionX;
    protected float selectionWidth;
    protected StringBuilder passwordBuffer;
    protected char passwordCharacter = (char)149;
    protected int visibleTextStart;
    protected int visibleTextEnd;
    protected int maxLength = 0;
    protected float blinkTime = 0.32f;

    public TextField() {
        this("");
    }

    public TextField(String text) {
        this(text, Core.scene.getStyle(TextFieldStyle.class));
    }

    public TextField(String text, TextFieldStyle style) {
        this.setStyle(style);
        this.initialize();
        this.setText(text);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected void initialize() {
        this.inputListener = this.createInputListener();
        this.addListener(this.inputListener);
        this.addListener(new IbeamCursorListener());
        this.addInputDialog();
    }

    protected InputListener createInputListener() {
        return new TextFieldClickListener();
    }

    protected int letterUnderCursor(float x) {
        x -= this.textOffset + this.fontOffset - this.style.font.getData().cursorX - this.glyphPositions.get(this.visibleTextStart);
        Drawable background = this.getBackgroundDrawable();
        if (background != null) {
            x -= this.style.background.getLeftWidth();
        }
        int n = this.glyphPositions.size;
        float[] glyphPositions = this.glyphPositions.items;
        for (int i = 1; i < n; ++i) {
            if (!(glyphPositions[i] > x)) continue;
            if (glyphPositions[i] - x <= x - glyphPositions[i - 1]) {
                return i;
            }
            return i - 1;
        }
        return n - 1;
    }

    protected boolean isWordCharacter(char c) {
        return Character.isLetterOrDigit(c);
    }

    protected int[] wordUnderCursor(int at) {
        String text = this.text;
        int right = text.length();
        int left = 0;
        if (at >= text.length()) {
            left = text.length();
            right = 0;
        } else {
            int index;
            for (index = at; index < right; ++index) {
                if (this.isWordCharacter(text.charAt(index))) continue;
                right = index;
                break;
            }
            for (index = at - 1; index > -1; --index) {
                if (this.isWordCharacter(text.charAt(index))) continue;
                left = index + 1;
                break;
            }
        }
        return new int[]{left, right};
    }

    int[] wordUnderCursor(float x) {
        return this.wordUnderCursor(this.letterUnderCursor(x));
    }

    boolean withinMaxLength(int size) {
        return this.maxLength <= 0 || size < this.maxLength;
    }

    public void removeInputDialog() {
        if (this.hasInputDialog && this.inputDialogListener != null) {
            this.removeListener(this.inputDialogListener);
            this.hasInputDialog = false;
        }
    }

    public void addInputDialog() {
        if (!Core.app.isMobile() || this.hasInputDialog) {
            return;
        }
        this.hasInputDialog = true;
        this.inputDialogListener = this.tapped(() -> {
            if (Core.input.useKeyboard()) {
                return;
            }
            Input.TextInput input = new Input.TextInput();
            input.text = this.getText();
            if (this.maxLength > 0) {
                input.maxLength = this.maxLength;
            }
            input.multiline = this instanceof TextArea;
            input.accepted = text -> {
                this.clearText();
                this.appendText((String)text);
                this.change();
                Core.input.setOnscreenKeyboardVisible(false);
            };
            input.canceled = () -> {
                if (this.hasKeyboard()) {
                    Core.scene.setKeyboardFocus(null);
                }
                Core.input.setOnscreenKeyboardVisible(false);
            };
            Core.input.getTextInput(input);
        });
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void clearText() {
        this.setText("");
    }

    public void setOnlyFontChars(boolean onlyFontChars) {
        this.onlyFontChars = onlyFontChars;
    }

    public TextFieldStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextFieldStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.textHeight = style.font.getCapHeight() - style.font.getDescent() * 2.0f;
        this.invalidateHierarchy();
    }

    protected void calculateOffsets() {
        float x;
        float visibleWidth = this.getWidth();
        Drawable background = this.getBackgroundDrawable();
        if (background != null) {
            visibleWidth -= background.getLeftWidth() + background.getRightWidth();
        }
        int glyphCount = this.glyphPositions.size;
        float[] glyphPositions = this.glyphPositions.items;
        this.cursor = Mathf.clamp(this.cursor, 0, glyphPositions.length - 1);
        float distance = glyphPositions[Math.max(0, this.cursor - 1)] + this.renderOffset;
        if (distance <= 0.0f) {
            this.renderOffset -= distance;
        } else {
            int index = Math.min(glyphCount - 1, this.cursor + 1);
            float minX = glyphPositions[index] - visibleWidth;
            if (-this.renderOffset < minX) {
                this.renderOffset = -minX;
            }
        }
        float maxOffset = 0.0f;
        float width = glyphPositions[Mathf.clamp(glyphCount - 1, 0, glyphPositions.length - 1)];
        for (int i = glyphCount - 2; i >= 0 && !(width - (x = glyphPositions[i]) > visibleWidth); --i) {
            maxOffset = x;
        }
        if (-this.renderOffset > maxOffset) {
            this.renderOffset = -maxOffset;
        }
        this.visibleTextStart = 0;
        float startX = 0.0f;
        for (int i = 0; i < glyphCount; ++i) {
            if (!(glyphPositions[i] >= -this.renderOffset)) continue;
            this.visibleTextStart = Math.max(0, i);
            startX = glyphPositions[i];
            break;
        }
        int length = Math.min(this.displayText.length(), glyphPositions.length - 1);
        this.visibleTextEnd = Math.min(length, this.cursor + 1);
        while (this.visibleTextEnd <= length && !(glyphPositions[this.visibleTextEnd] > startX + visibleWidth)) {
            ++this.visibleTextEnd;
        }
        this.visibleTextEnd = Math.max(0, this.visibleTextEnd - 1);
        if ((this.textHAlign & 8) == 0) {
            this.textOffset = visibleWidth - (glyphPositions[this.visibleTextEnd] - startX);
            if ((this.textHAlign & 1) != 0) {
                this.textOffset = Math.round(this.textOffset * 0.5f);
            }
        } else {
            this.textOffset = startX + this.renderOffset;
        }
        if (this.hasSelection) {
            int minIndex = Math.min(this.cursor, this.selectionStart);
            int maxIndex = Math.max(this.cursor, this.selectionStart);
            float minX = Math.max(glyphPositions[minIndex] - glyphPositions[this.visibleTextStart], -this.textOffset);
            float maxX = Math.min(glyphPositions[maxIndex] - glyphPositions[this.visibleTextStart], visibleWidth - this.textOffset);
            this.selectionX = minX;
            this.selectionWidth = maxX - minX - this.style.font.getData().cursorX;
        }
    }

    private Drawable getBackgroundDrawable() {
        boolean focused;
        Scene stage = this.getScene();
        boolean bl = focused = stage != null && stage.getKeyboardFocus() == this;
        return this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : (!this.isValid() && this.style.invalidBackground != null ? this.style.invalidBackground : (focused && this.style.focusedBackground != null ? this.style.focusedBackground : this.style.background));
    }

    @Override
    public void draw() {
        float yOffset;
        boolean focused;
        Scene stage = this.getScene();
        boolean bl = focused = stage != null && stage.getKeyboardFocus() == this;
        if (!focused) {
            this.keyRepeatTask.cancel();
        }
        Font font = this.style.font;
        Color fontColor = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (focused && this.style.focusedFontColor != null ? this.style.focusedFontColor : this.style.fontColor);
        Drawable selection = this.style.selection;
        Drawable cursorPatch = this.style.cursor;
        Drawable background = this.getBackgroundDrawable();
        Color color = this.color;
        float x = this.x;
        float y = this.y;
        float width = this.getWidth();
        float height = this.getHeight();
        Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
        float bgLeftWidth = 0.0f;
        float bgRightWidth = 0.0f;
        if (background != null) {
            background.draw(x, y, width, height);
            bgLeftWidth = background.getLeftWidth();
            bgRightWidth = background.getRightWidth();
        }
        float textY = this.getTextY(font, background);
        this.calculateOffsets();
        if (focused && this.hasSelection && selection != null) {
            this.drawSelection(selection, font, x + bgLeftWidth, y + textY);
        }
        float f = yOffset = font.isFlipped() ? -this.textHeight : 0.0f;
        if (this.displayText.length() == 0) {
            if (!focused && this.messageText != null) {
                Font messageFont = this.style.messageFont != null ? this.style.messageFont : font;
                messageFont.getColor().write(Tmp.c1);
                if (this.style.messageFontColor != null) {
                    messageFont.setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * color.a * this.parentAlpha);
                } else {
                    messageFont.setColor(0.7f, 0.7f, 0.7f, color.a * this.parentAlpha);
                }
                boolean had = messageFont.getData().markupEnabled;
                messageFont.getData().markupEnabled = false;
                messageFont.draw(this.messageText, x + bgLeftWidth, y + textY + yOffset, 0, this.messageText.length(), width - bgLeftWidth - bgRightWidth, this.textHAlign, false, "...");
                messageFont.getData().markupEnabled = had;
                messageFont.setColor(Tmp.c1);
            }
        } else {
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * color.a * this.parentAlpha);
            this.drawText(font, x + bgLeftWidth, y + textY + yOffset);
        }
        if (focused && !this.disabled) {
            this.blink();
            if (this.cursorOn && cursorPatch != null) {
                this.drawCursor(cursorPatch, font, x + bgLeftWidth, y + textY);
            }
        }
    }

    public boolean isValid() {
        return this.validator == null || this.validator.valid(this.text);
    }

    protected float getTextY(Font font, Drawable background) {
        float height = this.getHeight();
        float textY = this.textHeight / 2.0f + font.getDescent();
        if (background != null) {
            float bottom = background.getBottomHeight();
            textY = textY + (height - background.getTopHeight() - bottom) / 2.0f + bottom;
        } else {
            textY += height / 2.0f;
        }
        if (font.usesIntegerPositions()) {
            textY = (int)textY;
        }
        return textY;
    }

    protected void drawSelection(Drawable selection, Font font, float x, float y) {
        selection.draw(x + this.textOffset + this.selectionX + this.fontOffset, y - this.textHeight - font.getDescent(), this.selectionWidth, this.textHeight);
    }

    protected void drawText(Font font, float x, float y) {
        boolean had = font.getData().markupEnabled;
        font.getData().markupEnabled = false;
        font.draw(this.displayText, x + this.textOffset, y, this.visibleTextStart, this.visibleTextEnd, 0.0f, 8, false);
        font.getData().markupEnabled = had;
    }

    protected void drawCursor(Drawable cursorPatch, Font font, float x, float y) {
        cursorPatch.draw(x + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset + font.getData().cursorX, y - this.textHeight - font.getDescent(), cursorPatch.getMinWidth(), this.textHeight);
    }

    protected void updateDisplayText() {
        Font font = this.style.font;
        Font.FontData data = font.getData();
        String text = this.text;
        int textLength = text.length();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < textLength; ++i) {
            char c = text.charAt(i);
            buffer.append(data.hasGlyph(c) ? c : (char)' ');
        }
        String newDisplayText = buffer.toString();
        if (this.passwordMode && data.hasGlyph(this.passwordCharacter)) {
            if (this.passwordBuffer == null) {
                this.passwordBuffer = new StringBuilder(newDisplayText.length());
            }
            if (this.passwordBuffer.length() > textLength) {
                this.passwordBuffer.setLength(textLength);
            } else {
                for (int i = this.passwordBuffer.length(); i < textLength; ++i) {
                    this.passwordBuffer.append(this.passwordCharacter);
                }
            }
            this.displayText = this.passwordBuffer;
        } else {
            this.displayText = newDisplayText;
        }
        this.layout.setText(font, this.displayText.toString().replace('\n', ' ').replace('\r', ' '));
        this.glyphPositions.clear();
        float x = 0.0f;
        if (this.layout.runs.size > 0) {
            GlyphLayout.GlyphRun run = this.layout.runs.first();
            FloatSeq xAdvances = run.xAdvances;
            this.fontOffset = xAdvances.first();
            int n = xAdvances.size;
            for (int i = 1; i < n; ++i) {
                this.glyphPositions.add(x);
                x += xAdvances.get(i);
            }
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(x);
        this.visibleTextStart = Math.min(this.visibleTextStart, this.glyphPositions.size);
        this.visibleTextEnd = Mathf.clamp(this.visibleTextEnd, this.visibleTextStart, this.glyphPositions.size);
        if (this.selectionStart > newDisplayText.length()) {
            this.selectionStart = textLength;
        }
    }

    private void blink() {
        if (!Core.graphics.isContinuousRendering()) {
            this.cursorOn = true;
            return;
        }
        long time = Time.nanos();
        if ((float)(time - this.lastBlink) / 1.0E9f > this.blinkTime) {
            this.cursorOn = !this.cursorOn;
            this.lastBlink = time;
        }
    }

    public void copy() {
        if (this.hasSelection && !this.passwordMode) {
            Core.app.setClipboardText(this.text.substring(Math.min(this.cursor, this.selectionStart), Math.max(this.cursor, this.selectionStart)));
        }
    }

    public void cut() {
        this.cut(this.programmaticChangeEvents);
    }

    void cut(boolean fireChangeEvent) {
        if (this.hasSelection && !this.passwordMode) {
            this.copy();
            this.cursor = this.delete(fireChangeEvent);
            this.updateDisplayText();
        }
    }

    public void paste(String content, boolean fireChangeEvent) {
        if (content == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int textLength = this.text.length();
        if (this.hasSelection) {
            textLength -= Math.abs(this.cursor - this.selectionStart);
        }
        Font.FontData data = this.style.font.getData();
        int n = content.length();
        for (int i = 0; i < n && this.withinMaxLength(textLength + buffer.length()); ++i) {
            char c = content.charAt(i);
            if (c == '\r' || (!this.writeEnters || c != '\n') && (c == '\n' || this.onlyFontChars && !data.hasGlyph(c) || this.filter != null && !this.filter.acceptChar(this, c))) continue;
            buffer.append(c);
        }
        content = buffer.toString();
        if (this.hasSelection) {
            this.cursor = this.delete(fireChangeEvent);
        }
        if (fireChangeEvent) {
            this.changeText(this.text, this.insert(this.cursor, content, this.text));
        } else {
            this.text = this.insert(this.cursor, content, this.text);
        }
        this.updateDisplayText();
        this.cursor += content.length();
    }

    String insert(int position, CharSequence text, String to) {
        if (to.length() == 0) {
            return text.toString();
        }
        return to.substring(0, position) + text + to.substring(position);
    }

    int delete(boolean fireChangeEvent) {
        int from = this.selectionStart;
        int to = this.cursor;
        int minIndex = Math.min(from, to);
        int maxIndex = Math.max(from, to);
        String newText = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex) : "");
        if (fireChangeEvent) {
            this.changeText(this.text, newText);
        } else {
            this.text = newText;
        }
        this.clearSelection();
        return minIndex;
    }

    public void next(boolean up) {
        Scene stage = this.getScene();
        if (stage == null) {
            return;
        }
        TextField current = this;
        while (true) {
            current.parent.localToStageCoordinates(tmp1.set(this.x, this.y));
            TextField textField = current.findNextTextField(stage.getElements(), null, tmp2, tmp1, up);
            if (textField == null) {
                if (up) {
                    tmp1.set(Float.MIN_VALUE, Float.MIN_VALUE);
                } else {
                    tmp1.set(Float.MAX_VALUE, Float.MAX_VALUE);
                }
                textField = current.findNextTextField(this.getScene().getElements(), null, tmp2, tmp1, up);
            }
            if (textField == null) {
                Core.input.setOnscreenKeyboardVisible(false);
                break;
            }
            if (stage.setKeyboardFocus(textField)) break;
            current = textField;
        }
    }

    private TextField findNextTextField(Seq<Element> elements, TextField best, Vec2 bestCoords, Vec2 currentCoords, boolean up) {
        int n = elements.size;
        for (int i = 0; i < n; ++i) {
            Element element = elements.get(i);
            if (element == this || !element.visible) continue;
            if (element instanceof TextField) {
                TextField textField = (TextField)element;
                if (textField.isDisabled() || !textField.focusTraversal) continue;
                Vec2 elementCoords = element.parent.localToStageCoordinates(tmp3.set(element.x, element.y));
                if (!((elementCoords.y < currentCoords.y || elementCoords.y == currentCoords.y && elementCoords.x > currentCoords.x) ^ up) || best != null && !((elementCoords.y > bestCoords.y || elementCoords.y == bestCoords.y && elementCoords.x < bestCoords.x) ^ up)) continue;
                best = (TextField)element;
                bestCoords.set(elementCoords);
                continue;
            }
            if (!(element instanceof Group)) continue;
            best = this.findNextTextField(((Group)element).getChildren(), best, bestCoords, currentCoords, up);
        }
        return best;
    }

    public InputListener getDefaultInputListener() {
        return this.inputListener;
    }

    public void setTextFieldListener(TextFieldListener listener) {
        this.listener = listener;
    }

    public void typed(char ch, Runnable run) {
        this.setTextFieldListener((textField, c) -> {
            if (c == ch) {
                run.run();
            }
        });
    }

    public void typed(Cons<Character> cons) {
        this.setTextFieldListener((textField, c) -> cons.get(Character.valueOf(c)));
    }

    public TextFieldFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TextFieldFilter filter) {
        this.filter = filter;
    }

    public void setValidator(TextFieldValidator validator) {
        this.validator = validator;
    }

    public TextFieldValidator getValidator() {
        return this.validator;
    }

    public void setFocusTraversal(boolean focusTraversal) {
        this.focusTraversal = focusTraversal;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText != null && (messageText.startsWith("$") || messageText.startsWith("@")) && Core.bundle != null && Core.bundle.has(messageText.substring(1)) ? Core.bundle.get(messageText.substring(1)) : messageText;
    }

    public void appendText(String str) {
        if (str == null) {
            str = "";
        }
        this.clearSelection();
        this.cursor = this.text.length();
        this.paste(str, this.programmaticChangeEvents);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.clearSelection();
        String oldText = this.text;
        this.text = "";
        this.paste(str, false);
        if (this.programmaticChangeEvents) {
            this.changeText(oldText, this.text);
        }
        this.cursor = 0;
    }

    boolean changeText(String oldText, String newText) {
        if (newText.equals(oldText)) {
            return false;
        }
        this.text = newText;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class, ChangeListener.ChangeEvent::new);
        boolean cancelled = this.fire(changeEvent);
        this.text = cancelled ? oldText : newText;
        Pools.free(changeEvent);
        return !cancelled;
    }

    public boolean getProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getSelection() {
        return this.hasSelection ? this.text.substring(Math.min(this.selectionStart, this.cursor), Math.max(this.selectionStart, this.cursor)) : "";
    }

    public void setSelection(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            throw new IllegalArgumentException("selectionStart must be >= 0");
        }
        if (selectionEnd < 0) {
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        selectionStart = Math.min(this.text.length(), selectionStart);
        selectionEnd = Math.min(this.text.length(), selectionEnd);
        if (selectionEnd == selectionStart) {
            this.clearSelection();
            return;
        }
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        this.hasSelection = true;
        this.selectionStart = selectionStart;
        this.cursor = selectionEnd;
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void clearSelection() {
        this.hasSelection = false;
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.cursor = Math.min(cursorPosition, this.text.length());
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        float topAndBottom = 0.0f;
        float minHeight = 0.0f;
        if (this.style.background != null) {
            topAndBottom = Math.max(topAndBottom, this.style.background.getBottomHeight() + this.style.background.getTopHeight());
            minHeight = Math.max(minHeight, this.style.background.getMinHeight());
        }
        if (this.style.focusedBackground != null) {
            topAndBottom = Math.max(topAndBottom, this.style.focusedBackground.getBottomHeight() + this.style.focusedBackground.getTopHeight());
            minHeight = Math.max(minHeight, this.style.focusedBackground.getMinHeight());
        }
        if (this.style.disabledBackground != null) {
            topAndBottom = Math.max(topAndBottom, this.style.disabledBackground.getBottomHeight() + this.style.disabledBackground.getTopHeight());
            minHeight = Math.max(minHeight, this.style.disabledBackground.getMinHeight());
        }
        return Math.max(topAndBottom + this.textHeight, minHeight);
    }

    public void setAlignment(int alignment) {
        this.textHAlign = alignment;
    }

    public boolean isPasswordMode() {
        return this.passwordMode;
    }

    public void setPasswordMode(boolean passwordMode) {
        this.passwordMode = passwordMode;
        this.updateDisplayText();
    }

    public void setPasswordCharacter(char passwordCharacter) {
        this.passwordCharacter = passwordCharacter;
        if (this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public void setBlinkTime(float blinkTime) {
        this.blinkTime = blinkTime;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    protected void moveCursor(boolean forward, boolean jump) {
        int charOffset;
        int limit = forward ? this.text.length() : 0;
        int n = charOffset = forward ? 0 : -1;
        while ((forward ? ++this.cursor < limit : --this.cursor > limit) && jump && this.continueCursor(this.cursor, charOffset)) {
        }
    }

    protected boolean continueCursor(int index, int offset) {
        char c = this.text.charAt(index + offset);
        return this.isWordCharacter(c);
    }

    public class TextFieldClickListener
    extends ClickListener {
        @Override
        public void clicked(InputEvent event, float x, float y) {
            if (TextField.this.imeData != null) {
                return;
            }
            int count = this.getTapCount() % 4;
            if (count == 0) {
                TextField.this.clearSelection();
            }
            if (count == 2) {
                int[] array = TextField.this.wordUnderCursor(x);
                TextField.this.setSelection(array[0], array[1]);
            }
            if (count == 3) {
                TextField.this.selectAll();
            }
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
            if (!super.touchDown(event, x, y, pointer, button)) {
                return false;
            }
            if (pointer == 0 && button != KeyCode.mouseLeft) {
                return false;
            }
            if (TextField.this.disabled || TextField.this.imeData != null) {
                return true;
            }
            this.setCursorPosition(x, y);
            TextField.this.selectionStart = TextField.this.cursor;
            Scene stage = TextField.this.getScene();
            if (stage != null) {
                stage.setKeyboardFocus(TextField.this);
            }
            if (!TextField.this.hasInputDialog) {
                Core.input.setOnscreenKeyboardVisible(true);
            }
            TextField.this.hasSelection = true;
            return true;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            super.touchDragged(event, x, y, pointer);
            this.setCursorPosition(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
            if (TextField.this.selectionStart == TextField.this.cursor) {
                TextField.this.hasSelection = false;
            }
            super.touchUp(event, x, y, pointer, button);
        }

        protected void setCursorPosition(float x, float y) {
            TextField.this.lastBlink = 0L;
            TextField.this.cursorOn = false;
            TextField.this.cursor = TextField.this.letterUnderCursor(x);
        }

        protected void goHome(boolean jump) {
            TextField.this.cursor = 0;
        }

        protected void goEnd(boolean jump) {
            TextField.this.cursor = TextField.this.text.length();
        }

        @Override
        public boolean keyDown(InputEvent event, KeyCode keycode) {
            boolean repeat;
            block24: {
                boolean jump;
                block19: {
                    int temp;
                    block21: {
                        block23: {
                            block22: {
                                block20: {
                                    if (TextField.this.disabled) {
                                        return false;
                                    }
                                    if (TextField.this.imeData != null) {
                                        return true;
                                    }
                                    TextField.this.lastBlink = 0L;
                                    TextField.this.cursorOn = false;
                                    Scene stage = TextField.this.getScene();
                                    if (stage == null || stage.getKeyboardFocus() != TextField.this) {
                                        return false;
                                    }
                                    repeat = false;
                                    boolean ctrl = Core.input.ctrl() && !Core.input.alt();
                                    boolean bl = jump = ctrl && !TextField.this.passwordMode;
                                    if (ctrl) {
                                        if (keycode == KeyCode.v) {
                                            TextField.this.paste(Core.app.getClipboardText(), true);
                                            repeat = true;
                                        }
                                        if (keycode == KeyCode.c || keycode == KeyCode.insert) {
                                            TextField.this.copy();
                                            return true;
                                        }
                                        if (keycode == KeyCode.x) {
                                            TextField.this.cut(true);
                                            return true;
                                        }
                                        if (keycode == KeyCode.a) {
                                            TextField.this.selectAll();
                                            return true;
                                        }
                                        if (keycode == KeyCode.z) {
                                            String oldText = TextField.this.text;
                                            TextField.this.setText(TextField.this.undoText);
                                            TextField.this.undoText = oldText;
                                            TextField.this.updateDisplayText();
                                            return true;
                                        }
                                    }
                                    if (!Core.input.shift()) break block19;
                                    if (keycode == KeyCode.insert) {
                                        TextField.this.paste(Core.app.getClipboardText(), true);
                                    }
                                    if (keycode == KeyCode.forwardDel) {
                                        TextField.this.cut(true);
                                    }
                                    temp = TextField.this.cursor;
                                    if (keycode != KeyCode.left) break block20;
                                    TextField.this.moveCursor(false, jump);
                                    repeat = true;
                                    break block21;
                                }
                                if (keycode != KeyCode.right) break block22;
                                TextField.this.moveCursor(true, jump);
                                repeat = true;
                                break block21;
                            }
                            if (keycode != KeyCode.home) break block23;
                            this.goHome(jump);
                            break block21;
                        }
                        if (keycode != KeyCode.end) break block24;
                        this.goEnd(jump);
                    }
                    if (!TextField.this.hasSelection) {
                        TextField.this.selectionStart = temp;
                        TextField.this.hasSelection = true;
                    }
                    break block24;
                }
                if (keycode == KeyCode.left) {
                    TextField.this.moveCursor(false, jump);
                    TextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == KeyCode.right) {
                    TextField.this.moveCursor(true, jump);
                    TextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == KeyCode.home) {
                    this.goHome(jump);
                    TextField.this.clearSelection();
                }
                if (keycode == KeyCode.end) {
                    this.goEnd(jump);
                    TextField.this.clearSelection();
                }
            }
            TextField.this.cursor = Mathf.clamp(TextField.this.cursor, 0, TextField.this.text.length());
            if (repeat) {
                this.scheduleKeyRepeatTask(keycode);
            }
            return true;
        }

        protected void scheduleKeyRepeatTask(KeyCode keycode) {
            if (!TextField.this.keyRepeatTask.isScheduled() || TextField.this.keyRepeatTask.keycode != keycode) {
                TextField.this.keyRepeatTask.keycode = keycode;
                TextField.this.keyRepeatTask.cancel();
                Timer.schedule(TextField.this.keyRepeatTask, keyRepeatInitialTime, keyRepeatTime);
            }
        }

        @Override
        public boolean keyUp(InputEvent event, KeyCode keycode) {
            if (TextField.this.disabled) {
                return false;
            }
            if (TextField.this.imeData != null) {
                return true;
            }
            TextField.this.keyRepeatTask.cancel();
            return true;
        }

        protected boolean checkFocusTraverse(char character) {
            return TextField.this.focusTraversal && (character == '\t' || (character == '\r' || character == '\n') && Core.app.isMobile());
        }

        @Override
        public boolean keyTyped(InputEvent event, char character) {
            Scene stage;
            if (TextField.this.disabled) {
                return false;
            }
            switch (character) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\r': 
                case '\u007f': {
                    if (TextField.this.imeData == null) break;
                    return true;
                }
                default: {
                    if (character >= ' ') break;
                    return false;
                }
            }
            if ((stage = TextField.this.getScene()) == null || stage.getKeyboardFocus() != TextField.this) {
                return false;
            }
            if (OS.isMac && Core.input.keyDown(KeyCode.sym)) {
                return true;
            }
            if (this.checkFocusTraverse(character)) {
                TextField.this.next(Core.input.shift());
            } else {
                boolean remove;
                boolean enter;
                boolean delete = character == '\u007f';
                boolean backspace = character == '\b';
                boolean bl = enter = character == '\n' || character == '\r';
                boolean add = enter ? TextField.this.writeEnters : !TextField.this.onlyFontChars || TextField.this.style.font.getData().hasGlyph(character);
                boolean bl2 = remove = backspace || delete;
                if (add || remove) {
                    String oldText = TextField.this.text;
                    int oldCursor = TextField.this.cursor;
                    if (TextField.this.hasSelection) {
                        TextField.this.cursor = TextField.this.delete(false);
                    } else {
                        if (backspace && TextField.this.cursor > 0) {
                            TextField.this.text = TextField.this.text.substring(0, TextField.this.cursor - 1) + TextField.this.text.substring(TextField.this.cursor--);
                            TextField.this.renderOffset = 0.0f;
                        }
                        if (delete && TextField.this.cursor < TextField.this.text.length()) {
                            TextField.this.text = TextField.this.text.substring(0, TextField.this.cursor) + TextField.this.text.substring(TextField.this.cursor + 1);
                        }
                    }
                    if (add && !remove) {
                        if (TextField.this.filter != null && !TextField.this.filter.acceptChar(TextField.this, character)) {
                            return true;
                        }
                        if (!TextField.this.withinMaxLength(TextField.this.text.length())) {
                            return true;
                        }
                        String insertion = enter ? "\n" : String.valueOf(character);
                        TextField.this.text = TextField.this.insert(TextField.this.cursor++, insertion, TextField.this.text);
                    }
                    if (TextField.this.changeText(oldText, TextField.this.text)) {
                        long time = System.currentTimeMillis();
                        if (time - 750L > TextField.this.lastChangeTime) {
                            TextField.this.undoText = oldText;
                        }
                        TextField.this.lastChangeTime = time;
                    } else {
                        TextField.this.cursor = oldCursor;
                    }
                    TextField.this.updateDisplayText();
                }
            }
            if (TextField.this.listener != null) {
                TextField.this.listener.keyTyped(TextField.this, character);
            }
            return true;
        }
    }

    class KeyRepeatTask
    extends Timer.Task {
        KeyCode keycode;

        KeyRepeatTask() {
        }

        @Override
        public void run() {
            TextField.this.inputListener.keyDown(null, this.keycode);
        }
    }

    public static class TextFieldStyle
    extends Style {
        public Font font;
        public Color fontColor;
        public Color focusedFontColor;
        public Color disabledFontColor;
        public Drawable background;
        public Drawable focusedBackground;
        public Drawable disabledBackground;
        public Drawable invalidBackground;
        public Drawable cursor;
        public Drawable selection;
        public Font messageFont;
        public Color messageFontColor;

        public TextFieldStyle() {
        }

        public TextFieldStyle(TextFieldStyle style) {
            this.messageFont = style.messageFont;
            if (style.messageFontColor != null) {
                this.messageFontColor = new Color(style.messageFontColor);
            }
            this.background = style.background;
            this.focusedBackground = style.focusedBackground;
            this.disabledBackground = style.disabledBackground;
            this.cursor = style.cursor;
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.selection = style.selection;
        }
    }

    public static interface TextFieldValidator {
        public boolean valid(String var1);
    }

    public static interface TextFieldFilter {
        public static final TextFieldFilter digitsOnly = (field, c) -> Character.isDigit(c);
        public static final TextFieldFilter floatsOnly = (field, c) -> Character.isDigit(c) || !field.getText().contains(".") && c == '.';

        public boolean acceptChar(TextField var1, char var2);
    }

    public static interface TextFieldListener {
        public void keyTyped(TextField var1, char var2);
    }
}

