/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.graphics.Color;
import arc.graphics.Colors;
import arc.math.Mathf;
import arc.struct.Seq;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class Strings {
    private static StringBuilder tmp1 = new StringBuilder();
    private static StringBuilder tmp2 = new StringBuilder();
    private static Pattern filenamePattern = Pattern.compile("[\u0000/\"<>|:*?\\\\]");
    private static Pattern reservedFilenamePattern = Pattern.compile("(CON|AUX|PRN|NUL|(COM[0-9])|(LPT[0-9]))((\\..*$)|$)", 2);
    public static final Charset utf8 = Charset.forName("UTF-8");

    public static boolean matches(String query, String name) {
        return query == null || query.isEmpty() || name != null && name.toLowerCase().contains(query.toLowerCase());
    }

    public static int count(CharSequence s, char c) {
        int total = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++total;
        }
        return total;
    }

    public static String truncate(String s, int length) {
        return s.length() <= length ? s : s.substring(0, length);
    }

    public static String truncate(String s, int length, String ellipsis) {
        return s.length() <= length ? s : s.substring(0, length) + ellipsis;
    }

    public static Seq<Throwable> getCauses(Throwable e) {
        Seq<Throwable> arr = new Seq<Throwable>();
        while (e != null) {
            arr.add(e);
            e = e.getCause();
        }
        return arr;
    }

    public static String getSimpleMessage(Throwable e) {
        Throwable fcause = Strings.getFinalCause(e);
        return fcause.getMessage() == null ? fcause.getClass().getSimpleName() : fcause.getClass().getSimpleName() + ": " + fcause.getMessage();
    }

    public static String getFinalMessage(Throwable e) {
        String message = e.getMessage();
        while (e.getCause() != null) {
            if ((e = e.getCause()).getMessage() == null) continue;
            message = e.getMessage();
        }
        return message;
    }

    public static Throwable getFinalCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String neatError(Throwable e) {
        return Strings.neatError(e, true);
    }

    public static String neatError(Throwable e, boolean stacktrace) {
        StringBuilder build = new StringBuilder();
        while (e != null) {
            String name = e.getClass().toString().substring("class ".length()).replace("Exception", "");
            if (name.indexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            build.append("> ").append(name);
            if (e.getMessage() != null) {
                build.append(": ");
                build.append("'").append(e.getMessage()).append("'");
            }
            if (stacktrace) {
                for (StackTraceElement s : e.getStackTrace()) {
                    if (s.getClassName().contains("MethodAccessor") || s.getClassName().substring(s.getClassName().lastIndexOf(".") + 1).equals("Method")) continue;
                    build.append("\n");
                    String className = s.getClassName();
                    build.append(className.substring(className.lastIndexOf(".") + 1)).append(".").append(s.getMethodName()).append(": ").append(s.getLineNumber());
                }
            }
            build.append("\n");
            e = e.getCause();
        }
        return build.toString();
    }

    public static String stripColors(CharSequence str) {
        StringBuilder out = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '[') {
                int length = Strings.parseColorMarkup(str, i + 1, str.length());
                if (length >= 0) {
                    i += length + 2;
                    continue;
                }
                out.append(c);
                ++i;
                continue;
            }
            out.append(c);
            ++i;
        }
        return out.toString();
    }

    public static String stripGlyphs(CharSequence str) {
        StringBuilder out = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') continue;
            out.append(c);
        }
        return out.toString();
    }

    private static int parseColorMarkup(CharSequence str, int start, int end) {
        if (start >= end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) break;
                        return i - start;
                    }
                    if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) break;
                }
                return -1;
            }
            case '[': {
                return -2;
            }
            case ']': {
                return 0;
            }
        }
        for (int i = start + 1; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch != ']') continue;
            Color namedColor = Colors.get(str.subSequence(start, i).toString());
            if (namedColor == null) {
                return -1;
            }
            return i - start;
        }
        return -1;
    }

    public static int count(String str, String substring) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(substring, lastIndex)) == -1) continue;
            ++count;
            lastIndex += substring.length();
        }
        return count;
    }

    public static String sanitizeFilename(String str) {
        if (reservedFilenamePattern.matcher(str).matches()) {
            return "a" + str;
        }
        return filenamePattern.matcher(str).replaceAll("_");
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException why) {
            throw new RuntimeException(why);
        }
    }

    public static String format(String text, Object ... args) {
        if (args.length > 0) {
            StringBuilder out = new StringBuilder(text.length() + args.length * 2);
            int argi = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '@' && argi < args.length) {
                    out.append(args[argi++]);
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }
        return text;
    }

    public static String join(String separator, String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
            builder.append(separator);
        }
        builder.setLength(builder.length() - separator.length());
        return builder.toString();
    }

    public static String join(String separator, Iterable<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
            builder.append(separator);
        }
        builder.setLength(builder.length() - separator.length());
        return builder.toString();
    }

    public static int levenshtein(String x, String y) {
        int[][] dp = new int[x.length() + 1][y.length() + 1];
        for (int i = 0; i <= x.length(); ++i) {
            for (int j = 0; j <= y.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j - 1] + (x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1), dp[i - 1][j] + 1), dp[i][j - 1] + 1));
            }
        }
        return dp[x.length()][y.length()];
    }

    public static String animated(float time, int length, float scale, String replacement) {
        return new String(new char[Math.abs((int)(time / scale) % length)]).replace("\u0000", replacement);
    }

    public static String kebabToCamel(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || c == '-') continue;
            if (i != 0 && (s.charAt(i - 1) == '_' || s.charAt(i - 1) == '-')) {
                result.append(Character.toUpperCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String camelToKebab(String s) {
        StringBuilder result = new StringBuilder(s.length() + 1);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i > 0 && Character.isUpperCase(s.charAt(i))) {
                result.append('-');
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String capitalize(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || c == '-') {
                result.append(" ");
                continue;
            }
            if (i == 0 || s.charAt(i - 1) == '_' || s.charAt(i - 1) == '-') {
                result.append(Character.toUpperCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String insertSpaces(String s) {
        StringBuilder result = new StringBuilder(s.length() + 1);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String camelize(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (c == ' ') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean canParseInt(String s) {
        return Strings.parseInt(s) != Integer.MIN_VALUE;
    }

    public static boolean canParsePositiveInt(String s) {
        int p = Strings.parseInt(s);
        return p >= 0;
    }

    public static int parseInt(String s, int defaultValue) {
        return Strings.parseInt(s, 10, defaultValue);
    }

    public static int parseInt(String s, int radix, int defaultValue) {
        return Strings.parseInt(s, radix, defaultValue, 0, s.length());
    }

    public static int parseInt(String s, int radix, int defaultValue, int start, int end) {
        int limitForMaxRadix;
        boolean negative = false;
        int i = start;
        int len = end - start;
        int limit = -2147483647;
        if (len <= 0) {
            return defaultValue;
        }
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        int limitBeforeMul = limitForMaxRadix = -59652323;
        int result = 0;
        while (i < end) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                return defaultValue;
            }
            if (result < limitBeforeMul) {
                if (limitBeforeMul == limitForMaxRadix) {
                    limitBeforeMul = limit / radix;
                    if (result < limitBeforeMul) {
                        return defaultValue;
                    }
                } else {
                    return defaultValue;
                }
            }
            if ((result *= radix) < limit + digit) {
                return defaultValue;
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static long parseLong(String s, long defaultValue) {
        return Strings.parseLong(s, 10, defaultValue);
    }

    public static long parseLong(String s, int radix, long defaultValue) {
        return Strings.parseLong(s, radix, 0, s.length(), defaultValue);
    }

    public static long parseLong(String s, int radix, int start, int end, long defaultValue) {
        boolean negative = false;
        int i = start;
        int len = end - start;
        long limit = -9223372036854775807L;
        if (len <= 0) {
            return defaultValue;
        }
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        long result = 0L;
        while (i < end) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                return defaultValue;
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return defaultValue;
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static double parseDouble(String value, double defaultValue) {
        int len = value.length();
        if (len == 0) {
            return defaultValue;
        }
        int sign = 1;
        int start = 0;
        int end = len;
        char last = value.charAt(len - 1);
        char first = value.charAt(0);
        if (last == 'F' || last == 'f' || last == '.') {
            --end;
        }
        if (first == '+') {
            start = 1;
        }
        if (first == '-') {
            start = 1;
            sign = -1;
        }
        int dot = -1;
        int e = -1;
        for (int i = start; i < end; ++i) {
            char c = value.charAt(i);
            if (c == '.') {
                dot = i;
            }
            if (c != 'e' && c != 'E') continue;
            e = i;
        }
        if (dot != -1 && dot < end) {
            long whole;
            long l = whole = start == dot ? 0L : Strings.parseLong(value, 10, start, dot, Long.MIN_VALUE);
            if (whole == Long.MIN_VALUE) {
                return defaultValue;
            }
            long dec = Strings.parseLong(value, 10, dot + 1, end, Long.MIN_VALUE);
            if (dec < 0L) {
                return defaultValue;
            }
            return ((double)whole + Math.copySign((double)dec / Math.pow(10.0, end - dot - 1), (double)whole)) * (double)sign;
        }
        if (e != -1) {
            long whole = Strings.parseLong(value, 10, start, e, Long.MIN_VALUE);
            if (whole == Long.MIN_VALUE) {
                return defaultValue;
            }
            long power = Strings.parseLong(value, 10, e + 1, end, Long.MIN_VALUE);
            if (power == Long.MIN_VALUE) {
                return defaultValue;
            }
            return (float)whole * Mathf.pow(10.0f, power) * (float)sign;
        }
        long out = Strings.parseLong(value, 10, start, end, Long.MIN_VALUE);
        return out == Long.MIN_VALUE ? defaultValue : (double)(out * (long)sign);
    }

    public static int parseInt(String s) {
        return Strings.parseInt(s, Integer.MIN_VALUE);
    }

    public static boolean canParseFloat(String s) {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canParsePositiveFloat(String s) {
        try {
            return Float.parseFloat(s) >= 0.0f;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static float parseFloat(String s) {
        return Strings.parseFloat(s, Float.MIN_VALUE);
    }

    public static float parseFloat(String s, float defaultValue) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String autoFixed(float value, int max) {
        int precision = Math.abs((float)((int)(value + 1.0E-4f)) - value) <= 1.0E-4f ? 0 : (Math.abs((float)((int)(value * 10.0f + 1.0E-4f)) - value * 10.0f) <= 1.0E-4f ? 1 : 2);
        return Strings.fixed(value, Math.min(precision, max));
    }

    public static String fixed(float d, int decimalPlaces) {
        return Strings.fixedBuilder(d, decimalPlaces).toString();
    }

    public static StringBuilder fixedBuilder(float d, int decimalPlaces) {
        if (decimalPlaces < 0 || decimalPlaces > 8) {
            throw new IllegalArgumentException("Unsupported number of decimal places: " + decimalPlaces);
        }
        boolean negative = d < 0.0f;
        d = Math.abs(d);
        StringBuilder dec = tmp2;
        dec.setLength(0);
        dec.append((int)((double)d * Math.pow(10.0, decimalPlaces) + (double)1.0E-4f));
        int len = dec.length();
        int decimalPosition = len - decimalPlaces;
        StringBuilder result = tmp1;
        result.setLength(0);
        if (negative) {
            result.append('-');
        }
        if (decimalPlaces == 0) {
            if (negative) {
                dec.insert(0, '-');
            }
            return dec;
        }
        if (decimalPosition > 0) {
            result.append(dec, 0, decimalPosition);
            result.append(".");
            result.append(dec, decimalPosition, dec.length());
        } else {
            result.append("0.");
            while (decimalPosition++ < 0) {
                result.append("0");
            }
            result.append((CharSequence)dec);
        }
        return result;
    }

    public static String formatMillis(long val) {
        StringBuilder buf = new StringBuilder(20);
        String sgn = "";
        if (val < 0L) {
            sgn = "-";
        }
        val = Math.abs(val);
        Strings.append(buf, sgn, 0, val / 3600000L);
        Strings.append(buf, ":", 2, (val %= 3600000L) / 60000L);
        Strings.append(buf, ":", 2, (val %= 60000L) / 1000L);
        return buf.toString();
    }

    private static void append(StringBuilder tgt, String pfx, int dgt, long val) {
        tgt.append(pfx);
        if (dgt > 1) {
            int pad = dgt - 1;
            for (long xa = val; xa > 9L && pad > 0; --pad, xa /= 10L) {
            }
            for (int xa = 0; xa < pad; ++xa) {
                tgt.append('0');
            }
        }
        tgt.append(val);
    }

    public static StringBuilder replace(StringBuilder builder, String find, String replace) {
        int findLength = find.length();
        int replaceLength = replace.length();
        int index = 0;
        while ((index = builder.indexOf(find, index)) != -1) {
            builder.replace(index, index + findLength, replace);
            index += replaceLength;
        }
        return builder;
    }

    public static StringBuilder replace(StringBuilder builder, char find, String replace) {
        int replaceLength = replace.length();
        int index = 0;
        while (index != builder.length()) {
            if (builder.charAt(index) != find) {
                ++index;
                continue;
            }
            builder.replace(index, index + 1, replace);
            index += replaceLength;
        }
        return builder;
    }
}

