/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntFloatMap;
import arc.struct.IntIntMap;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.TaskQueue;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.PathfindQueue;
import mindustry.ai.Pathfinder;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.PathTile;
import mindustry.gen.Unit;
import mindustry.world.Tile;

public class ControlPathfinder {
    private static final long maxUpdate = Time.millisToNanos(30L);
    private static final int updateFPS = 60;
    private static final int updateInterval = 16;
    private static final int wallImpassableCap = 1000000;
    public static final Pathfinder.PathCost costGround = (team, tile) -> PathTile.allDeep(tile) ? -1 : (PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) ? -1 : (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + 1 + (PathTile.nearSolid(tile) ? 6 : 0) + (PathTile.nearLiquid(tile) ? 8 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.damages(tile) ? 50 : 0));
    public static final Pathfinder.PathCost costHover = (team, tile) -> PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) ? -1 : (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + 1 + (PathTile.nearSolid(tile) ? 6 : 0);
    public static final Pathfinder.PathCost costLegs = (team, tile) -> PathTile.legSolid(tile) ? -1 : 1 + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.nearLegSolid(tile) ? 3 : 0);
    public static final Pathfinder.PathCost costNaval = (team, tile) -> PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) || !PathTile.liquid(tile) ? -1 : 1 + (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + (PathTile.nearGround(tile) || PathTile.nearSolid(tile) ? 6 : 0);
    public static boolean showDebug = false;
    static int wwidth;
    static int wheight;
    static volatile int worldUpdateId;
    @Nullable
    PathfindThread[] threads;
    int lastTargetId = 1;
    ObjectMap<Unit, PathRequest> requests = new ObjectMap();

    public ControlPathfinder() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.stop();
            wwidth = Vars.world.width();
            wheight = Vars.world.height();
            this.start();
        });
        Events.on(EventType.TilePreChangeEvent.class, e -> {
            if (e.tile.solid()) {
                ++worldUpdateId;
            }
        });
        Events.on(EventType.TileChangeEvent.class, e -> {
            if (e.tile.solid()) {
                ++worldUpdateId;
            }
        });
        Events.on(EventType.ResetEvent.class, event -> this.stop());
        Events.run((Object)EventType.Trigger.update, () -> {
            for (PathRequest req : this.requests.values()) {
                if (req.lastUpdateId > Vars.state.updateId - 10L) continue;
                Core.app.post(() -> this.requests.remove(req.unit));
                req.thread.queue.post(() -> req.thread.requests.remove(req));
            }
        });
        Events.run((Object)EventType.Trigger.draw, () -> {
            if (!showDebug) {
                return;
            }
            for (PathRequest req : this.requests.values()) {
                if (req.frontier == null) continue;
                Draw.draw(120.0f, () -> {
                    if (req.done) {
                        int rp = req.rayPathIndex;
                        int len = req.result.size;
                        if (rp < len && rp >= 0) {
                            Draw.color(Color.royal);
                            Tile tile = this.tile(req.result.items[rp]);
                            Lines.line(req.unit.x, req.unit.y, tile.worldx(), tile.worldy());
                        }
                        for (int i = 0; i < len; ++i) {
                            Draw.color(Tmp.c1.set(Color.white).fromHsv((float)i / (float)len * 360.0f, 1.0f, 0.9f));
                            int pos = req.result.items[i];
                            Fill.square(pos % wwidth * 8, pos / wwidth * 8, 3.0f);
                            if (i != req.pathIndex) continue;
                            Draw.color(Color.green);
                            Lines.square(pos % wwidth * 8, pos / wwidth * 8, 5.0f);
                        }
                    } else {
                        Rect view = Core.camera.bounds(Tmp.r1);
                        int len = req.frontier.size;
                        float[] weights = req.frontier.weights;
                        int[] poses = req.frontier.queue;
                        for (int i = 0; i < Math.min(len, 1000); ++i) {
                            int pos = poses[i];
                            if (!view.contains(pos % wwidth * 8, pos / wwidth * 8)) continue;
                            Draw.color(Tmp.c1.set(Color.white).fromHsv(weights[i] * 4.0f % 360.0f, 1.0f, 0.9f));
                            Lines.square(pos % wwidth * 8, pos / wwidth * 8, 4.0f);
                        }
                    }
                    Draw.reset();
                });
            }
        });
    }

    public int nextTargetId() {
        return this.lastTargetId++;
    }

    public boolean getPathPosition(Unit unit, int pathId, Vec2 destination, Vec2 out) {
        return this.getPathPosition(unit, pathId, destination, out, null);
    }

    public boolean getPathPosition(Unit unit, int pathId, Vec2 destination, Vec2 out, @Nullable boolean[] noResultFound) {
        if (noResultFound != null) {
            noResultFound[0] = false;
        }
        if (this.threads == null || !Vars.world.tiles.in(World.toTile(destination.x), World.toTile(destination.y))) {
            return false;
        }
        Pathfinder.PathCost costType = unit.type.pathCost;
        int team = unit.team.id;
        if (!(this.requests.containsKey(unit) && this.requests.get((Unit)unit).curId == pathId || ControlPathfinder.raycast(team, costType, unit.tileX(), unit.tileY(), World.toTile(destination.x), World.toTile(destination.y)))) {
            out.set(destination);
            return true;
        }
        if (ControlPathfinder.solid(team, costType, Vars.world.packArray(World.toTile(destination.x), World.toTile(destination.y)), false)) {
            return false;
        }
        if (this.requests.containsKey(unit)) {
            PathRequest req = this.requests.get(unit);
            req.lastUpdateId = Vars.state.updateId;
            req.team = unit.team.id;
            if (req.curId != req.lastId || req.curId != pathId) {
                req.pathIndex = 0;
                req.rayPathIndex = -1;
                req.done = false;
                req.foundEnd = false;
            }
            req.destination.set(destination);
            req.curId = pathId;
            if (req.done) {
                float f;
                req.stuckTimer += Time.delta;
                if (f >= 90.0f) {
                    req.stuckTimer = 0.0f;
                    if (req.lastPos.within(unit, 1.5f)) {
                        req.forceRecalculate();
                    }
                    req.lastPos.set(unit);
                }
            }
            if (req.done) {
                float f;
                int i;
                int[] items = req.result.items;
                int len = req.result.size;
                int tileX = unit.tileX();
                int tileY = unit.tileY();
                float range = 4.0f;
                float minDst = req.pathIndex < len ? unit.dst2(Vars.world.tiles.geti(items[req.pathIndex])) : 0.0f;
                int idx = req.pathIndex;
                for (i = len - 1; i >= idx; --i) {
                    Tile tile = this.tile(items[i]);
                    float dst = unit.dst2(tile);
                    if (!(dst < minDst) || ControlPathfinder.permissiveRaycast(team, costType, tileX, tileY, tile.x, tile.y)) continue;
                    req.pathIndex = Math.max(dst <= range * range ? i + 1 : i, req.pathIndex);
                    minDst = Math.min(dst, minDst);
                }
                if (req.rayPathIndex < 0) {
                    req.rayPathIndex = req.pathIndex;
                }
                req.raycastTimer += Time.delta;
                if (f >= 50.0f) {
                    for (i = len - 1; i > req.pathIndex; --i) {
                        int val = items[i];
                        if (ControlPathfinder.raycast(team, costType, tileX, tileY, val % wwidth, val / wwidth)) continue;
                        req.rayPathIndex = i;
                        break;
                    }
                    req.raycastTimer = 0.0f;
                }
                if (req.rayPathIndex < len && req.rayPathIndex >= 0) {
                    float angleToDest;
                    float angleToNext;
                    Tile tile = this.tile(items[req.rayPathIndex]);
                    out.set(tile);
                    if (req.rayPathIndex > 0 && Angles.angleDist(angleToNext = this.tile(items[req.rayPathIndex - 1]).angleTo(tile), angleToDest = unit.angleTo(tile)) > 80.0f && !unit.within(tile, 1.0f)) {
                        req.forceRecalculate();
                    }
                    if (unit.within(tile, range)) {
                        req.pathIndex = req.rayPathIndex = Math.max(req.pathIndex, req.rayPathIndex + 1);
                    }
                } else {
                    out.set(unit);
                }
                if (noResultFound != null) {
                    noResultFound[0] = !req.foundEnd;
                }
            }
            return req.done;
        }
        PathfindThread thread = Structs.findMin(this.threads, t -> t.requestSize);
        PathRequest req = new PathRequest(thread);
        req.unit = unit;
        req.cost = costType;
        req.destination.set(destination);
        req.curId = pathId;
        req.team = team;
        req.lastUpdateId = Vars.state.updateId;
        req.lastPos.set(unit);
        req.lastWorldUpdate = worldUpdateId;
        req.raycastTimer = 9999.0f;
        this.requests.put(unit, req);
        thread.queue.post(() -> thread.requests.add(req));
        return false;
    }

    private void start() {
        this.stop();
        if (Vars.net.client()) {
            return;
        }
        this.threads = new PathfindThread[Mathf.clamp(Runtime.getRuntime().availableProcessors() - 1, 1, 6)];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new PathfindThread("ControlPathfindThread-" + i);
            this.threads[i].setPriority(1);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
    }

    private void stop() {
        if (this.threads != null) {
            for (PathfindThread thread : this.threads) {
                thread.interrupt();
            }
        }
        this.threads = null;
        this.requests.clear();
    }

    private static boolean raycast(int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2) {
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (ControlPathfinder.avoid(team, type, x + y * wwidth)) {
                return true;
            }
            if (x == x2 && y == y2) {
                return false;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
        return true;
    }

    private static boolean permissiveRaycast(int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2) {
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (ControlPathfinder.solid(team, type, x + y * wwidth, true)) {
                return true;
            }
            if (x == x2 && y == y2) {
                return false;
            }
            if (2 * err + dy > dx - 2 * err) {
                err -= dy;
                x += sx;
                continue;
            }
            err += dx;
            y += sy;
        }
        return true;
    }

    static boolean cast(int team, Pathfinder.PathCost cost, int from, int to) {
        return ControlPathfinder.raycast(team, cost, from % wwidth, from / wwidth, to % wwidth, to / wwidth);
    }

    private Tile tile(int pos) {
        return Vars.world.tiles.geti(pos);
    }

    private static float heuristic(int a, int b) {
        int x = a % wwidth;
        int x2 = b % wwidth;
        int y = a / wwidth;
        int y2 = b / wwidth;
        return Math.abs(x - x2) + Math.abs(y - y2);
    }

    private static int tcost(int team, Pathfinder.PathCost cost, int tilePos) {
        return cost.getCost(team, Vars.pathfinder.tiles[tilePos]);
    }

    private static int cost(int team, Pathfinder.PathCost cost, int tilePos) {
        if (Vars.state.rules.limitMapArea && !Team.get(team).isAI()) {
            int x = tilePos % wwidth;
            int y = tilePos / wwidth;
            if (x < Vars.state.rules.limitX || y < Vars.state.rules.limitY || x > Vars.state.rules.limitX + Vars.state.rules.limitWidth || y > Vars.state.rules.limitY + Vars.state.rules.limitHeight) {
                return -1;
            }
        }
        return cost.getCost(team, Vars.pathfinder.tiles[tilePos]);
    }

    private static boolean avoid(int team, Pathfinder.PathCost type, int tilePos) {
        int cost = ControlPathfinder.cost(team, type, tilePos);
        return cost == -1 || cost >= 2;
    }

    private static boolean solid(int team, Pathfinder.PathCost type, int tilePos, boolean checkWall) {
        int cost = ControlPathfinder.cost(team, type, tilePos);
        return cost == -1 || checkWall && cost >= 6000;
    }

    private static float tileCost(int team, Pathfinder.PathCost type, int a, int b) {
        return ControlPathfinder.cost(team, type, b);
    }

    static class PathfindThread
    extends Thread {
        TaskQueue queue = new TaskQueue();
        Seq<PathRequest> requests = new Seq();
        volatile int requestSize;

        public PathfindThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (!Vars.net.client()) {
                try {
                    if (Vars.state.isPlaying()) {
                        this.queue.run();
                        this.requestSize = this.requests.size;
                        for (PathRequest req : this.requests) {
                            req.update(maxUpdate / (long)this.requests.size);
                        }
                    }
                    try {
                        Thread.sleep(16L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                catch (Throwable e) {
                    Log.err(e);
                    continue;
                }
                break;
            }
            return;
        }
    }

    static class PathRequest {
        final PathfindThread thread;
        volatile boolean done = false;
        volatile boolean foundEnd = false;
        volatile Unit unit;
        volatile Pathfinder.PathCost cost;
        volatile int team;
        volatile int lastWorldUpdate;
        volatile boolean forcedRecalc;
        final Vec2 lastPos = new Vec2();
        float stuckTimer = 0.0f;
        final Vec2 destination = new Vec2();
        final Vec2 lastDestination = new Vec2();
        volatile int pathIndex;
        int rayPathIndex = -1;
        IntSeq result = new IntSeq();
        volatile float raycastTimer;
        PathfindQueue frontier = new PathfindQueue();
        IntIntMap cameFrom = new IntIntMap();
        IntFloatMap costs = new IntFloatMap();
        int start;
        int goal;
        long lastUpdateId;
        long lastTime;
        long forceRecalcTime;
        volatile int lastId;
        volatile int curId;

        public PathRequest(PathfindThread thread) {
            this.thread = thread;
        }

        public void forceRecalculate() {
            if (Time.timeSinceMillis(this.forceRecalcTime) < 333L) {
                return;
            }
            this.forcedRecalc = true;
            this.forceRecalcTime = Time.millis();
        }

        void update(long maxUpdateNs) {
            if (this.curId != this.lastId) {
                this.clear(true);
            }
            this.lastId = this.curId;
            if (this.forcedRecalc || Time.timeSinceMillis(this.lastTime) > 3000L && (worldUpdateId != this.lastWorldUpdate || !this.destination.epsilonEquals(this.lastDestination, 2.0f))) {
                this.lastTime = Time.millis();
                this.lastWorldUpdate = worldUpdateId;
                this.forcedRecalc = false;
                this.clear(false);
            }
            if (this.done) {
                return;
            }
            long ns = Time.nanos();
            int counter = 0;
            while (this.frontier.size > 0) {
                int current = this.frontier.poll();
                if (current == this.goal) {
                    this.foundEnd = true;
                    break;
                }
                int cx = current % wwidth;
                int cy = current / wwidth;
                for (Point2 point : Geometry.d4) {
                    float newCost;
                    int newx = cx + point.x;
                    int newy = cy + point.y;
                    int next = newx + wwidth * newy;
                    if (newx >= wwidth || newy >= wheight || newx < 0 || newy < 0 || ControlPathfinder.tcost(this.team, this.cost, next) == -1) continue;
                    float add = ControlPathfinder.tileCost(this.team, this.cost, current, next);
                    float currentCost = this.costs.get(current);
                    if (add < 0.0f) continue;
                    float f = newCost = currentCost >= 1000000.0f && add >= 1000000.0f ? currentCost + add - 1000000.0f : currentCost + add;
                    if (this.costs.containsKey(next) && !(newCost < this.costs.get(next))) continue;
                    this.costs.put(next, newCost);
                    float priority = newCost + ControlPathfinder.heuristic(next, this.goal);
                    this.frontier.add(next, priority);
                    this.cameFrom.put(next, current);
                }
                if (counter++ < 100) continue;
                counter = 0;
                if (Time.timeSinceNanos(ns) <= maxUpdateNs) continue;
                return;
            }
            this.lastTime = Time.millis();
            this.raycastTimer = 9999.0f;
            this.result.clear();
            this.pathIndex = 0;
            this.rayPathIndex = -1;
            if (this.foundEnd) {
                int cur = this.goal;
                while (cur != this.start) {
                    this.result.add(cur);
                    cur = this.cameFrom.get(cur);
                }
                this.result.reverse();
                this.smoothPath();
            }
            this.frontier = new PathfindQueue();
            this.cameFrom = new IntIntMap();
            this.costs = new IntFloatMap();
            this.done = true;
        }

        void smoothPath() {
            int input;
            int len = this.result.size;
            if (len <= 2) {
                return;
            }
            int output = 1;
            for (input = 2; input < len; ++input) {
                if (!ControlPathfinder.cast(this.team, this.cost, this.result.get(output - 1), this.result.get(input))) continue;
                this.result.swap(output, input - 1);
                ++output;
            }
            this.result.swap(output, input - 1);
            this.result.size = output + 1;
        }

        void clear(boolean resetCurrent) {
            this.done = false;
            this.frontier = new PathfindQueue(20);
            this.cameFrom.clear();
            this.costs.clear();
            this.start = Vars.world.packArray(this.unit.tileX(), this.unit.tileY());
            this.goal = Vars.world.packArray(World.toTile(this.destination.x), World.toTile(this.destination.y));
            this.cameFrom.put(this.start, this.start);
            this.costs.put(this.start, 0.0f);
            this.frontier.add(this.start, 0.0f);
            this.foundEnd = false;
            this.lastDestination.set(this.destination);
            if (resetCurrent) {
                this.result.clear();
            }
        }
    }
}

