/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.func.Boolf;
import arc.func.Cons;
import arc.util.Nullable;
import arc.util.Time;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Build;
import mindustry.world.blocks.ConstructBlock;

public class BuilderAI
extends AIController {
    public static float buildRadius = 1500.0f;
    public static float retreatDst = 110.0f;
    public static float retreatDelay = 120.0f;
    public static float defaultRebuildPeriod = 120.0f;
    @Nullable
    public Unit assistFollowing;
    @Nullable
    public Unit following;
    @Nullable
    public Teamc enemy;
    @Nullable
    public Teams.BlockPlan lastPlan;
    public float fleeRange = 370.0f;
    public float rebuildPeriod = defaultRebuildPeriod;
    public boolean alwaysFlee;
    public boolean onlyAssist;
    boolean found = false;
    float retreatTimer;

    public BuilderAI(boolean alwaysFlee, float fleeRange) {
        this.alwaysFlee = alwaysFlee;
        this.fleeRange = fleeRange;
    }

    public BuilderAI() {
    }

    @Override
    public void init() {
        if (this.rebuildPeriod == defaultRebuildPeriod && this.unit.team.rules().buildAi) {
            this.rebuildPeriod = 10.0f;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateMovement() {
        block27: {
            block25: {
                block26: {
                    if (this.target != null && this.shouldShoot()) {
                        this.unit.lookAt(this.target);
                    }
                    this.unit.updateBuilding = true;
                    if (this.assistFollowing != null && this.assistFollowing.activelyBuilding()) {
                        this.following = this.assistFollowing;
                    }
                    if (this.following != null) {
                        this.retreatTimer = 0.0f;
                        if (!this.following.isValid() || !this.following.activelyBuilding()) {
                            this.following = null;
                            this.unit.plans.clear();
                            return;
                        }
                        this.unit.plans.clear();
                        this.unit.plans.addFirst(this.following.buildPlan());
                        this.lastPlan = null;
                    } else if (this.unit.buildPlan() == null || this.alwaysFlee) {
                        if (this.timer.get(3, 40.0f)) {
                            this.enemy = this.target(this.unit.x, this.unit.y, this.fleeRange, true, true);
                        }
                        if (((this.retreatTimer += Time.delta) >= BuilderAI.retreatDelay || this.alwaysFlee) && this.enemy != null) {
                            this.unit.clearBuilding();
                            core = this.unit.closestCore();
                            if (core != null && !this.unit.within(core, BuilderAI.retreatDst)) {
                                this.moveTo(core, BuilderAI.retreatDst);
                            }
                        }
                    }
                    if (this.unit.buildPlan() == null) break block25;
                    if (!this.alwaysFlee) {
                        this.retreatTimer = 0.0f;
                    }
                    req = this.unit.buildPlan();
                    if (!req.breaking && this.timer.get(1, 40.0f)) {
                        for (Player player : Groups.player) {
                            if (!player.isBuilder() || !player.unit().activelyBuilding() || !player.unit().buildPlan().samePos(req) || !player.unit().buildPlan().breaking) continue;
                            this.unit.plans.removeFirst();
                            this.unit.team.data().plans.remove((Teams.BlockPlan)(Boolf<Teams.BlockPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateMovement$0(mindustry.entities.units.BuildPlan mindustry.game.Teams$BlockPlan ), (Lmindustry/game/Teams$BlockPlan;)Z)((BuildPlan)req));
                            return;
                        }
                    }
                    if (this.lastPlan != null && this.lastPlan.removed) ** GOTO lbl-1000
                    if (req.tile() == null || !((var4_8 = req.tile().build) instanceof ConstructBlock.ConstructBuild)) break block26;
                    cons = (ConstructBlock.ConstructBuild)var4_8;
                    if (cons.current == req.block) ** GOTO lbl-1000
                }
                if (req.breaking != false ? Build.validBreak(this.unit.team(), req.x, req.y) != false : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation) != false) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = valid = false;
                }
                if (valid) {
                    this.moveTo(req.tile(), this.unit.type.buildRange - 20.0f);
                } else {
                    this.unit.plans.removeFirst();
                    this.lastPlan = null;
                }
                break block27;
            }
            if (this.assistFollowing != null) {
                this.moveTo(this.assistFollowing, this.assistFollowing.type.hitSize + this.unit.type.hitSize / 2.0f + 60.0f);
            }
            if (this.timer.get(1, 20.0f)) {
                this.found = false;
                Units.nearby(this.unit.team, this.unit.x, this.unit.y, BuilderAI.buildRadius, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$updateMovement$1(mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((BuilderAI)this));
                if (this.onlyAssist) {
                    minDst = 3.4028235E38f;
                    closest = null;
                    for (Player player : Groups.player) {
                        if (!player.unit().canBuild() || player.dead() || player.team() != this.unit.team || !((dst = player.dst2(this.unit)) < minDst)) continue;
                        closest = player;
                        minDst = dst;
                    }
                    v1 = this.assistFollowing = closest == null ? null : closest.unit();
                }
            }
            if (!this.onlyAssist && !this.unit.team.data().plans.isEmpty() && this.following == null && this.timer.get(2, this.rebuildPeriod)) {
                blocks = this.unit.team.data().plans;
                block = blocks.first();
                if (Vars.world.tile(block.x, block.y) != null && Vars.world.tile((int)block.x, (int)block.y).block().id == block.block) {
                    blocks.removeFirst();
                } else if (!(!Build.validPlace(Vars.content.block(block.block), this.unit.team(), block.x, block.y, block.rotation) || this.alwaysFlee && this.nearEnemy(block.x, block.y))) {
                    this.lastPlan = block;
                    this.unit.addBuild(new BuildPlan(block.x, block.y, block.rotation, Vars.content.block(block.block), block.config));
                    blocks.addLast(blocks.removeFirst());
                } else {
                    blocks.addLast(blocks.removeFirst());
                }
            }
        }
    }

    protected boolean nearEnemy(int x, int y) {
        return Units.nearEnemy(this.unit.team, (float)(x * 8) - this.fleeRange / 2.0f, (float)(y * 8) - this.fleeRange / 2.0f, this.fleeRange, this.fleeRange);
    }

    @Override
    public AIController fallback() {
        return this.unit.type.flying ? new FlyingAI() : new GroundAI();
    }

    @Override
    public boolean useFallback() {
        return Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam && !this.unit.team.rules().rtsAi;
    }

    @Override
    public boolean shouldShoot() {
        return !this.unit.isBuilding() && this.unit.type.canAttack;
    }

    private /* synthetic */ void lambda$updateMovement$1(Unit u) {
        if (this.found) {
            return;
        }
        if (u.canBuild() && u != this.unit && u.activelyBuilding()) {
            ConstructBlock.ConstructBuild cons;
            float dist;
            BuildPlan plan = u.buildPlan();
            Building build = Vars.world.build(plan.x, plan.y);
            if (build instanceof ConstructBlock.ConstructBuild && (dist = Math.min((cons = (ConstructBlock.ConstructBuild)build).dst(this.unit) - this.unit.type.buildRange, 0.0f)) / this.unit.speed() < cons.buildCost * 0.9f) {
                this.following = u;
                this.found = true;
            }
        }
    }

    private static /* synthetic */ boolean lambda$updateMovement$0(BuildPlan req, Teams.BlockPlan p) {
        return p.x == req.x && p.y == req.y;
    }
}

