/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.GroundAI;
import mindustry.core.World;
import mindustry.entities.Sized;
import mindustry.entities.units.AIController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Tile;

public class CommandAI
extends AIController {
    protected static final float localInterval = 40.0f;
    protected static final Vec2 vecOut = new Vec2();
    protected static final Vec2 flockVec = new Vec2();
    protected static final Vec2 separation = new Vec2();
    protected static final Vec2 cohesion = new Vec2();
    protected static final Vec2 massCenter = new Vec2();
    protected static final boolean[] noFound = new boolean[]{false};
    @Nullable
    public Vec2 targetPos;
    @Nullable
    public Teamc attackTarget;
    public IntSeq unreachableBuildings = new IntSeq(8);
    protected boolean stopAtTarget;
    protected boolean stopWhenInRange;
    protected Vec2 lastTargetPos;
    protected int pathId = -1;
    protected Seq<Unit> local = new Seq(false);
    protected boolean flocked;
    @Nullable
    public UnitCommand command;
    @Nullable
    protected AIController commandController;
    @Nullable
    protected UnitCommand lastCommand;

    public UnitCommand currentCommand() {
        return this.command == null ? UnitCommand.moveCommand : this.command;
    }

    public void command(UnitCommand command) {
        if (Structs.contains(this.unit.type.commands, command)) {
            this.unit.mineTile = null;
            this.unit.clearBuilding();
            this.command = command;
        }
    }

    @Override
    public boolean isLogicControllable() {
        return !this.hasCommand();
    }

    public boolean isAttacking() {
        return this.target != null && this.unit.within(this.target, this.unit.range() + 10.0f);
    }

    @Override
    public void updateUnit() {
        UnitCommand curCommand;
        if (this.command == null && this.unit.type.commands.length > 0) {
            UnitCommand unitCommand = this.command = this.unit.type.defaultCommand == null ? this.unit.type.commands[0] : this.unit.type.defaultCommand;
        }
        if (this.lastCommand != (curCommand = this.command)) {
            this.lastCommand = curCommand;
            AIController aIController = this.commandController = curCommand == null ? null : curCommand.controller.get(this.unit);
        }
        if (this.commandController != null) {
            if (this.commandController.unit() != this.unit) {
                this.commandController.unit(this.unit);
            }
            this.commandController.updateUnit();
        } else {
            this.defaultBehavior();
            this.unit.updateBoosting(false);
        }
    }

    public void defaultBehavior() {
        if (this.unit.team.isAI() && this.unit.team.rules().rtsAi && this.unit.type.naval) {
            if (this.fallback == null) {
                this.fallback = new GroundAI();
            }
            if (this.fallback.unit() != this.unit) {
                this.fallback.unit(this.unit);
            }
            this.fallback.updateUnit();
            return;
        }
        this.updateVisuals();
        if (this.targetPos == null || this.nearAttackTarget(this.unit.x, this.unit.y, this.unit.range()) || this.unit.type.autoFindTarget) {
            this.updateTargeting();
        } else if (this.attackTarget == null) {
            this.target = null;
            for (WeaponMount mount : this.unit.mounts) {
                if (!mount.weapon.controllable) continue;
                mount.target = null;
            }
        }
        if (this.attackTarget != null && this.invalid(this.attackTarget)) {
            this.attackTarget = null;
            this.targetPos = null;
        }
        if (this.targetPos != null) {
            if (this.timer.get(2, 40.0f) || !this.flocked) {
                if (!this.flocked) {
                    this.timer.reset(2, Mathf.random(40.0f));
                }
                this.local.clear();
                float size = this.unit.hitSize * 3.0f;
                this.unit.team.data().tree().intersect(this.unit.x - size / 2.0f, this.unit.y - size / 2.0f, size, size, this.local);
                this.local.remove(this.unit);
                this.flocked = true;
            }
        } else {
            this.flocked = false;
        }
        if (this.attackTarget != null) {
            Teamc teamc;
            if (this.targetPos == null) {
                this.lastTargetPos = this.targetPos = new Vec2();
            }
            this.targetPos.set(this.attackTarget);
            if (this.unit.isGrounded() && (teamc = this.attackTarget) instanceof Building) {
                Tile best;
                Building build = (Building)teamc;
                if (build.tile.solid() && this.unit.pathType() != 1 && (best = build.findClosestEdge(this.unit, Tile::solid)) != null) {
                    this.targetPos.set(best);
                }
            }
        }
        if (this.targetPos != null) {
            boolean move = true;
            vecOut.set(this.targetPos);
            if (this.unit.isGrounded()) {
                move = Vars.controlPath.getPathPosition(this.unit, this.pathId, this.targetPos, vecOut, noFound);
                if (this.unit.team.isAI() && (noFound[0] || this.unit.isPathImpassable(World.toTile(this.targetPos.x), World.toTile(this.targetPos.y)))) {
                    Teamc teamc = this.attackTarget;
                    if (teamc instanceof Building) {
                        Building build = (Building)teamc;
                        this.unreachableBuildings.addUnique(build.pos());
                    }
                    this.attackTarget = null;
                    this.targetPos = null;
                    return;
                }
            }
            float engageRange = this.unit.type.range - 10.0f;
            if (move) {
                if (this.unit.type.circleTarget && this.attackTarget != null) {
                    this.target = this.attackTarget;
                    this.circleAttack(80.0f);
                } else {
                    this.moveTo(vecOut, this.attackTarget != null && this.unit.within(this.attackTarget, engageRange) ? engageRange : (this.unit.isGrounded() ? 0.0f : (this.attackTarget != null ? engageRange : 0.0f)), this.unit.isFlying() ? 40.0f : 100.0f, false, null, this.targetPos.epsilonEquals(vecOut, 4.1f));
                }
            }
            if (this.attackTarget != null && this.stopAtTarget && this.unit.within(this.attackTarget, engageRange - 1.0f)) {
                this.attackTarget = null;
            }
            if (this.unit.isFlying()) {
                this.unit.lookAt(this.targetPos);
            } else {
                this.faceTarget();
            }
            if (this.attackTarget == null) {
                if (this.unit.within(this.targetPos, Math.max(5.0f, this.unit.hitSize / 2.0f))) {
                    this.targetPos = null;
                } else if (this.local.size > 1) {
                    int count = 0;
                    for (Unit near : this.local) {
                        if (!near.isCommandable() || near.command().hasCommand() || !this.targetPos.epsilonEquals(near.command().lastTargetPos, 0.001f)) continue;
                        ++count;
                    }
                    if (count >= Math.max(3, this.local.size / 2)) {
                        this.targetPos = null;
                    }
                }
            }
            if (this.stopWhenInRange && this.targetPos != null && this.unit.within(this.targetPos, engageRange * 0.9f)) {
                this.targetPos = null;
                this.stopWhenInRange = false;
            }
        } else if (this.target != null) {
            this.faceTarget();
        }
    }

    @Override
    public void hit(Bullet bullet) {
        Unit u;
        Teamc teamc;
        Entityc entityc;
        if (this.unit.team.isAI() && (entityc = bullet.owner) instanceof Teamc && (teamc = (Teamc)entityc).team() != this.unit.team && this.attackTarget == null && (!(teamc instanceof Unit) || (u = (Unit)teamc).checkTarget(this.unit.type.targetAir, this.unit.type.targetGround)) && this.timer.get(3, 600.0f)) {
            this.commandTarget(teamc, true);
        }
    }

    @Override
    public boolean keepState() {
        return true;
    }

    @Override
    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        return !this.nearAttackTarget(x, y, range) ? super.findTarget(x, y, range, air, ground) : this.attackTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nearAttackTarget(float x, float y, float range) {
        float f;
        if (this.attackTarget == null) return false;
        Teamc teamc = this.attackTarget;
        if (teamc instanceof Sized) {
            Sized s = (Sized)((Object)teamc);
            f = s.hitSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        if (!this.attackTarget.within(x, y, range + 3.0f + f)) return false;
        return true;
    }

    @Override
    public boolean retarget() {
        return this.attackTarget != null ? this.timer.get(0, 10.0f) : this.timer.get(0, 20.0f);
    }

    public boolean hasCommand() {
        return this.targetPos != null;
    }

    public void setupLastPos() {
        this.lastTargetPos = this.targetPos;
    }

    @Override
    public void commandPosition(Vec2 pos) {
        this.commandPosition(pos, false);
        if (this.commandController != null) {
            this.commandController.commandPosition(pos);
        }
    }

    public void commandPosition(Vec2 pos, boolean stopWhenInRange) {
        this.targetPos = pos;
        this.lastTargetPos = pos;
        this.attackTarget = null;
        this.pathId = Vars.controlPath.nextTargetId();
        this.stopWhenInRange = stopWhenInRange;
    }

    @Override
    public void commandTarget(Teamc moveTo) {
        this.commandTarget(moveTo, false);
        if (this.commandController != null) {
            this.commandController.commandTarget(moveTo);
        }
    }

    public void commandTarget(Teamc moveTo, boolean stopAtTarget) {
        this.attackTarget = moveTo;
        this.stopAtTarget = stopAtTarget;
        this.pathId = Vars.controlPath.nextTargetId();
    }
}

