/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.PosTeam;
import mindustry.gen.Teamc;
import mindustry.logic.LUnitControl;
import mindustry.world.blocks.storage.CoreBlock;

public class LogicAI
extends AIController {
    public static final float transferDelay = 90.0f;
    public static final float logicControlTimeout = 600.0f;
    public LUnitControl control = LUnitControl.idle;
    public float moveX;
    public float moveY;
    public float moveRad;
    public float controlTimer = 600.0f;
    public float targetTimer;
    @Nullable
    public Building controller;
    public BuildPlan plan = new BuildPlan();
    public ObjectMap<Object, Object> execCache = new ObjectMap();
    public LUnitControl aimControl = LUnitControl.stop;
    public boolean boost;
    public Teamc mainTarget;
    public boolean shoot;
    public PosTeam posTarget = PosTeam.create();
    private ObjectSet<Object> radars = new ObjectSet();
    private float lastMoveX;
    private float lastMoveY;
    private int lastPathId = 0;

    @Override
    public boolean keepState() {
        return true;
    }

    @Override
    public void updateMovement() {
        if (!(this.control != LUnitControl.pathfind || Mathf.equal(this.moveX, this.lastMoveX, 0.1f) && Mathf.equal(this.moveY, this.lastMoveY, 0.1f))) {
            ++this.lastPathId;
            this.lastMoveX = this.moveX;
            this.lastMoveY = this.moveY;
        }
        if (this.targetTimer > 0.0f) {
            this.targetTimer -= Time.delta;
        } else {
            this.radars.clear();
            this.targetTimer = 40.0f;
        }
        if (this.controlTimer > 0.0f && this.controller != null && this.controller.isValid()) {
            this.controlTimer -= Time.delta;
        } else {
            this.unit.resetController();
            return;
        }
        switch (this.control) {
            case move: {
                this.moveTo(Tmp.v1.set(this.moveX, this.moveY), 1.0f, 30.0f);
                break;
            }
            case approach: {
                this.moveTo(Tmp.v1.set(this.moveX, this.moveY), this.moveRad - 7.0f, 7.0f, true, null);
                break;
            }
            case pathfind: {
                if (this.unit.isFlying()) {
                    this.moveTo(Tmp.v1.set(this.moveX, this.moveY), 1.0f, 30.0f);
                    break;
                }
                if (!Vars.controlPath.getPathPosition(this.unit, this.lastPathId, Tmp.v2.set(this.moveX, this.moveY), Tmp.v1, null)) break;
                this.moveTo(Tmp.v1, 1.0f, Tmp.v2.epsilonEquals(Tmp.v1, 4.1f) ? 30.0f : 0.0f);
                break;
            }
            case autoPathfind: {
                CoreBlock.CoreBuild core = this.unit.closestEnemyCore();
                if (core != null && this.unit.within(core, this.unit.range() * 0.5f)) break;
                boolean move = true;
                Position spawner = null;
                if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam && (spawner = this.getClosestSpawner()) != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                    move = false;
                }
                if (!move) break;
                if (this.unit.isFlying()) {
                    CoreBlock.CoreBuild target;
                    Position position = target = core == null ? spawner : core;
                    if (target == null) break;
                    this.moveTo(target, this.unit.range() * 0.5f);
                    break;
                }
                this.pathfind(0);
                break;
            }
            case stop: {
                this.unit.clearBuilding();
            }
        }
        if (this.unit.type.canBoost && !this.unit.type.flying) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, Mathf.num(this.boost || this.unit.onSolid() || this.unit.isFlying() && !this.unit.canLand()), this.unit.type.riseSpeed);
        }
        if (!this.shoot || !this.unit.type.omniMovement) {
            this.unit.lookAt(this.unit.prefRotation());
        } else if (this.unit.hasWeapons() && this.unit.mounts.length > 0 && !this.unit.mounts[0].weapon.ignoreRotation) {
            this.unit.lookAt(this.unit.mounts[0].aimX, this.unit.mounts[0].aimY);
        }
    }

    public boolean checkTargetTimer(Object radar) {
        return this.radars.add(radar);
    }

    @Override
    public boolean checkTarget(Teamc target, float x, float y, float range) {
        return false;
    }

    @Override
    public boolean retarget() {
        return true;
    }

    @Override
    public boolean invalid(Teamc target) {
        return false;
    }

    @Override
    public boolean shouldShoot() {
        return this.shoot && (!this.unit.type.canBoost || !this.boost);
    }

    @Override
    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        Teamc teamc;
        switch (this.aimControl) {
            case target: {
                teamc = this.posTarget;
                break;
            }
            case targetp: {
                teamc = this.mainTarget;
                break;
            }
            default: {
                teamc = null;
            }
        }
        return teamc;
    }
}

