/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;

public class MissileAI
extends AIController {
    @Nullable
    public Unit shooter;

    @Override
    public void updateMovement() {
        float time;
        float f;
        this.unloadPayloads();
        Unit unit = this.unit;
        if (unit instanceof TimedKillc) {
            TimedKillc t = (TimedKillc)((Object)unit);
            f = t.time();
        } else {
            f = time = 1000000.0f;
        }
        if (time >= this.unit.type.homingDelay && this.shooter != null && !this.shooter.dead()) {
            this.unit.lookAt(this.shooter.aimX, this.shooter.aimY);
        }
        this.unit.moveAt(vec.trns(this.unit.rotation, this.unit.type.missileAccelTime <= 0.0f ? this.unit.speed() : Mathf.pow(Math.min(time / this.unit.type.missileAccelTime, 1.0f), 2.0f) * this.unit.speed()));
        Building build = this.unit.buildOn();
        if (!(build == null || build.team == this.unit.team || build != this.target && build.block.underBullets)) {
            this.unit.kill();
        }
    }

    @Override
    public boolean retarget() {
        return this.timer.get(0, 4.0f);
    }
}

