/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Bullets;
import mindustry.content.ErekirTechTree;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.Loadouts;
import mindustry.content.Planets;
import mindustry.content.SectorPresets;
import mindustry.content.SerpuloTechTree;
import mindustry.content.StatusEffects;
import mindustry.content.TeamEntries;
import mindustry.content.UnitTypes;
import mindustry.content.Weathers;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.io.SaveVersion;
import mindustry.mod.Mods;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.Planet;
import mindustry.type.SectorPreset;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.ColorMapper;

public class ContentLoader {
    private ObjectMap<String, MappableContent>[] contentNameMap = new ObjectMap[ContentType.all.length];
    private Seq<Content>[] contentMap = new Seq[ContentType.all.length];
    private MappableContent[][] temporaryMapper;
    @Nullable
    private Mods.LoadedMod currentMod;
    @Nullable
    private Content lastAdded;
    private ObjectSet<Cons<Content>> initialization = new ObjectSet();

    public ContentLoader() {
        for (ContentType type : ContentType.all) {
            this.contentMap[type.ordinal()] = new Seq();
            this.contentNameMap[type.ordinal()] = new ObjectMap();
        }
    }

    public void createBaseContent() {
        TeamEntries.load();
        Items.load();
        StatusEffects.load();
        Liquids.load();
        Bullets.load();
        UnitTypes.load();
        Blocks.load();
        Loadouts.load();
        Weathers.load();
        Planets.load();
        SectorPresets.load();
        SerpuloTechTree.load();
        ErekirTechTree.load();
    }

    public void createModContent() {
        if (Vars.mods != null) {
            Vars.mods.loadContent();
        }
    }

    public void logContent() {
        for (Seq<Content> arr : this.contentMap) {
            for (int i = 0; i < arr.size; ++i) {
                short id = arr.get((int)i).id;
                if (id == i) continue;
                throw new IllegalArgumentException("Out-of-order IDs for content '" + arr.get(i) + "' (expected " + i + " but got " + id + ")");
            }
        }
        Log.debug("--- CONTENT INFO ---");
        for (int k = 0; k < this.contentMap.length; ++k) {
            Log.debug("[@]: loaded @", ContentType.all[k].name(), this.contentMap[k].size);
        }
        Log.debug("Total content loaded: @", Seq.with(ContentType.all).mapInt(c -> this.contentMap[c.ordinal()].size).sum());
        Log.debug("-------------------");
    }

    public void init() {
        this.initialize(Content::init);
        if (Vars.logicVars != null) {
            Vars.logicVars.init();
        }
        Events.fire(new EventType.ContentInitEvent());
    }

    public void load() {
        this.initialize(Content::loadIcon);
        this.initialize(Content::load);
    }

    private void initialize(Cons<Content> callable) {
        if (this.initialization.contains(callable)) {
            return;
        }
        for (ContentType type : ContentType.all) {
            for (Content content : this.contentMap[type.ordinal()]) {
                try {
                    callable.get(content);
                }
                catch (Throwable e) {
                    if (content.minfo.mod != null) {
                        Log.err(e);
                        Vars.mods.handleContentError(content, e);
                        continue;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        this.initialization.add(callable);
    }

    public void loadColors() {
        Pixmap pixmap = new Pixmap(Core.files.internal("sprites/block_colors.png"));
        for (int i = 0; i < pixmap.width; ++i) {
            int color;
            if (this.blocks().size <= i || (color = pixmap.get(i, 0)) == 0 || color == 255) continue;
            Block block = this.block(i);
            block.mapColor.rgba8888(color);
            block.squareSprite = block.mapColor.a > 0.5f;
            block.mapColor.a = 1.0f;
            block.hasColor = true;
        }
        pixmap.dispose();
        ColorMapper.load();
    }

    @Nullable
    public Content getLastAdded() {
        return this.lastAdded;
    }

    public void removeLast() {
        if (this.lastAdded != null && this.contentMap[this.lastAdded.getContentType().ordinal()].peek() == this.lastAdded) {
            this.contentMap[this.lastAdded.getContentType().ordinal()].pop();
            Content content = this.lastAdded;
            if (content instanceof MappableContent) {
                MappableContent c = (MappableContent)content;
                this.contentNameMap[this.lastAdded.getContentType().ordinal()].remove(c.name);
            }
        }
    }

    public void handleContent(Content content) {
        this.lastAdded = content;
        this.contentMap[content.getContentType().ordinal()].add(content);
    }

    public void setCurrentMod(@Nullable Mods.LoadedMod mod) {
        this.currentMod = mod;
    }

    public String transformName(String name) {
        return this.currentMod == null ? name : this.currentMod.name + "-" + name;
    }

    public void handleMappableContent(MappableContent content) {
        if (this.contentNameMap[content.getContentType().ordinal()].containsKey(content.name)) {
            throw new IllegalArgumentException("Two content objects cannot have the same name! (issue: '" + content.name + "')");
        }
        if (this.currentMod != null) {
            content.minfo.mod = this.currentMod;
            if (content.minfo.sourceFile == null) {
                content.minfo.sourceFile = new Fi(content.name);
            }
        }
        this.contentNameMap[content.getContentType().ordinal()].put(content.name, content);
    }

    public void setTemporaryMapper(MappableContent[][] temporaryMapper) {
        this.temporaryMapper = temporaryMapper;
    }

    public Seq<Content>[] getContentMap() {
        return this.contentMap;
    }

    public void each(Cons<Content> cons) {
        for (Seq<Content> seq : this.contentMap) {
            seq.each(cons);
        }
    }

    public <T extends MappableContent> T getByName(ContentType type, String name) {
        ObjectMap<String, MappableContent> map = this.contentNameMap[type.ordinal()];
        if (map == null) {
            return null;
        }
        if (type == ContentType.block) {
            name = SaveVersion.modContentNameMap.get(name, name);
        }
        return (T)map.get(name);
    }

    public <T extends Content> T getByID(ContentType type, int id) {
        if (this.temporaryMapper != null && this.temporaryMapper[type.ordinal()] != null && this.temporaryMapper[type.ordinal()].length != 0) {
            if (id < 0) {
                return null;
            }
            if (this.temporaryMapper[type.ordinal()].length <= id || this.temporaryMapper[type.ordinal()][id] == null) {
                return (T)this.contentMap[type.ordinal()].get(0);
            }
            return (T)this.temporaryMapper[type.ordinal()][id];
        }
        if (id >= this.contentMap[type.ordinal()].size || id < 0) {
            return null;
        }
        return (T)this.contentMap[type.ordinal()].get(id);
    }

    public <T extends Content> Seq<T> getBy(ContentType type) {
        return this.contentMap[type.ordinal()];
    }

    public Seq<Block> blocks() {
        return this.getBy(ContentType.block);
    }

    public Block block(int id) {
        return (Block)this.getByID(ContentType.block, id);
    }

    public Block block(String name) {
        return (Block)this.getByName(ContentType.block, name);
    }

    public Seq<Item> items() {
        return this.getBy(ContentType.item);
    }

    public Item item(int id) {
        return (Item)this.getByID(ContentType.item, id);
    }

    public Item item(String name) {
        return (Item)this.getByName(ContentType.item, name);
    }

    public Seq<Liquid> liquids() {
        return this.getBy(ContentType.liquid);
    }

    public Liquid liquid(int id) {
        return (Liquid)this.getByID(ContentType.liquid, id);
    }

    public Liquid liquid(String name) {
        return (Liquid)this.getByName(ContentType.liquid, name);
    }

    public Seq<BulletType> bullets() {
        return this.getBy(ContentType.bullet);
    }

    public BulletType bullet(int id) {
        return (BulletType)this.getByID(ContentType.bullet, id);
    }

    public Seq<StatusEffect> statusEffects() {
        return this.getBy(ContentType.status);
    }

    public StatusEffect statusEffect(String name) {
        return (StatusEffect)this.getByName(ContentType.status, name);
    }

    public Seq<SectorPreset> sectors() {
        return this.getBy(ContentType.sector);
    }

    public SectorPreset sector(String name) {
        return (SectorPreset)this.getByName(ContentType.sector, name);
    }

    public Seq<UnitType> units() {
        return this.getBy(ContentType.unit);
    }

    public UnitType unit(int id) {
        return (UnitType)this.getByID(ContentType.unit, id);
    }

    public UnitType unit(String name) {
        return (UnitType)this.getByName(ContentType.unit, name);
    }

    public Seq<Planet> planets() {
        return this.getBy(ContentType.planet);
    }

    public Planet planet(String name) {
        return (Planet)this.getByName(ContentType.planet, name);
    }
}

