/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Texture;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Buffers;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.ScreenUtils;
import arc.util.Threads;
import arc.util.Time;
import arc.util.Tmp;
import java.nio.Buffer;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Drawc;
import mindustry.gen.Groups;
import mindustry.graphics.BlockRenderer;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.EnvRenderers;
import mindustry.graphics.FogRenderer;
import mindustry.graphics.LightRenderer;
import mindustry.graphics.MinimapRenderer;
import mindustry.graphics.OverlayRenderer;
import mindustry.graphics.Pal;
import mindustry.graphics.Pixelator;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.maps.MapPreviewLoader;
import mindustry.world.blocks.storage.CoreBlock;

public class Renderer
implements ApplicationListener {
    public static float laserOpacity = 0.5f;
    public static float bridgeOpacity = 0.75f;
    private static final float cloudScaling = 1700.0f;
    private static final float cfinScl = -2.0f;
    private static final float cfinOffset = 0.3f;
    private static final float calphaFinOffset = 0.25f;
    private static final float[] cloudAlphas = new float[]{0.0f, 0.5f, 1.0f, 0.1f, 0.0f, 0.0f};
    private static final float cloudAlpha = 0.81f;
    private static final Interp landInterp = Interp.pow3;
    public final BlockRenderer blocks = new BlockRenderer();
    public final FogRenderer fog = new FogRenderer();
    public final MinimapRenderer minimap = new MinimapRenderer();
    public final OverlayRenderer overlays = new OverlayRenderer();
    public final LightRenderer lights = new LightRenderer();
    public final Pixelator pixelator = new Pixelator();
    public PlanetRenderer planets;
    @Nullable
    public Bloom bloom;
    @Nullable
    public FrameBuffer backgroundBuffer;
    public FrameBuffer effectBuffer = new FrameBuffer();
    public boolean animateShields;
    public boolean drawWeather = true;
    public boolean drawStatus;
    public boolean enableEffects;
    public boolean drawDisplays = true;
    public boolean drawLight = true;
    public float weatherAlpha;
    public float minZoom = 1.5f;
    public float maxZoom = 6.0f;
    public Seq<EnvRenderer> envRenderers = new Seq();
    public ObjectMap<String, Runnable> customBackgrounds = new ObjectMap();
    public TextureRegion[] bubbles = new TextureRegion[16];
    public TextureRegion[] splashes = new TextureRegion[12];
    public TextureRegion[][] fluidFrames;
    @Nullable
    private CoreBlock.CoreBuild landCore;
    @Nullable
    private CoreBlock launchCoreType;
    private Color clearColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private float cloudSeed = 0.0f;
    private float targetscale;
    private float camerascale = this.targetscale = Scl.scl(4.0f);
    private float minZoomScl = Scl.scl(0.02f);
    private float landTime;
    private float landPTimer;
    private float shakeIntensity;
    private float shakeReduction;
    private float shakeTime;
    private boolean launching;
    private Vec2 camShakeOffset = new Vec2();

    public Renderer() {
        Core.camera = new Camera();
        Shaders.init();
        Events.on(EventType.ResetEvent.class, e -> {
            this.shakeReduction = 0.0f;
            this.shakeIntensity = 0.0f;
            this.shakeTime = 0.0f;
            this.camShakeOffset.setZero();
        });
    }

    public void shake(float intensity, float duration) {
        this.shakeIntensity = Math.max(this.shakeIntensity, Mathf.clamp(intensity, 0.0f, 100.0f));
        this.shakeTime = Math.max(this.shakeTime, duration);
        this.shakeReduction = this.shakeIntensity / this.shakeTime;
    }

    public void addEnvRenderer(int mask, Runnable render) {
        this.envRenderers.add(new EnvRenderer(mask, render));
    }

    public void addCustomBackground(String name, Runnable render) {
        this.customBackgrounds.put(name, render);
    }

    @Override
    public void init() {
        int i;
        this.planets = new PlanetRenderer();
        if (Core.settings.getBool("bloom", !Vars.ios)) {
            this.setupBloom();
        }
        Events.run((Object)EventType.Trigger.newGame, () -> {
            this.landCore = Vars.player.bestCore();
        });
        EnvRenderers.init();
        for (i = 0; i < this.bubbles.length; ++i) {
            this.bubbles[i] = Core.atlas.find("bubble-" + i);
        }
        for (i = 0; i < this.splashes.length; ++i) {
            this.splashes[i] = Core.atlas.find("splash-" + i);
        }
        this.loadFluidFrames();
        Events.on(EventType.ClientLoadEvent.class, e -> this.loadFluidFrames());
        Core.assets.load((String)"sprites/clouds.png", Texture.class).loaded = t -> {
            t.setWrap(Texture.TextureWrap.repeat);
            t.setFilter(Texture.TextureFilter.linear);
        };
        Events.on(EventType.WorldLoadEvent.class, e -> {
            if (this.backgroundBuffer != null) {
                this.backgroundBuffer.dispose();
                this.backgroundBuffer = null;
            }
        });
    }

    public void loadFluidFrames() {
        this.fluidFrames = new TextureRegion[2][50];
        String[] fluidTypes = new String[]{"liquid", "gas"};
        for (int i = 0; i < fluidTypes.length; ++i) {
            for (int j = 0; j < 50; ++j) {
                this.fluidFrames[i][j] = Core.atlas.find("fluid-" + fluidTypes[i] + "-" + j);
            }
        }
    }

    public TextureRegion[][] getFluidFrames() {
        if (this.fluidFrames == null || this.fluidFrames[0][0].texture.isDisposed()) {
            this.loadFluidFrames();
        }
        return this.fluidFrames;
    }

    @Override
    public void update() {
        Color.white.set(1.0f, 1.0f, 1.0f, 1.0f);
        float baseTarget = this.targetscale;
        if (Vars.control.input.logicCutscene) {
            baseTarget = Mathf.lerp(this.minZoom, this.maxZoom, Vars.control.input.logicCutsceneZoom);
        }
        float dest = Mathf.clamp(Mathf.round(baseTarget, 0.5f), this.minScale(), this.maxScale());
        this.camerascale = Mathf.lerpDelta(this.camerascale, dest, 0.1f);
        if (Mathf.equal(this.camerascale, dest, 0.001f)) {
            this.camerascale = dest;
        }
        laserOpacity = (float)Core.settings.getInt("lasersopacity") / 100.0f;
        bridgeOpacity = (float)Core.settings.getInt("bridgeopacity") / 100.0f;
        this.animateShields = Core.settings.getBool("animatedshields");
        this.drawStatus = Core.settings.getBool("blockstatus");
        this.enableEffects = Core.settings.getBool("effects");
        this.drawDisplays = !Core.settings.getBool("hidedisplays");
        this.drawLight = Core.settings.getBool("drawlight", true);
        if (this.landTime > 0.0f) {
            if (!Vars.state.isPaused()) {
                CoreBlock.CoreBuild build = this.landCore == null ? Vars.player.bestCore() : this.landCore;
                build.updateLandParticles();
            }
            if (!Vars.state.isPaused()) {
                this.landTime -= Time.delta;
            }
            float fin = this.landTime / 160.0f;
            if (!this.launching) {
                fin = 1.0f - fin;
            }
            this.camerascale = landInterp.apply(this.minZoomScl, Scl.scl(4.0f), fin);
            this.weatherAlpha = 0.0f;
            if (this.landCore != null) {
                Core.camera.position.set(this.landCore);
            }
        } else {
            this.weatherAlpha = Mathf.lerpDelta(this.weatherAlpha, 1.0f, 0.08f);
        }
        Core.camera.width = (float)Core.graphics.getWidth() / this.camerascale;
        Core.camera.height = (float)Core.graphics.getHeight() / this.camerascale;
        if (Vars.state.isMenu()) {
            this.landTime = 0.0f;
            Core.graphics.clear(Color.black);
        } else {
            this.minimap.update();
            if (this.shakeTime > 0.0f) {
                float intensity = this.shakeIntensity * ((float)Core.settings.getInt("screenshake", 4) / 4.0f) * 0.75f;
                this.camShakeOffset.setToRandomDirection().scl(Mathf.random(intensity));
                Core.camera.position.add(this.camShakeOffset);
                this.shakeIntensity -= this.shakeReduction * Time.delta;
                this.shakeTime -= Time.delta;
                this.shakeIntensity = Mathf.clamp(this.shakeIntensity, 0.0f, 100.0f);
            } else {
                this.camShakeOffset.setZero();
                this.shakeIntensity = 0.0f;
            }
            if (this.pixelator.enabled()) {
                this.pixelator.drawPixelate();
            } else {
                this.draw();
            }
            Core.camera.position.sub(this.camShakeOffset);
        }
    }

    public void updateAllDarkness() {
        this.blocks.updateDarkness();
        this.minimap.updateAll();
    }

    public boolean isCutscene() {
        return this.landTime > 0.0f;
    }

    public float landScale() {
        return this.landTime > 0.0f ? this.camerascale : 1.0f;
    }

    @Override
    public void dispose() {
        Events.fire(new EventType.DisposeEvent());
    }

    @Override
    public void resume() {
        if (Core.settings.getBool("bloom") && this.bloom != null) {
            this.bloom.resume();
        }
    }

    void setupBloom() {
        try {
            if (this.bloom != null) {
                this.bloom.dispose();
                this.bloom = null;
            }
            this.bloom = new Bloom(true);
        }
        catch (Throwable e) {
            Core.settings.put("bloom", false);
            Vars.ui.showErrorMessage("@error.bloom");
            Log.err(e);
        }
    }

    public void toggleBloom(boolean enabled) {
        if (enabled) {
            if (this.bloom == null) {
                this.setupBloom();
            }
        } else if (this.bloom != null) {
            this.bloom.dispose();
            this.bloom = null;
        }
    }

    public void draw() {
        Events.fire(EventType.Trigger.preDraw);
        MapPreviewLoader.checkPreviews();
        Core.camera.update();
        if (Float.isNaN(Core.camera.position.x) || Float.isNaN(Core.camera.position.y)) {
            Core.camera.position.set(Vars.player);
        }
        Core.graphics.clear(this.clearColor);
        Draw.reset();
        if (Core.settings.getBool("animatedwater") || this.animateShields) {
            this.effectBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        }
        Draw.proj(Core.camera);
        this.blocks.checkChanges();
        this.blocks.floor.checkChanges();
        this.blocks.processBlocks();
        Draw.sort(true);
        Events.fire(EventType.Trigger.draw);
        MapPreviewLoader.checkPreviews();
        if (this.pixelator.enabled()) {
            this.pixelator.register();
        }
        Draw.draw(-10.0f, this::drawBackground);
        Draw.draw(0.0f, this.blocks.floor::drawFloor);
        Draw.draw(29.0f, this.blocks::drawShadows);
        Draw.draw(29.91f, () -> {
            this.blocks.floor.beginDraw();
            this.blocks.floor.drawLayer(CacheLayer.walls);
            this.blocks.floor.endDraw();
        });
        Draw.drawRange(40.0f, () -> Draw.shader(Shaders.blockbuild, true), Draw::shader);
        for (EnvRenderer renderer : this.envRenderers) {
            if ((renderer.env & Vars.state.rules.env) != renderer.env) continue;
            renderer.renderer.run();
        }
        if (Vars.state.rules.lighting && this.drawLight) {
            Draw.draw(140.0f, this.lights::draw);
        }
        if (Vars.enableDarkness) {
            Draw.draw(80.0f, this.blocks::drawDarkness);
        }
        if (this.bloom != null) {
            this.bloom.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            this.bloom.setBloomIntensity((float)Core.settings.getInt("bloomintensity", 6) / 4.0f + 1.0f);
            this.bloom.blurPasses = Core.settings.getInt("bloomblur", 1);
            Draw.draw(99.98f, this.bloom::capture);
            Draw.draw(110.02f, this.bloom::render);
        }
        Draw.draw(85.0f, this.overlays::drawBottom);
        if (this.animateShields && Shaders.shield != null) {
            Draw.drawRange(125.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                this.effectBuffer.end();
                this.effectBuffer.blit(Shaders.shield);
            });
            Draw.drawRange(122.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                this.effectBuffer.end();
                this.effectBuffer.blit(Shaders.buildBeam);
            });
        }
        Draw.draw(120.0f, this.overlays::drawTop);
        if (Vars.state.rules.fog) {
            Draw.draw(155.0f, this.fog::drawFog);
        }
        Draw.draw(160.0f, this::drawLanding);
        Events.fire(EventType.Trigger.drawOver);
        this.blocks.drawBlocks();
        Groups.draw.draw(Drawc::draw);
        Draw.reset();
        Draw.flush();
        Draw.sort(false);
        Events.fire(EventType.Trigger.postDraw);
    }

    protected void drawBackground() {
        if (!(Vars.state.rules.backgroundTexture == null || Vars.state.rules.planetBackground != null && Vars.state.rules.planetBackground.drawSkybox)) {
            float size;
            if (!Core.assets.isLoaded(Vars.state.rules.backgroundTexture, Texture.class)) {
                Fi file = Core.assets.getFileHandleResolver().resolve(Vars.state.rules.backgroundTexture);
                if (!file.exists() || !file.extEquals("png")) {
                    return;
                }
                AssetDescriptor<Texture> desc = Core.assets.load(Vars.state.rules.backgroundTexture, Texture.class, new TextureLoader.TextureParameter(){
                    {
                        this.wrapU = this.wrapV = Texture.TextureWrap.mirroredRepeat;
                        this.magFilter = this.minFilter = Texture.TextureFilter.linear;
                    }
                });
                Core.assets.finishLoadingAsset(desc);
            }
            Texture tex = Core.assets.get(Vars.state.rules.backgroundTexture, Texture.class);
            Tmp.tr1.set(tex);
            Tmp.tr1.u = 0.0f;
            Tmp.tr1.v = 0.0f;
            float ratio = Core.camera.width / Core.camera.height;
            Tmp.tr1.u2 = size = Vars.state.rules.backgroundScl;
            Tmp.tr1.v2 = size / ratio;
            float sx = 0.0f;
            float sy = 0.0f;
            if (!Mathf.zero(Vars.state.rules.backgroundSpeed)) {
                sx = Core.camera.position.x / Vars.state.rules.backgroundSpeed;
                sy = Core.camera.position.y / Vars.state.rules.backgroundSpeed;
            }
            Tmp.tr1.scroll(sx + Vars.state.rules.backgroundOffsetX, -sy + Vars.state.rules.backgroundOffsetY);
            Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        }
        if (Vars.state.rules.planetBackground != null) {
            int size = Math.max(Core.graphics.getWidth(), Core.graphics.getHeight());
            boolean resized = false;
            if (this.backgroundBuffer == null) {
                resized = true;
                this.backgroundBuffer = new FrameBuffer(size, size);
            }
            if (resized || this.backgroundBuffer.resizeCheck(size, size)) {
                this.backgroundBuffer.begin(Color.clear);
                PlanetParams params = Vars.state.rules.planetBackground;
                params.viewW = size;
                params.viewH = size;
                params.alwaysDrawAtmosphere = true;
                params.drawUi = false;
                this.planets.render(params);
                this.backgroundBuffer.end();
            }
            float drawSize = Math.max(Core.camera.width, Core.camera.height);
            Draw.rect(Draw.wrap((Texture)this.backgroundBuffer.getTexture()), Core.camera.position.x, Core.camera.position.y, drawSize, -drawSize);
        }
        if (Vars.state.rules.customBackgroundCallback != null && this.customBackgrounds.containsKey(Vars.state.rules.customBackgroundCallback)) {
            this.customBackgrounds.get(Vars.state.rules.customBackgroundCallback).run();
        }
    }

    void drawLanding() {
        CoreBlock.CoreBuild build = this.landCore == null ? Vars.player.bestCore() : this.landCore;
        Texture clouds = Core.assets.get("sprites/clouds.png", Texture.class);
        if (this.landTime > 0.0f && build != null) {
            float f;
            float fout = this.landTime / 160.0f;
            if (this.launching) {
                fout = 1.0f - fout;
            }
            float fin = 1.0f - fout;
            float scl = Scl.scl(4.0f) / this.camerascale;
            float pfin = Interp.pow3Out.apply(fin);
            float pf = Interp.pow2In.apply(fout);
            Draw.color(Pal.lightTrail);
            Angles.randLenVectors(1L, pfin, 100, 800.0f * scl * pfin, (ax, ay, ffin, ffout) -> {
                Lines.stroke(scl * ffin * pf * 3.0f);
                Lines.lineAngle(build.x + ax, build.y + ay, Mathf.angle(ax, ay), (ffin * 20.0f + 1.0f) * scl);
            });
            Draw.color();
            CoreBlock block = this.launching && this.launchCoreType != null ? this.launchCoreType : (CoreBlock)build.block;
            block.drawLanding(build, build.x, build.y);
            Draw.color();
            Draw.mixcol(Color.white, Interp.pow5In.apply(fout));
            if (this.launching && (f = Mathf.clamp(1.0f - fout * 12.0f)) > 0.001f) {
                Draw.mixcol(Pal.accent, f);
            }
            if (Vars.state.rules.cloudColor.a > 1.0E-4f) {
                float scaling = 1700.0f;
                float sscl = Math.max(1.0f + Mathf.clamp(fin + 0.3f) * -2.0f, 0.0f) * this.camerascale;
                Tmp.tr1.set(clouds);
                Tmp.tr1.set((Core.camera.position.x - Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y - Core.camera.height / 2.0f * sscl) / scaling, (Core.camera.position.x + Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y + Core.camera.height / 2.0f * sscl) / scaling);
                Tmp.tr1.scroll(10.0f * this.cloudSeed, 10.0f * this.cloudSeed);
                Draw.alpha(Mathf.sample(cloudAlphas, fin + 0.25f) * 0.81f);
                Draw.mixcol(Vars.state.rules.cloudColor, Vars.state.rules.cloudColor.a);
                Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
                Draw.reset();
            }
        }
    }

    public void scaleCamera(float amount) {
        this.targetscale *= amount / 4.0f + 1.0f;
        this.clampScale();
    }

    public void clampScale() {
        this.targetscale = Mathf.clamp(this.targetscale, this.minScale(), this.maxScale());
    }

    public float getDisplayScale() {
        return this.camerascale;
    }

    public float minScale() {
        return Scl.scl(this.minZoom);
    }

    public float maxScale() {
        return Mathf.round(Scl.scl(this.maxZoom));
    }

    public float getScale() {
        return this.targetscale;
    }

    public void setScale(float scl) {
        this.targetscale = scl;
        this.clampScale();
    }

    public boolean isLaunching() {
        return this.launching;
    }

    public CoreBlock getLaunchCoreType() {
        return this.launchCoreType;
    }

    public float getLandTime() {
        return this.landTime;
    }

    public float getLandPTimer() {
        return this.landPTimer;
    }

    public void setLandPTimer(float landPTimer) {
        this.landPTimer = landPTimer;
    }

    public void showLanding() {
        this.launching = false;
        this.camerascale = this.minZoomScl;
        this.landTime = 160.0f;
        this.cloudSeed = Mathf.random(1.0f);
    }

    public void showLaunch(CoreBlock coreType) {
        Vars.ui.hudfrag.showLaunch();
        Vars.control.input.config.hideConfig();
        Vars.control.input.inv.hide();
        this.launchCoreType = coreType;
        this.launching = true;
        this.landCore = Vars.player.team().core();
        this.cloudSeed = Mathf.random(1.0f);
        this.landTime = 160.0f;
        if (this.landCore != null) {
            Fx.coreLaunchConstruct.at(this.landCore.x, this.landCore.y, coreType.size);
        }
    }

    public void takeMapScreenshot() {
        int w = Vars.world.width() * 8;
        int h = Vars.world.height() * 8;
        int memory = w * h * 4 / 1024 / 1024;
        if (Vars.checkScreenshotMemory && memory >= (Vars.mobile ? 65 : 120)) {
            Vars.ui.showInfo("@screenshot.invalid");
            return;
        }
        FrameBuffer buffer = new FrameBuffer(w, h);
        this.drawWeather = false;
        float vpW = Core.camera.width;
        float vpH = Core.camera.height;
        float px = Core.camera.position.x;
        float py = Core.camera.position.y;
        Vars.disableUI = true;
        Core.camera.width = w;
        Core.camera.height = h;
        Core.camera.position.x = (float)w / 2.0f + 4.0f;
        Core.camera.position.y = (float)h / 2.0f + 4.0f;
        buffer.begin();
        this.draw();
        Draw.flush();
        byte[] lines = ScreenUtils.getFrameBufferPixels(0, 0, w, h, true);
        buffer.end();
        Vars.disableUI = false;
        Core.camera.width = vpW;
        Core.camera.height = vpH;
        Core.camera.position.set(px, py);
        this.drawWeather = true;
        buffer.dispose();
        Threads.thread(() -> {
            for (int i = 0; i < lines.length; i += 4) {
                lines[i + 3] = -1;
            }
            Pixmap fullPixmap = new Pixmap(w, h);
            Buffers.copy(lines, 0, (Buffer)fullPixmap.pixels, lines.length);
            Fi file = Vars.screenshotDirectory.child("screenshot-" + Time.millis() + ".png");
            PixmapIO.writePng(file, fullPixmap);
            fullPixmap.dispose();
            Core.app.post(() -> Vars.ui.showInfoFade(Core.bundle.format("screenshot", file.toString())));
        });
    }

    public static class EnvRenderer {
        public final int env;
        public final Runnable renderer;

        public EnvRenderer(int env, Runnable renderer) {
            this.env = env;
            this.renderer = renderer;
        }
    }
}

