/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Events;
import arc.math.geom.Point2;
import arc.struct.IntMap;
import arc.util.Structs;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Fire;
import mindustry.world.Tile;

public class Fires {
    private static final float baseLifetime = 1000.0f;
    private static final IntMap<Fire> map = new IntMap();

    public static void create(Tile tile) {
        if (Vars.net.client() || tile == null || !Vars.state.rules.fire || !Vars.state.rules.hasEnv(128)) {
            return;
        }
        Fire fire = map.get(tile.pos());
        if (fire == null) {
            fire = Fire.create();
            fire.tile = tile;
            fire.lifetime = 1000.0f;
            fire.set(tile.worldx(), tile.worldy());
            fire.add();
            map.put(tile.pos(), fire);
        } else {
            fire.lifetime = 1000.0f;
            fire.time = 0.0f;
        }
    }

    public static Fire get(int x, int y) {
        return map.get(Point2.pack(x, y));
    }

    public static boolean has(int x, int y) {
        if (!Structs.inBounds(x, y, Vars.world.width(), Vars.world.height()) || !map.containsKey(Point2.pack(x, y))) {
            return false;
        }
        Fire fire = map.get(Point2.pack(x, y));
        return fire.isAdded() && fire.fin() < 1.0f && fire.tile() != null && fire.tile().x == x && fire.tile().y == y;
    }

    public static void extinguish(Tile tile, float intensity) {
        if (tile != null && map.containsKey(tile.pos())) {
            Fire fire = map.get(tile.pos());
            fire.time(fire.time + intensity * Time.delta);
            Fx.steam.at(fire);
            if (fire.time >= fire.lifetime) {
                Events.fire(EventType.Trigger.fireExtinguish);
            }
        }
    }

    public static void remove(Tile tile) {
        if (tile != null) {
            map.remove(tile.pos());
        }
    }

    public static void register(Fire fire) {
        if (fire.tile != null) {
            map.put(fire.tile.pos(), fire);
        }
    }
}

