/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.Rules;
import mindustry.game.Teams;
import mindustry.graphics.Pal;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.modules.ItemModule;

public class Team
implements Comparable<Team> {
    public final int id;
    public final Color color;
    public final Color[] palette;
    public final int[] palettei = new int[3];
    public String emoji = "";
    public boolean hasPalette;
    public String name;
    public static final Team[] all;
    public static final Team[] baseTeams;
    public static final Team derelict;
    public static final Team sharded;
    public static final Team crux;
    public static final Team malis;
    public static final Team green;
    public static final Team blue;
    public static final Team neoplastic;

    public static Team get(int id) {
        return all[(byte)id & 0xFF];
    }

    protected Team(int id, String name, Color color) {
        this.name = name;
        this.color = color;
        this.id = id;
        if (id < 6) {
            Team.baseTeams[id] = this;
        }
        Team.all[id] = this;
        this.palette = new Color[3];
        this.palette[0] = color;
        this.palette[1] = color.cpy().mul(0.75f);
        this.palette[2] = color.cpy().mul(0.5f);
        for (int i = 0; i < 3; ++i) {
            this.palettei[i] = this.palette[i].rgba();
        }
    }

    protected Team(int id, String name, Color color, Color pal1, Color pal2, Color pal3) {
        this(id, name, color);
        this.palette[0] = pal1;
        this.palette[1] = pal2;
        this.palette[2] = pal3;
        for (int i = 0; i < 3; ++i) {
            this.palettei[i] = this.palette[i].rgba();
        }
        this.hasPalette = true;
    }

    public ItemModule items() {
        return this.core() == null ? ItemModule.empty : this.core().items;
    }

    public Rules.TeamRule rules() {
        return Vars.state.rules.teams.get(this);
    }

    public Teams.TeamData data() {
        return Vars.state.teams.get(this);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.data().core();
    }

    public boolean active() {
        return Vars.state.teams.isActive(this);
    }

    public boolean isAI() {
        return (Vars.state.rules.waves || Vars.state.rules.attackMode) && this != Vars.state.rules.defaultTeam && !Vars.state.rules.pvp;
    }

    public boolean isOnlyAI() {
        return this.isAI() && this.data().players.size == 0;
    }

    public boolean needsFlowField() {
        return this.isAI() && !this.rules().rtsAi;
    }

    @Deprecated
    public boolean isEnemy(Team other) {
        return this != other;
    }

    public Seq<CoreBlock.CoreBuild> cores() {
        return Vars.state.teams.cores(this);
    }

    public String localized() {
        return Core.bundle.get("team." + this.name + ".name", this.name);
    }

    public String coloredName() {
        return this.emoji + "[#" + this.color + "]" + this.localized() + "[]";
    }

    @Override
    public int compareTo(Team team) {
        return Integer.compare(this.id, team.id);
    }

    public String toString() {
        return this.name;
    }

    static {
        int i;
        all = new Team[256];
        baseTeams = new Team[6];
        derelict = new Team(0, "derelict", Color.valueOf("4d4e58"));
        sharded = new Team(1, "sharded", Pal.accent.cpy(), Color.valueOf("ffd37f"), Color.valueOf("eab678"), Color.valueOf("d4816b"));
        crux = new Team(2, "crux", Color.valueOf("f25555"), Color.valueOf("fc8e6c"), Color.valueOf("f25555"), Color.valueOf("a04553"));
        malis = new Team(3, "malis", Color.valueOf("a27ce5"), Color.valueOf("c195fb"), Color.valueOf("665c9f"), Color.valueOf("484988"));
        green = new Team(4, "green", Color.valueOf("54d67d"));
        blue = new Team(5, "blue", Color.valueOf("6c87fd"));
        neoplastic = new Team(6, "neoplastic", Color.valueOf("e05438"));
        Mathf.rand.setSeed(8L);
        for (i = 0; i < 3; ++i) {
            Mathf.random();
        }
        for (i = 7; i < all.length; ++i) {
            new Team(i, "team#" + i, Color.HSVtoRGB(360.0f * Mathf.random(), 100.0f * Mathf.random(0.4f, 1.0f), 100.0f * Mathf.random(0.6f, 1.0f), 1.0f));
        }
        Mathf.rand.setSeed(new Rand().nextLong());
    }
}

