/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.struct.Seq;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Fire;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__build;
import mindustry.gen.IndexableEntity__bullet;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__fire;
import mindustry.gen.IndexableEntity__label;
import mindustry.gen.IndexableEntity__player;
import mindustry.gen.IndexableEntity__powerGraph;
import mindustry.gen.IndexableEntity__puddle;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.IndexableEntity__unit;
import mindustry.gen.IndexableEntity__weather;
import mindustry.gen.Player;
import mindustry.gen.PowerGraphUpdaterc;
import mindustry.gen.Puddle;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.gen.WeatherState;
import mindustry.gen.WorldLabel;

public class Groups {
    public static EntityGroup<Entityc> all;
    public static EntityGroup<Building> build;
    public static EntityGroup<Bullet> bullet;
    public static EntityGroup<Drawc> draw;
    public static EntityGroup<Fire> fire;
    private static Seq<Pool.Poolable> freeQueue;
    public static boolean isClearing;
    public static EntityGroup<WorldLabel> label;
    public static EntityGroup<Player> player;
    public static EntityGroup<PowerGraphUpdaterc> powerGraph;
    public static EntityGroup<Puddle> puddle;
    public static EntityGroup<Syncc> sync;
    public static EntityGroup<Unit> unit;
    public static EntityGroup<WeatherState> weather;

    public static void clear() {
        isClearing = true;
        all.clear();
        player.clear();
        bullet.clear();
        unit.clear();
        build.clear();
        sync.clear();
        draw.clear();
        fire.clear();
        puddle.clear();
        weather.clear();
        label.clear();
        powerGraph.clear();
        isClearing = false;
    }

    public static void init() {
        all = new EntityGroup<Entityc>(Entityc.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__all) {
                IndexableEntity__all ix = (IndexableEntity__all)((Object)e);
                ix.setIndex__all(pos);
            }
        });
        player = new EntityGroup<Player>(Player.class, false, true, (e, pos) -> {
            if (e instanceof IndexableEntity__player) {
                IndexableEntity__player ix = (IndexableEntity__player)((Object)e);
                ix.setIndex__player(pos);
            }
        });
        bullet = new EntityGroup<Bullet>(Bullet.class, true, false, (e, pos) -> {
            if (e instanceof IndexableEntity__bullet) {
                IndexableEntity__bullet ix = (IndexableEntity__bullet)((Object)e);
                ix.setIndex__bullet(pos);
            }
        });
        unit = new EntityGroup<Unit>(Unit.class, true, true, (e, pos) -> {
            if (e instanceof IndexableEntity__unit) {
                IndexableEntity__unit ix = (IndexableEntity__unit)((Object)e);
                ix.setIndex__unit(pos);
            }
        });
        build = new EntityGroup<Building>(Building.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__build) {
                IndexableEntity__build ix = (IndexableEntity__build)((Object)e);
                ix.setIndex__build(pos);
            }
        });
        sync = new EntityGroup<Syncc>(Syncc.class, false, true, (e, pos) -> {
            if (e instanceof IndexableEntity__sync) {
                IndexableEntity__sync ix = (IndexableEntity__sync)((Object)e);
                ix.setIndex__sync(pos);
            }
        });
        draw = new EntityGroup<Drawc>(Drawc.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__draw) {
                IndexableEntity__draw ix = (IndexableEntity__draw)((Object)e);
                ix.setIndex__draw(pos);
            }
        });
        fire = new EntityGroup<Fire>(Fire.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__fire) {
                IndexableEntity__fire ix = (IndexableEntity__fire)((Object)e);
                ix.setIndex__fire(pos);
            }
        });
        puddle = new EntityGroup<Puddle>(Puddle.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__puddle) {
                IndexableEntity__puddle ix = (IndexableEntity__puddle)((Object)e);
                ix.setIndex__puddle(pos);
            }
        });
        weather = new EntityGroup<WeatherState>(WeatherState.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__weather) {
                IndexableEntity__weather ix = (IndexableEntity__weather)((Object)e);
                ix.setIndex__weather(pos);
            }
        });
        label = new EntityGroup<WorldLabel>(WorldLabel.class, false, true, (e, pos) -> {
            if (e instanceof IndexableEntity__label) {
                IndexableEntity__label ix = (IndexableEntity__label)((Object)e);
                ix.setIndex__label(pos);
            }
        });
        powerGraph = new EntityGroup<PowerGraphUpdaterc>(PowerGraphUpdaterc.class, false, false, (e, pos) -> {
            if (e instanceof IndexableEntity__powerGraph) {
                IndexableEntity__powerGraph ix = (IndexableEntity__powerGraph)((Object)e);
                ix.setIndex__powerGraph(pos);
            }
        });
    }

    public static void queueFree(Pool.Poolable obj) {
        freeQueue.add(obj);
    }

    public static void resize(float x, float y, float w, float h) {
        bullet.resize(x, y, w, h);
        unit.resize(x, y, w, h);
    }

    public static void update() {
        for (Pool.Poolable p : freeQueue) {
            Pools.free(p);
        }
        freeQueue.clear();
        bullet.updatePhysics();
        unit.updatePhysics();
        all.update();
        bullet.collide();
    }

    static {
        freeQueue = new Seq();
    }
}

