/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.util.Disposable;
import mindustry.Vars;
import mindustry.graphics.Shaders;

public class Pixelator
implements Disposable {
    private FrameBuffer buffer = new FrameBuffer();
    private float px;
    private float py;
    private float pre;

    public Pixelator() {
        ((Texture)this.buffer.getTexture()).setFilter(Texture.TextureFilter.nearest, Texture.TextureFilter.nearest);
    }

    public void drawPixelate() {
        this.pre = Vars.renderer.getScale();
        float scale = Vars.renderer.getScale();
        scale = (int)scale;
        Vars.renderer.setScale(scale);
        Core.camera.width = (int)Core.camera.width;
        Core.camera.height = (int)Core.camera.height;
        this.px = Core.camera.position.x;
        this.py = Core.camera.position.y;
        Core.camera.position.set((float)((int)this.px) + ((int)Core.camera.width % 2 == 0 ? 0.0f : 0.5f), (float)((int)this.py) + ((int)Core.camera.height % 2 == 0 ? 0.0f : 0.5f));
        int w = (int)Core.camera.width;
        int h = (int)Core.camera.height;
        if (Vars.renderer.isCutscene()) {
            w = (int)(Core.camera.width * Vars.renderer.landScale() / Vars.renderer.getScale());
            h = (int)(Core.camera.height * Vars.renderer.landScale() / Vars.renderer.getScale());
        }
        w = Mathf.clamp(w, 2, Core.graphics.getWidth());
        h = Mathf.clamp(h, 2, Core.graphics.getHeight());
        this.buffer.resize(w, h);
        this.buffer.begin(Color.clear);
        Vars.renderer.draw();
    }

    public void register() {
        Draw.draw(200.0f, () -> {
            this.buffer.end();
            Blending.disabled.apply();
            this.buffer.blit(Shaders.screenspace);
            Core.camera.position.set(this.px, this.py);
            Vars.renderer.setScale(this.pre);
        });
    }

    public boolean enabled() {
        return Core.settings.getBool("pixelate");
    }

    @Override
    public void dispose() {
        this.buffer.dispose();
    }
}

