/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.struct.ObjectMap;
import arc.struct.StringMap;
import arc.util.Nullable;
import arc.util.io.CounterInputStream;
import arc.util.io.ReusableByteOutStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import mindustry.world.WorldContext;

public abstract class SaveFileReader {
    public static final ObjectMap<String, String> fallback = ObjectMap.of("dart-mech-pad", "legacy-mech-pad", "dart-ship-pad", "legacy-mech-pad", "javelin-ship-pad", "legacy-mech-pad", "trident-ship-pad", "legacy-mech-pad", "glaive-ship-pad", "legacy-mech-pad", "alpha-mech-pad", "legacy-mech-pad", "tau-mech-pad", "legacy-mech-pad", "omega-mech-pad", "legacy-mech-pad", "delta-mech-pad", "legacy-mech-pad", "draug-factory", "legacy-unit-factory", "spirit-factory", "legacy-unit-factory", "phantom-factory", "legacy-unit-factory", "wraith-factory", "legacy-unit-factory", "ghoul-factory", "legacy-unit-factory-air", "revenant-factory", "legacy-unit-factory-air", "dagger-factory", "legacy-unit-factory", "crawler-factory", "legacy-unit-factory", "titan-factory", "legacy-unit-factory-ground", "fortress-factory", "legacy-unit-factory-ground", "mass-conveyor", "payload-conveyor", "vestige", "scepter", "turbine-generator", "steam-generator", "rocks", "stone-wall", "sporerocks", "spore-wall", "icerocks", "ice-wall", "dunerocks", "dune-wall", "sandrocks", "sand-wall", "shalerocks", "shale-wall", "snowrocks", "snow-wall", "saltrocks", "salt-wall", "dirtwall", "dirt-wall", "ignarock", "basalt", "holostone", "dacite", "holostone-wall", "dacite-wall", "rock", "boulder", "snowrock", "snow-boulder", "cliffs", "stone-wall", "craters", "crater-stone", "deepwater", "deep-water", "water", "shallow-water", "sand", "sand-floor", "slag", "molten-slag", "cryofluidmixer", "cryofluid-mixer", "block-forge", "constructor", "block-unloader", "payload-unloader", "block-loader", "payload-loader", "thermal-pump", "impulse-pump", "alloy-smelter", "surge-smelter", "steam-vent", "rhyolite-vent", "fabricator", "tank-fabricator", "basic-reconstructor", "refabricator");
    public static final ObjectMap<String, String> modContentNameMap = ObjectMap.of("craters", "crater-stone", "deepwater", "deep-water", "water", "shallow-water", "slag", "molten-slag");
    protected final ReusableByteOutStream byteOutput = new ReusableByteOutStream();
    protected final ReusableByteOutStream byteOutput2 = new ReusableByteOutStream();
    protected final DataOutputStream dataBytes = new DataOutputStream(this.byteOutput);
    protected final DataOutputStream dataBytes2 = new DataOutputStream(this.byteOutput2);
    protected final ReusableByteOutStream byteOutputSmall = new ReusableByteOutStream();
    protected final DataOutputStream dataBytesSmall = new DataOutputStream(this.byteOutputSmall);
    protected boolean chunkNested = false;
    protected int lastRegionLength;
    @Nullable
    protected CounterInputStream currCounter;

    public static String mapFallback(String name) {
        return fallback.get(name, name);
    }

    public void region(String name, DataInput stream, CounterInputStream counter, IORunner<DataInput> cons) throws IOException {
        int length;
        counter.resetCount();
        this.currCounter = counter;
        try {
            length = this.readChunk(stream, cons);
        }
        catch (Throwable e) {
            throw new IOException("Error reading region \"" + name + "\".", e);
        }
        if (length != counter.count - 4) {
            throw new IOException("Error reading region \"" + name + "\": read length mismatch. Expected: " + length + "; Actual: " + (counter.count - 4));
        }
    }

    public void region(String name, DataOutput stream, IORunner<DataOutput> cons) throws IOException {
        try {
            this.writeChunk(stream, cons);
        }
        catch (Throwable e) {
            throw new IOException("Error writing region \"" + name + "\".", e);
        }
    }

    public void writeChunk(DataOutput output, IORunner<DataOutput> runner) throws IOException {
        this.writeChunk(output, false, runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(DataOutput output, boolean isShort, IORunner<DataOutput> runner) throws IOException {
        boolean wasNested = this.chunkNested;
        if (!isShort) {
            this.chunkNested = true;
        }
        ReusableByteOutStream dout = isShort ? this.byteOutputSmall : (wasNested ? this.byteOutput2 : this.byteOutput);
        try {
            dout.reset();
            runner.accept(isShort ? this.dataBytesSmall : (wasNested ? this.dataBytes2 : this.dataBytes));
            int length = dout.size();
            if (!isShort) {
                output.writeInt(length);
            } else {
                if (length > 65535) {
                    throw new IOException("Byte write length exceeded: " + length + " > 65535");
                }
                output.writeShort(length);
            }
            output.write(dout.getBytes(), 0, length);
        }
        finally {
            this.chunkNested = wasNested;
        }
    }

    public int readChunk(DataInput input, IORunner<DataInput> runner) throws IOException {
        return this.readChunk(input, false, runner);
    }

    public int readChunk(DataInput input, boolean isShort, IORunner<DataInput> runner) throws IOException {
        int length;
        this.lastRegionLength = length = isShort ? input.readUnsignedShort() : input.readInt();
        runner.accept(input);
        return length;
    }

    public void skipChunk(DataInput input) throws IOException {
        this.skipChunk(input, false);
    }

    public void skipChunk(DataInput input, boolean isShort) throws IOException {
        int skipped;
        int length = this.readChunk(input, isShort, t -> {});
        if (length != (skipped = input.skipBytes(length))) {
            throw new IOException("Could not skip bytes. Expected length: " + length + "; Actual length: " + skipped);
        }
    }

    public void writeStringMap(DataOutput stream, ObjectMap<String, String> map) throws IOException {
        stream.writeShort(map.size);
        for (ObjectMap.Entry entry : map.entries()) {
            stream.writeUTF((String)entry.key);
            stream.writeUTF((String)entry.value);
        }
    }

    public StringMap readStringMap(DataInput stream) throws IOException {
        StringMap map = new StringMap();
        int size = stream.readShort();
        for (int i = 0; i < size; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
        return map;
    }

    public abstract void read(DataInputStream var1, CounterInputStream var2, WorldContext var3) throws IOException;

    public abstract void write(DataOutputStream var1) throws IOException;

    public static interface IORunner<T> {
        public void accept(T var1) throws IOException;
    }

    public static interface CustomChunk {
        public void write(DataOutput var1) throws IOException;

        public void read(DataInput var1) throws IOException;

        default public boolean shouldWrite() {
            return true;
        }

        default public boolean writeNet() {
            return true;
        }
    }
}

